#include <gmp.h>
#include <cmath>
#include <ctime>
#include <string>
#include <fstream>
#include <iomanip>
#include <iostream>
using namespace std;

#define Tc 1		// 1 2 3
#define Td 30		// 30 20 10
#define ColorNum 256
#define ColorDepth 3
#define max_size 1024
#define SecLength 1000000

char SecretFileName[25] = "aaa";

unsigned int ClusterNum;
unsigned int TotalEmbeddedBits;
unsigned int im_height, im_width;
unsigned int PaletteNum, indexsize, DuPosiLen;

double 		luminance[ColorNum];
double 		sortstack[ColorNum];
double		ColorDifference[ColorNum][ColorNum];
unsigned int	SecMap[5]={0,1,0,1,0};
unsigned int  	EmCode[SecLength];						//ΨӦsSecret databits
unsigned int	ColorClSi[ColorNum];
unsigned int  	ClusterSize[ColorNum];					//ΨӰOC@clusterjp(size)
unsigned int	ExtractData[SecLength];
unsigned int	DuPosition[max_size*max_size];
unsigned int  	IndexImage[max_size*max_size];					//Imageblock
unsigned int 	Palette[ColorNum][ColorDepth];
unsigned int  	ClusterIndex[ColorNum][ColorNum];		//CClustercodebookcodeword
unsigned char 	InImage[max_size][max_size][ColorDepth];
unsigned char 	OutImage[max_size][max_size][ColorDepth];

double RMSE();
double PSNR(double);
int main(int, char* []);
int Product_Palette();
void decode();
void contrast();
void Embedding();
void SortPalette();
void PaletteIndex();
void Du_Method(mpz_t);
void ReadBMP(char []);							//ŪXv
void ProductCluster();
void WriteBMP(char []);							//gJv
void ReadSigningCode();					//Ū:Secret Data
void PaletteChange(int);
void ExtrPaletteIndex();
void InputErrorPrintf();
void ReadCluster(char []);
void ComputeDiffOfColors();
void Quicksort(const int ,const int);

//====================================================================================
void Du_Method(mpz_t ComDat)
{		
	int pi, pb, ptr, i, j, k, l;
	int record[indexsize][2];		
	unsigned long int  numexProd;	
	
	mpz_t CMDT, exProd, reamt;	
	mpz_init(CMDT);
	mpz_init(exProd);
	mpz_init(reamt);
	mpz_set(CMDT, ComDat);	

	mpz_set_ui(exProd,(unsigned long int)0);
	numexProd = 0;
	
	//pnδXindeics@ƦCզX	
	while(mpz_cmp(CMDT,exProd)>0){		
		//**IndexImage[i][j]ݩ󨺤@cluster			
		for(i=0;i<ClusterNum;i++){
			for(j=0;j<ClusterSize[i];j++){				
				if(IndexImage[DuPosition[numexProd]] == ClusterIndex[i][j]){
					pi = i;	//@s
					pb = j;	//@sĴX					
				}
			}
		}
		record[numexProd][0]=pi;
		record[numexProd][1]=pb;		
				
		if(ClusterSize[pi]==1){
			mpz_mul_ui(exProd,exProd,(unsigned long int)1);	
			cout<<"Du_method error!"<<endl;
			exit(1);
		}
		else{
			if(mpz_cmp_ui(exProd,(unsigned long int)0) == 0)
				mpz_set_ui(exProd,(unsigned long int)(ClusterSize[pi]));
			else							
				mpz_mul_ui(exProd,exProd,(unsigned long int)(ClusterSize[pi]));	
		}
				
		numexProd++;
		if(numexProd>DuPosiLen){
			cout<<"Du::Out of indexsize."<<endl;
			exit(1);
		}		
	}//end of while(ComDat>exProd)
			
	bool ISZERO = true;
	for(i=numexProd-1;i>=0;i--){		//ϹLӰ:D
		if(ClusterSize[pi]!=1){				
			mpz_mod_ui(reamt, CMDT, (unsigned long int)ClusterSize[record[i][0]]);
			ptr = mpz_get_ui(reamt);				
			mpz_cdiv_q_ui(CMDT, CMDT, (unsigned long int)ClusterSize[record[i][0]]);			
				
			if(ISZERO)	//ܰ}CsǬ1,2,...(ClusterSize[i]-1)-1,0;  䤤(ClusterSize[i]-1)hbreakpoint᪺size
			{								
				if(ptr==0)		//lƬ0,indexcluster̫@ӫDbreakpointcodeword						
					IndexImage[DuPosition[i]]=ClusterIndex[record[i][0]][ClusterSize[record[i][0]]-1];					
				else{		//ptr!=0
					ISZERO = false;						
					IndexImage[DuPosition[i]] = ClusterIndex[record[i][0]][ptr-1];					
				}				
			}
			else		//ܰ}CsǬ0,1,...(ClusterSize[i]-1)-1;									
				IndexImage[DuPosition[i]] = ClusterIndex[record[i][0]][ptr];					
		}
	}
}
//====================================================================================

//====================================================================================
void Embedding()
{
	cout<<"Embedding Program"<<endl;
	
	int i, j, k, l, p, pi, pj, ccc;
	int DistinctColor, DuLen, NowSec, numNeighbor;
	int numEmbeddedOneBit, numDuPosition, numEmbeddable, numNonEmbeddable, numNotEmbeddedOneBit;
	int neighbor[4];		
	double MinDiff, MaxD, sum, CandMaxD;
	mpz_t Prod, SDec;
	
	mpz_init(SDec);
	mpz_init(Prod);
	mpz_set_ui(SDec, (unsigned long int)1);
	DuPosiLen = 0;
	
	numDuPosition = 0;
	numEmbeddable = 0;
	numNonEmbeddable = 0;
	numEmbeddedOneBit = 0;
	numNotEmbeddedOneBit = 0;
	
	TotalEmbeddedBits = 0;
	
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){
			
			numNeighbor = 0;
			MaxD = 0;
			cout<<"("<<i<<","<<j<<")"<<" ";
						
			//pMaximum color difference between (i,j) and (i-1, j-1), (i-1, j), (i-1, j+1), (i, j-1)
			if((i-1)>0 && (j-1)>0){			//For (i-1, j-1)				
				if(ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+(j-1)] ]>MaxD)
					MaxD = ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+(j-1)] ];
				sortstack[numNeighbor] = IndexImage[(i-1)*im_width + (j-1)];	
				numNeighbor++;		
			}
			if((i-1)>0){					//For (i-1, j)
				if(ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+j] ]>MaxD)
					MaxD = ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+j] ];
				sortstack[numNeighbor] = IndexImage[(i-1)*im_width + j];
				numNeighbor++;
			}
			if((i-1)>0 && (j+1)<im_width){	//For (i-1, j+1)
				if(ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+(j+1)] ]>MaxD)
					MaxD = ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[(i-1)*im_width+(j+1)] ];
				sortstack[numNeighbor] = IndexImage[(i-1)*im_width+(j+1)];	
				numNeighbor++;			
			}
			if((j-1)>0){					//For (i, j-1)
				if(ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[i*im_width+(j-1)] ]>MaxD)
					MaxD = ColorDifference[ IndexImage[i*im_width+j] ][ IndexImage[i*im_width+(j-1)] ];
				sortstack[numNeighbor] = IndexImage[i*im_width+(j-1)];
				numNeighbor++;
			}
						
			if(numNeighbor!=0){
				Quicksort(0,(numNeighbor-1));
				DistinctColor = 1;
				for(k=1; k<numNeighbor; k++){
					if(sortstack[k]!=sortstack[k-1])
						DistinctColor++;
				}
			}
			else		
				DistinctColor = 0;
					
			//cout<<" "<<DistinctColor<<"/"<<numNeighbor<<" "<<MaxD<<" ";
			
			if(DistinctColor>=Tc && MaxD<=Td){			
								
				numEmbeddable++;
				
				if(ColorClSi[IndexImage[i*im_width+j]]==1){
					if(numNeighbor!=4){
						for(k=numNeighbor; k<4; k++)
							sortstack[k] = 0;						
						Quicksort(0, 3);									
					}
					if(IndexImage[i*im_width+j]>=sortstack[3])
						NowSec = SecMap[0];
					else if(sortstack[3]>IndexImage[i*im_width+j] && IndexImage[i*im_width+j]>=sortstack[2])
						NowSec = SecMap[1];
					else if(sortstack[2]>IndexImage[i*im_width+j] && IndexImage[i*im_width+j]>=sortstack[1])
						NowSec = SecMap[2];
					else if(sortstack[1]>IndexImage[i*im_width+j] && IndexImage[i*im_width+j]>=sortstack[0])
						NowSec = SecMap[3];
					else
						NowSec = SecMap[4];
					//cout<<IndexImage[i*im_width+j]<<"/"<<NowSec<<" ";
					if( NowSec != EmCode[TotalEmbeddedBits%SecLength]){  //not okay unPEmCodeۦP
						MinDiff = 999999;
						for(k=0; k<PaletteNum; k++){
							if(ColorClSi[k]==1){	//uҼ{ClusterSize1
								
								if(k>=sortstack[3])
									l = SecMap[0];
								else if(sortstack[3]>k && k>=sortstack[2])
									l = SecMap[1];
								else if(sortstack[2]>k && k>=sortstack[1])
									l = SecMap[2];
								else if(sortstack[1]>k && k>=sortstack[0])
									l = SecMap[3];
								else
									l = SecMap[4];
								
								if(l == EmCode[TotalEmbeddedBits%SecLength]){
									//pMaximum color difference between (i,j) and (i-1, j-1), (i-1, j), (i-1, j+1), (i, j-1)
									CandMaxD = 0;
									if((i-1)>0 && (j-1)>0){		//For (i-1, j-1)
										if(ColorDifference[ k ][ IndexImage[(i-1)*im_width+(j-1)] ]>CandMaxD)
											CandMaxD = ColorDifference[ k ][ IndexImage[(i-1)*im_width+(j-1)] ];						
									}
									if((i-1)>0){					//For (i-1, j)
										if(ColorDifference[ k ][ IndexImage[(i-1)*im_width+j] ]>CandMaxD)
											CandMaxD = ColorDifference[ k ][ IndexImage[(i-1)*im_width+j] ];									
									}
									if((i-1)>0 && (j+1)<im_width){	//For (i-1, j+1)
										if(ColorDifference[ k ][ IndexImage[(i-1)*im_width+(j+1)] ]>CandMaxD)
											CandMaxD = ColorDifference[ k ][ IndexImage[(i-1)*im_width+(j+1)] ];												
									}
									if((j-1)>0){					//For (i, j-1)
										if(ColorDifference[ k ][ IndexImage[i*im_width+(j-1)] ]>CandMaxD)
											CandMaxD = ColorDifference[ k ][ IndexImage[i*im_width+(j-1)] ];								
									}
									if(CandMaxD<MinDiff){
										MinDiff = CandMaxD;
										p = k;
									}
								}
								
							}
						}
						if(MinDiff<=Td){							
							cout<<"Embedding 1 bits! changed"<<TotalEmbeddedBits<<endl;
							IndexImage[i*im_width+j] = p;
							numEmbeddedOneBit++;
							TotalEmbeddedBits++;
						}
						else{
							numNotEmbeddedOneBit++;
							cout<<"Not Embedding Data! Since replace color isn't satisfied!"<<endl;
						}
					}
					else{						
						cout<<"Embedding 1 bits!  nonchanged"<<TotalEmbeddedBits<<endl;
						numEmbeddedOneBit++;
						TotalEmbeddedBits++;
					}																
				}
				else{
					//nClusterҦcolorO_ŦXembeddable
					for(k=0; k<ClusterNum; k++){						
						for(l=0; l<ClusterSize[k]; l++){
							if(IndexImage[i*im_width+j] == ClusterIndex[k][l]){
								pi = k;
								pj = l;								
							}
						}
					}
					CandMaxD = 0;
					for(k=0; k<ColorClSi[IndexImage[i*im_width+j]]; k++){						
						if((i-1)>0 && (j-1)>0){		//For (i-1, j-1)
							if(ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+(j-1)] ]>CandMaxD)
								CandMaxD = ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+(j-1)] ];						
						}
						if((i-1)>0){					//For (i-1, j)
							if(ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+j] ]>CandMaxD)
								CandMaxD = ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+j] ];									
						}
						if((i-1)>0 && (j+1)<im_width){	//For (i-1, j+1)
							if(ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+(j+1)] ]>CandMaxD)
								CandMaxD = ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[(i-1)*im_width+(j+1)] ];												
						}
						if((j-1)>0){					//For (i, j-1)
							if(ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[i*im_width+(j-1)] ]>CandMaxD)
								CandMaxD = ColorDifference[ ClusterIndex[pi][k] ][ IndexImage[i*im_width+(j-1)] ];								
						}						
					}
					if(CandMaxD>=Td){
						cout<<"Not Embedding Data in Du Position! Since had a replace color isn't embeddable!"<<endl;
					}
					else{
						cout<<"Using Du's method!"<<endl;					
						mpz_mul_ui(SDec, SDec, (unsigned long int)ColorClSi[IndexImage[i*im_width+j]]);					
						DuPosition[DuPosiLen] = i*im_width+j;
						numDuPosition++;
						DuPosiLen++;
					}													
				}
			}
			else{
				numNonEmbeddable++;
				cout<<"Not Embedding Data!"<<endl;
			}					
		}	
	}
	cout<<SDec<<endl;
	DuLen = 0;
	mpz_set_ui(Prod, (unsigned long)1);	
	while(mpz_cmp(SDec, Prod)>0)
	{			
		mpz_ui_pow_ui(Prod, (unsigned long int)2, (unsigned long int)DuLen);
		DuLen++;
	}
	DuLen = DuLen-2;	
	
	//XnäJSecret data(10)
	mpz_set_ui(SDec, (unsigned long)0);
	for(i=0; i<DuLen; i++){
		if(EmCode[(TotalEmbeddedBits+i)%SecLength]==0)
			mpz_mul_ui(SDec, SDec, (unsigned long)2);	//SDec = SDec*2;		
		else{
			mpz_mul_ui(SDec, SDec, (unsigned long)2);	//SDec = SDec*2;
			mpz_add_ui(SDec, SDec, (unsigned long)1);	//SDec = SDec+1;
		}
	}	
	cout<<"SDec : "<<SDec<<endl;	
	
	Du_Method(SDec);
	
	cout<<"indexsize: "<<indexsize<<endl;
	cout<<"numNonEmbeddable: "<<numNonEmbeddable<<endl;
	cout<<"numEmbeddable: "<<numEmbeddable<<endl;
	cout<<"numEmbeddedOneBit: "<<numEmbeddedOneBit<<" :: numNotEmbeddedOneBit: "<<numNotEmbeddedOneBit<<" :: numDuPosition: "<<numDuPosition<<" ("<<numDuPosition+numEmbeddedOneBit+numNotEmbeddedOneBit<<")"<<endl;
	
	cout<<"TotalEmbeddedBits:"<<TotalEmbeddedBits+DuLen<<endl;
	
	//DuøT
	
	
}
//====================================================================================

//====================================================================================
void contrast()
{
}
//====================================================================================

//====================================================================================
void decode()
{
	
}
//====================================================================================

//====================================================================================
void Quicksort(const int left,const int right)
{
	int i, j;
	double pivot,temp;
	
	if(left<right)
	{
		i=left;
		j=right+1;
		pivot=sortstack[left];
		do{
    		do{
				i++;			
			}while(sortstack[i]<pivot);
			do{
				j--;
			}while(sortstack[j]>pivot);
			if(i<j)
			{
				temp=sortstack[i];
				sortstack[i]=sortstack[j];
				sortstack[j]=temp;
			}
		}while(i<j);
    	temp=sortstack[left];		
		sortstack[left]=sortstack[j];
		sortstack[j]=temp;		
	    
		Quicksort(left,j-1);
    	Quicksort(j+1,right);
	}
}
//====================================================================================

//====================================================================================
void PaletteChange(int p)			//using for SortPalette()
{
	int i;
	int ColorTemp[ColorDepth];
	
	for(i; i<ColorDepth; i++)
		ColorTemp[i]=Palette[p][i];
	for(i; i<ColorDepth; i++)
		Palette[p][i]=Palette[p][p+1];
	for(i; i<ColorDepth; i++)
		Palette[p+1][i]=ColorTemp[i];
}
//====================================================================================

//====================================================================================
void SortPalette()
{
	cout<<"SortPalette"<<endl;
	int i, j, k, l;
	int appear = 0;
	int Reco[ColorNum];
	int Temp[ColorNum][ColorDepth];
	
	for(i=0; i<PaletteNum; i++){
		for(j=0; j<ColorDepth; j++){
			Temp[i][0] = Palette[i][0];
		    Temp[i][1] = Palette[i][1];
		    Temp[i][2] = Palette[i][2];
		}
	}
	
	for(i=0; i<PaletteNum; i++){
		luminance[i] = 0.3*Palette[i][0]+0.59*Palette[i][1]+0.11*Palette[i][2];
		sortstack[i] = 0.3*Palette[i][0]+0.59*Palette[i][1]+0.11*Palette[i][2];		
	}
	
	Quicksort(0, (PaletteNum-1));
	
	l = 0;
	for(i=0; i<=PaletteNum; i++){	
		for(j=0; j<PaletteNum; j++){			
			if(sortstack[(PaletteNum-1)-i]==luminance[j]){
				appear = 0;
				for(k=0; k<l; k++){
					if(Reco[k]==j)
						appear = 1;
				}
				if(appear==0){
					for(k=0; k<ColorDepth; k++)
						Palette[i][k] = Temp[j][k];
					Reco[l] = j;
					l++;
					break;
				}
			}
		}		
	}
	
	for(i=0; i<PaletteNum; i++)
		luminance[i] = sortstack[(PaletteNum-1)-i];
	
	for(i=0; i<(PaletteNum-1); i++){		
		if(luminance[i]==luminance[i+1]){
			if(Palette[i][0]<Palette[i+1][0]){
				PaletteChange(i);
			}
			else if(Palette[i][0]==Palette[i+1][0]){
				if(Palette[i][1]<Palette[i+1][1]){
					PaletteChange(i);
				}
				else if(Palette[i][1]==Palette[i+1][1]){
					if(Palette[i][2]<Palette[i+1][2])
						PaletteChange(i);
				}
			}
		}
	}		
}
//====================================================================================

//====================================================================================
void PaletteIndex()							//NvনPalette Index
{
	int i, j, k;		
	int CountOfIndex;	
	
	CountOfIndex=0;
	
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){
			for(k=0;k<PaletteNum;k++){
				if((InImage[i][j][0]==Palette[k][0]) && (InImage[i][j][1]==Palette[k][1]) && (InImage[i][j][2]==Palette[k][2])){					
					IndexImage[CountOfIndex]=k;
					CountOfIndex++;
				}
			}
		}
	}	
	if(CountOfIndex != indexsize){
		cout<<"Error!!Size isn't same!! - VQIndex\n";
		exit(1);
	}	
}
//====================================================================================

//====================================================================================
void ComputeDiffOfColors()
{
	cout<<"ComputeDiffOfColors"<<endl;
	int i, j, k;
	double sum;
		
	//إPaletteCColorDifference
	for(i=0; i<PaletteNum; i++){
		for(j=0; j<PaletteNum; j++){
			sum = 0.0;
			for(k=0; k<ColorDepth; k++)
				sum += (Palette[i][k]-Palette[j][k])*(Palette[i][k]-Palette[j][k]);
			ColorDifference[i][j]=sqrt(sum);
		}
	}
}
//====================================================================================

//====================================================================================
void ExtrPaletteIndex()
{
	int i,j,k,l;
	//w OutImage
	k = 0;
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){			
			for(l=0; l<ColorDepth; l++){				
				OutImage[i][j][l] = Palette[IndexImage[k]][l];				
			}
			k++;
		}
	}	
}
//====================================================================================

//====================================================================================
int Product_Palette()
{
	int i, j, k, pn, reseen;
	pn = 0;
	for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){
			reseen = 0;
			for(k=0; k<pn; k++){							
				if((Palette[k][0]==InImage[i][j][0]) && (Palette[k][1]==InImage[i][j][1]) && (Palette[k][2]==InImage[i][j][2]))
					reseen = 1;
		    }
		    if(reseen == 0){
		    	Palette[pn][0] = InImage[i][j][0];
		    	Palette[pn][1] = InImage[i][j][1];
		    	Palette[pn][2] = InImage[i][j][2];
		    	pn++;
		    }		    
		}
	}		
	
	return pn;
}
//====================================================================================

//====================================================================================
void ProductCluster()			//ŪiCluster(sG)--ǫϥ C Ūɤk
{
	cout<<"ProductCluster"<<endl;
	int i,j,k,p,ppp, pi, pj;
	int DCP, timecl, appear, tempclustersize;
	int tempci[ColorNum];
	int IndexCount[ColorNum];
	double Tv = 15;
	double MinDiff, MaxDiff;				
	
	//Init.
	for(i=0;i<PaletteNum;i++){
		IndexCount[i] = 0;
		sortstack[i] = 0;
		ClusterSize[i] = 1;
		ClusterIndex[i][0] = i;
	}
	tempclustersize = PaletteNum;
	
	DCP = PaletteNum-ClusterNum;		
	
	//pIndexX{
	for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){
			IndexCount[IndexImage[i*im_width+j]]++;
			sortstack[IndexImage[i*im_width+j]]++;
		}
	}
	
	//for(i=0;i<PaletteNum; i++)
	//	cout<<IndexCount[i]<<" ";
	//cout<<endl;
	
	Quicksort(0, (PaletteNum-1));
	
	timecl = 0;
	ppp = 0;
	while(tempclustersize>ClusterNum && timecl<PaletteNum){
		
		cout<<tempclustersize<<"::"<<ClusterNum<<"  "<<timecl<<endl;
		
		//̾ڤjp(Ѥjp)XX{̦hIndex
		for(i=0; i<tempclustersize; i++){
			for(j=0;j<ClusterSize[i];j++){
				appear = 0;
				for(k=0; k<timecl; k++){
					if(ClusterIndex[i][j]==tempci[k]){
						appear = 1;
						break;
					}
				}
				if(appear == 0){		//|Jtempci[]
					if(sortstack[(PaletteNum-1)-ppp] == IndexCount[ClusterIndex[i][j]]){
						tempci[timecl]=ClusterIndex[i][j];
						pi = i;
						pj = j;
						timecl ++ ;
						break;
					}
				}
			}
		}
		
		//䤣bCluster̬۪colorJcluster
		MinDiff = 999999;
		for(i=0; i<tempclustersize; i++){
			if(i!=pi){
				MaxDiff = 0;
				for(k=0; k<ClusterSize[pi]; k++){
					for(j=0;j<ClusterSize[i];j++){						
						if(ColorDifference[ClusterIndex[pi][k]][ClusterIndex[i][j]]>MaxDiff)
							MaxDiff = ColorDifference[ClusterIndex[pi][k]][ClusterIndex[i][j]];
					}
				}
				if(MaxDiff<MinDiff){
					MinDiff = MaxDiff;
					p=i;
				}
			}
		}
		
		if(MinDiff<=Tv){		//X piMp oCluster
			for(i=0; i<ClusterSize[p]; i++){
				ClusterIndex[pi][ClusterSize[pi]] = ClusterIndex[p][i];
				ClusterSize[pi]++;
			}
			for(i=p; i<(tempclustersize-1); i++){
				ClusterSize[i] = ClusterSize[i+1];
				for(j=0; j<ClusterSize[i+1]; j++){
					ClusterIndex[i][j]=ClusterIndex[i+1][j];
				}
			}
			
			tempclustersize--;			
		}
		ppp++;						
	}
	
	//==Show Information
	cout<<"Number of Cluster is "<<ClusterNum<<endl;
	cout<<"Every Cluster Size is:"<<endl;
	for(i=0;i<ClusterNum;i++)
		cout<<ClusterSize[i]<<" ";	
	cout<<endl;
	
	for(i=0;i<ClusterNum;i++){
		for(j=0;j<ClusterSize[i];j++){
			cout<<ClusterIndex[i][j]<<" ";
		}
		cout<<" ; ";
	}
	cout<<endl;
	
}
//====================================================================================

//====================================================================================
void ReadCluster(char rCF[25])			//ŪiCluster(sG)--ǫϥ C Ūɤk
{
	FILE *rCC;
	int i,j,k;	
	int tempci[ColorNum];
	
	if ((rCC=fopen(rCF,"rb"))==NULL){
		printf("Unable to open Cluster File.\n");
    	exit(1);
	}	
	fread(&ClusterNum,sizeof(unsigned int),1,rCC);
	fread(ClusterSize,sizeof(unsigned int),ClusterNum,rCC);
	fread(tempci,sizeof(unsigned int),PaletteNum,rCC);
   
	fclose(rCC);	
		
	k=0;
	for(i=0;i<ClusterNum;i++){
		for(j=0;j<ClusterSize[i];j++){
			ClusterIndex[i][j]=tempci[k];
			k++;
		}
	}
	
	//==Show Information
	cout<<"Number of Cluster is "<<ClusterNum<<endl;
	cout<<"Every Cluster Size is:"<<endl;
	for(i=0;i<ClusterNum;i++)
		cout<<ClusterSize[i]<<" ";   	   	
   	cout<<endl;
   	/*
   	for(i=0;i<ClusterNum;i++){
		for(j=0;j<ClusterSize[i];j++)
			cout<<setw(3)<<ClusterIndex[i][j];
		cout<<endl;
	}
	cout<<endl;
	*/
}
//====================================================================================

//====================================================================================
void ReadSigningCode(char incb[25])		//ŪSecret Data File
{
	char ch;		
	ifstream infile(incb,ios::binary);
	for(int i=0;i<SecLength;i++)
	{
		infile.get(ch);
		if (infile.eof())
			break;	
		else{
			if(ch=='1')	EmCode[i]=1;				
			else if(ch=='0') EmCode[i]=0;
		}
	}
	
	infile.close();
}
//====================================================================================

//====================================================================================
void ReadBMP(char inputname[25])	//Ūv(.Raw)
{
	int i, j, k;
	char ch;		
	ifstream infile(inputname,ios::binary);
	for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){
			for(k=0; k<ColorDepth; k++){
				infile.get(ch);				
				if (infile.eof())
					break;	
				else
					InImage[i][j][k] = ch;	
			}
		}
	}
	infile.close();	
}
//====================================================================================

//====================================================================================
void WriteBMP(char outputname[40])	//gv(.Raw)
{	
	int i, j, k;
	ofstream outfile(outputname,ios::binary);
    for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){		
			for(k=0; k<ColorDepth; k++)
		    	outfile<<(unsigned char)OutImage[i][j][k];		
		}
	}
	outfile.close();		
}
//====================================================================================

//====================================================================================
double RMSE()							//pMean Square Error
{
	double _mse = 0;	
	for(int i=0;i<im_height;i++){
		for(int j=0;j<im_width;j++){
			for(int k=0;k<ColorDepth;k++)
				_mse += (InImage[i][j][k]-OutImage[i][j][k])*(InImage[i][j][k]-OutImage[i][j][k]);
		}
	}	
	_mse = sqrt(_mse/(im_height*im_width));		
	return _mse;
}
//====================================================================================

//====================================================================================
double PSNR(double _pm)					//pPSNR
{	
	double _psnr;		
	_psnr = 10*log10(255*255/_pm);	
	return _psnr;
}
//====================================================================================

//====================================================================================
void InputErrorPrintf()
{
	//		  0		  1			2		  3		  4	      5       6			//
	cout<<"$HCDHPI [OPTION1] [OPTION2] [Item1] [Item2] [Item3] [Item4]"<<endl;
	cout<<" D <Decoder Option>"<<endl;
	cout<<"	C <Using Clostest pair method>"<<endl;
	cout<<"		$HCDHPI D C [Stego-Image File] [Image Height] [Image Width] [Clustering File]"<<endl;
	cout<<"	G <Using GA Glustering method>"<<endl;
	cout<<"		$HCDHPI D G [Stego-Image File] [Image Height] [Image Width] [Clustering File]"<<endl;	
	cout<<endl;
	cout<<" H <Data Hiding Option>"<<endl;
	cout<<"	C <Using Clostest pair method>"<<endl;
	cout<<"		$HCDHPI D C [Stego-Image File] [Image Height] [Image Width] [Clustering File]"<<endl;
	cout<<"	G <Using GA Glustering method>"<<endl;
	cout<<"		$HCDHPI D G [Stego-Image File] [Image Height] [Image Width] [Clustering File]"<<endl;
	exit(1);
}
//====================================================================================

//====================================================================================
int main(int argc, char* argv[])
{
	int i, j, k;
	double ms, ps;
	char OutImageName[40]="Cover_";		
	
	if(argc!=7 || (argv[1][0]!='D' && argv[1][0]!='H') || (argv[2][0]!='C' && argv[2][0]!='G'))
		InputErrorPrintf();	
	
	//NMeŪJ::]Ūɻݭn""M"e"
	im_height = 0;	
	for(i=0;i<strlen(argv[4]);i++){
		if( 48<=argv[4][i] && argv[4][i]<=57)
			im_height = im_height*10 + argv[4][i]-48;
	}		
	im_width = 0;	
	for(i=0;i<strlen(argv[5]);i++){
		if( 48<=argv[5][i] && argv[5][i]<=57)
			im_width = im_width*10 + argv[5][i]-48;
	}
	if(im_height>max_size || im_width>max_size){
		cout<<"WLImage Size!!"<<endl;
		exit(1);
	}
	indexsize = im_height*im_width;
	
	//==Ū==		
	ReadBMP(argv[3]);					//ŪJcover image
	PaletteNum = Product_Palette();		//Ncover imageզLͥX,oզLC`
	//========
	
	//==զLsT==
	SortPalette();						//NզLҦCⰵjpƧ
	PaletteIndex();						//NCPixelIndexӪ
	ComputeDiffOfColors();				//إPaletteCӪColorDifference
	if(argv[2][0]=='C'){
		ClusterNum = 0;
		for(i=0;i<strlen(argv[6]);i++){
			if( 48<=argv[6][i] && argv[6][i]<=57)
				ClusterNum = ClusterNum*10 + argv[6][i]-48;
		}
		if(ClusterNum>PaletteNum){
			cout<<"Cluster SizeWLPalette Size!!"<<endl;
			cout<<"The number of the palette is "<<PaletteNum<<endl;
			exit(1);
		}
		ProductCluster();			
	}
	else if(argv[2][0]=='G')
		ReadCluster(argv[6]);		
	
	//wC@color indexݪclustersize
	for(i=0; i<ClusterNum; i++){
		for(j=0; j<ClusterSize[i]; j++){
			ColorClSi[ClusterIndex[i][j]]=ClusterSize[i];
		}
	}
	//for(i=0;i<PaletteNum;i++)
	//	cout<<ColorClSi[i]<<" ";	
	//cout<<endl;
	//==========	


	ReadSigningCode(SecretFileName);
	
	if(argv[1][0]=='D'){
		decode();
		contrast();
	}
	else if(argv[1][0]=='H'){		
		
		Embedding();
	
		ExtrPaletteIndex();
		ms = RMSE();	//==pMSE==	
		cout<<"MSE = "<<ms;	
		if( ms != 0){
			ps = PSNR(ms);  //==pPSNR==
			cout<<"	PSNR = "<<ps;
		}
		strcat(OutImageName, argv[3]);	
		WriteBMP(OutImageName);
	}
	
	
	
	return 0;
}
//====================================================================================