#include <gmp.h>
#include <cmath>
#include <ctime>
#include <string>
#include <fstream>
#include <iomanip>
#include <iostream>
using namespace std;

#define Tc 1		// 1 2 3
#define Td 30		// 30 20 10
#define ColorNum 256
#define ColorDepth 3
#define max_size 1024
#define SecLength 1000000

unsigned int ClusterNum;
unsigned int TotalEmbeddedBits;
unsigned int im_height, im_width;
unsigned int PaletteNum, indexsize, DuPosiLen;

double 			luminance[ColorNum];
double 			sortstack[ColorNum];
double			ClusterDiff[ColorNum][ColorNum];
unsigned int	SecMap[5]={0,1,0,1,0};
unsigned int	DuPosition[max_size*max_size];
unsigned int 	PToCluster[ColorNum];
unsigned int  	EmCode[SecLength];						//ΨӦsSecret databits
unsigned int  	ClusterSize[ColorNum];					//ΨӰOC@clusterjp(size)
unsigned int  	ClusterIndex[ColorNum][ColorNum];		//CClustercodebookcodeword
unsigned int  	IndexImage[max_size*max_size];			//Imageblock
unsigned int 	Palette[ColorNum][ColorDepth];
unsigned char 	InImage[max_size][max_size][ColorDepth];
unsigned char 	OutImage[max_size][max_size][ColorDepth];

void Embedding();
void decode();
void Du_Method(mpz_t);
void Quicksort(const int ,const int);
void PaletteChange(int);
void SortPalette();
void PaletteIndex();
void ExtrPaletteIndex();
int Product_Palette();
void ClusterProcessing();
void ReadCluster(char []);
void ReadSigningCode();							//Ū:Secret Data
void ReadBMP(char []);							//ŪXv
void WriteBMP(char []);							//gJv
double RMSE();
double PSNR(double);
int main(int, char* []);


//====================================================================================
void Embedding()
{
	int i, j, k, l, p, ci, cj, ccc;
	int DistinctColor, DuLen, NowSec, numNeighbor;
	int numEmbeddedOneBit, numDuPosition, numEmbeddable, numNonEmbeddable, numNotEmbeddedOneBit;
	int neighbor[4];		
	double MinDiff, MaxD, sum, CandMaxD;
	mpz_t Prod, SDec;
	
	mpz_init(SDec);
	mpz_init(Prod);
	mpz_set_ui(SDec, (unsigned long int)1);
	DuPosiLen = 0;
	
	numDuPosition = 0;
	numEmbeddable = 0;
	numNonEmbeddable = 0;
	numEmbeddedOneBit = 0;
	numNotEmbeddedOneBit = 0;
	
	TotalEmbeddedBits = 0;
	
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){	
			
			numNeighbor = 0;
						
			cout<<"("<<i<<","<<j<<")"<<" ";
			
			MaxD = 0;
			
			if((i-1)>0 && (j-1)>0){			//For (i-1, j-1)	
				if(ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+(j-1)]] ]>MaxD)
					MaxD = ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+(j-1)]] ];
				sortstack[numNeighbor] = PToCluster[IndexImage[(i-1)*im_width+(j-1)]];	
				numNeighbor++;			
			}
			if((i-1)>0){						//For (i-1, j)
				if(ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+j]] ]>MaxD)
					MaxD = ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+j]] ];
				sortstack[numNeighbor] = PToCluster[IndexImage[(i-1)*im_width+j]];	
				numNeighbor++;	
			}
			if((i-1)>0 && (j+1)<im_width){	//For (i-1, j+1)
				if(ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+(j+1)]] ]>MaxD)
					MaxD = ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[(i-1)*im_width+(j+1)]] ];
				sortstack[numNeighbor] = PToCluster[IndexImage[(i-1)*im_width+(j+1)]];	
				numNeighbor++;	
			}
			if((j-1)>0){						//For (i, j-1)
				if(ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[i*im_width+(j-1)]] ]>MaxD)
					MaxD = ClusterDiff[ PToCluster[IndexImage[i*im_width+j]] ][ PToCluster[IndexImage[i*im_width+(j-1)]] ];
				sortstack[numNeighbor] = PToCluster[IndexImage[i*im_width+(j-1)]];	//NݪClusterJsortstack
				numNeighbor++;	
			}
			
			if(numNeighbor!=0){
				Quicksort(0,(numNeighbor-1));
				DistinctColor = 1;
				for(k=1; k<numNeighbor; k++){
					if(sortstack[k]!=sortstack[k-1])
						DistinctColor++;
				}
			}
			else		
				DistinctColor = 0;
			
			//cout<<DistinctColor<<" "<<MaxD<<" ";
			
			//P_ӦmO_äJ
			if(DistinctColor>=Tc && MaxD<=Td){
				cout<<"Embeddable:: ";
				numEmbeddable++;
				if(ClusterSize[PToCluster[IndexImage[i*im_width+j]]]>1){
					mpz_mul_ui(SDec, SDec, (unsigned long int)ClusterSize[PToCluster[IndexImage[i*im_width+j]]]);					
					DuPosition[DuPosiLen] = i*im_width+j;
					numDuPosition++;
					DuPosiLen++;			
				}	
			}
			else{
				cout<<"Non Embeddable!!"<<endl;
				numNonEmbeddable++;			
			}			
		} //for(j=0; j<im_width; j++)
	} //for(i=0; i<im_height; i++)
	
	//cout<<SDec<<endl;
	DuLen = 0;
	if(DuPosiLen!=0){
		mpz_set_ui(Prod, (unsigned long)1);	
		while(mpz_cmp(SDec, Prod)>0)
		{			
			mpz_ui_pow_ui(Prod, (unsigned long int)2, (unsigned long int)DuLen);
			DuLen++;
		}
		DuLen = DuLen-2;
		
		//XnäJSecret data(10)
		mpz_set_ui(SDec, (unsigned long)0);
		for(i=0; i<DuLen; i++){
			if(EmCode[(TotalEmbeddedBits+i)%SecLength]==0)
				mpz_mul_ui(SDec, SDec, (unsigned long)2);	//SDec = SDec*2;		
			else{
				mpz_mul_ui(SDec, SDec, (unsigned long)2);	//SDec = SDec*2;
				mpz_add_ui(SDec, SDec, (unsigned long)1);	//SDec = SDec+1;
			}
		}	
		//cout<<"SDec : "<<SDec<<endl;
		TotalEmbeddedBits += DuLen;	
		Du_Method(SDec);
	}
	
	cout<<"indexsize: "<<indexsize<<endl;
	cout<<"numNonEmbeddable: "<<numNonEmbeddable<<endl;
	cout<<"numEmbeddable: "<<numEmbeddable<<endl;
	
	cout<<"TotalEmbeddedBits:"<<TotalEmbeddedBits<<endl;	
}
//====================================================================================

//====================================================================================
void decode()
{
}
//====================================================================================

//====================================================================================
void Du_Method(mpz_t ComDat)
{		
	int pi, pb, ptr, i, j, k, l;
	int record[indexsize][2];		
	unsigned long int  numexProd;	
	
	mpz_t CMDT, exProd, reamt;	
	mpz_init(CMDT);
	mpz_init(exProd);
	mpz_init(reamt);
	mpz_set(CMDT, ComDat);	

	mpz_set_ui(exProd,(unsigned long int)0);
	numexProd = 0;
	
	//pnδXindeics@ƦCզX	
	while(mpz_cmp(CMDT,exProd)>0){		
		//**IndexImage[i][j]ݩ󨺤@cluster			
		for(i=0;i<ClusterNum;i++){
			for(j=0;j<ClusterSize[i];j++){				
				if(IndexImage[DuPosition[numexProd]] == ClusterIndex[i][j]){
					pi = i;	//@s
					pb = j;	//@sĴX					
				}
			}
		}
		record[numexProd][0]=pi;
		record[numexProd][1]=pb;		
				
		if(ClusterSize[pi]==1){
			mpz_mul_ui(exProd,exProd,(unsigned long int)1);	
			cout<<"Du_method error!"<<endl;
			exit(1);
		}
		else{
			if(mpz_cmp_ui(exProd,(unsigned long int)0) == 0)
				mpz_set_ui(exProd,(unsigned long int)(ClusterSize[pi]));
			else							
				mpz_mul_ui(exProd,exProd,(unsigned long int)(ClusterSize[pi]));	
		}
				
		numexProd++;
		if(numexProd>DuPosiLen){
			cout<<"Du::Out of indexsize."<<endl;
			exit(1);
		}		
	}//end of while(ComDat>exProd)
			
	bool ISZERO = true;
	for(i=numexProd-1;i>=0;i--){		//ϹLӰ:D				
		mpz_mod_ui(reamt, CMDT, (unsigned long int)ClusterSize[record[i][0]]);
		ptr = mpz_get_ui(reamt);				
		mpz_cdiv_q_ui(CMDT, CMDT, (unsigned long int)ClusterSize[record[i][0]]);			
				
		if(ISZERO)	//ܰ}CsǬ1,2,...(ClusterSize[i]-1)-1,0;  䤤(ClusterSize[i]-1)hbreakpoint᪺size
		{								
			if(ptr==0)		//lƬ0,indexcluster̫@ӫDbreakpointcodeword						
				IndexImage[DuPosition[i]]=ClusterIndex[record[i][0]][ClusterSize[record[i][0]]-1];					
			else{		//ptr!=0
				ISZERO = false;						
				IndexImage[DuPosition[i]] = ClusterIndex[record[i][0]][ptr-1];					
			}				
		}
		else		//ܰ}CsǬ0,1,...(ClusterSize[i]-1)-1;									
			IndexImage[DuPosition[i]] = ClusterIndex[record[i][0]][ptr];					
	}	
}
//====================================================================================

//====================================================================================
void Quicksort(const int left,const int right)
{
	int i, j;
	double pivot,temp;
	
	if(left<right)
	{
		i=left;
		j=right+1;
		pivot=sortstack[left];
		do{
    		do{
				i++;			
			}while(sortstack[i]<pivot);
			do{
				j--;
			}while(sortstack[j]>pivot);
			if(i<j)
			{
				temp=sortstack[i];
				sortstack[i]=sortstack[j];
				sortstack[j]=temp;
			}
		}while(i<j);
    	temp=sortstack[left];		
		sortstack[left]=sortstack[j];
		sortstack[j]=temp;		
	    
		Quicksort(left,j-1);
    	Quicksort(j+1,right);
	}
}
//====================================================================================

//====================================================================================
void PaletteChange(int p)			//using for SortPalette()
{
	int i;
	int ColorTemp[ColorDepth];
	
	for(i; i<ColorDepth; i++)
		ColorTemp[i]=Palette[p][i];
	for(i; i<ColorDepth; i++)
		Palette[p][i]=Palette[p][p+1];
	for(i; i<ColorDepth; i++)
		Palette[p+1][i]=ColorTemp[i];
}
//====================================================================================

//====================================================================================
void SortPalette()
{
	cout<<"SortPalette"<<endl;
	int i, j, k, l;
	int appear = 0;
	int Reco[ColorNum];
	int Temp[ColorNum][ColorDepth];
	
	for(i=0; i<PaletteNum; i++){
		for(j=0; j<ColorDepth; j++){
			Temp[i][0] = Palette[i][0];
		    Temp[i][1] = Palette[i][1];
		    Temp[i][2] = Palette[i][2];
		}
	}
	
	for(i=0; i<PaletteNum; i++){
		luminance[i] = 0.3*Palette[i][0]+0.59*Palette[i][1]+0.11*Palette[i][2];
		sortstack[i] = 0.3*Palette[i][0]+0.59*Palette[i][1]+0.11*Palette[i][2];		
	}
	
	Quicksort(0, (PaletteNum-1));
	
	l = 0;
	for(i=0; i<=PaletteNum; i++){	
		for(j=0; j<PaletteNum; j++){			
			if(sortstack[(PaletteNum-1)-i]==luminance[j]){
				appear = 0;
				for(k=0; k<l; k++){
					if(Reco[k]==j)
						appear = 1;
				}
				if(appear==0){
					for(k=0; k<ColorDepth; k++)
						Palette[i][k] = Temp[j][k];
					Reco[l] = j;
					l++;
					break;
				}
			}
		}		
	}
	
	for(i=0; i<PaletteNum; i++)
		luminance[i] = sortstack[(PaletteNum-1)-i];
	
	for(i=0; i<(PaletteNum-1); i++){		
		if(luminance[i]==luminance[i+1]){
			if(Palette[i][0]<Palette[i+1][0]){
				PaletteChange(i);
			}
			else if(Palette[i][0]==Palette[i+1][0]){
				if(Palette[i][1]<Palette[i+1][1]){
					PaletteChange(i);
				}
				else if(Palette[i][1]==Palette[i+1][1]){
					if(Palette[i][2]<Palette[i+1][2])
						PaletteChange(i);
				}
			}
		}
	}
	
	//for( i=0;i<PaletteNum; i++){
	//	for(k=0; k<ColorDepth; k++)
	//		cout<<Palette[i][k]<<",";		
	//	cout<<endl;
	//}		
}
//====================================================================================

//====================================================================================
void PaletteIndex()							//NvনPalette Index
{
	int i, j, k;		
	int CountOfIndex;	
	
	CountOfIndex=0;
	
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){
			for(k=0;k<PaletteNum;k++){
				if((InImage[i][j][0]==Palette[k][0]) && (InImage[i][j][1]==Palette[k][1]) && (InImage[i][j][2]==Palette[k][2])){					
					IndexImage[CountOfIndex]=k;
					CountOfIndex++;
				}
			}
		}
	}	
	if(CountOfIndex != indexsize){
		cout<<"Error!!Size isn't same!! - VQIndex\n";
		exit(1);
	}	
}
//====================================================================================

//====================================================================================
void ExtrPaletteIndex()
{
	int i,j,l;
	//w OutImage	
	for(i=0; i<im_height; i++){
		for(j=0; j<im_width; j++){			
			for(l=0; l<ColorDepth; l++){				
				OutImage[i][j][l] = Palette[IndexImage[i*im_width+j]][l];				
			}			
		}
	}	
}
//====================================================================================

//====================================================================================
int Product_Palette()
{
	int i, j, k, pn, reseen;
	pn = 0;
	for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){
			reseen = 0;
			for(k=0; k<pn; k++){							
				if((Palette[k][0]==InImage[i][j][0]) && (Palette[k][1]==InImage[i][j][1]) && (Palette[k][2]==InImage[i][j][2]))
					reseen = 1;
		    }
		    if(reseen == 0){
		    	Palette[pn][0] = InImage[i][j][0];
		    	Palette[pn][1] = InImage[i][j][1];
		    	Palette[pn][2] = InImage[i][j][2];
		    	pn++;
		    }		    
		}
	}		
	
	return pn;
}
//====================================================================================

//====================================================================================
void ClusterProcessing()
{
	int i, j, k;
	double sum;
	double ClusterCenter[ColorNum][ColorDepth];
	//NCplatte colorݪcluster
	for(i=0 ;i<PaletteNum; i++){
		for(j=0; j<ClusterNum; j++){
			for(k=0; k<ClusterSize[j]; k++){
				if(i == ClusterIndex[j][k]){
					PToCluster[i] = j;			//iCݩjs
					break;
				}
			}
		}
	}
	
	//pC@s
	for(i=0; i<ClusterNum; i++){
		for(k=0; k<ColorDepth; k++){
			sum = 0;
			for(j=0; j<ClusterSize[i]; j++){
				sum += Palette[ClusterIndex[i][j]][k];
			}
			ClusterCenter[i][k] = sum/ClusterSize[i];
		}
	}
	
	//̾ڨCӤߺ⩼ClusterZ
	for(i=0; i<ClusterNum; i++){
		for(j=0; j<ClusterNum; j++){
			sum = 0.0;
			for(k=0; k<ColorDepth; k++)
				sum += (ClusterCenter[i][k]-ClusterCenter[j][k])*(ClusterCenter[i][k]-ClusterCenter[j][k]);
			ClusterDiff[i][j]=sqrt(sum);
		}
	}
}
//====================================================================================

//====================================================================================
void ReadCluster(char rCF[25])			//ŪiCluster(sG)--ǫϥ C Ūɤk
{
	FILE *rCC;
	int i,j,k;	
	int tempci[ColorNum];
	
	if ((rCC=fopen(rCF,"rb"))==NULL){
		printf("Unable to open Cluster File.\n");
    	exit(1);
	}	
	fread(&ClusterNum,sizeof(unsigned int),1,rCC);
	fread(ClusterSize,sizeof(unsigned int),ClusterNum,rCC);
	fread(tempci,sizeof(unsigned int),PaletteNum,rCC);
   
	fclose(rCC);	
		
	k=0;
	for(i=0;i<ClusterNum;i++){
		for(j=0;j<ClusterSize[i];j++){
			ClusterIndex[i][j]=tempci[k];
			k++;
		}
	}
	
	//==Show Information
	cout<<"Number of Cluster is "<<ClusterNum<<endl;
	cout<<"Every Cluster Size is:"<<endl;
	for(i=0;i<ClusterNum;i++)
		cout<<ClusterSize[i]<<" ";   	   	
   	cout<<endl;
   	
   	for(i=0;i<ClusterNum;i++){
		for(j=0;j<ClusterSize[i];j++)
			cout<<ClusterIndex[i][j]<<" ";
		cout<<" ; ";
	}
	cout<<endl;
	
}
//====================================================================================

//====================================================================================
void ReadSigningCode()		//ŪSecret Data File
{
	char ch;		
	ifstream infile("aaa",ios::binary);
	for(int i=0;i<SecLength;i++)
	{
		infile.get(ch);
		if (infile.eof())
			break;	
		else{
			if(ch=='1')	EmCode[i]=1;				
			else if(ch=='0') EmCode[i]=0;
		}
	}
	
	infile.close();
}
//====================================================================================

//====================================================================================
void ReadBMP(char inputname[25])	//Ūv(.Raw)
{
	int i, j, k;
	char ch;		
	ifstream infile(inputname,ios::binary);
	for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){
			for(k=0; k<ColorDepth; k++){
				infile.get(ch);				
				if (infile.eof())
					break;	
				else
					InImage[i][j][k] = ch;	
			}
		}
	}
	infile.close();	
}
//====================================================================================

//====================================================================================
void WriteBMP(char outputname[50])	//gv(.Raw)
{	
	cout<<"WriteBMP:"<<outputname<<endl;
	int i, j, k;
	ofstream outfile(outputname,ios::binary);
    for(i=0;i<im_height;i++){
		for(j=0;j<im_width;j++){		
			for(k=0; k<ColorDepth; k++)
		    	outfile<<(unsigned char)OutImage[i][j][k];		
		}
	}
	outfile.close();		
}
//====================================================================================

//====================================================================================
double RMSE()							//pMean Square Error
{
	double _mse = 0;	
	for(int i=0;i<im_height;i++){
		for(int j=0;j<im_width;j++){
			for(int k=0;k<ColorDepth;k++)
				_mse += (InImage[i][j][k]-OutImage[i][j][k])*(InImage[i][j][k]-OutImage[i][j][k]);
		}
	}	
	_mse = sqrt(_mse/(im_height*im_width));		
	return _mse;
}
//====================================================================================

//====================================================================================
double PSNR(double _pm)					//pPSNR
{	
	double _psnr;		
	_psnr = 10*log10(255*255/_pm);	
	return _psnr;
}
//====================================================================================

//====================================================================================
int main(int argc, char* argv[])
{
	int i, j, k;
	double ms, ps;
	char OutImageName[50]="Cover_";		
	
	if(argc!=6 || (argv[1][0]!='D' && argv[1][0]!='H')){
		cout<<"$HCDHPI [OPTION]  [Item1] [Item2] [Item3] [Item4]"<<endl;	
		cout<<"		$HCDHPI [OPTION: H:hide/D:decode] [Stego-Image File] [Image Height] [Image Width] [Clustering File]"<<endl;
		exit(1);
	}
	
	//NMeŪJ::]Ūɻݭn""M"e"
	im_height = 0;	
	for(i=0;i<strlen(argv[3]);i++){
		if( 48<=argv[3][i] && argv[3][i]<=57)
			im_height = im_height*10 + argv[3][i]-48;
	}
	im_width = 0;	
	for(i=0;i<strlen(argv[4]);i++){
		if( 48<=argv[4][i] && argv[4][i]<=57)
			im_width = im_width*10 + argv[4][i]-48;
	}
	if(im_height>max_size || im_width>max_size){
		cout<<"WLImage Size!!"<<endl;
		exit(1);
	}
	indexsize = im_height*im_width;
	
	//==Ū==
	ReadSigningCode();	
	ReadBMP(argv[2]);					//ŪJcover image
	PaletteNum = Product_Palette();		//Ncover imageզLͥX,oզLC`
	cout<<PaletteNum<<endl;
	//========
	
	//==զLsT==
	SortPalette();						//NզLҦCⰵjpƧ
	ReadCluster(argv[5]);
	ClusterProcessing();
	PaletteIndex();						//NCPixelIndexӪ	
	//==================
	
	if(argv[1][0]=='H'){		
		Embedding();
			
		ExtrPaletteIndex();
		
		ms = RMSE();	//==pMSE==	
		cout<<"MSE = "<<ms;	
		if( ms != 0){
			ps = PSNR(ms);  //==pPSNR==
			cout<<"	PSNR = "<<ps;
		}
		cout<<endl;
		strcat(OutImageName, argv[2]);	
		
		WriteBMP(OutImageName);
	}
	else{
		decode();
	}
	
	return 0;
}
//====================================================================================














/*
					if( NowSec != EmCode[TotalEmbeddedBits%SecLength]){  //not okay unPEmCodeۦP
						MinDiff = 999999;
						for(k=0; k<ClusterNum; k++){
							if(ClusterSize[k]==1){
								if(k<=sortstack[0])
									l = SecMap[0];
								else if(sortstack[0]<k && k<=sortstack[1])
									l = SecMap[1];
								else if(sortstack[1]<k && k<=sortstack[2])
									l = SecMap[2];
								else if(sortstack[1]<k && k<=sortstack[3])
									l = SecMap[3];
								else
									l = SecMap[4];
								if(l==EmCode[TotalEmbeddedBits%SecLength]){
									//pMaximum color difference between (i,j) and (i-1, j-1), (i-1, j), (i-1, j+1), (i, j-1)																																	
									CandMaxD = 0;
									if((i-1)>0 && (j-1)>0){		//For (i-1, j-1)
										if(ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+(j-1)]] ]>CandMaxD)
											CandMaxD = ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+(j-1)]] ];						
									}
									if((i-1)>0){					//For (i-1, j)
										if(ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+j]] ]>CandMaxD)
											CandMaxD = ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+j]] ];									
									}
									if((i-1)>0 && (j+1)<im_width){	//For (i-1, j+1)
										if(ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+(j+1)]] ]>CandMaxD)
											CandMaxD = ClusterDiff[ k ][ PToCluster[IndexImage[(i-1)*im_width+(j+1)]] ];												
									}
									if((j-1)>0){					//For (i, j-1)
										if(ClusterDiff[ k ][ PToCluster[IndexImage[i*im_width+(j-1)]] ]>CandMaxD)
											CandMaxD = ClusterDiff[ k ][ PToCluster[IndexImage[i*im_width+(j-1)]] ];						
									}
									if(CandMaxD<MinDiff){
										MinDiff = CandMaxD;
										p = k;
									}
								}
							}													
						}//for(k=0; k<ClusterNum; k++)
						
						if(MinDiff<=Td){							
							cout<<"Embedding 1 bits! changed"<<TotalEmbeddedBits<<endl;
							IndexImage[i*im_width+j] = ClusterIndex[p][0];
							numEmbeddedOneBit++;
							TotalEmbeddedBits++;
						}
						else{
							numNotEmbeddedOneBit++;
							cout<<"Not Embedding Data! Since replace color isn't satisfied!"<<endl;
						}
					}//if( NowSec != EmCode[TotalEmbeddedBits%SecLength])
					else{
						cout<<"Embedding 1 bits! not changed"<<TotalEmbeddedBits<<endl;
						numEmbeddedOneBit++;
					}
*/		

