package guiDomain;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class OpenDialog extends JDialog
{
    private JTextField experimentField;
    private JTextField shotField;

    private String experiment;
    private int shot;

    private JButton okButton;
    private JButton cancelButton;

    private boolean okPressed;

    /** @param mode Is this dialog modal? */
    public OpenDialog(JFrame parent, String title, boolean mode)
    {
        super( parent, title, mode );

        Container mainPane = getContentPane();
        mainPane.setLayout( new BorderLayout() );

	// data panel
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout( new GridLayout( 2, 2 ) );
        experimentField = new JTextField("edam");
        shotField = new JTextField("17615");
        dataPanel.add( new JLabel( "Experiment" ) );
        dataPanel.add( experimentField );
        dataPanel.add( new JLabel( "Shot #" ) );
        dataPanel.add( shotField );
        mainPane.add( dataPanel, BorderLayout.CENTER );

	// button panel
        JPanel buttonPanel = new JPanel();
        okButton = new JButton( "Ok" );
        okButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                if ( validateFields() )
                {
                    okPressed = true;
                    setVisible( false );
                }
            }
        }
        );

        cancelButton = new JButton( "Cancel" );
        cancelButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                setVisible( false );
            }

        }
        );

        buttonPanel.add( okButton );
        buttonPanel.add( cancelButton );
        mainPane.add( buttonPanel, BorderLayout.SOUTH );

        setBounds( 200, 200, 300, 200 );
    }

    /** Make the dialog visible and set okPressed to "false"*/
    public boolean showDialog()
    {
        okPressed = false;
        this.setVisible(true);

        return okPressed;
    }


    /** Checks the experiment and shot fields for valid input.
    @return "true" if fields are valid, "false" otherwise */
    private boolean validateFields()
    {
        String shottmp;

        try
        {
            experiment = experimentField.getText();
            shottmp = shotField.getText();

        }
        catch ( NullPointerException e )
        {
            JOptionPane.showMessageDialog( this,
            "Error retrieving data from fields",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }

        try
        {
            shot = Integer.parseInt( shottmp );
        }
        catch ( NumberFormatException e )
        {
            JOptionPane.showMessageDialog( this,
            "Invalid Shot Number",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }

        if ( shot <= 0 || shot >= 65536 )
        {
            JOptionPane.showMessageDialog( this,
            "Invalid Shot Number",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }
        return true;
    }

    // get and set methods
    /** @return experiment name */
    public String getExperiment()
    {
        return experiment;
    }
    /** @return shot number */
    public int getShot()
    {
        return shot;
    }
}
