package guiDomain;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;

public class ServerSelectDialog extends JDialog
{
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox factoryCombo;

    private String factoryClassName;
    private String serverCport;
    private String experiment;
    private String shot;
    private String[] args;

    private boolean okPressed;

    private Properties properties = new Properties();

    /** @param mode Is this dialog modal? */
    public ServerSelectDialog(JFrame parent, String title, boolean mode)
    {
        super( parent, title, mode );

        //Open property file and get properties
        try {
            properties.load(new FileInputStream("EScope.properties"));
        }
        catch(Exception exc)
        {
            System.err.println("Cannot load EScope.properties");
        }

        Container mainPane = getContentPane();
        mainPane.setLayout( new BorderLayout() );

        // data panel
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout( new GridLayout( 1, 2 ) );
        dataPanel.add(new JLabel("Data Server"));
        factoryCombo = new JComboBox(getFactoryNames());
        dataPanel.add(factoryCombo);
        mainPane.add( dataPanel, BorderLayout.CENTER );

	// button panel
        JPanel buttonPanel = new JPanel();
        okButton = new JButton( "Ok" );
        okButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                //note that null or blank strings may be found
	        int idx = factoryCombo.getSelectedIndex();
                factoryClassName = getFactoryClassNames()[idx];

		idx++; // add 1 to index to get correct property
                serverCport = properties.getProperty("DataServer_" + idx +
						     ".Source");
                experiment = properties.getProperty("DataServer_" + idx +
						     ".Experiment");
		if (experiment == null) experiment ="";
                shot = properties.getProperty("DataServer_" + idx +
						     ".Shot");
		if (shot == null || shot.equals("")) shot = "-1";

		//check for a list of comma-separated parameters for
                //data server factory method
		args = getPropertyLine("DataServer_" + idx + ".Args");

                okPressed = true;
                setVisible(false);
            }

        }
        );
        cancelButton = new JButton( "Cancel" );
        cancelButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                setVisible( false );
            }

        }
        );
        buttonPanel.add( okButton );
        buttonPanel.add( cancelButton );
        mainPane.add( buttonPanel, BorderLayout.SOUTH );
        setBounds( 200, 200, 400, 150 );
    }

    /** Make the dialog visible and set okPressed to "false"*/
    public boolean showDialog()
    {
        okPressed=false;
        this.setVisible(true);
        return okPressed;
    }

    // get and set methods
    /** @return The server and port separated by a colon */
    public String getServer()
    {
        return serverCport;
    }

    public String getExperiment() { return experiment;}
    public String getShot() { return shot;}
    public String[] getArgs() { return args;}

    public String getFactoryClassName()
    {
        return factoryClassName;
    }

    private String[] getFactoryNames()
    {
        return getPropertyList("Name");
    }

    private String[] getFactoryClassNames()
    {
        return getPropertyList("FactoryClass");
    }

    /** Return a list of single property values for all data servers*/
    private String[] getPropertyList(String propertyName)
    {
	ArrayList<String> result = new ArrayList();
	String property="";
	int idx = 0; //index counter

        while (true)
        {
            idx++;
            property = properties.getProperty("DataServer_" + idx + "."
                + propertyName);
	    if (property==null) return toStringArr(result); //no more servers
	    result.add(property);
	}
    }

    /** Return a list of multiple property values for one specific
        property name. (One line in the properties file.)*/
    private String[] getPropertyLine(String propertyName)
    {
        String namesList = properties.getProperty(propertyName);
        if(namesList == null)
        {
            return new String[0];
        }
        //Get names from comma-separated list
        StringTokenizer st = new StringTokenizer(namesList, ", ");
        String names[] = new String[st.countTokens()];
        for(int i = 0; i < names.length; i++)
            names[i] = st.nextToken();
        return names;
    }


    private String[] toStringArr(ArrayList<String> inStrings)
    {
	int dim = inStrings.size();
	String[] result = new String[dim];
	for (int i =0; i<dim; i++) result[i] = inStrings.get(i);
	return result;
    }
}
