package mdsServerDomain;

import sharedInterfaces.*;
import sharedDataInterfaces.*;

import java.io.*;
import java.util.*;
import javax.swing.*;

public class DataServerProxy
    implements DataServerFacadeInterface
{
    // handle on the real dataServer
    private DataServerFacadeInterface dataServer;
    // list to remember which graphData are locally stored
    ArrayList graphDataList = null;
    // maximum number of files (Note: Demonstration purposes. Not used!)
    int maxFiles;

    /**
      Constructs a new DataServerProxy
     */
    public DataServerProxy()
    {
        this.dataServer = new DataServerFacade();
        graphDataList = new ArrayList();
    }

    public DataServerProxy(String[] params)
    {
	try
	{
	    maxFiles = Integer.parseInt(params[0]);
	}
	catch (Exception e){}
	System.out.println(" Demonstration of passing additional arguments");
	System.out.println(" to DataServerProxy");
	System.out.println(" maxFiles = " + maxFiles);
        this.dataServer = new DataServerFacade();
        graphDataList = new ArrayList();
    }

    public void constructTree(JTree tree) throws IOException
    {
        dataServer.constructTree(tree);
    }

    public void connect(String source) throws IOException
    {
        deleteTempFile();
        dataServer.connect(source);
    }

    public void disconnect() throws IOException
    {
        deleteTempFile();
        dataServer.disconnect();
    }

    public void open(String _experiment, int _shot) throws IOException
    {
        deleteTempFile();
        dataServer.open(_experiment, _shot);
    }

    public void close() throws IOException
    {
        deleteTempFile();
        dataServer.close();
    }

    public boolean isConnected()
    {
        return dataServer.isConnected();
    }

    public boolean isOpen()
    {
        return dataServer.isOpen();
    }


    public String getExperiment()
    {
        return dataServer.getExperiment();
    }

    public int getShot()
    {
        return dataServer.getShot();
    }

    /**
     Gets the plot data (x-values, y-values, x-units, y-units) for a node.
     Once loaded saved locally in tmp file. On request for same node, local
     data is used.
     @param inPath Specifies the path of the node to be retrieved
     @return a GraphData object which stores waveform data
     */
    public GraphDataInterface getPlotData(String inPath)
    {
        GraphDataInterface output = null;

        try
        {
            // First check whether graph is already saved locally
            for (int i = 0; i < graphDataList.size(); i++)
            {
                if (inPath.equals( (String) graphDataList.get(i)))
                {
                    FileInputStream fis = new FileInputStream(i + ".tmp");
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    output = (GraphDataInterface) ois.readObject();
                    ois.close();
                    fis.close();

                    System.out.println("Graph " + inPath + " is loaded from " +
                                       i + ".tmp");
                    return output;
                }
            }

            // Not locally saved, so get it from real retriever
            output = dataServer.getPlotData(inPath);

            // Now save it locally for next time if data valid
            if(!output.getIsDataError())
            {
                FileOutputStream fos = new FileOutputStream(graphDataList.size() +
                                                            ".tmp");
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(output);
                oos.close();
                fos.close();
                System.out.println("Graph " + inPath + " is stored in " +
                                   graphDataList.size() + ".tmp");
                graphDataList.add(inPath);
            }
        }
        catch (FileNotFoundException e1)
        {
            System.out.println("FileNotFoundException : " + e1);
        }
        catch (IOException e2)
        {
            System.out.println("IOException : " + e2);
        }
        catch (ClassNotFoundException e3)
        {
            System.out.println("ClassNotFoundException : " + e3);
        }

        // Finally return output
        return output;
    }

    public void deleteTempFile()
    {
        // When experiment is closed local tmp files are removed.
        File temp = null;
        for (int i = 0; i < graphDataList.size(); i++)
        {
            temp = new File(i + ".tmp");
            temp.delete();
        }
        graphDataList = new ArrayList();
    }
}
