package guiDomain;
abstract public class AbstractNotifier {
    boolean terminated = false;
    boolean valid = true;
    abstract void specificExecutionTerminated();
    public synchronized void executionTerminated()
    {
        specificExecutionTerminated();
        terminated = true;
        notifyAll();
    }

    public synchronized boolean waitForTermination()
    {
        while(!terminated && valid)
        {
            try {
                wait();
            }catch(InterruptedException exc) {}
        }
        return valid;
    }

    public synchronized void invalidate()
    {
        valid = true;
        notifyAll();
    }
}
