package graphicsDomain;

import java.awt.*;

/** Encapsulates methods to draw axes and tick marks and labels */
public class DrawAxisTicksY extends DrawAxisTicks
{
    public DrawAxisTicksY() { super();}

    //Get maximum, minumum avlues and size in pixel (returned in a double array)
    //for Y axis
    public double[] getMaxMinLen(GraphMetrics metrics)
    {
	double yMin = metrics.getMinYData();
	double yMax = metrics.getMaxYData();
	double dLen = metrics.getYSize();
	return new double[] {yMin,yMax,dLen};
    }

    //Draw the current line in the Y tick grid, based on the current tick value
    public int drawTickGrid(Graphics2D g2D, GraphMetrics metrics)
    {
        // Draw little tick mark
        int gp = metrics.getYPixel(currentTickVal);
        int xr = (int) borderSize;
        int xl = xr-tickPix; // Number of pixels left of the axis for tick
        g2D.drawLine(xl,gp,xr,gp); // Draw little tick

        // Draw grid line
        g2D.drawLine(borderSize,gp,(int)xSize-borderSize,gp);
	return gp;
    }

    //Draw the current Y tick label
    public void drawTickLabel(Graphics2D g2D)
    {
        // Draw label
        int xp = (int) (1.5*axisLabelHeight + textFac*stringHeight);
        int yp = currentTickPixel + ((int)(stringWidth/2.0));
        // Rotate and draw string; rotate back
        g2D.rotate(-90.0*Math.PI/180.,xp,yp);
        g2D.drawString(tickLabel,xp,yp);
        g2D.rotate(90.0*Math.PI/180.,xp,yp);
    }

    //Store Y scientific label suffix in metrics
    public void setSciLabel(GraphMetrics metrics,String label)
    {
	metrics.getGraphData().setYSuffix(label);
    }
}
