package graphicsDomain;

import java.awt.*;
import java.awt.geom.Line2D;

public class DrawWaveform 
{
    public DrawWaveform() {}

    public void draw(GraphMetrics metrics, Graphics2D g2)
    {
	GraphDataInGraphics graphData = metrics.getGraphData();

        Point[]points = metrics.getPixelArray(graphData.getX(), graphData.getY());
	g2.setStroke(metrics.getGraphOptions().getLineStroke());
	g2.setColor(metrics.getGraphOptions().selectColor(
            metrics.getGraphOptions().getLineColor()));

        for(int i = 0; i < points.length-1; i++)
        {
          Line2D line = new Line2D.Float (points[i].x, points[i].y,
                          points[i+1].x,points[i+1].y);
          g2.draw(line);

        }
    }
}

