package sharedDataInterfaces;

import java.awt.*;

/** Stores the options settings for the graph panel */
public interface GraphOptionsInterface
{
    public static final int numColors = 13;
    public static final int BLACK = 0;
    public static final int WHITE = 1;
    public static final int RED = 2;
    public static final int BLUE = 3;
    public static final int ORANGE = 4;
    public static final int GRAY = 5;
    public static final int LGRAY = 6;
    public static final int DGRAY = 7;
    public static final int MAGENTA = 8;
    public static final int GREEN = 9;
    public static final int YELLOW = 10;
    public static final int CYAN = 11;
    public static final int PINK = 12;

    public static final  String[] colorNames = {"Black","White","Red","Blue"
	,"Orange","Gray","L. Gray","D. Gray","Magenta","Green","Yellow",
				  "Cyan","Pink"};

    /** returns a Color object corresponding to index i */
    public Color selectColor(int i);
    /** returns a string colour name corresponding to index i */
    public String selectColorName(int i);

    public int getTitleColor();

    public int getGraphColor();

    public int getLineColor();

    public boolean getDefaultBorder();

    public boolean getNiceNumbers();
}
