package graphicsDomain;

import java.awt.*;
import java.awt.geom.*;

//Encapsulates methods for drawing a crosshair centered on the waveform at the given X position
public class DrawCrossHair  extends GraphDecorator
{
    //The current mouse X position is used to find the centre of the crosshair
    private int currX;

    public DrawCrossHair(GraphMediator med) { super(med);}

    public void setCurrX(int currX)
    {
        this.currX = currX;
    }

    //Draw the crosshair
    public void drawThis(Graphics2D g2)
    {
        Point[] points = med.getPixelArray(med.getGraphData().getX(), med.getGraphData().getY());
        int xSize = med.getXSize();
        int ySize = med.getYSize();

        /* Draw cursor */
        // First find index of closest x data point
        // find closest data value from xScaled
        int minIdx = 0;
        double minDist = Math.abs(currX - points[0].x);
        double currDist = minDist;
        for (int i = 1; i < points.length; i++)
        {
            currDist = Math.abs(currX - points[i].x);
            if (currDist < minDist)
            {
                minDist = currDist;
                minIdx = i;
            }
        }
        // set xData to xVals at minimum distance
        double xdata = med.getXValue(points[minIdx].x);
        double ydata = med.getYValue(points[minIdx].y);

        //Notify listener of the update
        med.getGraphicsFacade().graphPointUpdated(xdata, ydata, true);
        // draw large cursor marker on graph
        g2.setStroke(med.getGraphOptions().getLineStroke());
        Line2D xLine = new Line2D.Float(0, points[minIdx].y,
                                        xSize, points[minIdx].y);
        Line2D yLine = new Line2D.Float(points[minIdx].x, ySize,
                                        points[minIdx].x, 0);
        g2.draw(xLine);
        g2.draw(yLine);
    }
    public String toString()
    {
        return "DrawCrossHair";
    }

}
