package graphicsDomain;
import sharedDataInterfaces.*;

/** Adapted version of GraphData.
Adds scientific suffix to axes labels. Can set special values of
minYData, maxYData, etc., to guard against divide by zero.*/
public class GraphDataInGraphics
{
    private GraphDataInterface graphData;
    private String xSuffix,ySuffix;
    double minXData=0,maxXData=0,minYData=0,maxYData=0;

    public GraphDataInGraphics(GraphDataInterface gData)
    {
	graphData=gData;
	if (graphData.getIsGraphData())
	{
	    double xMin = graphData.getMinX();
	    double xMax = graphData.getMaxX();
	    double yMin = graphData.getMinY();
	    double yMax = graphData.getMaxY();
            double deltaX = xMax - xMin;
            double deltaY = yMax - yMin;

	    // Deal with small denominators
	    if (Math.abs(deltaY)<1.e-6) // warning: hard coding
	    { // Cope with zero range in the data
	        System.out.println(" GraphDataInGraphics: small demoninator in y values");
	        double absVal = Math.abs(yMin);
	        if (absVal > 0.)
	        {
		    yMin = yMin - 0.5*absVal;
		    yMax = yMax + 0.5*absVal;
	        }
	        else
	        {
		    yMin = -.5;
		    yMax = .5;
	        }
	    }
	    if (Math.abs(deltaX)<1.e-6) // warning: hard coding
	    { // Cope with zero range in the data
	        System.out.println(" GraphDataInGraphics: small demoninator in x values");
	        double absVal = Math.abs(xMin);
	        if (absVal > 0.)
	        {
	    	    xMin = xMin - 0.5*absVal;
		    xMax = xMax + 0.5*absVal;
	        }
	        else
	        {
		    xMin = -.5;
		    xMax = .5;
	        }
	    }
	    minXData = xMin;
	    maxXData = xMax;
	    minYData = yMin;
	    maxYData = yMax;
	}
    }

    public void setXSuffix(String suffix)
    {
	xSuffix = suffix;
    }

    public void setYSuffix(String suffix)
    {
	ySuffix = suffix;
    }

    public String getFullXLabel()
    {
	return graphData.getXLabel() + xSuffix;
    }
    public String getFullYLabel()
    {
	return graphData.getYLabel() + ySuffix;
    }


    public int getLength(){ return graphData.getLength();}
    public double getMinX(){ return minXData;}
    public double getMaxX(){ return maxXData;}
    public double getMinY(){ return minYData;}
    public double getMaxY(){ return maxYData;}
    public double[] getX(){ return graphData.getX();}
    public double[] getY(){ return graphData.getY();}
    public String getTitle(){ return graphData.getTitle();}
    public boolean getIsGraphData(){ return graphData.getIsGraphData();}
    public boolean getIsDataError(){ return graphData.getIsDataError();}
}
