package guiDomain;
import sharedDataInterfaces.GraphOptionsInterface;

import java.awt.*;

/** Stores the options settings for the graph panel */
public class GraphOptions implements GraphOptionsInterface
{
    // Color indices for Colors
    private int titleColor=RED, graphColor=WHITE, lineColor=BLACK;
    private boolean defaultBorder=true;
    private boolean niceNumbers=true;

    private int displayMode = CROSSHAIR_MODE;

    public GraphOptions()
    {
    }

    public Color selectColor(int i)
    {
	switch (i)
	{
	    case 0:
		return Color.black;
	    case 1:
		return Color.white;
	    case 2:
		return Color.red.darker();
	    case 3:
		return Color.blue;
	    case 4:
		return Color.orange;
	    case 5:
		return Color.gray;
	    case 6:
		return Color.lightGray;
	    case 7:
		return Color.darkGray;
	    case 8:
		return Color.magenta;
	    case 9:
		return Color.green;
	    case 10:
		return Color.yellow;
	    case 11:
		return Color.cyan;
	    case 12:
		return Color.pink;
	}
	return Color.black; //index out of range
    }

    public String selectColorName(int i)
    {
		if (i>=0 && i<numColors)
			return colorNames[i];
		return ""; // index out of range
    }

    public void setTitleColor(int colorIndex) {titleColor=colorIndex;}
    public int getTitleColor() {return titleColor;}

    public void setGraphColor(int colorIndex) {graphColor=colorIndex;}
    public int getGraphColor() {return graphColor;}

    public void setLineColor(int colorIndex) {lineColor=colorIndex;}
    public int getLineColor() {return lineColor;}

    public void setDefaultBorder(boolean isDefault) {defaultBorder=isDefault;}
    public boolean getDefaultBorder() {return defaultBorder;}

    public void setNiceNumbers(boolean isNice) {niceNumbers=isNice;}
    public boolean getNiceNumbers() {return niceNumbers;}

    public void setDisplayMode(int mode) {displayMode = mode;}
    public int getDisplayMode() {return displayMode;}

}

