package graphicsDomain;

import java.awt.*;

/** Encapsulates methods to draw axes and tick marks and labels */
public class DrawAxisTicksX extends DrawAxisTicks
{
    public DrawAxisTicksX(GraphMediator med) { super(med);}

    //Get maximum, minumum avlues and size in pixel (returned in a double array)
    //for either X axis
    public double[] getMaxMinLen()
    {
	double xMin = med.getMinXData();
	double xMax = med.getMaxXData();
	double dLen = med.getXSize();
	return new double[] {xMin,xMax,dLen};
    }
    //Draw the current line in the X tick grid  based on the current tick value
    public int drawTickGrid(Graphics2D g2D)
    {
        // Draw little tick mark
        int gp = med.getXPixel(currentTickVal);
        int yu = (int) ySize-borderSize;
        int yl = yu+tickPix; // Number of pixels below the axis for tick
        g2D.drawLine(gp,yu,gp,yl); // Draw little tick

        // Draw grid line
        g2D.drawLine(gp,yu,gp,borderSize);
	return gp;
    }

    //Draw the current X tick label
    public void drawTickLabel(Graphics2D g2D)
    {
        // Draw label
        int xp = currentTickPixel - (int) (stringWidth/2.0);
        int tickOffset = 3;
        int yp = (int) (ySize - borderSize + tickOffset + textFac*stringHeight);
	if (borderSize<stringHeight)
	    yp = (int) (ySize - stringHeight + textFac*stringHeight);
        g2D.drawString(tickLabel,xp,yp);
    }
    //Store X scientific label suffix in med
    public void setSciLabel(String label)
    {
	med.getGraphData().setXSuffix(label);
    }
    public String toString()
    {
        return "DrawAxisTicksX";
    }

}

