import java.io.*;

/** This version reads in some MDSplus data and writes it to 2 files:

    File "data_yVals": Number of y values; expression

    File "data_xVals": Number of x values; dim_of(expression)
*/

public class PreEScope0
{
    public static void main(String[] args)
    {
        new PreEScope0(args);
    }

    public PreEScope0(String[] args)
    {
        String server;
        String experiment;
        int shot=0;
        String expression = " ";
        int i,yLen,xLen;
	double[] yVals,xVals;

        MDSNetworkSource dataSource;
        MDSDescriptor result2=null, result4=null;

        /*
        * Make sure all the parameters are given
        */
        if ( args.length != 4 )
        {
            System.out.println( "Usage: PreEScope0 <server> " +
            "<experiment> <shot> <expression>" );
            System.exit(-1);
        }

        /*
        * Get the parameters
        */
        server = args[0];
        experiment = args[1];
        expression = args[3];

        try
        {
            shot = Integer.parseInt( args[2] );
        }
        catch ( NumberFormatException e )
        {
            System.out.println( "Invalid Shot Number: " + e.getMessage() );
            System.exit(-1);
        }

        /*
        * Connect to server and open experiment
        */

        dataSource = new MDSNetworkSource();
        try
        {
            System.out.println( "\nConnecting to server ..." );
            dataSource.connect( server );

            System.out.println( "Opening Experiment and Shot ..." );
            dataSource.open( experiment, shot );
        }
        catch ( IOException e )
        {
            System.out.println( "Failed to communicate with server: " +
            e.getMessage() );
            System.exit(-1);
        }

        try
        {
            System.out.println( "Evaluating Expression ..." + expression );
            result2 = dataSource.evaluate( expression );
            if(result2.getDoubleData() == null)
            {
                 System.out.println("Failed to retrieve " + expression + ": " + result2.getCstringData());
                 System.exit(-1);
            }

	    expression="dim_of("+expression+")";
            System.out.println( "Evaluating Expression ..." + expression );
            result4 = dataSource.evaluate( expression );
            if(result4.getDoubleData() == null)
            {
                 System.out.println("Failed to retrieve " + expression + ": " + result2.getCstringData());
                 System.exit(-1);
            }

        }
        catch ( IOException e )
        {
            System.out.println( "Failed to communicate with server: "
				+ e.getMessage() );
            System.exit(-1);
        }
        //Check for errors when retrieving signals

	try
	{
	    File f2 = new File("data_yVals");
	    f2.createNewFile();
	    DataOutputStream out2 =
	       new DataOutputStream(
	       new BufferedOutputStream(new FileOutputStream(f2)));

	    File f3 = new File("data_xVals");
	    f3.createNewFile();
	    DataOutputStream out3 =
	       new DataOutputStream(
	       new BufferedOutputStream(new FileOutputStream(f3)));


	    yLen = result2.getDoubleData().length;
	    xLen = result4.getDoubleData().length;

            yVals = new double[yLen];
            xVals = new double[xLen];

	    yVals = result2.getDoubleData();
	    xVals = result4.getDoubleData();

	    out2.writeInt(yLen);
	    out3.writeInt(xLen);

	    for ( i = 0; i < yLen; i++ )
	    {
	        out2.writeDouble(yVals[i]);
	    }

	    for ( i = 0; i < xLen; i++ )
	    {
	        out3.writeDouble(xVals[i]);
	    }
	    out2.flush();
      	    out2.close();
	    out3.flush();
      	    out3.close();

	    Plotter.plot(xVals,yVals,"test");
	}
	catch (IOException e) {System.out.println(e);}

        /*
        * Close experiment and disconnect from server
        */
        try
        {
            System.out.println( "\nClosing Experiment ..." );
            dataSource.close();

            System.out.println( "Disconnecting from server ..." );
            dataSource.disconnect();

            dataSource = null;
        }
        catch ( IOException e )
        {
            System.out.println( "Failed to communicate with server: " + e.getMessage() );
            System.exit(-1);
        }
    }
}


