import java.io.*;

/** This class calls MDSTree to create the directory tree corresponding
to one particular shot*/

public class ExperimentTree
{
    public static void main(String[] args)
    {
        new ExperimentTree(args);
    }

    /** @param args <br>args[0] - <i>server<b>:</b>port</i><br>args[1] -
	<i>experiment</i><br>args[2] - <i>shot</i> */
    public ExperimentTree(String[] args)
    {
	MDSDataSource database;
        MDSTree tree;
	MDSTreeNode treeNode;
	String server;
	String experiment;
	int shot;

        // Make sure all the parameters are given
	if ( args.length != 3 )
	{
	    System.out.println( "usage: ExperimentTree <server> " 
                 + "<experiment> <shot #>" );
	    return;
        }

	server = args[0];
	experiment = args[1];

	try
	{
	    shot = Integer.parseInt( args[2] );
	}
	catch ( NumberFormatException e )
	{
	    System.out.println( "Invalid shot number: " + e.getMessage() );
	    System.out.println( "usage: ExperimentTree <server> " + "<experiment> <shot #>" );
	    return;
        }
        
        // Connect to server
	database = new MDSNetworkSource();
	try
	{
	    database.connect(server);
	    database.open( experiment, shot );
            // get the tree
	    treeNode = new MDSTreeNode();
            tree = new MDSTree( database,treeNode );
	    tree.getTree();

	    database.close();
	    database.disconnect();
        }
	catch ( IOException e )
	{
	    System.out.println( "Error communicating with server: " +
		  e.getMessage() );
	    return;
	}
    }
}
