/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Ballot
implements Cloneable {
    private Vector vote;
    private Vector oVoteStore;
    private Vector vVoteStore;
    private Vector pointStore;
    private Vector bPointStore;
    private Vector talliedSMV;
    private Vector talliedTwoRoundMV;
    private Vector talliedAltV;
    private Vector talliedAppV;
    private Vector talliedCondorcet;
    private Vector talliedBorda;
    private Vector talliedBordaP;
    private Vector talliedSV;
    private boolean serialDraw = false;
    private boolean twoRoundDraw = false;
    private boolean AVDraw = false;
    private int numPrefs = 0;
    private final int MAX_VALUE = 14;
    private static int voteNumber = 0;

    public Ballot() {
        this.vote = new Vector(14, 1);
        this.oVoteStore = new Vector(0, 1);
        this.vVoteStore = new Vector(0, 1);
        this.pointStore = new Vector(0, 1);
        this.bPointStore = new Vector(0, 1);
        this.talliedSMV = new Vector(0, 1);
        this.talliedTwoRoundMV = new Vector(0, 1);
        this.talliedAltV = new Vector(0, 1);
        this.talliedAppV = new Vector(0, 1);
        this.talliedCondorcet = new Vector(0, 1);
        this.talliedBorda = new Vector(0, 1);
        this.talliedBordaP = new Vector(0, 1);
        this.talliedSV = new Vector(0, 1);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Ballot(int size) {
        this.vote = new Vector(size > 14 || size < 1 ? (size = 10) : size, 1);
        this.oVoteStore = new Vector(0, 1);
        this.vVoteStore = new Vector(0, 1);
        this.pointStore = new Vector(0, 1);
        this.bPointStore = new Vector(0, 1);
        this.talliedSMV = new Vector(0, 1);
        this.talliedTwoRoundMV = new Vector(0, 1);
        this.talliedAltV = new Vector(0, 1);
        this.talliedAppV = new Vector(0, 1);
        this.talliedCondorcet = new Vector(0, 1);
        this.talliedBorda = new Vector(0, 1);
        this.talliedBordaP = new Vector(0, 1);
        this.talliedSV = new Vector(0, 1);
    }

    public boolean isEmpty(Vector v) {
        return v.isEmpty();
    }

    public void clear() {
        this.oVoteStore.clear();
        this.vVoteStore.clear();
        this.pointStore.clear();
        this.bPointStore.clear();
        this.talliedSMV.clear();
        this.talliedTwoRoundMV.clear();
        this.talliedAltV.clear();
        this.talliedAppV.clear();
        this.talliedCondorcet.clear();
        this.talliedBorda.clear();
        this.talliedBordaP.clear();
        this.talliedSV.clear();
        voteNumber = 0;
    }

    public void setNumPrefs(int i) {
        this.numPrefs = i;
        if (voteNumber == 1) {
            for (int count = 0; count < this.numPrefs; ++count) {
                this.talliedTwoRoundMV.add(count, "0");
            }
        }
    }

    public int getNumPrefs() {
        return this.numPrefs;
    }

    public void truncatePrefs(int truncateFrom) {
        this.pointStore.clear();
        this.bPointStore.clear();
        for (int i = 0; i < this.oVoteStore.size(); ++i) {
            int j;
            Vector thisVote = (Vector)this.oVoteStore.elementAt(i);
            Vector thisVoteCopy = (Vector)thisVote.clone();
            if (truncateFrom > thisVoteCopy.size()) {
                for (j = thisVoteCopy.size(); j < truncateFrom; ++j) {
                    thisVoteCopy.add(j, "0");
                }
            }
            if (truncateFrom < thisVoteCopy.size()) {
                for (j = thisVoteCopy.size() - 1; j >= truncateFrom; --j) {
                    thisVoteCopy.removeElementAt(j);
                }
            }
            thisVoteCopy.trimToSize();
            Vector thisVoteCopy2 = (Vector)thisVoteCopy.clone();
            Vector validNew = this.validate(thisVoteCopy);
            Vector validNew2 = this.validate(thisVoteCopy2);
            this.vVoteStore.set(i, validNew);
            Vector points = this.tally(validNew);
            Vector bPoints = this.tallyB(validNew2);
            this.pointStore.add(points);
            this.bPointStore.add(bPoints);
        }
    }

    public void recordVote(Vector v) {
        Vector vCopy = (Vector)v.clone();
        boolean count = false;
        int maxCount = v.size();
        int flag = -1;
        boolean target = false;
        ++voteNumber;
        this.oVoteStore.add(v);
        vCopy = this.validate(vCopy);
        this.vVoteStore.add(vCopy);
        Vector tempCopy = (Vector)vCopy.clone();
        Vector tempCopy2 = (Vector)vCopy.clone();
        tempCopy = this.tally(tempCopy);
        tempCopy2 = this.tallyB(tempCopy2);
        this.pointStore.add(tempCopy);
        this.bPointStore.add(tempCopy2);
    }

    public void recordVote(int element, Vector v) {
        Vector vCopy = (Vector)v.clone();
        boolean count = false;
        int maxCount = v.size();
        int flag = -1;
        boolean target = false;
        this.oVoteStore.set(element, v);
        vCopy = this.validate(vCopy);
        this.vVoteStore.set(element, vCopy);
        Vector tempCopy = (Vector)vCopy.clone();
        Vector tempCopy2 = (Vector)vCopy.clone();
        tempCopy = this.tally(tempCopy);
        tempCopy2 = this.tallyB(tempCopy2);
        this.pointStore.set(element, tempCopy);
        this.bPointStore.set(element, tempCopy2);
    }

    public Vector validate(Vector vCopy) {
        int i2;
        int i;
        int count = 0;
        int maxCount = vCopy.size();
        int flag = -1;
        boolean target = false;
        for (i = vCopy.size(); i < this.numPrefs; ++i) {
            vCopy.add(i, "0");
        }
        for (i = 0; i < this.numPrefs; ++i) {
            char[] source = vCopy.elementAt(i).toString().toCharArray();
            for (int j = 0; j < source.length; ++j) {
                if (!Character.isDigit(source[j]) && !Character.isIdentifierIgnorable(source[j]) && !Character.isISOControl(source[j]) || Character.isSpaceChar(source[j]) || Character.isWhitespace(source[j])) {
                    vCopy.set(i, "0");
                }
                if (!vCopy.elementAt(i).equals("1")) continue;
                flag = 3;
            }
        }
        if (flag != 3) {
            for (i = 0; i < this.numPrefs; ++i) {
                vCopy.set(i, "0");
            }
        } else {
            flag = -1;
        }
        Vector tempCopy = (Vector)vCopy.clone();
        this.sortVote(tempCopy);
        while (flag == -1 && count < tempCopy.size() - 1) {
            String s2;
            String s1 = (String)tempCopy.elementAt(count);
            int i1 = Integer.parseInt(s1);
            if (i1 == (i2 = Integer.parseInt(s2 = (String)tempCopy.elementAt(count + 1))) && i2 != 0) {
                flag = 0;
                count -= 2;
            }
            if (i2 - i1 != 1 && i2 - i1 != 0) {
                flag = 1;
                count -= 2;
            }
            if (i1 == i2 && i2 == 1) {
                flag = 2;
                count -= 2;
            }
            ++count;
        }
        if (flag == 0 || flag == 1 || flag == 2) {
            int i3;
            for (i3 = 0; i3 < tempCopy.size(); ++i3) {
                String s1 = (String)tempCopy.elementAt(i3);
                int i1 = Integer.parseInt(s1);
                if (i1 <= 0) {
                    tempCopy.set(i3, "0");
                }
                if (flag == 0 && i3 > count) {
                    tempCopy.set(i3, "0");
                }
                if (flag == 1 && i3 > count + 1) {
                    tempCopy.set(i3, "0");
                }
                if (flag != 2) continue;
                for (int c = 0; c < tempCopy.size(); ++c) {
                    tempCopy.set(c, "0");
                }
            }
            for (i3 = 0; i3 < tempCopy.size(); ++i3) {
                int i1 = this.maximum(tempCopy);
                String s2 = (String)vCopy.elementAt(i3);
                i2 = Integer.parseInt(s2);
                if (i2 <= i1) continue;
                vCopy.set(i3, "0");
            }
        }
        return vCopy;
    }

    public Vector tallyB(Vector vCopy) {
        int leastPreferred = this.maximum(vCopy);
        int points = 1;
        Vector tempCopy = (Vector)vCopy.clone();
        while (leastPreferred > 0) {
            for (int i = 0; i < vCopy.size(); ++i) {
                String s1 = (String)vCopy.elementAt(i);
                int i1 = Integer.parseInt(s1);
                if (i1 != leastPreferred || leastPreferred <= 0) continue;
                tempCopy.set(i, String.valueOf(points));
                vCopy.set(i, "0");
                ++points;
                leastPreferred = this.maximum(vCopy);
            }
        }
        return tempCopy;
    }

    public Vector tally(Vector vCopy) {
        int target = this.maximum(vCopy);
        int score = this.numPrefs + 1;
        Vector tempCopy = (Vector)vCopy.clone();
        Vector tempCopy2 = (Vector)vCopy.clone();
        for (int count = 0; target > 0 || count < tempCopy.size(); ++count) {
            target = this.maximum(tempCopy2);
            if (target <= 0) continue;
            for (int i = 0; i < vCopy.size(); ++i) {
                String s1 = (String)vCopy.elementAt(i);
                int i1 = Integer.parseInt(s1);
                if (i1 != target) continue;
                tempCopy.set(i, String.valueOf(score - target));
                tempCopy2.set(i, "0");
            }
        }
        return tempCopy;
    }

    public Vector sortVote(Vector vec) {
        for (int top = vec.size() - 1; top > 0; --top) {
            for (int i = 0; i < top; ++i) {
                String s1 = (String)vec.elementAt(i);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)vec.elementAt(i + 1);
                int i2 = Integer.parseInt(s2);
                if (i2 >= i1) continue;
                int temp = i1;
                i1 = i2;
                i2 = temp;
                String sOne = String.valueOf(i1);
                String sTwo = String.valueOf(i2);
                vec.set(i, sOne);
                vec.set(i + 1, sTwo);
            }
        }
        return vec;
    }

    public int getNumVotes() {
        return voteNumber;
    }

    public Vector auditVote(int ballotNumber) {
        return (Vector)this.vVoteStore.elementAt(ballotNumber);
    }

    public Vector returnVote(int ballotNumber) {
        return (Vector)this.oVoteStore.elementAt(ballotNumber);
    }

    protected Vector returnPoints(int ballotNumber) {
        return (Vector)this.pointStore.elementAt(ballotNumber);
    }

    protected Vector returnBPoints(int ballotNumber) {
        return (Vector)this.bPointStore.elementAt(ballotNumber);
    }

    protected int maximum(Vector v) {
        int count = 0;
        for (int c = 0; c < this.numPrefs; ++c) {
            String s1 = (String)v.elementAt(c);
            int i1 = s1.equals("-") ? 0 : Integer.parseInt(s1);
            if (i1 <= count) continue;
            count = i1;
        }
        return count;
    }

    public String toString() {
        return this.oVoteStore.toString();
    }

    public Vector simpleMajorityVote() {
        Vector temp = new Vector();
        this.talliedSMV.clear();
        for (int count = 0; count < this.numPrefs; ++count) {
            this.talliedSMV.add(count, "0");
        }
        for (int i = 0; i < voteNumber; ++i) {
            temp = (Vector)this.pointStore.elementAt(i);
            for (int j = 0; j < this.numPrefs; ++j) {
                String s1 = (String)temp.elementAt(j);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedSMV.elementAt(j);
                int i2 = Integer.parseInt(s2);
                if (i1 != this.maximum(temp) || i1 < 1) continue;
                i1 = 1;
                this.talliedSMV.set(j, String.valueOf(i1 + i2));
            }
        }
        return this.talliedSMV;
    }

    public Vector twoRoundMV() {
        int count;
        int i;
        int i2;
        Vector twoRoundPointStore = (Vector)this.pointStore.clone();
        Vector talliedTwoRoundMVBackup = (Vector)this.talliedTwoRoundMV.clone();
        Vector temp = new Vector(0, 1);
        Vector temp2 = new Vector(0, 1);
        int maxScore = 0;
        int firstElement = 0;
        int secondElement = 1;
        int total = 0;
        boolean empty = false;
        boolean winner = false;
        int numMaxima = 0;
        this.setTwoRoundDraw(false);
        this.talliedTwoRoundMV.clear();
        for (int count2 = 0; count2 < this.numPrefs; ++count2) {
            this.talliedTwoRoundMV.add(count2, "0");
            talliedTwoRoundMVBackup.add(count2, "0");
        }
        for (i2 = 0; i2 < voteNumber; ++i2) {
            temp = (Vector)this.pointStore.elementAt(i2);
            temp2 = (Vector)temp.clone();
            for (int j = 0; j < temp2.size(); ++j) {
                String s1 = (String)temp2.elementAt(j);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedTwoRoundMV.elementAt(j);
                int i22 = Integer.parseInt(s2);
                empty = this.maximum(temp2) <= 0;
                if (i1 != this.maximum(temp2) || i1 <= 0) continue;
                i1 = 1;
                this.talliedTwoRoundMV.set(j, String.valueOf(i1 + i22));
            }
        }
        for (i2 = 0; i2 < this.numPrefs; ++i2) {
            String s1 = (String)this.talliedTwoRoundMV.elementAt(i2);
            total += Integer.parseInt(s1);
        }
        double max = Double.parseDouble(String.valueOf(this.maximum(this.talliedTwoRoundMV)));
        double percentage = max / (double)total * 100.0;
        if (percentage > 50.0) {
            return this.talliedTwoRoundMV;
        }
        for (i = 0; i < this.numPrefs; ++i) {
            if (Double.parseDouble(String.valueOf(this.talliedTwoRoundMV.elementAt(i))) != max || !(max > 0.0) || ++numMaxima <= 1) continue;
            this.setTwoRoundDraw(true);
        }
        if (empty) {
            for (count = 0; count < this.numPrefs; ++count) {
                if (this.talliedTwoRoundMV.elementAt(count) != "-") continue;
                this.talliedTwoRoundMV.set(count, "0");
            }
        }
        talliedTwoRoundMVBackup.clear();
        for (i = 0; i < 2; ++i) {
            boolean maxFound = false;
            maxScore = this.maximum(this.talliedTwoRoundMV);
            for (int count3 = 0; count3 < temp.size() && !maxFound; ++count3) {
                String s1 = (String)this.talliedTwoRoundMV.elementAt(count3);
                int i1 = Integer.parseInt(s1);
                if (i1 != maxScore) continue;
                this.talliedTwoRoundMV.set(count3, "0");
                if (i == 0) {
                    firstElement = count3;
                }
                if (i == 1) {
                    secondElement = count3;
                }
                maxFound = true;
            }
        }
        this.talliedTwoRoundMV.clear();
        for (count = 0; count < this.numPrefs; ++count) {
            this.talliedTwoRoundMV.add(count, "0");
        }
        for (i = 0; i < voteNumber; ++i) {
            boolean set = false;
            temp = (Vector)this.pointStore.elementAt(i);
            temp2 = (Vector)temp.clone();
            for (int j = 0; j < temp2.size(); ++j) {
                String s4;
                int i4;
                String s1 = (String)this.talliedTwoRoundMV.elementAt(firstElement);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedTwoRoundMV.elementAt(secondElement);
                int i23 = Integer.parseInt(s2);
                String s3 = (String)temp2.elementAt(firstElement);
                int i3 = Integer.parseInt(s3);
                if (i3 > (i4 = Integer.parseInt(s4 = (String)temp2.elementAt(secondElement))) && i3 > 0 && !set) {
                    this.talliedTwoRoundMV.set(firstElement, String.valueOf(++i1));
                    set = true;
                    continue;
                }
                if (i3 >= i4 || i4 <= 0 || set) continue;
                this.talliedTwoRoundMV.set(secondElement, String.valueOf(++i23));
                set = true;
            }
        }
        return this.talliedTwoRoundMV;
    }

    public Vector alternativeVote() {
        Vector altPointStore = (Vector)this.pointStore.clone();
        Vector temp = new Vector(0, 1);
        Vector temp2 = new Vector(0, 1);
        double percentage = 0.0;
        int total = 0;
        int leastPreferred = 0;
        int numMaxima = 0;
        int numMinima = 0;
        int x = 10;
        this.setAVDraw(false);
        while (percentage <= 50.0) {
            int i;
            --x;
            total = 0;
            numMaxima = 0;
            numMinima = 0;
            this.talliedAltV.clear();
            for (int count = 0; count < this.numPrefs; ++count) {
                this.talliedAltV.add(count, "0");
            }
            for (int i2 = 0; i2 < voteNumber; ++i2) {
                temp = (Vector)altPointStore.elementAt(i2);
                temp2 = (Vector)temp.clone();
                for (int j = 0; j < temp2.size(); ++j) {
                    String s1 = (String)temp2.elementAt(j);
                    int i1 = Integer.parseInt(s1);
                    String s2 = (String)this.talliedAltV.elementAt(j);
                    int i22 = Integer.parseInt(s2);
                    if (i1 != this.maximum(temp2) || i1 <= 0) continue;
                    i1 = 1;
                    this.talliedAltV.set(j, String.valueOf(i1 + i22));
                }
            }
            for (int n = 0; n < this.numPrefs; ++n) {
                String s1 = (String)this.talliedAltV.elementAt(n);
                total += Integer.parseInt(s1);
            }
            double max = Double.parseDouble(String.valueOf(this.maximum(this.talliedAltV)));
            percentage = max / (double)total * 100.0;
            for (i = 0; i < this.numPrefs; ++i) {
                if ((double)Integer.parseInt(String.valueOf(this.talliedAltV.elementAt(i))) != max || !(max > 0.0) || ++numMaxima <= 1) continue;
                this.setAVDraw(true);
            }
            if (total == 0 || !(percentage <= 50.0)) continue;
            for (i = 0; i < this.talliedAltV.size(); ++i) {
                String leastP = (String)this.talliedAltV.elementAt(i);
                leastPreferred += Integer.parseInt(leastP);
            }
            int element = -1;
            for (i = this.numPrefs - 1; i >= 0; --i) {
                String s1 = (String)this.talliedAltV.elementAt(i);
                int i1 = Integer.parseInt(s1);
                if (i1 >= leastPreferred || i1 <= 0) continue;
                leastPreferred = i1;
                element = i;
            }
            for (i = 0; i < this.numPrefs; ++i) {
                if (Integer.parseInt(String.valueOf(this.talliedAltV.elementAt(i))) != leastPreferred || leastPreferred <= 0 || ++numMinima <= 1) continue;
                this.setAVDraw(true);
            }
            for (i = voteNumber - 1; i >= 0; --i) {
                temp = (Vector)altPointStore.elementAt(i);
                temp2 = (Vector)temp.clone();
                temp2.set(element, "0");
                for (int c = 0; c < this.numPrefs; ++c) {
                    int points = Integer.parseInt(String.valueOf(this.talliedAltV.elementAt(c)));
                    if (points != 0) continue;
                    temp2.set(c, "0");
                }
                altPointStore.set(i, temp2);
            }
        }
        return this.talliedAltV;
    }

    public Vector approvalVote() {
        Vector temp = new Vector();
        this.talliedAppV.clear();
        for (int count = 0; count < this.numPrefs; ++count) {
            this.talliedAppV.add(count, "0");
        }
        for (int i = 0; i < voteNumber; ++i) {
            temp = (Vector)this.pointStore.elementAt(i);
            for (int j = 0; j < this.numPrefs; ++j) {
                String s1 = (String)temp.elementAt(j);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedAppV.elementAt(j);
                int i2 = Integer.parseInt(s2);
                if (i1 < 1) continue;
                i1 = 1;
                this.talliedAppV.set(j, String.valueOf(i1 + i2));
            }
        }
        return this.talliedAppV;
    }

    public Vector condorcet() {
        int outer = 0;
        int increment = 0;
        Vector<String> storage = new Vector<String>();
        this.talliedCondorcet.clear();
        for (int count = 0; count < this.numPrefs; ++count) {
            this.talliedCondorcet.add(count, "0");
        }
        while (outer < this.numPrefs) {
            for (int inner = 1 + increment; inner < this.numPrefs; ++inner) {
                int first = 0;
                int second = 0;
                for (int i = 0; i < voteNumber; ++i) {
                    String s2;
                    int i2;
                    Vector temp = (Vector)this.pointStore.elementAt(i);
                    String s1 = (String)temp.elementAt(outer);
                    int i1 = Integer.parseInt(s1);
                    if (i1 > (i2 = Integer.parseInt(s2 = (String)temp.elementAt(inner)))) {
                        ++first;
                    }
                    if (i1 >= i2) continue;
                    ++second;
                }
                storage.add(String.valueOf(first));
                storage.add(String.valueOf(second));
            }
            ++outer;
            ++increment;
        }
        return storage;
    }

    public Vector borda() {
        Vector temp = new Vector();
        this.talliedBorda.clear();
        for (int count = 0; count < this.numPrefs; ++count) {
            this.talliedBorda.add(count, "0");
        }
        for (int i = 0; i < voteNumber; ++i) {
            temp = (Vector)this.pointStore.elementAt(i);
            for (int j = 0; j < this.numPrefs; ++j) {
                String s1 = (String)temp.elementAt(j);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedBorda.elementAt(j);
                int i2 = Integer.parseInt(s2);
                this.talliedBorda.set(j, Integer.toString(i2 += i1));
            }
        }
        return this.talliedBorda;
    }

    public Vector bordaP() {
        Vector temp = new Vector();
        this.talliedBordaP.clear();
        for (int count = 0; count < this.numPrefs; ++count) {
            this.talliedBordaP.add(count, "0");
        }
        for (int i = 0; i < voteNumber; ++i) {
            temp = (Vector)this.bPointStore.elementAt(i);
            for (int j = 0; j < this.numPrefs; ++j) {
                String s1 = (String)temp.elementAt(j);
                int i1 = Integer.parseInt(s1);
                String s2 = (String)this.talliedBordaP.elementAt(j);
                int i2 = Integer.parseInt(s2);
                this.talliedBordaP.set(j, Integer.toString(i2 += i1));
            }
        }
        return this.talliedBordaP;
    }

    public Vector serialVote() {
        Vector serialPointStore = (Vector)this.pointStore.clone();
        Vector temp = new Vector(0, 1);
        Vector temp2 = new Vector(0, 1);
        int first = 0;
        int last = this.numPrefs - 1;
        boolean end = false;
        this.setSerialDraw(false);
        while (!end) {
            int i;
            String sLast;
            int iLast;
            this.talliedSV.clear();
            for (int count = 0; count < this.numPrefs; ++count) {
                this.talliedSV.add(count, "0");
            }
            int lowestTotal = 0;
            int highestTotal = 0;
            for (int i2 = 0; i2 < voteNumber; ++i2) {
                String highestExtremeS;
                int highestExtremeI;
                temp = (Vector)serialPointStore.elementAt(i2);
                temp2 = (Vector)temp.clone();
                String lowestExtremeS = (String)temp2.elementAt(first);
                int lowestExtremeI = Integer.parseInt(lowestExtremeS);
                if (lowestExtremeI > (highestExtremeI = Integer.parseInt(highestExtremeS = (String)temp2.elementAt(last)))) {
                    this.talliedSV.set(first, String.valueOf(++lowestTotal));
                }
                if (highestExtremeI <= lowestExtremeI) continue;
                this.talliedSV.set(last, String.valueOf(++highestTotal));
            }
            String sFirst = (String)this.talliedSV.elementAt(first);
            int iFirst = Integer.parseInt(sFirst);
            if (iFirst >= (iLast = Integer.parseInt(sLast = (String)this.talliedSV.elementAt(last)))) {
                if (iFirst == iLast && iFirst > 0) {
                    this.setSerialDraw(true);
                }
                for (i = 0; i < voteNumber; ++i) {
                    temp = (Vector)serialPointStore.elementAt(i);
                    temp2 = (Vector)temp.clone();
                    temp2.set(last, "0");
                    serialPointStore.set(i, temp2);
                }
                --last;
            } else {
                for (i = 0; i < voteNumber; ++i) {
                    temp = (Vector)serialPointStore.elementAt(i);
                    temp2 = (Vector)temp.clone();
                    temp2.set(first, "0");
                    serialPointStore.set(i, temp2);
                }
                ++first;
            }
            if (last > first && first < last) continue;
            end = true;
        }
        return this.talliedSV;
    }

    public void setTwoRoundDraw(boolean b) {
        this.twoRoundDraw = b;
    }

    public void setAVDraw(boolean b) {
        this.AVDraw = b;
    }

    public void setSerialDraw(boolean b) {
        this.serialDraw = b;
    }

    public boolean getTwoRoundDraw() {
        return this.twoRoundDraw;
    }

    public boolean getAVDraw() {
        return this.AVDraw;
    }

    public boolean getSerialDraw() {
        return this.serialDraw;
    }

    private void jbInit() throws Exception {
    }
}

