/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    private int copies = 1;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print(c);
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print(Component c) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        try {
            printJob.print();
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(c, "Error printing: " + pe, "Printing Error", 0);
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        double scaleX = pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth();
        double scaleY = pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight();
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.scale(scaleX, scaleY);
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        g2d.drawString("Ballot# " + this.copies, 0, 0);
        this.componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

