#include "shader.h"

struct front_bright_dot { 
    miColor tint; 
};

DLLEXPORT
int front_bright_dot_version(void) { return(1); }

DLLEXPORT
miBoolean front_bright_dot ( 
    miColor *result, miState *state, struct front_bright_dot *params  )
{
    miColor *tint = mi_eval_color(&params->tint);
    miScalar scale = -mi_vector_dot(&state->normal, &state->dir);
    result->r = tint->r * scale;
    result->g = tint->g * scale;
    result->b = tint->b * scale;
    result->a = 1.0;
    return miTRUE;
}
