double miaux_shadow_continuous (
    double color, double transparency, double expansion )
{
    return transparency 
	+ miaux_fit(transparency,
		    0, 1, 
		    expansion * transparency * (color - transparency), 0);
}

double miaux_fit(
    double v, double oldmin, double oldmax, double newmin, double newmax)    
{
    return newmin + ((v - oldmin) / (oldmax - oldmin)) * (newmax - newmin);
}

miBoolean miaux_all_channels_equal(miColor *c, miScalar v)
{
    if (c->r == v && c->g == v && c->b == v && c->a == v)
	return miTRUE;
    else
	return miFALSE;
}