miTag miaux_current_light_tag(miState *state)
{
    miTag light_tag;
    mi_query(miQ_INST_ITEM, state, state->light_instance, &light_tag);
    return light_tag;
}

miScalar miaux_offset_spread_from_light(miState *state, miTag light_tag)
{
    miVector light_direction, light_to_sample_point;

    mi_query(miQ_LIGHT_DIRECTION, state, light_tag, &light_direction);
    mi_vector_normalize(&light_direction);

    mi_vector_to_light(state, &light_to_sample_point, &state->dir);
    mi_vector_normalize(&light_to_sample_point); 

    return mi_vector_dot(&light_to_sample_point, &light_direction);
}

miScalar miaux_light_spread(miState *state, miTag light_tag)
{
    miScalar light_spread;
    mi_query(miQ_LIGHT_SPREAD, state, light_tag, &light_spread);
    return light_spread;
}

double miaux_fit(
    double v, double oldmin, double oldmax, double newmin, double newmax)    
{
    return newmin + ((v - oldmin) / (oldmax - oldmin)) * (newmax - newmin);
}

void miaux_scale_color(miColor *result, miScalar scale)
{
    result->r *= scale;
    result->g *= scale;
    result->b *= scale;
}