void miaux_light_array(miTag **lights, int *light_count, miState *state,
		       int *offset_param, int *count_param, miTag *lights_param)
{
    int array_offset = *mi_eval_integer(offset_param);
    *light_count = *mi_eval_integer(count_param);
    *lights = mi_eval_tag(lights_param) + array_offset;
}

void miaux_set_channels(miColor *c, miScalar new_value)
{
    c->r = c->g = c->b = c->a = new_value;
}

void miaux_add_diffuse_component(
    miColor *result, 
    miScalar light_and_surface_cosine, 
    miColor *diffuse, miColor *light_color)
{
    result->r += light_and_surface_cosine * diffuse->r * light_color->r;
    result->g += light_and_surface_cosine * diffuse->g * light_color->g;
    result->b += light_and_surface_cosine * diffuse->b * light_color->b;
}

void miaux_add_ward_specular_component(
    miColor *result, miState *state,
    miScalar shiny_u, miScalar shiny_v,
    miColor *glossy, miScalar normal_dot_light,
    miVector direction_toward_light,
    miColor *light_color)
{
    miScalar specular_reflection_amount;
    if (shiny_u == shiny_v)  /* Isotropic */
	specular_reflection_amount = normal_dot_light * 
	    mi_ward_glossy(
		&state->dir, &direction_toward_light, &state->normal, shiny_u);

    else {	             /* Anisotropic */
	miVector u = state->derivs[0], v;
	float d = mi_vector_dot(&u, &state->normal);
	u.x -= d * state->normal.x;
	u.y -= d * state->normal.y;
	u.z -= d * state->normal.z;
	mi_vector_normalize(&u);
	/* Set v to be perpendicular to u (in the tangent plane) */
	mi_vector_prod(&v, &state->normal, &u);
	specular_reflection_amount = normal_dot_light * 
	    mi_ward_anisglossy(&state->dir, &direction_toward_light, 
			       &state->normal, &u, &v, shiny_u, shiny_v);
    }
    if (specular_reflection_amount > 0.0) {
	result->r += specular_reflection_amount * glossy->r * light_color->r;
	result->g += specular_reflection_amount * glossy->g * light_color->g;
	result->b += specular_reflection_amount * glossy->b * light_color->b;
    }
}

void miaux_add_scaled_color(miColor *result, miColor *color, miScalar scale)
{
    result->r += color->r * scale;
    result->g += color->g * scale;
    result->b += color->b * scale;
}