@echo off
REM Written by Anthony Ambrus, Rare Ltd. April 2008

REM Microsoft "Windows" batch file for the compilation of the shaders contained
REM in the book "Writing mental ray Shaders: A perceptual introduction".
REM Compilation is described in http://www.writingshaders.com/compilation.html.
REM Also see the subsection "Dynamic Linking of Shaders" in section "Using and
REM Writing Shaders" in the on-line mental ray documentation.

REM Compilation commands for general shaders 
REM for 32-bit systems using Visual C++ 2008 Express.

REM Usage: compile.bat <filename>
REM    Compiles the filename.c file, then copies output filename.dll and
REM    filename.mi to %MI_CUSTOM_SCENES_PATH%
REM Example: compile depth_2

call set_variables.bat
set MI_CUSTOM_SCENES_PATH=C:\MRT\ray\scenes\

set file=%1
set file=%file:.cpp=%
set file=%file:.c=%

REM reset  colour
color 07 
cls

if "%1" == "" (
	echo Usage: compile [filename]
	echo    Compiles the filename.c* file, then copies output filename.dll and
	echo    filename.mi to %MI_CUSTOM_SCENES_PATH%
	echo.
	echo Example: compile depth_2
	echo.
	goto End
)

:Compile
	echo.
	echo [+] Compiling %file%.c*...
	cl %WMRS_C_FLAGS% %WMRS_INCLUDE_FLAGS% %file%.c*
	if not %ERRORLEVEL% == 0 goto Error
	
	echo.
	echo [+] Linking dll...
	link %WMRS_LINK_FLAGS% /OUT:%file%.dll %file%.obj miaux.obj shader.lib
	if not %ERRORLEVEL% == 0 goto Error
	
	echo.
	echo [+] Merging manifest...
	mt %WMRS_MT_FLAGS% %file%.dll.manifest -outputresource:%file%.dll;2
	if not %ERRORLEVEL% == 0 goto Error
	
	echo.
	echo [+] Copying %file%.mi to %MI_CUSTOM_SCENES_PATH%
	copy %file%.dll %MI_CUSTOM_SCENES_PATH%
		
	echo.
	echo [+] Copying %file%.dll to %MI_CUSTOM_SCENES_PATH%
	copy %file%.mi %MI_CUSTOM_SCENES_PATH%
	
	goto End

:Error
	echo.
	echo [!] Failed to compile
	
	REM flash red twice, using poor Man's SLEEP utility :)
	color 0c
	@ping 1.1.1.1 -n 1 -w 100 >NUL
	color 07
	@ping 1.1.1.1 -n 1 -w 100 >NUL
	color 0c
	@ping 1.1.1.1 -n 1 -w 100 >NUL

:End
	color 07
