#include "shader.h"
#include "miaux.h"

struct depth_fade_tint_2 { 
    miScalar near;
    miColor near_color;
    miScalar far;
    miColor far_color;
};

DLLEXPORT
int depth_fade_tint_2_version(void) { return(1); }

DLLEXPORT
miBoolean depth_fade_tint_2 ( 
    miColor *result, miState *state, struct depth_fade_tint_2 *params  )
{
    miScalar near = *mi_eval_scalar(&params->near);
    miColor *near_color = mi_eval_color(&params->near_color);
    miScalar far = *mi_eval_scalar(&params->far);
    miColor *far_color = mi_eval_color(&params->far_color);

    miaux_blend_colors(result, near_color, far_color,
                       miaux_fit(state->point.z, far, near, 0.0, 1.0));

    return miTRUE;
}
