#include "shader.h"
#include "miaux.h"

struct depth_fade_tint_3 { 
    miScalar near;
    miColor near_color;
    miScalar far;
    miColor far_color;
};

DLLEXPORT
int depth_fade_tint_3_version(void) { return(1); }

DLLEXPORT
miBoolean depth_fade_tint_3 ( 
    miColor *result, miState *state, struct depth_fade_tint_3 *params  )
{
    miaux_blend_colors(result, 
                       mi_eval_color(&params->near_color),
                       mi_eval_color(&params->far_color),
                       miaux_fit(state->point.z, 
                                 *mi_eval_scalar(&params->far),
                                 *mi_eval_scalar(&params->near),
                                 0.0, 1.0));
    return miTRUE;
}
