double miaux_shadow_breakpoint_scale (
    double color, double transparency, double breakpoint, 
    double center, double extent )
{
    double scaled_color = 
	miaux_fit(color, 0, 1, center - extent/2.0, center + extent/2.0);
    if (transparency < breakpoint)
	return miaux_fit(transparency, 0, breakpoint, 0, scaled_color);
    else
	return miaux_fit(transparency, breakpoint, 1, scaled_color, 1);
}

double miaux_fit(
    double v, double oldmin, double oldmax, double newmin, double newmax)    
{
    return newmin + ((v - oldmin) / (oldmax - oldmin)) * (newmax - newmin);
}

miBoolean miaux_all_channels_equal(miColor *c, miScalar v)
{
    if (c->r == v && c->g == v && c->b == v && c->a == v)
	return miTRUE;
    else
	return miFALSE;
}