#include "shader.h"
#include "miaux.h"

struct shadowpass {
    miColor base_color;
    int     i_light;
    int     n_light;
    miTag   light[1];
};

DLLEXPORT
int shadowpass_version(void) { return 1; }

DLLEXPORT
miBoolean shadowpass (
    miColor *result, miState *state, struct shadowpass *params  )
{
    int i, light_count;
    miTag *light;
    miColor without_shadow, with_shadow, shadow;
    miColor *base_color = mi_eval_color(&params->base_color);
    miaux_light_array(&light, &light_count, state,
                      &params->i_light, &params->n_light, params->light);

    miaux_set_channels(&without_shadow, 0.0);
    miaux_set_channels(&with_shadow, 0.0);

    for (i = 0; i < light_count; i++, light++) {
        miaux_add_light_color(&without_shadow, state, *light, miFALSE);
        miaux_add_light_color(&with_shadow, state, *light, miTRUE);
    }
    miaux_divide_colors(&shadow, &with_shadow, &without_shadow);

    miaux_multiply_colors(result, base_color, &shadow);
    mi_fb_put(state, 0, base_color);
    mi_fb_put(state, 1, &shadow);

    return miTRUE;
}

