#include "shader.h"
#include "miaux.h"

struct transparent_modularized { 
    miColor color; 
    miColor transparency;
};

DLLEXPORT
int transparent_modularized_version(void) { return(1); }

DLLEXPORT
miBoolean transparent_modularized ( 
    miColor *result, miState *state, struct transparent_modularized *params  )
{
    miColor *transparency = mi_eval_color(&params->transparency);

    if (miaux_all_channels_equal(transparency, 0.0)) 
      *result = *mi_eval_color(&params->color);

    else if (miaux_all_channels_equal(transparency, 1.0))
      mi_trace_transparent(result, state);      

    else {
      miColor *color = mi_eval_color(&params->color), opacity;
      mi_trace_transparent(result, state);
      miaux_invert_channels(&opacity, transparency);
      mi_opacity_set(state, &opacity);
      miaux_blend_channels(result, color, transparency);
    }

    return miTRUE;
}
