function y = LinearBrickAssemble(K,k,i,j,m,n,p,q,r,s)
%LinearBrickAssemble   This function assembles the element stiffness
%                      matrix k of the linear brick (solid)
%                      element with nodes i, j, m, n, p, q, r, 
%                      and s into the global stiffness matrix K.
%                      This function returns the global stiffness  
%                      matrix K after the element stiffness matrix  
%                      k is assembled.
K(3*i-2,3*i-2) = K(3*i-2,3*i-2) + k(1,1);
K(3*i-2,3*i-1) = K(3*i-2,3*i-1) + k(1,2);
K(3*i-2,3*i) = K(3*i-2,3*i) + k(1,3);
K(3*i-2,3*j-2) = K(3*i-2,3*j-2) + k(1,4);
K(3*i-2,3*j-1) = K(3*i-2,3*j-1) + k(1,5);
K(3*i-2,3*j) = K(3*i-2,3*j) + k(1,6);
K(3*i-2,3*m-2) = K(3*i-2,3*m-2) + k(1,7);
K(3*i-2,3*m-1) = K(3*i-2,3*m-1) + k(1,8);
K(3*i-2,3*m) = K(3*i-2,3*m) + k(1,9);
K(3*i-2,3*n-2) = K(3*i-2,3*n-2) + k(1,10);
K(3*i-2,3*n-1) = K(3*i-2,3*n-1) + k(1,11);
K(3*i-2,3*n) = K(3*i-2,3*n) + k(1,12);
K(3*i-2,3*p-2) = K(3*i-2,3*p-2) + k(1,13);
K(3*i-2,3*p-1) = K(3*i-2,3*p-1) + k(1,14);
K(3*i-2,3*p) = K(3*i-2,3*p) + k(1,15);
K(3*i-2,3*q-2) = K(3*i-2,3*q-2) + k(1,16);
K(3*i-2,3*q-1) = K(3*i-2,3*q-1) + k(1,17);
K(3*i-2,3*q) = K(3*i-2,3*q) + k(1,18);
K(3*i-2,3*r-2) = K(3*i-2,3*r-2) + k(1,19);
K(3*i-2,3*r-1) = K(3*i-2,3*r-1) + k(1,20);
K(3*i-2,3*r) = K(3*i-2,3*r) + k(1,21);
K(3*i-2,3*s-2) = K(3*i-2,3*s-2) + k(1,22);
K(3*i-2,3*s-1) = K(3*i-2,3*s-1) + k(1,23);
K(3*i-2,3*s) = K(3*i-2,3*s) + k(1,24);
K(3*i-1,3*i-2) = K(3*i-1,3*i-2) + k(2,1);
K(3*i-1,3*i-1) = K(3*i-1,3*i-1) + k(2,2);
K(3*i-1,3*i) = K(3*i-1,3*i) + k(2,3);
K(3*i-1,3*j-2) = K(3*i-1,3*j-2) + k(2,4);
K(3*i-1,3*j-1) = K(3*i-1,3*j-1) + k(2,5);
K(3*i-1,3*j) = K(3*i-1,3*j) + k(2,6);
K(3*i-1,3*m-2) = K(3*i-1,3*m-2) + k(2,7);
K(3*i-1,3*m-1) = K(3*i-1,3*m-1) + k(2,8);
K(3*i-1,3*m) = K(3*i-1,3*m) + k(2,9);
K(3*i-1,3*n-2) = K(3*i-1,3*n-2) + k(2,10);
K(3*i-1,3*n-1) = K(3*i-1,3*n-1) + k(2,11);
K(3*i-1,3*n) = K(3*i-1,3*n) + k(2,12);
K(3*i-1,3*p-2) = K(3*i-1,3*p-2) + k(2,13);
K(3*i-1,3*p-1) = K(3*i-1,3*p-1) + k(2,14);
K(3*i-1,3*p) = K(3*i-1,3*p) + k(2,15);
K(3*i-1,3*q-2) = K(3*i-1,3*q-2) + k(2,16);
K(3*i-1,3*q-1) = K(3*i-1,3*q-1) + k(2,17);
K(3*i-1,3*q) = K(3*i-1,3*q) + k(2,18);
K(3*i-1,3*r-2) = K(3*i-1,3*r-2) + k(2,19);
K(3*i-1,3*r-1) = K(3*i-1,3*r-1) + k(2,20);
K(3*i-1,3*r) = K(3*i-1,3*r) + k(2,21);
K(3*i-1,3*s-2) = K(3*i-1,3*s-2) + k(2,22);
K(3*i-1,3*s-1) = K(3*i-1,3*s-1) + k(2,23);
K(3*i-1,3*s) = K(3*i-1,3*s) + k(2,24);
K(3*i,3*i-2) = K(3*i,3*i-2) + k(3,1);
K(3*i,3*i-1) = K(3*i,3*i-1) + k(3,2);
K(3*i,3*i) = K(3*i,3*i) + k(3,3);
K(3*i,3*j-2) = K(3*i,3*j-2) + k(3,4);
K(3*i,3*j-1) = K(3*i,3*j-1) + k(3,5);
K(3*i,3*j) = K(3*i,3*j) + k(3,6);
K(3*i,3*m-2) = K(3*i,3*m-2) + k(3,7);
K(3*i,3*m-1) = K(3*i,3*m-1) + k(3,8);
K(3*i,3*m) = K(3*i,3*m) + k(3,9);
K(3*i,3*n-2) = K(3*i,3*n-2) + k(3,10);
K(3*i,3*n-1) = K(3*i,3*n-1) + k(3,11);
K(3*i,3*n) = K(3*i,3*n) + k(3,12);
K(3*i,3*p-2) = K(3*i,3*p-2) + k(3,13);
K(3*i,3*p-1) = K(3*i,3*p-1) + k(3,14);
K(3*i,3*p) = K(3*i,3*p) + k(3,15);
K(3*i,3*q-2) = K(3*i,3*q-2) + k(3,16);
K(3*i,3*q-1) = K(3*i,3*q-1) + k(3,17);
K(3*i,3*q) = K(3*i,3*q) + k(3,18);
K(3*i,3*r-2) = K(3*i,3*r-2) + k(3,19);
K(3*i,3*r-1) = K(3*i,3*r-1) + k(3,20);
K(3*i,3*r) = K(3*i,3*r) + k(3,21);
K(3*i,3*s-2) = K(3*i,3*s-2) + k(3,22);
K(3*i,3*s-1) = K(3*i,3*s-1) + k(3,23);
K(3*i,3*s) = K(3*i,3*s) + k(3,24);
K(3*j-2,3*i-2) = K(3*j-2,3*i-2) + k(4,1);
K(3*j-2,3*i-1) = K(3*j-2,3*i-1) + k(4,2);
K(3*j-2,3*i) = K(3*j-2,3*i) + k(4,3);
K(3*j-2,3*j-2) = K(3*j-2,3*j-2) + k(4,4);
K(3*j-2,3*j-1) = K(3*j-2,3*j-1) + k(4,5);
K(3*j-2,3*j) = K(3*j-2,3*j) + k(4,6);
K(3*j-2,3*m-2) = K(3*j-2,3*m-2) + k(4,7);
K(3*j-2,3*m-1) = K(3*j-2,3*m-1) + k(4,8);
K(3*j-2,3*m) = K(3*j-2,3*m) + k(4,9);
K(3*j-2,3*n-2) = K(3*j-2,3*n-2) + k(4,10);
K(3*j-2,3*n-1) = K(3*j-2,3*n-1) + k(4,11);
K(3*j-2,3*n) = K(3*j-2,3*n) + k(4,12);
K(3*j-2,3*p-2) = K(3*j-2,3*p-2) + k(4,13);
K(3*j-2,3*p-1) = K(3*j-2,3*p-1) + k(4,14);
K(3*j-2,3*p) = K(3*j-2,3*p) + k(4,15);
K(3*j-2,3*q-2) = K(3*j-2,3*q-2) + k(4,16);
K(3*j-2,3*q-1) = K(3*j-2,3*q-1) + k(4,17);
K(3*j-2,3*q) = K(3*j-2,3*q) + k(4,18);
K(3*j-2,3*r-2) = K(3*j-2,3*r-2) + k(4,19);
K(3*j-2,3*r-1) = K(3*j-2,3*r-1) + k(4,20);
K(3*j-2,3*r) = K(3*j-2,3*r) + k(4,21);
K(3*j-2,3*s-2) = K(3*j-2,3*s-2) + k(4,22);
K(3*j-2,3*s-1) = K(3*j-2,3*s-1) + k(4,23);
K(3*j-2,3*s) = K(3*j-2,3*s) + k(4,24);
K(3*j-1,3*i-2) = K(3*j-1,3*i-2) + k(5,1);
K(3*j-1,3*i-1) = K(3*j-1,3*i-1) + k(5,2);
K(3*j-1,3*i) = K(3*j-1,3*i) + k(5,3);
K(3*j-1,3*j-2) = K(3*j-1,3*j-2) + k(5,4);
K(3*j-1,3*j-1) = K(3*j-1,3*j-1) + k(5,5);
K(3*j-1,3*j) = K(3*j-1,3*j) + k(5,6);
K(3*j-1,3*m-2) = K(3*j-1,3*m-2) + k(5,7);
K(3*j-1,3*m-1) = K(3*j-1,3*m-1) + k(5,8);
K(3*j-1,3*m) = K(3*j-1,3*m) + k(5,9);
K(3*j-1,3*n-2) = K(3*j-1,3*n-2) + k(5,10);
K(3*j-1,3*n-1) = K(3*j-1,3*n-1) + k(5,11);
K(3*j-1,3*n) = K(3*j-1,3*n) + k(5,12);
K(3*j-1,3*p-2) = K(3*j-1,3*p-2) + k(5,13);
K(3*j-1,3*p-1) = K(3*j-1,3*p-1) + k(5,14);
K(3*j-1,3*p) = K(3*j-1,3*p) + k(5,15);
K(3*j-1,3*q-2) = K(3*j-1,3*q-2) + k(5,16);
K(3*j-1,3*q-1) = K(3*j-1,3*q-1) + k(5,17);
K(3*j-1,3*q) = K(3*j-1,3*q) + k(5,18);
K(3*j-1,3*r-2) = K(3*j-1,3*r-2) + k(5,19);
K(3*j-1,3*r-1) = K(3*j-1,3*r-1) + k(5,20);
K(3*j-1,3*r) = K(3*j-1,3*r) + k(5,21);
K(3*j-1,3*s-2) = K(3*j-1,3*s-2) + k(5,22);
K(3*j-1,3*s-1) = K(3*j-1,3*s-1) + k(5,23);
K(3*j-1,3*s) = K(3*j-1,3*s) + k(5,24);
K(3*j,3*i-2) = K(3*j,3*i-2) + k(6,1);
K(3*j,3*i-1) = K(3*j,3*i-1) + k(6,2);
K(3*j,3*i) = K(3*j,3*i) + k(6,3);
K(3*j,3*j-2) = K(3*j,3*j-2) + k(6,4);
K(3*j,3*j-1) = K(3*j,3*j-1) + k(6,5);
K(3*j,3*j) = K(3*j,3*j) + k(6,6);
K(3*j,3*m-2) = K(3*j,3*m-2) + k(6,7);
K(3*j,3*m-1) = K(3*j,3*m-1) + k(6,8);
K(3*j,3*m) = K(3*j,3*m) + k(6,9);
K(3*j,3*n-2) = K(3*j,3*n-2) + k(6,10);
K(3*j,3*n-1) = K(3*j,3*n-1) + k(6,11);
K(3*j,3*n) = K(3*j,3*n) + k(6,12);
K(3*j,3*p-2) = K(3*j,3*p-2) + k(6,13);
K(3*j,3*p-1) = K(3*j,3*p-1) + k(6,14);
K(3*j,3*p) = K(3*j,3*p) + k(6,15);
K(3*j,3*q-2) = K(3*j,3*q-2) + k(6,16);
K(3*j,3*q-1) = K(3*j,3*q-1) + k(6,17);
K(3*j,3*q) = K(3*j,3*q) + k(6,18);
K(3*j,3*r-2) = K(3*j,3*r-2) + k(6,19);
K(3*j,3*r-1) = K(3*j,3*r-1) + k(6,20);
K(3*j,3*r) = K(3*j,3*r) + k(6,21);
K(3*j,3*s-2) = K(3*j,3*s-2) + k(6,22);
K(3*j,3*s-1) = K(3*j,3*s-1) + k(6,23);
K(3*j,3*s) = K(3*j,3*s) + k(6,24);
K(3*m-2,3*i-2) = K(3*m-2,3*i-2) + k(7,1);
K(3*m-2,3*i-1) = K(3*m-2,3*i-1) + k(7,2);
K(3*m-2,3*i) = K(3*m-2,3*i) + k(7,3);
K(3*m-2,3*j-2) = K(3*m-2,3*j-2) + k(7,4);
K(3*m-2,3*j-1) = K(3*m-2,3*j-1) + k(7,5);
K(3*m-2,3*j) = K(3*m-2,3*j) + k(7,6);
K(3*m-2,3*m-2) = K(3*m-2,3*m-2) + k(7,7);
K(3*m-2,3*m-1) = K(3*m-2,3*m-1) + k(7,8);
K(3*m-2,3*m) = K(3*m-2,3*m) + k(7,9);
K(3*m-2,3*n-2) = K(3*m-2,3*n-2) + k(7,10);
K(3*m-2,3*n-1) = K(3*m-2,3*n-1) + k(7,11);
K(3*m-2,3*n) = K(3*m-2,3*n) + k(7,12);
K(3*m-2,3*p-2) = K(3*m-2,3*p-2) + k(7,13);
K(3*m-2,3*p-1) = K(3*m-2,3*p-1) + k(7,14);
K(3*m-2,3*p) = K(3*m-2,3*p) + k(7,15);
K(3*m-2,3*q-2) = K(3*m-2,3*q-2) + k(7,16);
K(3*m-2,3*q-1) = K(3*m-2,3*q-1) + k(7,17);
K(3*m-2,3*q) = K(3*m-2,3*q) + k(7,18);
K(3*m-2,3*r-2) = K(3*m-2,3*r-2) + k(7,19);
K(3*m-2,3*r-1) = K(3*m-2,3*r-1) + k(7,20);
K(3*m-2,3*r) = K(3*m-2,3*r) + k(7,21);
K(3*m-2,3*s-2) = K(3*m-2,3*s-2) + k(7,22);
K(3*m-2,3*s-1) = K(3*m-2,3*s-1) + k(7,23);
K(3*m-2,3*s) = K(3*m-2,3*s) + k(7,24);
K(3*m-1,3*i-2) = K(3*m-1,3*i-2) + k(8,1);
K(3*m-1,3*i-1) = K(3*m-1,3*i-1) + k(8,2);
K(3*m-1,3*i) = K(3*m-1,3*i) + k(8,3);
K(3*m-1,3*j-2) = K(3*m-1,3*j-2) + k(8,4);
K(3*m-1,3*j-1) = K(3*m-1,3*j-1) + k(8,5);
K(3*m-1,3*j) = K(3*m-1,3*j) + k(8,6);
K(3*m-1,3*m-2) = K(3*m-1,3*m-2) + k(8,7);
K(3*m-1,3*m-1) = K(3*m-1,3*m-1) + k(8,8);
K(3*m-1,3*m) = K(3*m-1,3*m) + k(8,9);
K(3*m-1,3*n-2) = K(3*m-1,3*n-2) + k(8,10);
K(3*m-1,3*n-1) = K(3*m-1,3*n-1) + k(8,11);
K(3*m-1,3*n) = K(3*m-1,3*n) + k(8,12);
K(3*m-1,3*p-2) = K(3*m-1,3*p-2) + k(8,13);
K(3*m-1,3*p-1) = K(3*m-1,3*p-1) + k(8,14);
K(3*m-1,3*p) = K(3*m-1,3*p) + k(8,15);
K(3*m-1,3*q-2) = K(3*m-1,3*q-2) + k(8,16);
K(3*m-1,3*q-1) = K(3*m-1,3*q-1) + k(8,17);
K(3*m-1,3*q) = K(3*m-1,3*q) + k(8,18);
K(3*m-1,3*r-2) = K(3*m-1,3*r-2) + k(8,19);
K(3*m-1,3*r-1) = K(3*m-1,3*r-1) + k(8,20);
K(3*m-1,3*r) = K(3*m-1,3*r) + k(8,21);
K(3*m-1,3*s-2) = K(3*m-1,3*s-2) + k(8,22);
K(3*m-1,3*s-1) = K(3*m-1,3*s-1) + k(8,23);
K(3*m-1,3*s) = K(3*m-1,3*s) + k(8,24);
K(3*m,3*i-2) = K(3*m,3*i-2) + k(9,1);
K(3*m,3*i-1) = K(3*m,3*i-1) + k(9,2);
K(3*m,3*i) = K(3*m,3*i) + k(9,3);
K(3*m,3*j-2) = K(3*m,3*j-2) + k(9,4);
K(3*m,3*j-1) = K(3*m,3*j-1) + k(9,5);
K(3*m,3*j) = K(3*m,3*j) + k(9,6);
K(3*m,3*m-2) = K(3*m,3*m-2) + k(9,7);
K(3*m,3*m-1) = K(3*m,3*m-1) + k(9,8);
K(3*m,3*m) = K(3*m,3*m) + k(9,9);
K(3*m,3*n-2) = K(3*m,3*n-2) + k(9,10);
K(3*m,3*n-1) = K(3*m,3*n-1) + k(9,11);
K(3*m,3*n) = K(3*m,3*n) + k(9,12);
K(3*m,3*p-2) = K(3*m,3*p-2) + k(9,13);
K(3*m,3*p-1) = K(3*m,3*p-1) + k(9,14);
K(3*m,3*p) = K(3*m,3*p) + k(9,15);
K(3*m,3*q-2) = K(3*m,3*q-2) + k(9,16);
K(3*m,3*q-1) = K(3*m,3*q-1) + k(9,17);
K(3*m,3*q) = K(3*m,3*q) + k(9,18);
K(3*m,3*r-2) = K(3*m,3*r-2) + k(9,19);
K(3*m,3*r-1) = K(3*m,3*r-1) + k(9,20);
K(3*m,3*r) = K(3*m,3*r) + k(9,21);
K(3*m,3*s-2) = K(3*m,3*s-2) + k(9,22);
K(3*m,3*s-1) = K(3*m,3*s-1) + k(9,23);
K(3*m,3*s) = K(3*m,3*s) + k(9,24);
K(3*n-2,3*i-2) = K(3*n-2,3*i-2) + k(10,1);
K(3*n-2,3*i-1) = K(3*n-2,3*i-1) + k(10,2);
K(3*n-2,3*i) = K(3*n-2,3*i) + k(10,3);
K(3*n-2,3*j-2) = K(3*n-2,3*j-2) + k(10,4);
K(3*n-2,3*j-1) = K(3*n-2,3*j-1) + k(10,5);
K(3*n-2,3*j) = K(3*n-2,3*j) + k(10,6);
K(3*n-2,3*m-2) = K(3*n-2,3*m-2) + k(10,7);
K(3*n-2,3*m-1) = K(3*n-2,3*m-1) + k(10,8);
K(3*n-2,3*m) = K(3*n-2,3*m) + k(10,9);
K(3*n-2,3*n-2) = K(3*n-2,3*n-2) + k(10,10);
K(3*n-2,3*n-1) = K(3*n-2,3*n-1) + k(10,11);
K(3*n-2,3*n) = K(3*n-2,3*n) + k(10,12);
K(3*n-2,3*p-2) = K(3*n-2,3*p-2) + k(10,13);
K(3*n-2,3*p-1) = K(3*n-2,3*p-1) + k(10,14);
K(3*n-2,3*p) = K(3*n-2,3*p) + k(10,15);
K(3*n-2,3*q-2) = K(3*n-2,3*q-2) + k(10,16);
K(3*n-2,3*q-1) = K(3*n-2,3*q-1) + k(10,17);
K(3*n-2,3*q) = K(3*n-2,3*q) + k(10,18);
K(3*n-2,3*r-2) = K(3*n-2,3*r-2) + k(10,19);
K(3*n-2,3*r-1) = K(3*n-2,3*r-1) + k(10,20);
K(3*n-2,3*r) = K(3*n-2,3*r) + k(10,21);
K(3*n-2,3*s-2) = K(3*n-2,3*s-2) + k(10,22);
K(3*n-2,3*s-1) = K(3*n-2,3*s-1) + k(10,23);
K(3*n-2,3*s) = K(3*n-2,3*s) + k(10,24);
K(3*n-1,3*i-2) = K(3*n-1,3*i-2) + k(11,1);
K(3*n-1,3*i-1) = K(3*n-1,3*i-1) + k(11,2);
K(3*n-1,3*i) = K(3*n-1,3*i) + k(11,3);
K(3*n-1,3*j-2) = K(3*n-1,3*j-2) + k(11,4);
K(3*n-1,3*j-1) = K(3*n-1,3*j-1) + k(11,5);
K(3*n-1,3*j) = K(3*n-1,3*j) + k(11,6);
K(3*n-1,3*m-2) = K(3*n-1,3*m-2) + k(11,7);
K(3*n-1,3*m-1) = K(3*n-1,3*m-1) + k(11,8);
K(3*n-1,3*m) = K(3*n-1,3*m) + k(11,9);
K(3*n-1,3*n-2) = K(3*n-1,3*n-2) + k(11,10);
K(3*n-1,3*n-1) = K(3*n-1,3*n-1) + k(11,11);
K(3*n-1,3*n) = K(3*n-1,3*n) + k(11,12);
K(3*n-1,3*p-2) = K(3*n-1,3*p-2) + k(11,13);
K(3*n-1,3*p-1) = K(3*n-1,3*p-1) + k(11,14);
K(3*n-1,3*p) = K(3*n-1,3*p) + k(11,15);
K(3*n-1,3*q-2) = K(3*n-1,3*q-2) + k(11,16);
K(3*n-1,3*q-1) = K(3*n-1,3*q-1) + k(11,17);
K(3*n-1,3*q) = K(3*n-1,3*q) + k(11,18);
K(3*n-1,3*r-2) = K(3*n-1,3*r-2) + k(11,19);
K(3*n-1,3*r-1) = K(3*n-1,3*r-1) + k(11,20);
K(3*n-1,3*r) = K(3*n-1,3*r) + k(11,21);
K(3*n-1,3*s-2) = K(3*n-1,3*s-2) + k(11,22);
K(3*n-1,3*s-1) = K(3*n-1,3*s-1) + k(11,23);
K(3*n-1,3*s) = K(3*n-1,3*s) + k(11,24);
K(3*n,3*i-2) = K(3*n,3*i-2) + k(12,1);
K(3*n,3*i-1) = K(3*n,3*i-1) + k(12,2);
K(3*n,3*i) = K(3*n,3*i) + k(12,3);
K(3*n,3*j-2) = K(3*n,3*j-2) + k(12,4);
K(3*n,3*j-1) = K(3*n,3*j-1) + k(12,5);
K(3*n,3*j) = K(3*n,3*j) + k(12,6);
K(3*n,3*m-2) = K(3*n,3*m-2) + k(12,7);
K(3*n,3*m-1) = K(3*n,3*m-1) + k(12,8);
K(3*n,3*m) = K(3*n,3*m) + k(12,9);
K(3*n,3*n-2) = K(3*n,3*n-2) + k(12,10);
K(3*n,3*n-1) = K(3*n,3*n-1) + k(12,11);
K(3*n,3*n) = K(3*n,3*n) + k(12,12);
K(3*n,3*p-2) = K(3*n,3*p-2) + k(12,13);
K(3*n,3*p-1) = K(3*n,3*p-1) + k(12,14);
K(3*n,3*p) = K(3*n,3*p) + k(12,15);
K(3*n,3*q-2) = K(3*n,3*q-2) + k(12,16);
K(3*n,3*q-1) = K(3*n,3*q-1) + k(12,17);
K(3*n,3*q) = K(3*n,3*q) + k(12,18);
K(3*n,3*r-2) = K(3*n,3*r-2) + k(12,19);
K(3*n,3*r-1) = K(3*n,3*r-1) + k(12,20);
K(3*n,3*r) = K(3*n,3*r) + k(12,21);
K(3*n,3*s-2) = K(3*n,3*s-2) + k(12,22);
K(3*n,3*s-1) = K(3*n,3*s-1) + k(12,23);
K(3*n,3*s) = K(3*n,3*s) + k(12,24);
K(3*p-2,3*i-2) = K(3*p-2,3*i-2) + k(13,1);
K(3*p-2,3*i-1) = K(3*p-2,3*i-1) + k(13,2);
K(3*p-2,3*i) = K(3*p-2,3*i) + k(13,3);
K(3*p-2,3*j-2) = K(3*p-2,3*j-2) + k(13,4);
K(3*p-2,3*j-1) = K(3*p-2,3*j-1) + k(13,5);
K(3*p-2,3*j) = K(3*p-2,3*j) + k(13,6);
K(3*p-2,3*m-2) = K(3*p-2,3*m-2) + k(13,7);
K(3*p-2,3*m-1) = K(3*p-2,3*m-1) + k(13,8);
K(3*p-2,3*m) = K(3*p-2,3*m) + k(13,9);
K(3*p-2,3*n-2) = K(3*p-2,3*n-2) + k(13,10);
K(3*p-2,3*n-1) = K(3*p-2,3*n-1) + k(13,11);
K(3*p-2,3*n) = K(3*p-2,3*n) + k(13,12);
K(3*p-2,3*p-2) = K(3*p-2,3*p-2) + k(13,13);
K(3*p-2,3*p-1) = K(3*p-2,3*p-1) + k(13,14);
K(3*p-2,3*p) = K(3*p-2,3*p) + k(13,15);
K(3*p-2,3*q-2) = K(3*p-2,3*q-2) + k(13,16);
K(3*p-2,3*q-1) = K(3*p-2,3*q-1) + k(13,17);
K(3*p-2,3*q) = K(3*p-2,3*q) + k(13,18);
K(3*p-2,3*r-2) = K(3*p-2,3*r-2) + k(13,19);
K(3*p-2,3*r-1) = K(3*p-2,3*r-1) + k(13,20);
K(3*p-2,3*r) = K(3*p-2,3*r) + k(13,21);
K(3*p-2,3*s-2) = K(3*p-2,3*s-2) + k(13,22);
K(3*p-2,3*s-1) = K(3*p-2,3*s-1) + k(13,23);
K(3*p-2,3*s) = K(3*p-2,3*s) + k(13,24);
K(3*p-1,3*i-2) = K(3*p-1,3*i-2) + k(14,1);
K(3*p-1,3*i-1) = K(3*p-1,3*i-1) + k(14,2);
K(3*p-1,3*i) = K(3*p-1,3*i) + k(14,3);
K(3*p-1,3*j-2) = K(3*p-1,3*j-2) + k(14,4);
K(3*p-1,3*j-1) = K(3*p-1,3*j-1) + k(14,5);
K(3*p-1,3*j) = K(3*p-1,3*j) + k(14,6);
K(3*p-1,3*m-2) = K(3*p-1,3*m-2) + k(14,7);
K(3*p-1,3*m-1) = K(3*p-1,3*m-1) + k(14,8);
K(3*p-1,3*m) = K(3*p-1,3*m) + k(14,9);
K(3*p-1,3*n-2) = K(3*p-1,3*n-2) + k(14,10);
K(3*p-1,3*n-1) = K(3*p-1,3*n-1) + k(14,11);
K(3*p-1,3*n) = K(3*p-1,3*n) + k(14,12);
K(3*p-1,3*p-2) = K(3*p-1,3*p-2) + k(14,13);
K(3*p-1,3*p-1) = K(3*p-1,3*p-1) + k(14,14);
K(3*p-1,3*p) = K(3*p-1,3*p) + k(14,15);
K(3*p-1,3*q-2) = K(3*p-1,3*q-2) + k(14,16);
K(3*p-1,3*q-1) = K(3*p-1,3*q-1) + k(14,17);
K(3*p-1,3*q) = K(3*p-1,3*q) + k(14,18);
K(3*p-1,3*r-2) = K(3*p-1,3*r-2) + k(14,19);
K(3*p-1,3*r-1) = K(3*p-1,3*r-1) + k(14,20);
K(3*p-1,3*r) = K(3*p-1,3*r) + k(14,21);
K(3*p-1,3*s-2) = K(3*p-1,3*s-2) + k(14,22);
K(3*p-1,3*s-1) = K(3*p-1,3*s-1) + k(14,23);
K(3*p-1,3*s) = K(3*p-1,3*s) + k(14,24);
K(3*p,3*i-2) = K(3*p,3*i-2) + k(15,1);
K(3*p,3*i-1) = K(3*p,3*i-1) + k(15,2);
K(3*p,3*i) = K(3*p,3*i) + k(15,3);
K(3*p,3*j-2) = K(3*p,3*j-2) + k(15,4);
K(3*p,3*j-1) = K(3*p,3*j-1) + k(15,5);
K(3*p,3*j) = K(3*p,3*j) + k(15,6);
K(3*p,3*m-2) = K(3*p,3*m-2) + k(15,7);
K(3*p,3*m-1) = K(3*p,3*m-1) + k(15,8);
K(3*p,3*m) = K(3*p,3*m) + k(15,9);
K(3*p,3*n-2) = K(3*p,3*n-2) + k(15,10);
K(3*p,3*n-1) = K(3*p,3*n-1) + k(15,11);
K(3*p,3*n) = K(3*p,3*n) + k(15,12);
K(3*p,3*p-2) = K(3*p,3*p-2) + k(15,13);
K(3*p,3*p-1) = K(3*p,3*p-1) + k(15,14);
K(3*p,3*p) = K(3*p,3*p) + k(15,15);
K(3*p,3*q-2) = K(3*p,3*q-2) + k(15,16);
K(3*p,3*q-1) = K(3*p,3*q-1) + k(15,17);
K(3*p,3*q) = K(3*p,3*q) + k(15,18);
K(3*p,3*r-2) = K(3*p,3*r-2) + k(15,19);
K(3*p,3*r-1) = K(3*p,3*r-1) + k(15,20);
K(3*p,3*r) = K(3*p,3*r) + k(15,21);
K(3*p,3*s-2) = K(3*p,3*s-2) + k(15,22);
K(3*p,3*s-1) = K(3*p,3*s-1) + k(15,23);
K(3*p,3*s) = K(3*p,3*s) + k(15,24);
K(3*q-2,3*i-2) = K(3*q-2,3*i-2) + k(16,1);
K(3*q-2,3*i-1) = K(3*q-2,3*i-1) + k(16,2);
K(3*q-2,3*i) = K(3*q-2,3*i) + k(16,3);
K(3*q-2,3*j-2) = K(3*q-2,3*j-2) + k(16,4);
K(3*q-2,3*j-1) = K(3*q-2,3*j-1) + k(16,5);
K(3*q-2,3*j) = K(3*q-2,3*j) + k(16,6);
K(3*q-2,3*m-2) = K(3*q-2,3*m-2) + k(16,7);
K(3*q-2,3*m-1) = K(3*q-2,3*m-1) + k(16,8);
K(3*q-2,3*m) = K(3*q-2,3*m) + k(16,9);
K(3*q-2,3*n-2) = K(3*q-2,3*n-2) + k(16,10);
K(3*q-2,3*n-1) = K(3*q-2,3*n-1) + k(16,11);
K(3*q-2,3*n) = K(3*q-2,3*n) + k(16,12);
K(3*q-2,3*p-2) = K(3*q-2,3*p-2) + k(16,13);
K(3*q-2,3*p-1) = K(3*q-2,3*p-1) + k(16,14);
K(3*q-2,3*p) = K(3*q-2,3*p) + k(16,15);
K(3*q-2,3*q-2) = K(3*q-2,3*q-2) + k(16,16);
K(3*q-2,3*q-1) = K(3*q-2,3*q-1) + k(16,17);
K(3*q-2,3*q) = K(3*q-2,3*q) + k(16,18);
K(3*q-2,3*r-2) = K(3*q-2,3*r-2) + k(16,19);
K(3*q-2,3*r-1) = K(3*q-2,3*r-1) + k(16,20);
K(3*q-2,3*r) = K(3*q-2,3*r) + k(16,21);
K(3*q-2,3*s-2) = K(3*q-2,3*s-2) + k(16,22);
K(3*q-2,3*s-1) = K(3*q-2,3*s-1) + k(16,23);
K(3*q-2,3*s) = K(3*q-2,3*s) + k(16,24);
K(3*q-1,3*i-2) = K(3*q-1,3*i-2) + k(17,1);
K(3*q-1,3*i-1) = K(3*q-1,3*i-1) + k(17,2);
K(3*q-1,3*i) = K(3*q-1,3*i) + k(17,3);
K(3*q-1,3*j-2) = K(3*q-1,3*j-2) + k(17,4);
K(3*q-1,3*j-1) = K(3*q-1,3*j-1) + k(17,5);
K(3*q-1,3*j) = K(3*q-1,3*j) + k(17,6);
K(3*q-1,3*m-2) = K(3*q-1,3*m-2) + k(17,7);
K(3*q-1,3*m-1) = K(3*q-1,3*m-1) + k(17,8);
K(3*q-1,3*m) = K(3*q-1,3*m) + k(17,9);
K(3*q-1,3*n-2) = K(3*q-1,3*n-2) + k(17,10);
K(3*q-1,3*n-1) = K(3*q-1,3*n-1) + k(17,11);
K(3*q-1,3*n) = K(3*q-1,3*n) + k(17,12);
K(3*q-1,3*p-2) = K(3*q-1,3*p-2) + k(17,13);
K(3*q-1,3*p-1) = K(3*q-1,3*p-1) + k(17,14);
K(3*q-1,3*p) = K(3*q-1,3*p) + k(17,15);
K(3*q-1,3*q-2) = K(3*q-1,3*q-2) + k(17,16);
K(3*q-1,3*q-1) = K(3*q-1,3*q-1) + k(17,17);
K(3*q-1,3*q) = K(3*q-1,3*q) + k(17,18);
K(3*q-1,3*r-2) = K(3*q-1,3*r-2) + k(17,19);
K(3*q-1,3*r-1) = K(3*q-1,3*r-1) + k(17,20);
K(3*q-1,3*r) = K(3*q-1,3*r) + k(17,21);
K(3*q-1,3*s-2) = K(3*q-1,3*s-2) + k(17,22);
K(3*q-1,3*s-1) = K(3*q-1,3*s-1) + k(17,23);
K(3*q-1,3*s) = K(3*q-1,3*s) + k(17,24);
K(3*q,3*i-2) = K(3*q,3*i-2) + k(18,1);
K(3*q,3*i-1) = K(3*q,3*i-1) + k(18,2);
K(3*q,3*i) = K(3*q,3*i) + k(18,3);
K(3*q,3*j-2) = K(3*q,3*j-2) + k(18,4);
K(3*q,3*j-1) = K(3*q,3*j-1) + k(18,5);
K(3*q,3*j) = K(3*q,3*j) + k(18,6);
K(3*q,3*m-2) = K(3*q,3*m-2) + k(18,7);
K(3*q,3*m-1) = K(3*q,3*m-1) + k(18,8);
K(3*q,3*m) = K(3*q,3*m) + k(18,9);
K(3*q,3*n-2) = K(3*q,3*n-2) + k(18,10);
K(3*q,3*n-1) = K(3*q,3*n-1) + k(18,11);
K(3*q,3*n) = K(3*q,3*n) + k(18,12);
K(3*q,3*p-2) = K(3*q,3*p-2) + k(18,13);
K(3*q,3*p-1) = K(3*q,3*p-1) + k(18,14);
K(3*q,3*p) = K(3*q,3*p) + k(18,15);
K(3*q,3*q-2) = K(3*q,3*q-2) + k(18,16);
K(3*q,3*q-1) = K(3*q,3*q-1) + k(18,17);
K(3*q,3*q) = K(3*q,3*q) + k(18,18);
K(3*q,3*r-2) = K(3*q,3*r-2) + k(18,19);
K(3*q,3*r-1) = K(3*q,3*r-1) + k(18,20);
K(3*q,3*r) = K(3*q,3*r) + k(18,21);
K(3*q,3*s-2) = K(3*q,3*s-2) + k(18,22);
K(3*q,3*s-1) = K(3*q,3*s-1) + k(18,23);
K(3*q,3*s) = K(3*q,3*s) + k(18,24);
K(3*r-2,3*i-2) = K(3*r-2,3*i-2) + k(19,1);
K(3*r-2,3*i-1) = K(3*r-2,3*i-1) + k(19,2);
K(3*r-2,3*i) = K(3*r-2,3*i) + k(19,3);
K(3*r-2,3*j-2) = K(3*r-2,3*j-2) + k(19,4);
K(3*r-2,3*j-1) = K(3*r-2,3*j-1) + k(19,5);
K(3*r-2,3*j) = K(3*r-2,3*j) + k(19,6);
K(3*r-2,3*m-2) = K(3*r-2,3*m-2) + k(19,7);
K(3*r-2,3*m-1) = K(3*r-2,3*m-1) + k(19,8);
K(3*r-2,3*m) = K(3*r-2,3*m) + k(19,9);
K(3*r-2,3*n-2) = K(3*r-2,3*n-2) + k(19,10);
K(3*r-2,3*n-1) = K(3*r-2,3*n-1) + k(19,11);
K(3*r-2,3*n) = K(3*r-2,3*n) + k(19,12);
K(3*r-2,3*p-2) = K(3*r-2,3*p-2) + k(19,13);
K(3*r-2,3*p-1) = K(3*r-2,3*p-1) + k(19,14);
K(3*r-2,3*p) = K(3*r-2,3*p) + k(19,15);
K(3*r-2,3*q-2) = K(3*r-2,3*q-2) + k(19,16);
K(3*r-2,3*q-1) = K(3*r-2,3*q-1) + k(19,17);
K(3*r-2,3*q) = K(3*r-2,3*q) + k(19,18);
K(3*r-2,3*r-2) = K(3*r-2,3*r-2) + k(19,19);
K(3*r-2,3*r-1) = K(3*r-2,3*r-1) + k(19,20);
K(3*r-2,3*r) = K(3*r-2,3*r) + k(19,21);
K(3*r-2,3*s-2) = K(3*r-2,3*s-2) + k(19,22);
K(3*r-2,3*s-1) = K(3*r-2,3*s-1) + k(19,23);
K(3*r-2,3*s) = K(3*r-2,3*s) + k(19,24);
K(3*r-1,3*i-2) = K(3*r-1,3*i-2) + k(20,1);
K(3*r-1,3*i-1) = K(3*r-1,3*i-1) + k(20,2);
K(3*r-1,3*i) = K(3*r-1,3*i) + k(20,3);
K(3*r-1,3*j-2) = K(3*r-1,3*j-2) + k(20,4);
K(3*r-1,3*j-1) = K(3*r-1,3*j-1) + k(20,5);
K(3*r-1,3*j) = K(3*r-1,3*j) + k(20,6);
K(3*r-1,3*m-2) = K(3*r-1,3*m-2) + k(20,7);
K(3*r-1,3*m-1) = K(3*r-1,3*m-1) + k(20,8);
K(3*r-1,3*m) = K(3*r-1,3*m) + k(20,9);
K(3*r-1,3*n-2) = K(3*r-1,3*n-2) + k(20,10);
K(3*r-1,3*n-1) = K(3*r-1,3*n-1) + k(20,11);
K(3*r-1,3*n) = K(3*r-1,3*n) + k(20,12);
K(3*r-1,3*p-2) = K(3*r-1,3*p-2) + k(20,13);
K(3*r-1,3*p-1) = K(3*r-1,3*p-1) + k(20,14);
K(3*r-1,3*p) = K(3*r-1,3*p) + k(20,15);
K(3*r-1,3*q-2) = K(3*r-1,3*q-2) + k(20,16);
K(3*r-1,3*q-1) = K(3*r-1,3*q-1) + k(20,17);
K(3*r-1,3*q) = K(3*r-1,3*q) + k(20,18);
K(3*r-1,3*r-2) = K(3*r-1,3*r-2) + k(20,19);
K(3*r-1,3*r-1) = K(3*r-1,3*r-1) + k(20,20);
K(3*r-1,3*r) = K(3*r-1,3*r) + k(20,21);
K(3*r-1,3*s-2) = K(3*r-1,3*s-2) + k(20,22);
K(3*r-1,3*s-1) = K(3*r-1,3*s-1) + k(20,23);
K(3*r-1,3*s) = K(3*r-1,3*s) + k(20,24);
K(3*r,3*i-2) = K(3*r,3*i-2) + k(21,1);
K(3*r,3*i-1) = K(3*r,3*i-1) + k(21,2);
K(3*r,3*i) = K(3*r,3*i) + k(21,3);
K(3*r,3*j-2) = K(3*r,3*j-2) + k(21,4);
K(3*r,3*j-1) = K(3*r,3*j-1) + k(21,5);
K(3*r,3*j) = K(3*r,3*j) + k(21,6);
K(3*r,3*m-2) = K(3*r,3*m-2) + k(21,7);
K(3*r,3*m-1) = K(3*r,3*m-1) + k(21,8);
K(3*r,3*m) = K(3*r,3*m) + k(21,9);
K(3*r,3*n-2) = K(3*r,3*n-2) + k(21,10);
K(3*r,3*n-1) = K(3*r,3*n-1) + k(21,11);
K(3*r,3*n) = K(3*r,3*n) + k(21,12);
K(3*r,3*p-2) = K(3*r,3*p-2) + k(21,13);
K(3*r,3*p-1) = K(3*r,3*p-1) + k(21,14);
K(3*r,3*p) = K(3*r,3*p) + k(21,15);
K(3*r,3*q-2) = K(3*r,3*q-2) + k(21,16);
K(3*r,3*q-1) = K(3*r,3*q-1) + k(21,17);
K(3*r,3*q) = K(3*r,3*q) + k(21,18);
K(3*r,3*r-2) = K(3*r,3*r-2) + k(21,19);
K(3*r,3*r-1) = K(3*r,3*r-1) + k(21,20);
K(3*r,3*r) = K(3*r,3*r) + k(21,21);
K(3*r,3*s-2) = K(3*r,3*s-2) + k(21,22);
K(3*r,3*s-1) = K(3*r,3*s-1) + k(21,23);
K(3*r,3*s) = K(3*r,3*s) + k(21,24);
K(3*s-2,3*i-2) = K(3*s-2,3*i-2) + k(22,1);
K(3*s-2,3*i-1) = K(3*s-2,3*i-1) + k(22,2);
K(3*s-2,3*i) = K(3*s-2,3*i) + k(22,3);
K(3*s-2,3*j-2) = K(3*s-2,3*j-2) + k(22,4);
K(3*s-2,3*j-1) = K(3*s-2,3*j-1) + k(22,5);
K(3*s-2,3*j) = K(3*s-2,3*j) + k(22,6);
K(3*s-2,3*m-2) = K(3*s-2,3*m-2) + k(22,7);
K(3*s-2,3*m-1) = K(3*s-2,3*m-1) + k(22,8);
K(3*s-2,3*m) = K(3*s-2,3*m) + k(22,9);
K(3*s-2,3*n-2) = K(3*s-2,3*n-2) + k(22,10);
K(3*s-2,3*n-1) = K(3*s-2,3*n-1) + k(22,11);
K(3*s-2,3*n) = K(3*s-2,3*n) + k(22,12);
K(3*s-2,3*p-2) = K(3*s-2,3*p-2) + k(22,13);
K(3*s-2,3*p-1) = K(3*s-2,3*p-1) + k(22,14);
K(3*s-2,3*p) = K(3*s-2,3*p) + k(22,15);
K(3*s-2,3*q-2) = K(3*s-2,3*q-2) + k(22,16);
K(3*s-2,3*q-1) = K(3*s-2,3*q-1) + k(22,17);
K(3*s-2,3*q) = K(3*s-2,3*q) + k(22,18);
K(3*s-2,3*r-2) = K(3*s-2,3*r-2) + k(22,19);
K(3*s-2,3*r-1) = K(3*s-2,3*r-1) + k(22,20);
K(3*s-2,3*r) = K(3*s-2,3*r) + k(22,21);
K(3*s-2,3*s-2) = K(3*s-2,3*s-2) + k(22,22);
K(3*s-2,3*s-1) = K(3*s-2,3*s-1) + k(22,23);
K(3*s-2,3*s) = K(3*s-2,3*s) + k(22,24);
K(3*s-1,3*i-2) = K(3*s-1,3*i-2) + k(23,1);
K(3*s-1,3*i-1) = K(3*s-1,3*i-1) + k(23,2);
K(3*s-1,3*i) = K(3*s-1,3*i) + k(23,3);
K(3*s-1,3*j-2) = K(3*s-1,3*j-2) + k(23,4);
K(3*s-1,3*j-1) = K(3*s-1,3*j-1) + k(23,5);
K(3*s-1,3*j) = K(3*s-1,3*j) + k(23,6);
K(3*s-1,3*m-2) = K(3*s-1,3*m-2) + k(23,7);
K(3*s-1,3*m-1) = K(3*s-1,3*m-1) + k(23,8);
K(3*s-1,3*m) = K(3*s-1,3*m) + k(23,9);
K(3*s-1,3*n-2) = K(3*s-1,3*n-2) + k(23,10);
K(3*s-1,3*n-1) = K(3*s-1,3*n-1) + k(23,11);
K(3*s-1,3*n) = K(3*s-1,3*n) + k(23,12);
K(3*s-1,3*p-2) = K(3*s-1,3*p-2) + k(23,13);
K(3*s-1,3*p-1) = K(3*s-1,3*p-1) + k(23,14);
K(3*s-1,3*p) = K(3*s-1,3*p) + k(23,15);
K(3*s-1,3*q-2) = K(3*s-1,3*q-2) + k(23,16);
K(3*s-1,3*q-1) = K(3*s-1,3*q-1) + k(23,17);
K(3*s-1,3*q) = K(3*s-1,3*q) + k(23,18);
K(3*s-1,3*r-2) = K(3*s-1,3*r-2) + k(23,19);
K(3*s-1,3*r-1) = K(3*s-1,3*r-1) + k(23,20);
K(3*s-1,3*r) = K(3*s-1,3*r) + k(23,21);
K(3*s-1,3*s-2) = K(3*s-1,3*s-2) + k(23,22);
K(3*s-1,3*s-1) = K(3*s-1,3*s-1) + k(23,23);
K(3*s-1,3*s) = K(3*s-1,3*s) + k(23,24);
K(3*s,3*i-2) = K(3*s,3*i-2) + k(24,1);
K(3*s,3*i-1) = K(3*s,3*i-1) + k(24,2);
K(3*s,3*i) = K(3*s,3*i) + k(24,3);
K(3*s,3*j-2) = K(3*s,3*j-2) + k(24,4);
K(3*s,3*j-1) = K(3*s,3*j-1) + k(24,5);
K(3*s,3*j) = K(3*s,3*j) + k(24,6);
K(3*s,3*m-2) = K(3*s,3*m-2) + k(24,7);
K(3*s,3*m-1) = K(3*s,3*m-1) + k(24,8);
K(3*s,3*m) = K(3*s,3*m) + k(24,9);
K(3*s,3*n-2) = K(3*s,3*n-2) + k(24,10);
K(3*s,3*n-1) = K(3*s,3*n-1) + k(24,11);
K(3*s,3*n) = K(3*s,3*n) + k(24,12);
K(3*s,3*p-2) = K(3*s,3*p-2) + k(24,13);
K(3*s,3*p-1) = K(3*s,3*p-1) + k(24,14);
K(3*s,3*p) = K(3*s,3*p) + k(24,15);
K(3*s,3*q-2) = K(3*s,3*q-2) + k(24,16);
K(3*s,3*q-1) = K(3*s,3*q-1) + k(24,17);
K(3*s,3*q) = K(3*s,3*q) + k(24,18);
K(3*s,3*r-2) = K(3*s,3*r-2) + k(24,19);
K(3*s,3*r-1) = K(3*s,3*r-1) + k(24,20);
K(3*s,3*r) = K(3*s,3*r) + k(24,21);
K(3*s,3*s-2) = K(3*s,3*s-2) + k(24,22);
K(3*s,3*s-1) = K(3*s,3*s-1) + k(24,23);
K(3*s,3*s) = K(3*s,3*s) + k(24,24);
y = K;



