function y = BilinearQuadAssemble(K,k,i,j,m,n)
%BilinearQuadAssemble   This function assembles the element 
%                       stiffness matrix k of the bilinear 
%                       quadrilateral element with nodes i, j, 
%                       m, and n into the global stiffness 
%                       matrix K.
%                       This function returns the global stiffness  
%                       matrix K after the element stiffness matrix  
%                       k is assembled.
K(2*i-1,2*i-1) = K(2*i-1,2*i-1) + k(1,1);
K(2*i-1,2*i) = K(2*i-1,2*i) + k(1,2);
K(2*i-1,2*j-1) = K(2*i-1,2*j-1) + k(1,3);
K(2*i-1,2*j) = K(2*i-1,2*j) + k(1,4);
K(2*i-1,2*m-1) = K(2*i-1,2*m-1) + k(1,5);
K(2*i-1,2*m) = K(2*i-1,2*m) + k(1,6);
K(2*i-1,2*n-1) = K(2*i-1,2*n-1) + k(1,7);
K(2*i-1,2*n) = K(2*i-1,2*n) + k(1,8);
K(2*i,2*i-1) = K(2*i,2*i-1) + k(2,1);
K(2*i,2*i) = K(2*i,2*i) + k(2,2);
K(2*i,2*j-1) = K(2*i,2*j-1) + k(2,3);
K(2*i,2*j) = K(2*i,2*j) + k(2,4);
K(2*i,2*m-1) = K(2*i,2*m-1) + k(2,5);
K(2*i,2*m) = K(2*i,2*m) + k(2,6);
K(2*i,2*n-1) = K(2*i,2*n-1) + k(2,7);
K(2*i,2*n) = K(2*i,2*n) + k(2,8);
K(2*j-1,2*i-1) = K(2*j-1,2*i-1) + k(3,1);
K(2*j-1,2*i) = K(2*j-1,2*i) + k(3,2);
K(2*j-1,2*j-1) = K(2*j-1,2*j-1) + k(3,3);
K(2*j-1,2*j) = K(2*j-1,2*j) + k(3,4);
K(2*j-1,2*m-1) = K(2*j-1,2*m-1) + k(3,5);
K(2*j-1,2*m) = K(2*j-1,2*m) + k(3,6);
K(2*j-1,2*n-1) = K(2*j-1,2*n-1) + k(3,7);
K(2*j-1,2*n) = K(2*j-1,2*n) + k(3,8);
K(2*j,2*i-1) = K(2*j,2*i-1) + k(4,1);
K(2*j,2*i) = K(2*j,2*i) + k(4,2);
K(2*j,2*j-1) = K(2*j,2*j-1) + k(4,3);
K(2*j,2*j) = K(2*j,2*j) + k(4,4);
K(2*j,2*m-1) = K(2*j,2*m-1) + k(4,5);
K(2*j,2*m) = K(2*j,2*m) + k(4,6);
K(2*j,2*n-1) = K(2*j,2*n-1) + k(4,7);
K(2*j,2*n) = K(2*j,2*n) + k(4,8);
K(2*m-1,2*i-1) = K(2*m-1,2*i-1) + k(5,1);
K(2*m-1,2*i) = K(2*m-1,2*i) + k(5,2);
K(2*m-1,2*j-1) = K(2*m-1,2*j-1) + k(5,3);
K(2*m-1,2*j) = K(2*m-1,2*j) + k(5,4);
K(2*m-1,2*m-1) = K(2*m-1,2*m-1) + k(5,5);
K(2*m-1,2*m) = K(2*m-1,2*m) + k(5,6);
K(2*m-1,2*n-1) = K(2*m-1,2*n-1) + k(5,7);
K(2*m-1,2*n) = K(2*m-1,2*n) + k(5,8);
K(2*m,2*i-1) = K(2*m,2*i-1) + k(6,1);
K(2*m,2*i) = K(2*m,2*i) + k(6,2);
K(2*m,2*j-1) = K(2*m,2*j-1) + k(6,3);
K(2*m,2*j) = K(2*m,2*j) + k(6,4);
K(2*m,2*m-1) = K(2*m,2*m-1) + k(6,5);
K(2*m,2*m) = K(2*m,2*m) + k(6,6);
K(2*m,2*n-1) = K(2*m,2*n-1) + k(6,7);
K(2*m,2*n) = K(2*m,2*n) + k(6,8);
K(2*n-1,2*i-1) = K(2*n-1,2*i-1) + k(7,1);
K(2*n-1,2*i) = K(2*n-1,2*i) + k(7,2);
K(2*n-1,2*j-1) = K(2*n-1,2*j-1) + k(7,3);
K(2*n-1,2*j) = K(2*n-1,2*j) + k(7,4);
K(2*n-1,2*m-1) = K(2*n-1,2*m-1) + k(7,5);
K(2*n-1,2*m) = K(2*n-1,2*m) + k(7,6);
K(2*n-1,2*n-1) = K(2*n-1,2*n-1) + k(7,7);
K(2*n-1,2*n) = K(2*n-1,2*n) + k(7,8);
K(2*n,2*i-1) = K(2*n,2*i-1) + k(8,1);
K(2*n,2*i) = K(2*n,2*i) + k(8,2);
K(2*n,2*j-1) = K(2*n,2*j-1) + k(8,3);
K(2*n,2*j) = K(2*n,2*j) + k(8,4);
K(2*n,2*m-1) = K(2*n,2*m-1) + k(8,5);
K(2*n,2*m) = K(2*n,2*m) + k(8,6);
K(2*n,2*n-1) = K(2*n,2*n-1) + k(8,7);
K(2*n,2*n) = K(2*n,2*n) + k(8,8);
y = K;



