function y = TetrahedronAssemble(K,k,i,j,m,n)
%TetrahedronAssemble   This function assembles the element stiffness
%                      matrix k of the linear tetrahedral (solid)
%                      element with nodes i, j, m, and n into the
%                      global stiffness matrix K.
%                      This function returns the global stiffness  
%                      matrix K after the element stiffness matrix  
%                      k is assembled.
K(3*i-2,3*i-2) = K(3*i-2,3*i-2) + k(1,1);
K(3*i-2,3*i-1) = K(3*i-2,3*i-1) + k(1,2);
K(3*i-2,3*i) = K(3*i-2,3*i) + k(1,3);
K(3*i-2,3*j-2) = K(3*i-2,3*j-2) + k(1,4);
K(3*i-2,3*j-1) = K(3*i-2,3*j-1) + k(1,5);
K(3*i-2,3*j) = K(3*i-2,3*j) + k(1,6);
K(3*i-2,3*m-2) = K(3*i-2,3*m-2) + k(1,7);
K(3*i-2,3*m-1) = K(3*i-2,3*m-1) + k(1,8);
K(3*i-2,3*m) = K(3*i-2,3*m) + k(1,9);
K(3*i-2,3*n-2) = K(3*i-2,3*n-2) + k(1,10);
K(3*i-2,3*n-1) = K(3*i-2,3*n-1) + k(1,11);
K(3*i-2,3*n) = K(3*i-2,3*n) + k(1,12);
K(3*i-1,3*i-2) = K(3*i-1,3*i-2) + k(2,1);
K(3*i-1,3*i-1) = K(3*i-1,3*i-1) + k(2,2);
K(3*i-1,3*i) = K(3*i-1,3*i) + k(2,3);
K(3*i-1,3*j-2) = K(3*i-1,3*j-2) + k(2,4);
K(3*i-1,3*j-1) = K(3*i-1,3*j-1) + k(2,5);
K(3*i-1,3*j) = K(3*i-1,3*j) + k(2,6);
K(3*i-1,3*m-2) = K(3*i-1,3*m-2) + k(2,7);
K(3*i-1,3*m-1) = K(3*i-1,3*m-1) + k(2,8);
K(3*i-1,3*m) = K(3*i-1,3*m) + k(2,9);
K(3*i-1,3*n-2) = K(3*i-1,3*n-2) + k(2,10);
K(3*i-1,3*n-1) = K(3*i-1,3*n-1) + k(2,11);
K(3*i-1,3*n) = K(3*i-1,3*n) + k(2,12);
K(3*i,3*i-2) = K(3*i,3*i-2) + k(3,1);
K(3*i,3*i-1) = K(3*i,3*i-1) + k(3,2);
K(3*i,3*i) = K(3*i,3*i) + k(3,3);
K(3*i,3*j-2) = K(3*i,3*j-2) + k(3,4);
K(3*i,3*j-1) = K(3*i,3*j-1) + k(3,5);
K(3*i,3*j) = K(3*i,3*j) + k(3,6);
K(3*i,3*m-2) = K(3*i,3*m-2) + k(3,7);
K(3*i,3*m-1) = K(3*i,3*m-1) + k(3,8);
K(3*i,3*m) = K(3*i,3*m) + k(3,9);
K(3*i,3*n-2) = K(3*i,3*n-2) + k(3,10);
K(3*i,3*n-1) = K(3*i,3*n-1) + k(3,11);
K(3*i,3*n) = K(3*i,3*n) + k(3,12);
K(3*j-2,3*i-2) = K(3*j-2,3*i-2) + k(4,1);
K(3*j-2,3*i-1) = K(3*j-2,3*i-1) + k(4,2);
K(3*j-2,3*i) = K(3*j-2,3*i) + k(4,3);
K(3*j-2,3*j-2) = K(3*j-2,3*j-2) + k(4,4);
K(3*j-2,3*j-1) = K(3*j-2,3*j-1) + k(4,5);
K(3*j-2,3*j) = K(3*j-2,3*j) + k(4,6);
K(3*j-2,3*m-2) = K(3*j-2,3*m-2) + k(4,7);
K(3*j-2,3*m-1) = K(3*j-2,3*m-1) + k(4,8);
K(3*j-2,3*m) = K(3*j-2,3*m) + k(4,9);
K(3*j-2,3*n-2) = K(3*j-2,3*n-2) + k(4,10);
K(3*j-2,3*n-1) = K(3*j-2,3*n-1) + k(4,11);
K(3*j-2,3*n) = K(3*j-2,3*n) + k(4,12);
K(3*j-1,3*i-2) = K(3*j-1,3*i-2) + k(5,1);
K(3*j-1,3*i-1) = K(3*j-1,3*i-1) + k(5,2);
K(3*j-1,3*i) = K(3*j-1,3*i) + k(5,3);
K(3*j-1,3*j-2) = K(3*j-1,3*j-2) + k(5,4);
K(3*j-1,3*j-1) = K(3*j-1,3*j-1) + k(5,5);
K(3*j-1,3*j) = K(3*j-1,3*j) + k(5,6);
K(3*j-1,3*m-2) = K(3*j-1,3*m-2) + k(5,7);
K(3*j-1,3*m-1) = K(3*j-1,3*m-1) + k(5,8);
K(3*j-1,3*m) = K(3*j-1,3*m) + k(5,9);
K(3*j-1,3*n-2) = K(3*j-1,3*n-2) + k(5,10);
K(3*j-1,3*n-1) = K(3*j-1,3*n-1) + k(5,11);
K(3*j-1,3*n) = K(3*j-1,3*n) + k(5,12);
K(3*j,3*i-2) = K(3*j,3*i-2) + k(6,1);
K(3*j,3*i-1) = K(3*j,3*i-1) + k(6,2);
K(3*j,3*i) = K(3*j,3*i) + k(6,3);
K(3*j,3*j-2) = K(3*j,3*j-2) + k(6,4);
K(3*j,3*j-1) = K(3*j,3*j-1) + k(6,5);
K(3*j,3*j) = K(3*j,3*j) + k(6,6);
K(3*j,3*m-2) = K(3*j,3*m-2) + k(6,7);
K(3*j,3*m-1) = K(3*j,3*m-1) + k(6,8);
K(3*j,3*m) = K(3*j,3*m) + k(6,9);
K(3*j,3*n-2) = K(3*j,3*n-2) + k(6,10);
K(3*j,3*n-1) = K(3*j,3*n-1) + k(6,11);
K(3*j,3*n) = K(3*j,3*n) + k(6,12);
K(3*m-2,3*i-2) = K(3*m-2,3*i-2) + k(7,1);
K(3*m-2,3*i-1) = K(3*m-2,3*i-1) + k(7,2);
K(3*m-2,3*i) = K(3*m-2,3*i) + k(7,3);
K(3*m-2,3*j-2) = K(3*m-2,3*j-2) + k(7,4);
K(3*m-2,3*j-1) = K(3*m-2,3*j-1) + k(7,5);
K(3*m-2,3*j) = K(3*m-2,3*j) + k(7,6);
K(3*m-2,3*m-2) = K(3*m-2,3*m-2) + k(7,7);
K(3*m-2,3*m-1) = K(3*m-2,3*m-1) + k(7,8);
K(3*m-2,3*m) = K(3*m-2,3*m) + k(7,9);
K(3*m-2,3*n-2) = K(3*m-2,3*n-2) + k(7,10);
K(3*m-2,3*n-1) = K(3*m-2,3*n-1) + k(7,11);
K(3*m-2,3*n) = K(3*m-2,3*n) + k(7,12);
K(3*m-1,3*i-2) = K(3*m-1,3*i-2) + k(8,1);
K(3*m-1,3*i-1) = K(3*m-1,3*i-1) + k(8,2);
K(3*m-1,3*i) = K(3*m-1,3*i) + k(8,3);
K(3*m-1,3*j-2) = K(3*m-1,3*j-2) + k(8,4);
K(3*m-1,3*j-1) = K(3*m-1,3*j-1) + k(8,5);
K(3*m-1,3*j) = K(3*m-1,3*j) + k(8,6);
K(3*m-1,3*m-2) = K(3*m-1,3*m-2) + k(8,7);
K(3*m-1,3*m-1) = K(3*m-1,3*m-1) + k(8,8);
K(3*m-1,3*m) = K(3*m-1,3*m) + k(8,9);
K(3*m-1,3*n-2) = K(3*m-1,3*n-2) + k(8,10);
K(3*m-1,3*n-1) = K(3*m-1,3*n-1) + k(8,11);
K(3*m-1,3*n) = K(3*m-1,3*n) + k(8,12);
K(3*m,3*i-2) = K(3*m,3*i-2) + k(9,1);
K(3*m,3*i-1) = K(3*m,3*i-1) + k(9,2);
K(3*m,3*i) = K(3*m,3*i) + k(9,3);
K(3*m,3*j-2) = K(3*m,3*j-2) + k(9,4);
K(3*m,3*j-1) = K(3*m,3*j-1) + k(9,5);
K(3*m,3*j) = K(3*m,3*j) + k(9,6);
K(3*m,3*m-2) = K(3*m,3*m-2) + k(9,7);
K(3*m,3*m-1) = K(3*m,3*m-1) + k(9,8);
K(3*m,3*m) = K(3*m,3*m) + k(9,9);
K(3*m,3*n-2) = K(3*m,3*n-2) + k(9,10);
K(3*m,3*n-1) = K(3*m,3*n-1) + k(9,11);
K(3*m,3*n) = K(3*m,3*n) + k(9,12);
K(3*n-2,3*i-2) = K(3*n-2,3*i-2) + k(10,1);
K(3*n-2,3*i-1) = K(3*n-2,3*i-1) + k(10,2);
K(3*n-2,3*i) = K(3*n-2,3*i) + k(10,3);
K(3*n-2,3*j-2) = K(3*n-2,3*j-2) + k(10,4);
K(3*n-2,3*j-1) = K(3*n-2,3*j-1) + k(10,5);
K(3*n-2,3*j) = K(3*n-2,3*j) + k(10,6);
K(3*n-2,3*m-2) = K(3*n-2,3*m-2) + k(10,7);
K(3*n-2,3*m-1) = K(3*n-2,3*m-1) + k(10,8);
K(3*n-2,3*m) = K(3*n-2,3*m) + k(10,9);
K(3*n-2,3*n-2) = K(3*n-2,3*n-2) + k(10,10);
K(3*n-2,3*n-1) = K(3*n-2,3*n-1) + k(10,11);
K(3*n-2,3*n) = K(3*n-2,3*n) + k(10,12);
K(3*n-1,3*i-2) = K(3*n-1,3*i-2) + k(11,1);
K(3*n-1,3*i-1) = K(3*n-1,3*i-1) + k(11,2);
K(3*n-1,3*i) = K(3*n-1,3*i) + k(11,3);
K(3*n-1,3*j-2) = K(3*n-1,3*j-2) + k(11,4);
K(3*n-1,3*j-1) = K(3*n-1,3*j-1) + k(11,5);
K(3*n-1,3*j) = K(3*n-1,3*j) + k(11,6);
K(3*n-1,3*m-2) = K(3*n-1,3*m-2) + k(11,7);
K(3*n-1,3*m-1) = K(3*n-1,3*m-1) + k(11,8);
K(3*n-1,3*m) = K(3*n-1,3*m) + k(11,9);
K(3*n-1,3*n-2) = K(3*n-1,3*n-2) + k(11,10);
K(3*n-1,3*n-1) = K(3*n-1,3*n-1) + k(11,11);
K(3*n-1,3*n) = K(3*n-1,3*n) + k(11,12);
K(3*n,3*i-2) = K(3*n,3*i-2) + k(12,1);
K(3*n,3*i-1) = K(3*n,3*i-1) + k(12,2);
K(3*n,3*i) = K(3*n,3*i) + k(12,3);
K(3*n,3*j-2) = K(3*n,3*j-2) + k(12,4);
K(3*n,3*j-1) = K(3*n,3*j-1) + k(12,5);
K(3*n,3*j) = K(3*n,3*j) + k(12,6);
K(3*n,3*m-2) = K(3*n,3*m-2) + k(12,7);
K(3*n,3*m-1) = K(3*n,3*m-1) + k(12,8);
K(3*n,3*m) = K(3*n,3*m) + k(12,9);
K(3*n,3*n-2) = K(3*n,3*n-2) + k(12,10);
K(3*n,3*n-1) = K(3*n,3*n-1) + k(12,11);
K(3*n,3*n) = K(3*n,3*n) + k(12,12);
y = K;



