#! /bin/sh

#####################################################################
# wenn man in einem gegenenen verzeichis einen relativen dateinamen
# hat, wandelt dieses programm ihn in einen absoluten um.
# bsp: aktuelles verzeichnis ist /root/text
#      ./t.txt  ---> /root/text/t.xt
#      ../t.txt ---> /root/t.txt

# achtung: wenn leerzeichen irgendwo auftauchen, funktioniert das nicht
#   zu tun: alles irgendwie in "" einfangen. 

abs_path () {
  file0="$1"
  oldpath=$(/bin/pwd)
  newpath=$(dirname  "$file0")
  base=$(basename "$file0")
  cd "$newpath"
  if test "$?" != "0"; then
    echo "could not get absolute path of $file0"
    return -1
  fi
  newabspath=$(/bin/pwd)
  echo "$newabspath"/"$base"
  cd "$oldpath"
  return 0
}


#####################################################################
# wenn man einen dateinamen hat, der ein symbolischer link sein kann,
# gibt dieses script den absoluten dateinamen wieder, auf den der link verweist
# dabei knnen ggf. mehrere links hintereinander verfolgt werden.
# aufruf: follow_links

# achtung: wenn leerzeichen irgendwo auftauchen, funktioniert das nicht

follow_links () {

  file0=$(abs_path "$1")

  if [ -L "$file0" ]; then
    oldpath=$(/bin/pwd)

    n=1
    while [ $n -le 8 ]
    do
      newdir=$(dirname "$file0")
      cd "$newdir"
      file0=$(basename "$file0")

      file0=$(ls -ld "$file0" | /bin/sed -n 's/.*-> //p')
  
      file0=$(abs_path "$file0")

      if [ ! -L "$file0" ]; then
        n=1000
      fi

      n=$(expr $n + 1)
    done

    cd "$oldpath"
  fi

  echo "$file0"
}

shell_script=$(follow_links "$0")

path=$(dirname "$shell_script")

exe_name="ode.exe"

/lib/ld-linux.so.* --library-path "$path" "$path"/"$exe_name" &

