ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Routine for input data
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      program g_main
c
c	This program computes the solar irradiance 
c     on a horizontal surface, at ground level, on cloudy sky
c     Computation is performed for all the days in a given month, for
c     a given locality.
c-----------
c	Input meteorological data comes from a file placed in the same 
c     directory with this program. This file must be prespared by 
c     the user. The recordings of that file have the following structure:
c
c	nluna - number of the month within the year
c	nzi - number of the day within the month
c	ora - hour
c	pres - air pressure at ground level (Pa)
c	temp - air temperature at ground level (K)
c	pc - total cloud amount (dimensionless; between 0 and 1)
c	u - air relative humidity at ground level
c         (dimensionless; between 0 and 1)
c-----------
c	Results are stored in a file. The recordings of that 
c     file have the following structure
c
c	nluna - number of the month within the year
c	nzi - number of the day within the month
c	ora - hour
c	pres - air pressure at ground level (Pa)
c	temp - air temperature at ground level (K)
c	pc - total cloud amount (dimensionless; between 0 and 1)
c	u - air relative humidity at ground level
c         (dimensionless; between 0 and 1)
c	nsun - sunshine number (dimensionless; 0 or 1)
c	vih	- direct solar irradiance on cloudy sky (W/m2)
c	vdh	- diffuse solar irradiance on cloudy sky (W/m2)
c	vgh	- global solar irradiance on cloudy sky (W/m2)
c------------
c
c     Dialog between user and computer
c
	call g_input(ninreg)
c
c	Computations for all recordings in the file with meteo data
c
      do 4500 ku=1,ninreg
c             Reading from the file with meteo data
	read(1,455,rec=ku)nluna,nzi,ora,pres,temp,pc,u
c			Computes irradiance on clear sky
	call g_clear(nluna,nzi,ora,pres,temp,u,cosz,dsen,gsen)
c			Computes irradiance on cloudy sky
	call g_cloudy(pc,cosz,dsen,gsen,nsun,vih,vdh,vgh)
c			Writing data in the file with results
      write(2,2700,rec=ku)nluna,nzi,ora,pres,temp,pc,u,
	* nsun,vih,vdh,vgh
4500  continue
c
455	format(i3,i3,1x,f6.3,3x,f6.1,1x,f5.1,1x,f5.3,1x,f5.3)
2700   format(i3,i3,1x,f6.3,3x,f6.1,1x,f5.1,1x,f5.3,1x,f5.3,
     *     3x,i1,1x,3(1x,f6.1))
       stop
       end
