C     Last change:  JAD  18 Nov 98    3:02 pm
      SUBROUTINE  DISORT( NLYR, DTAUC, SSALB, PMOM, TEMPER, WVNMLO,
     $                    WVNMHI, USRTAU, NTAU, UTAU, NSTR, USRANG,
     $                    NUMU, UMU, NPHI, PHI, IBCND, FBEAM, UMU0,
     $                    PHI0, FISOT, LAMBER, ALBEDO, HL, BTEMP,
     $                    TTEMP, TEMIS, DELTAM, NOPLNK, ONLYFL,
     $                    ACCUR, PRNT, MAXCLY, MAXULV,
     $                    MAXUMU, MAXCMU, MAXPHI, RFLDIR, RFLDN,
     $                    FLUP, DFDT, UAVG, UU, U0U, ALBMED, TRNMED )
C
C **********************************************************************
C       PLANE-PARALLEL DISCRETE ORDINATES RADIATIVE TRANSFER PROGRAM
C             ( SEE DISORT.DOC FOR COMPLETE DOCUMENTATION )
C **********************************************************************
C
C+---------------------------------------------------------------------+
C------------------    I/O VARIABLE SPECIFICATIONS     -----------------
C+---------------------------------------------------------------------+
C
	IMPLICIT REAL*8 (A-G, O-Z)
c      CHARACTER  HEADER*127
      LOGICAL  DELTAM, LAMBER, NOPLNK, ONLYFL, PRNT(7), USRANG, USRTAU
      INTEGER  IBCND, MAXCLY, MAXUMU, MAXULV, MAXCMU, MAXPHI, NLYR,
     $         NUMU, NSTR, NPHI, NTAU
      REAL*8   ACCUR, ALBEDO, BTEMP, DTAUC( MAXCLY ), FBEAM,FISOT,
     $         HL( 0:MAXCMU ), PHI( MAXPHI ), PMOM( 0:MAXCMU, MAXCLY ),
     $         PHI0, SSALB( MAXCLY ), TEMPER( 0:MAXCLY ), TEMIS, TTEMP,
     $         WVNMLO, WVNMHI, UMU( MAXUMU ), UMU0, UTAU( MAXULV )
C
      REAL*8   RFLDIR( MAXULV ), RFLDN( MAXULV ), FLUP(MAXULV),
     $         UAVG( MAXULV ), DFDT( MAXULV ), U0U( MAXUMU, MAXULV ),
     $         UU( MAXUMU, MAXULV, MAXPHI ), ALBMED( MAXUMU ),
     $         TRNMED( MAXUMU )
C
C+---------------------------------------------------------------------+
C      ROUTINES CALLED (IN ORDER):  SLFTST, ZEROAL, CHEKIN, SETDIS,
C                                   PRTINP, ALBTRN, LEPOLY, SURFAC,
C                                   SOLEIG, UPBEAM, UPISOT, TERPEV,
C                                   TERPSO, SETMTX, SOLVE0, FLUXES,
C                                   USRINT, PRAVIN, PRTINT
C+---------------------------------------------------------------------+
C
C  INDEX CONVENTIONS (FOR ALL DO-LOOPS AND ALL VARIABLE DESCRIPTIONS):
C
C     IU     :  FOR USER POLAR ANGLES
C
C  IQ,JQ,KQ  :  FOR COMPUTATIONAL POLAR ANGLES ('QUADRATURE ANGLES')
C
C   IQ/2     :  FOR HALF THE COMPUTATIONAL POLAR ANGLES (JUST THE ONES
C               IN EITHER 0-90 DEGREES, OR 90-180 DEGREES)
C
C     J      :  FOR USER AZIMUTHAL ANGLES
C
C     K,L    :  FOR LEGENDRE EXPANSION COEFFICIENTS OR, ALTERNATIVELY,
C               SUBSCRIPTS OF ASSOCIATED LEGENDRE POLYNOMIALS
C
C     LU     :  FOR USER LEVELS
C
C     LC     :  FOR COMPUTATIONAL LAYERS (EACH HAVING A DIFFERENT
C               SINGLE-SCATTER ALBEDO AND/OR PHASE FUNCTION)
C
C    LEV     :  FOR COMPUTATIONAL LEVELS
C
C    MAZ     :  FOR AZIMUTHAL COMPONENTS IN FOURIER COSINE EXPANSION
C               OF INTENSITY AND PHASE FUNCTION
C
C+---------------------------------------------------------------------+
C               I N T E R N A L    V A R I A B L E S
C
C   ALBSAV(IU)        TEMPORARY STORAGE FOR MEDIUM ALBEDO IN IBCND = 1
C                     SPECIAL CASE
C
C   AMB(IQ/2,IQ/2)    FIRST MATRIX FACTOR IN REDUCED EIGENVALUE PROBLEM
C                     OF EQS. SS(12), STWJ(8E)  (USED ONLY IN 'SOLEIG')
C
C   APB(IQ/2,IQ/2)    SECOND MATRIX FACTOR IN REDUCED EIGENVALUE PROBLEM
C                     OF EQS. SS(12), STWJ(8E)  (USED ONLY IN 'SOLEIG')
C
C   ARRAY(IQ,IQ)      SCRATCH MATRIX FOR 'SOLEIG', 'UPBEAM' AND 'UPISOT'
C                     (SEE EACH SUBROUTINE FOR DEFINITION)
C
C   B()               RIGHT-HAND SIDE VECTOR OF EQ. SC(5) GOING INTO
C                     *SOLVE0,1*;  RETURNS AS SOLUTION VECTOR
C                     VECTOR CAPITAL-L, THE CONSTANTS OF INTEGRATION
C
C   BDR(IQ/2,0:IQ/2)  BOTTOM-BOUNDARY BIDIRECTIONAL REFLECTIVITY FOR A
C                     GIVEN AZIMUTHAL COMPONENT.  FIRST INDEX ALWAYS
C                     REFERS TO A COMPUTATIONAL ANGLE.  SECOND INDEX:
C                     IF ZERO, REFERS TO INCIDENT BEAM ANGLE -UMU0-;
C                     IF NON-ZERO, REFERS TO A COMPUTATIONAL ANGLE.
C
C   BEM(IQ/2)         BOTTOM-BOUNDARY DIRECTIONAL EMISSIVITY AT COMPU-
C                     TATIONAL ANGLES.
C
C   BPLANK            INTENSITY EMITTED FROM BOTTOM BOUNDARY
C
C   CBAND()           MATRIX OF LEFT-HAND SIDE OF THE LINEAR SYSTEM
C                     EQ. SC(5), SCALED BY EQ. SC(12);  IN BANDED
C                     FORM REQUIRED BY LINPACK SOLUTION ROUTINES
C
C   CC(IQ,IQ)         CAPITAL-C-SUB-IJ IN EQ. SS(5)
C
C   CMU(IQ)           COMPUTATIONAL POLAR ANGLES (GAUSSIAN)
C
C   CWT(IQ)           QUADRATURE WEIGHTS CORRESP. TO -CMU-
C
C   DELM0             KRONECKER DELTA, DELTA-SUB-M0, WHERE 'M' = MAZ
C                     IS THE NUMBER OF THE FOURIER COMPONENT IN THE
C                     AZIMUTH COSINE EXPANSION
C
C   EMU(IU)           BOTTOM-BOUNDARY DIRECTIONAL EMISSIVITY AT USER
C                     ANGLES.
C
C   EVAL(IQ)          TEMPORARY STORAGE FOR EIGENVALUES OF EQ. SS(12)
C
C   EVECC(IQ,IQ)      COMPLETE EIGENVECTORS OF SS(7) ON RETURN FROM
C                     *SOLEIG* ; STORED PERMANENTLY IN -GC-
C
C   EXPBEA(LC)        TRANSMISSION OF DIRECT BEAM IN DELTA-M OPTICAL
C                     DEPTH COORDINATES
C
C   FLYR(LC)          TRUNCATED FRACTION IN DELTA-M METHOD
C
C   GL(K,LC)          PHASE FUNCTION LEGENDRE POLY. EXPANSION
C                     COEFFICIENTS, CALCULATED FROM 'PMOM' BY
C                     INCLUDING SINGLE-SCATTERING ALBEDO, FACTOR
C                     2K+1, AND (IF DELTAM=TRUE) THE DELTA-M
C                     SCALING
C
C   GC(IQ,IQ,LC)      EIGENVECTORS AT POLAR QUADRATURE ANGLES,
C                     LITTLE-G  IN EQ. SC(1)
C
C   GU(IU,IQ,LC)      EIGENVECTORS INTERPOLATED TO USER POLAR ANGLES
C                     ( LITTLE-G  IN EQS. SC(3) AND S1(8-9), i.e.
C                     CAPITAL-G WITHOUT THE CAPITAL-L FACTOR )
C
C   HLPR()            LEGENDRE COEFFICIENTS OF BOTTOM BIDIRECTIONAL
C                     REFLECTIVITY (AFTER INCLUSION OF 2K+1 FACTOR)
C
C   IPVT(LC*IQ)       INTEGER VECTOR OF PIVOT INDICES FOR LINPACK
C                     ROUTINES
C
C   KK(IQ,LC)         EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C
C   KCONV             COUNTER IN AZIMUTH CONVERGENCE TEST
C
C   LAYRU(LU)         COMPUTATIONAL LAYER IN WHICH USER OUTPUT LEVEL
C                     -UTAU(LU)- IS LOCATED
C
C   LL(IQ,LC)         CONSTANTS OF INTEGRATION CAPITAL-L IN EQ. SC(1),
C                     OBTAINED BY SOLVING SCALED VERSION OF EQ. SC(5)
C
C   LYRCUT            TRUE, RADIATION IS ASSUMED ZERO BELOW LAYER
C                     -NCUT- BECAUSE OF ALMOST COMPLETE ABSORPTION
C
C   NAZ               NUMBER OF AZIMUTHAL COMPONENTS CONSIDERED
C
C   NCUT              COMPUTATIONAL LAYER NUMBER IN WHICH ABSORPTION
C                     OPTICAL DEPTH FIRST EXCEEDS 10
C
C   OPRIM(LC)         SINGLE SCATTERING ALBEDO AFTER DELTA-M SCALING
C
C   PASS1             TRUE ON FIRST ENTRY, FALSE THEREAFTER
C
C   PKAG(0:LC)        INTEGRATED PLANCK FUNCTION FOR INTERNAL EMISSION
C
C   PSI(IQ)           SUM JUST AFTER SQUARE BRACKET IN  EQ. SD(9)
C
C   RMU(IU,0:IQ)      BOTTOM-BOUNDARY BIDIRECTIONAL REFLECTIVITY FOR A
C                     GIVEN AZIMUTHAL COMPONENT.  FIRST INDEX ALWAYS
C                     REFERS TO A USER ANGLE.  SECOND INDEX:
C                     IF ZERO, REFERS TO INCIDENT BEAM ANGLE -UMU0-;
C                     IF NON-ZERO, REFERS TO A COMPUTATIONAL ANGLE.
C
C   TAUC(0:LC)        CUMULATIVE OPTICAL DEPTH (UN-DELTA-M-SCALED)
C
C   TAUCPR(0:LC)      CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED IF
C                     DELTAM = TRUE, OTHERWISE EQUAL TO -TAUC-)
C
C   TPLANK            INTENSITY EMITTED FROM TOP BOUNDARY
C
C   UUM(IU,LU,MAZ)    COMPONENTS OF THE INTENSITY (U-SUPER-M) WHEN
C                     EXPANDED IN FOURIER COSINE SERIES IN AZIMUTH ANGLE
C
C   U0C(IQ,LU)        AZIMUTHALLY-AVERAGED INTENSITY
C
C   UTAUPR(LU)        OPTICAL DEPTHS OF USER OUTPUT LEVELS IN DELTA-M
C                     COORDINATES;  EQUAL TO  -UTAU(LU)- IF NO DELTA-M
C
C   WK()              SCRATCH ARRAY
C
C   XR0(LC)           X-SUB-ZERO IN EXPANSION OF THERMAL SOURCE FUNC-
C                     TION PRECEDING EQ. SS(14) (HAS NO MU-DEPENDENCE)
C
C   XR1(LC)           X-SUB-ONE IN EXPANSION OF THERMAL SOURCE FUNC-
C                     TION;  SEE  EQS. SS(14-16)
C
C   YLM0(L)           NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                     OF SUBSCRIPT 'L' AT THE BEAM ANGLE (NOT SAVED
C                     AS FUNCTION OF SUPERSCIPT 'M')
C
C   YLMC(L,IQ)        NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                     OF SUBSCRIPT 'L' AT THE COMPUTATIONAL ANGLES
C                     (NOT SAVED AS FUNCTION OF SUPERSCIPT 'M')
C
C   YLMU(L,IU)        NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                     OF SUBSCRIPT 'L' AT THE USER ANGLES
C                     (NOT SAVED AS FUNCTION OF SUPERSCIPT 'M')
C
C   Z()               SCRATCH ARRAY USED IN *SOLVE0,1* TO SOLVE A
C                     LINEAR SYSTEM FOR THE CONSTANTS OF INTEGRATION
C
C   Z0(IQ)            SOLUTION VECTORS Z-SUB-ZERO OF EQ. SS(16)
C
C   Z0U(IU,LC)        Z-SUB-ZERO IN EQ. SS(16) INTERPOLATED TO USER
C                     ANGLES FROM AN EQUATION DERIVED FROM SS(16)
C
C   Z1(IQ)            SOLUTION VECTORS Z-SUB-ONE  OF EQ. SS(16)
C
C   Z1U(IU,LC)        Z-SUB-ONE IN EQ. SS(16) INTERPOLATED TO USER
C                     ANGLES FROM AN EQUATION DERIVED FROM SS(16)
C
C   ZBEAM(IU,LC)      PARTICULAR SOLUTION FOR BEAM SOURCE
C
C   ZJ(IQ)            RIGHT-HAND SIDE VECTOR CAPITAL-X-SUB-ZERO IN
C                     EQ. SS(19), ALSO THE SOLUTION VECTOR CAPITAL
C                     -Z-SUB-ZERO AFTER SOLVING THAT SYSTEM
C
C   ZZ(IQ,LC)         PERMANENT STORAGE FOR THE BEAM SOURCE VECTORS -ZJ-
C
C   ZPLK0(IQ,LC)      PERMANENT STORAGE FOR THE THERMAL SOURCE
C                     VECTORS  -Z0-  OBTAINED BY SOLVING  EQ. SS(16)
C
C   ZPLK1(IQ,LC)      PERMANENT STORAGE FOR THE THERMAL SOURCE
C                     VECTORS  -Z1-  OBTAINED BY SOLVING  EQ. SS(16)
C
C+---------------------------------------------------------------------+
C   LOCAL SYMBOLIC DIMENSIONS:
C
C       MXCLY  = MAX NO. OF COMPUTATIONAL LAYERS
C       MXULV  = MAX NO. OF OUTPUT LEVELS
C       MXCMU  = MAX NO. OF COMPUTATION POLAR ANGLES
C       MXUMU  = MAX NO. OF OUTPUT POLAR ANGLES
C       MXPHI  = MAX NO. OF OUTPUT AZIMUTHAL ANGLES
C+---------------------------------------------------------------------+
c	PARAMETER ( MXCLY = 4, MXULV = 5, MXCMU = 100, MXUMU = 50,
c     $            MXPHI = 40, MI = MXCMU/2, MI9M2 = 9*MI-2,
c     $            NNLYRI = MXCMU*MXCLY )
      PARAMETER ( MXCLY = 50, MXULV = 50, MXCMU = 100, MXUMU = 50,
     $            MXPHI = 40, MI = MXCMU/2, MI9M2 = 9*MI-2,
     $            NNLYRI = MXCMU*MXCLY )
C
      LOGICAL LYRCUT, PASS1
      INTEGER IPVT( NNLYRI ), LAYRU( MXULV )
C	REAL*8 ALBSAV( MXUMU)      
      REAL*8  AMB( MI,MI ), APB( MI,MI ),
     $        ARRAY( MXCMU,MXCMU ), B( NNLYRI ), BDR( MI,0:MI ),
     $        BEM( MI ), CBAND( MI9M2,NNLYRI ), CC( MXCMU,MXCMU ),
     $        CMU( MXCMU ), CWT( MXCMU ), EMU( MXUMU ), EVAL( MI ),
     $        EVECC( MXCMU, MXCMU ), EXPBEA( 0:MXCLY ), FLYR( MXCLY ),
     $        FLDN( MXULV ), FLDIR( MXULV ), GL( 0:MXCMU,MXCLY ),
     $        GC( MXCMU,MXCMU,MXCLY ), GU( MXUMU,MXCMU,MXCLY ),
     $        HLPR( 0:MXCMU ), KK( MXCMU,MXCLY ), LL( MXCMU,MXCLY ),
     $        OPRIM( MXCLY ), PHIRAD( MXPHI ), PKAG( 0:MXCLY ),
     $        PSI( MXCMU ), RMU( MXUMU,0:MI ), TAUC( 0:MXCLY ),
     $        TAUCPR( 0:MXCLY ), U0C( MXCMU,MXULV ), UTAUPR( MXULV ),
     $        UUM( MXUMU,MXULV,0:MXCMU ), WK( MXCMU ), XR0( MXCLY ),
     $        XR1( MXCLY ), YLM0( 0:MXCMU ), YLMC( 0:MXCMU,MXCMU ),
     $        YLMU( 0:MXCMU,MXUMU ), Z( NNLYRI ), Z0( MXCMU ),
     $        Z0U( MXUMU,MXCLY ), Z1( MXCMU ),
     $        Z1U( MXUMU,MXCLY ), ZJ( MXCMU ), ZZ( MXCMU,MXCLY ),
     $        ZPLK0( MXCMU,MXCLY ), ZPLK1( MXCMU,MXCLY ),
     $        ZBEAM( MXUMU,MXCLY )
      REAL*8  AD( MI,MI ), EVALD( MI ) , EVECCD( MI,MI ), WKD( MXCMU )
C
      SAVE  PASS1
      DATA  PASS1 / .TRUE. /
C
C
      IF ( PASS1 )  THEN
         PI = 2.0D0* DASIN(1.d0)
         EPSIL = 10.0D0*2.22D-16		!EPS - CODY(1988)
         RPD = PI / 180.0D0
C                                ** INSERT INPUT VALUES FOR SELF-TEST
C                                ** NOTE: SELF-TEST MUST NOT USE IBCND=1
C
         CALL  SLFTST( ACCUR, ALBEDO, BTEMP, DELTAM, DTAUC( 1 ), FBEAM,
     $                 FISOT, IBCND, LAMBER, NLYR, NOPLNK, NPHI,
     $                 NUMU, NSTR, NTAU, ONLYFL, PHI( 1 ), PHI0, PMOM,
     $                 PRNT, SSALB( 1 ), TEMIS, TEMPER, TTEMP, UMU( 1 ),
     $                 USRANG, USRTAU, UTAU( 1 ), UMU0, WVNMHI, WVNMLO,
     $                 .FALSE., DUM, DUM, DUM, DUM )
      END IF
C
   1  CONTINUE
C      IF ( PRNT(1) )  THEN
C      	WRITE( *,1010 )  HEADER
C      	WRITE( 3,1010 )  HEADER
C      END IF
C
C                         ** ZERO SOME ARRAYS (NOT STRICTLY NECESSARY,
C                         ** BUT OTHERWISE UNUSED PARTS OF ARRAYS
C                         ** COLLECT GARBAGE)
      DO 10 I = 1, NNLYRI
         IPVT(I) = 0
10    CONTINUE
      CALL  ZEROAL( AMB, APB, ARRAY, CC, CMU, CWT, EVAL, EVECC,
     $              GC, GU, HLPR, KK, LL, PSI, WK, XR0, XR1,
     $              YLM0, YLMC, YLMU, Z, Z0, Z1, ZJ, ZZ, ZPLK0,
     $              ZPLK1, Z0U, Z1U, ZBEAM, MI, MXCMU, MXCLY,
     $              NNLYRI, MXUMU, MXULV )
C
C                                  ** CALCULATE CUMULATIVE OPTICAL DEPTH
C                                  ** AND DITHER SINGLE-SCATTER ALBEDO
C                                  ** TO IMPROVE NUMERICAL BEHAVIOR OF
C                                  ** EIGENVALUE/VECTOR COMPUTATION
      TAUC( 0 ) = 0.0D0
      CALL  ZEROIT( TAUC(0), MXCLY+1 )
      DO 20  LC = 1, NLYR
         IF( SSALB(LC).EQ.1.0D0 )  SSALB(LC) = 1.0D0 - EPSIL
         TAUC(LC) = TAUC(LC-1) + DTAUC(LC)
20    CONTINUE
C                                ** CHECK INPUT DIMENSIONS AND VARIABLES
C
      CALL  CHEKIN( NLYR, DTAUC, SSALB, PMOM, TEMPER, WVNMLO,
     $              WVNMHI, USRTAU, NTAU, UTAU, NSTR, USRANG,
     $              NUMU, UMU, NPHI, PHI, IBCND, FBEAM, UMU0,
     $              PHI0, FISOT, LAMBER, ALBEDO, HL, BTEMP,
     $              TTEMP, TEMIS, NOPLNK, ONLYFL, ACCUR, MAXCLY,
     $              MAXULV, MAXUMU, MAXCMU, MAXPHI, MXCLY,
     $              MXULV,  MXUMU,  MXCMU,  MXPHI, TAUC )
C
C                                 ** PERFORM VARIOUS SETUP OPERATIONS
C
      CALL  SETDIS( CMU, CWT, DELTAM, DTAUC, EXPBEA, FBEAM, FLYR,
     $              GL, HL, HLPR, IBCND, LAMBER, LAYRU, LYRCUT, 
     $              MAXUMU, MAXCMU, MXCMU, NCUT, NLYR, NTAU, NN, 
     $              NSTR, NOPLNK, NUMU, ONLYFL, OPRIM, PMOM, SSALB,
     $              TAUC, TAUCPR, UTAU, UTAUPR, UMU, UMU0, USRTAU,
     $              USRANG )
C
C                                             ** PRINT INPUT INFORMATION
      IF ( PRNT(1) )
     $     CALL PRTINP( NLYR, DTAUC, SSALB, PMOM, TEMPER, WVNMLO,
     $                  WVNMHI, NTAU, UTAU, NSTR, NUMU, UMU,
     $                  NPHI, PHI, IBCND, FBEAM, UMU0, PHI0,
     $                  FISOT, LAMBER, ALBEDO, HL, BTEMP, TTEMP,
     $                  TEMIS, DELTAM, NOPLNK, ONLYFL, ACCUR,
     $                  FLYR, LYRCUT, OPRIM, TAUC, TAUCPR,
     $                  MAXCMU, PRNT(7) )
C
C
      IF ( IBCND.EQ.1 )  THEN
C                              ** HANDLE SPECIAL CASE FOR GETTING ALBEDO
C                              ** AND TRANSMISSIVITY OF MEDIUM FOR MANY
C                              ** BEAM ANGLES AT ONCE
C
         CALL  ALBTRN( ALBEDO, AMB, APB, ARRAY, B, BDR, CBAND, CC,
     $                 CMU, CWT, EVAL, EVECC, GL, GC, GU, IPVT,
     $                 KK, LL, NLYR, NN, NSTR, NUMU, PRNT, TAUCPR,
     $                 UMU, U0U, WK, YLMC, YLMU, Z, AD, EVALD,
     $                 EVECCD, WKD, MI, MI9M2, MAXULV, MAXUMU,
     $                 MXCMU, MXUMU, NNLYRI, ALBMED, TRNMED )
         RETURN
      ENDIF
C                                   ** CALCULATE PLANCK FUNCTIONS
      IF ( NOPLNK )  THEN
         BPLANK = 0.0D0
         TPLANK = 0.0D0
         CALL  ZEROIT( PKAG, MXCLY+1 )
      ELSE
         TPLANK = TEMIS * PLKAVG( WVNMLO, WVNMHI, TTEMP )
         BPLANK =         PLKAVG( WVNMLO, WVNMHI, BTEMP )
         DO 40  LEV = 0, NLYR
            PKAG( LEV ) = PLKAVG( WVNMLO, WVNMHI, TEMPER(LEV) )
 40      CONTINUE
      END IF
C
C
C ========  BEGIN LOOP TO SUM AZIMUTHAL COMPONENTS OF INTENSITY  =======
C ========  (EQ STWJ 5)
C
      KCONV = 0
      NAZ = NSTR-1
C                                            ** AZIMUTH-INDEPENDENT CASE
C
      IF ( FBEAM.EQ.0.0D0 .OR. (1.-UMU0).LT.1.0D-5 .OR. ONLYFL .OR.
     $     (NUMU.EQ.1.AND.(1.0D0-UMU(1)).LT.1.0D-5 ) )
     $   NAZ = 0
C
      CALL  ZEROIT( UU, MAXUMU*MAXULV*MAXPHI )
      DO  200  MAZ = 0, NAZ
C
      IF ( MAZ.EQ.0 )  DELM0 = 1.0D0
      IF ( MAZ.GT.0 )  DELM0 = 0.0D0
C                                  ** GET NORMALIZED ASSOCIATED LEGENDRE
C                          ** POLYNOMIALS FOR INCIDENT BEAM ANGLE COSINE
      IF ( FBEAM.GT.0.0D0 ) then
          CALL  LEPOLY( 1, MAZ, MXCMU, NSTR-1, -UMU0, YLM0 )
      endif
           
C
C                                  ** GET NORMALIZED ASSOCIATED LEGENDRE
C                                      ** POLYNOMIALS FOR COMPUTATIONAL
C                                      ** AND USER POLAR ANGLE COSINES
      IF ( .NOT.ONLYFL .AND. USRANG )
     $ CALL  LEPOLY( NUMU, MAZ, MXCMU, NSTR-1, UMU, YLMU )
       CALL  LEPOLY( NN,   MAZ, MXCMU, NSTR-1, CMU, YLMC )
C
C                       ** EVALUATE NORMALIZED ASSOCIATED LEGENDRE
C                       ** POLYNOMIALS WITH NEGATIVE -CMU- FROM THOSE
C                       ** WITH POSITIVE -CMU-; DAVE/ARMSTRONG EQ. (15)
      SGN  = - 1.0D0
      DO  50  L = MAZ, NSTR-1
         SGN = - SGN
         DO  50  IQ = NN+1, NSTR
            YLMC( L,IQ ) = SGN * YLMC( L,IQ-NN )
 50   CONTINUE
C                                 ** SPECIFY USER'S BOTTOM REFLECTIVITY
C                                 ** AND EMISSIVITY PROPERTIES
      IF ( .NOT.LYRCUT ) then
        CALL  SURFAC( ALBEDO, CMU, CWT, DELM0, FBEAM, HLPR, LAMBER,
     $                 MI, MAZ, MXCMU, MXUMU, NN, NUMU, NSTR, ONLYFL,
     $                 UMU, USRANG, YLM0, YLMC, YLMU, BDR, EMU, BEM,
     $                 RMU )
      endif
C
C ===================  BEGIN LOOP ON COMPUTATIONAL LAYERS  =============
C
      DO 100  LC = 1, NCUT
C
C                        ** SOLVE EIGENFUNCTION PROBLEM IN EQ. STWJ(8B);
C                        ** RETURN EIGENVALUES AND EIGENVECTORS
C
         CALL  SOLEIG( AMB, APB, ARRAY, CMU, CWT, GL(0,LC), MI, MAZ,
     $                 MXCMU, NN, NSTR, WK, YLMC, CC, EVECC, EVAL,
     $                 KK(1,LC), GC(1,1,LC), AD, WKD, EVECCD, EVALD )
C
C                                  ** CALCULATE PARTICULAR SOLUTIONS OF
C                                  ** EQ.SS(18) FOR INCIDENT BEAM SOURCE
         IF ( FBEAM.GT.0.0D0 )
     $        CALL  UPBEAM( ARRAY, CC, CMU, DELM0, FBEAM, GL(0,LC),
     $                      IPVT, MAZ, MXCMU, NN, NSTR, PI, UMU0, WK,
     $                      YLM0, YLMC, ZJ, ZZ(1,LC) )
C
         IF ( .NOT.NOPLNK .AND. MAZ.EQ.0 ) THEN
C
C                              ** CALCULATE PARTICULAR SOLUTIONS OF
C                              ** EQ. SS(15) FOR THERMAL EMISSION SOURCE
C
         DELTAT = TAUCPR(LC) - TAUCPR(LC-1)
         XR1(LC) = 0.0D0
         IF(DELTAT .GT. 0.0D0) XR1( LC ) = ( PKAG(LC) - PKAG(LC-1) ) /
     $                  DELTAT
            XR0( LC ) = PKAG(LC-1) - XR1(LC) * TAUCPR(LC-1)
C
            CALL UPISOT( ARRAY, CC, CMU, IPVT, MXCMU, NN, NSTR,
     $                   OPRIM(LC), WK, XR0(LC), XR1(LC), Z0, Z1,
     $                   ZPLK0(1,LC), ZPLK1(1,LC) )
         END IF
C
C
         IF ( .NOT.ONLYFL .AND. USRANG ) THEN
C                                            ** INTERPOLATE EIGENVECTORS
C                                            ** TO USER ANGLES
C
            CALL  TERPEV( CWT, EVECC, GL(0,LC), GU(1,1,LC), MAZ, MXCMU,
     $                    MXUMU, NN, NSTR, NUMU, WK, YLMC, YLMU)
C
C                                            ** INTERPOLATE SOURCE TERMS
C                                            ** TO USER ANGLES
C
            CALL  TERPSO( CWT, DELM0, FBEAM, GL(0,LC), MAZ,
     $                    MXCMU, MXUMU, NOPLNK, NUMU, NSTR, OPRIM(LC),
     $                    PI, YLM0, YLMC, YLMU, PSI, XR0(LC), XR1(LC),
     $                    Z0, ZJ, ZBEAM(1,LC), Z0U(1,LC), Z1U(1,LC) )
         END IF
C
100   CONTINUE
C
C ===================  END LOOP ON COMPUTATIONAL LAYERS  ===============
C
C                      ** SET COEFFICIENT MATRIX OF EQUATIONS COMBINING
C                      ** BOUNDARY AND LAYER INTERFACE CONDITIONS
C
      CALL  SETMTX( BDR, CBAND, CMU, CWT, DELM0, GC, KK, LAMBER,
     $              LYRCUT, MI, MI9M2, MXCMU, NCOL, NCUT, NNLYRI,
     $              NN, NSTR, TAUCPR, WK )
C
C                      ** SOLVE FOR CONSTANTS OF INTEGRATION IN HOMO-
C                      ** GENEOUS SOLUTION (GENERAL BOUNDARY CONDITIONS)
C
      CALL  SOLVE0( B, BDR, BEM, BPLANK, CBAND, CMU, CWT, EXPBEA,
     $              FBEAM, FISOT, IPVT, LAMBER, LL, LYRCUT,
     $              MAZ, MI, MI9M2, MXCMU, NCOL, NCUT, NN, NSTR,
     $              NNLYRI, PI, TPLANK, TAUCPR, UMU0, Z, ZZ,
     $              ZPLK0, ZPLK1 )
C
C                                  ** COMPUTE UPWARD AND DOWNWARD FLUXES
      IF ( MAZ.EQ.0 )
     $     CALL FLUXES( CMU, CWT, FBEAM, GC, KK, LAYRU, LL, LYRCUT,
     $                  MXCMU, MXULV, NCUT, NN, NSTR, NTAU, PI,
     $                  PRNT, SSALB, TAUCPR, UMU0, UTAU, UTAUPR,
     $                  XR0, XR1, ZZ, ZPLK0, ZPLK1, DFDT, FLUP,
     $                  FLDN, FLDIR, RFLDIR, RFLDN, UAVG, U0C,
     $                  MAXULV )
C
      IF ( ONLYFL )  THEN
         IF( MAXUMU.GE.NSTR )  THEN
C                                         ** SAVE AZIM-AVGD INTENSITIES
C                                         ** AT QUADRATURE ANGLES
            DO 120 LU = 1, NTAU
               DO 120 IQ = 1, NSTR
                  U0U( IQ,LU ) = U0C( IQ,LU )
120         CONTINUE
         ELSE
               CALL  ZEROIT( U0U, MAXUMU*MAXULV )
         ENDIF
         GO TO 210
      ENDIF
C
      IF ( USRANG ) THEN
C                                     ** COMPUTE AZIMUTHAL INTENSITY
C                                     ** COMPONENTS AT USER ANGLES
C
         CALL  USRINT( BPLANK, CMU, CWT, DELM0, EMU, EXPBEA,
     $                 FBEAM, FISOT, GC, GU, KK, LAMBER, LAYRU, LL,
     $                 LYRCUT, MAZ, MXCMU, MXULV, MXUMU, NCUT,
     $                 NLYR, NN, NSTR, NOPLNK, NUMU, NTAU, PI, RMU,
     $                 TAUCPR, TPLANK, UMU, UMU0, UTAUPR, WK,
     $                 ZBEAM, Z0U, Z1U, ZZ, ZPLK0, ZPLK1, UUM )
C
      ELSE
C                                     ** COMPUTE AZIMUTHAL INTENSITY
C                                     ** COMPONENTS AT QUADRATURE ANGLES
C
         CALL  CMPINT( FBEAM, GC, KK, LAYRU, LL, LYRCUT, MAZ,
     $                 MXCMU, MXULV, MXUMU, NCUT, NN, NSTR,
     $                 NOPLNK, NTAU, TAUCPR, UMU0, UTAUPR,
     $                 ZZ, ZPLK0, ZPLK1, UUM )
      END IF
C
      IF( MAZ.EQ.0 ) THEN
C
         DO  140  J = 1, NPHI
            PHIRAD( J ) = RPD * ( PHI(J) - PHI0 )
 140     CONTINUE
C                               ** SAVE AZIMUTHALLY AVERAGED INTENSITIES
         DO 160  LU = 1, NTAU
            DO 160  IU = 1, NUMU
               U0U( IU,LU ) = UUM( IU,LU,0 )
 160     CONTINUE
C                              ** PRINT AZIMUTHALLY AVERAGED INTENSITIES
C                              ** AT USER ANGLES
         IF ( PRNT(4) )
     $        CALL PRAVIN( UMU, NUMU, MAXUMU, UTAU, NTAU, U0U )
C
      END IF
C                                ** INCREMENT INTENSITY BY CURRENT
C                                ** AZIMUTHAL COMPONENT (FOURIER
C                                ** COSINE SERIES);  EQ SD(2)
      AZERR = 0.0D0
      DO 180  J = 1, NPHI
         COSPHI = DCOS( MAZ * PHIRAD(J) )
         DO 180  LU = 1, NTAU
            DO 180  IU = 1, NUMU
               AZTERM = UUM( IU,LU,MAZ ) * COSPHI
               UU( IU,LU,J ) = UU( IU,LU,J ) + AZTERM
               AZERR = DMAX1( RATIO( DABS(AZTERM), DABS(UU(IU,LU,J)) ),
     $                        AZERR )
180   CONTINUE
      IF ( AZERR.LE.ACCUR )  KCONV = KCONV + 1
      IF ( KCONV.GE.2 )      GOTO 210
C
200   CONTINUE
C
C ===================  END LOOP ON AZIMUTHAL COMPONENTS  ===============
C
C
C                                                 ** PRINT INTENSITIES
C
 210  IF ( PRNT(5) .AND. .NOT.ONLYFL )
     $     CALL  PRTINT( UU, UTAU, NTAU, UMU, NUMU, PHI, NPHI,
     $                   MAXULV, MAXUMU )
C
C
      IF ( PASS1 )  THEN
C                                      ** COMPARE TEST CASE RESULTS WITH
C                                    ** CORRECT ANSWERS AND ABORT IF BAD
C
         CALL SLFTST( ACCUR, ALBEDO, BTEMP, DELTAM, DTAUC( 1 ), FBEAM,
     $                FISOT, IBCND, LAMBER, NLYR, NOPLNK, NPHI,
     $                NUMU, NSTR, NTAU, ONLYFL, PHI( 1 ), PHI0, PMOM,
     $                PRNT, SSALB( 1 ), TEMIS, TEMPER, TTEMP, UMU( 1 ),
     $                USRANG, USRTAU, UTAU( 1 ), UMU0, WVNMHI, WVNMLO,
     $                .TRUE., FLUP( 1 ), RFLDIR( 1 ), RFLDN( 1 ),
     $                UU( 1,1,1 ) )
C
         PASS1 = .FALSE.
         GO TO 1
      END IF
C
      RETURN
C
c1010  FORMAT ( /, 1X, 79('*'), /, 2X,
c     $  'DISCRETE ORDINATES RADIATIVE TRANSFER PROGRAM, VERSION 1.0',
c     $  /, 1X, A, /, 1X, 79('*') )
      END
C**********************************************************************      
      SUBROUTINE  ALBTRN( ALBEDO, AMB, APB, ARRAY, B, BDR, CBAND, CC,
     $                    CMU, CWT, EVAL, EVECC, GL, GC, GU, IPVT,
     $                    KK, LL, NLYR, NN, NSTR, NUMU, PRNT, TAUCPR,
     $                    UMU, U0U, WK, YLMC, YLMU, Z, AD, EVALD,
     $                    EVECCD, WKD, MI, MI9M2, MAXULV, MAXUMU,
     $                    MXCMU, MXUMU, NNLYRI, ALBMED, TRNMED )
C
C        SPECIAL CASE TO GET ONLY ALBEDO AND TRANSMISSIVITY
C        OF ENTIRE MEDIUM AS A FUNCTION OF INCIDENT BEAM ANGLE
C        (MANY SIMPLIFICATIONS BECAUSE BOUNDARY CONDITION IS JUST
C        ISOTROPIC ILLUMINATION, THERE ARE NO THERMAL SOURCES, AND
C        PARTICULAR SOLUTIONS DO NOT NEED TO BE COMPUTED).  SEE
C        REF. S2 AND REFERENCES THEREIN FOR THEORY.
C
C        ROUTINES CALLED:  ALTRIN, LEPOLY, PRALTR, SETMTX, SOLVE1,
C                          SOLEIG, ZEROIT
C
	IMPLICIT REAL*8 (A-H, O-Z)

      LOGICAL  PRNT(*)
      INTEGER  NLYR, NUMU, NSTR
      REAL*8  UMU(*), U0U( MAXUMU,* )
C
      INTEGER IPVT(*)
      REAL*8  ALBMED(*), AMB( MI,* ), APB( MI,*),ARRAY( MXCMU,* ),
     $        B(*), BDR( MI,0:* ), CBAND( MI9M2,* ), CC( MXCMU,* ),
     $        CMU(*), CWT(*), EVAL(*), EVECC( MXCMU,* ),
     $        GL( 0:MXCMU,* ), GC( MXCMU,MXCMU,* ), GU( MXUMU,MXCMU,* ),
     $        KK( MXCMU,* ), LL( MXCMU,* ), TAUCPR( 0:* ), TRNMED(*),
     $        WK(*), YLMC( 0:MXCMU,* ), YLMU( 0:MXCMU,* ), Z(*)
      REAL*8  AD( MI,* ), EVALD(*) , EVECCD( MI,* ), WKD(*)
C
      LOGICAL  LAMBER, LYRCUT
C
C
C                    ** SET DISORT VARIABLES THAT ARE IGNORED IN THIS
C                    ** SPECIAL CASE BUT ARE NEEDED BELOW IN ARGUMENT
C                    ** LISTS OF SUBROUTINES SHARED WITH GENERAL CASE
      NCUT = NLYR
      LYRCUT = .false.
      FISOT = 1.0D0
      LAMBER = .TRUE.
C
      MAZ = 0
      DELM0 = 1.0D0
C                          ** GET LEGENDRE POLYNOMIALS FOR COMPUTATIONAL
C                          ** AND USER POLAR ANGLE COSINES
C
      CALL  LEPOLY( NUMU, MAZ, MXCMU, NSTR-1, UMU, YLMU )
      CALL  LEPOLY( NN,   MAZ, MXCMU, NSTR-1, CMU, YLMC )
C
C                       ** EVALUATE LEGENDRE POLYNOMIALS WITH NEGATIVE
C                       ** -CMU- FROM THOSE WITH POSITIVE -CMU-;
C                       ** DAVE/ARMSTRONG EQ. (15)
      SGN  = -1.0D0
      DO  5  L = MAZ, NSTR-1
         SGN = - SGN
         DO  5  IQ = NN+1, NSTR
            YLMC( L,IQ ) = SGN * YLMC( L,IQ-NN )
    5 CONTINUE
C                                  ** ZERO BOTTOM REFLECTIVITY
C                                  ** (-ALBEDO- IS USED ONLY IN ANALYTIC
C                                  ** FORMULAE INVOLVING ALBEDO = 0
C                                  ** SOLUTIONS; EQS 16-17 OF REF S2)
      CALL  ZEROIT( BDR, MI*(MI+1) )
C
C
C ===================  BEGIN LOOP ON COMPUTATIONAL LAYERS  =============
C
      DO 100  LC = 1, NLYR
C
C                        ** SOLVE EIGENFUNCTION PROBLEM IN EQ. STWJ(8B)
C
         CALL  SOLEIG( AMB, APB, ARRAY, CMU, CWT, GL(0,LC), MI, MAZ,
     $                 MXCMU, NN, NSTR, WK, YLMC, CC, EVECC, EVAL,
     $                 KK(1,LC), GC(1,1,LC), AD, WKD, EVECCD, EVALD)
C
C                          ** INTERPOLATE EIGENVECTORS TO USER ANGLES
C
         CALL  TERPEV( CWT, EVECC, GL(0,LC), GU(1,1,LC), MAZ, MXCMU,
     $                 MXUMU, NN, NSTR, NUMU, WK, YLMC, YLMU )
100   CONTINUE
C
C ===================  END LOOP ON COMPUTATIONAL LAYERS  ===============
C
C                      ** SET COEFFICIENT MATRIX OF EQUATIONS COMBINING
C                      ** BOUNDARY AND LAYER INTERFACE CONDITIONS
C
      CALL  SETMTX( BDR, CBAND, CMU, CWT, DELM0, GC, KK, LAMBER,
     $              LYRCUT, MI, MI9M2, MXCMU, NCOL, NCUT, NNLYRI,
     $              NN, NSTR, TAUCPR, WK )
C
      CALL  ZEROIT( U0U, MAXUMU*MAXULV )
C
      NHOM = 2
      IF( NLYR.EQ.1 )  NHOM = 1
      SPHALB = 0.0D0
      SPHTRN = 0.0D0
      DO 200  IHOM = 1, NHOM
C                             ** SOLVE FOR CONSTANTS OF INTEGRATION IN
C                             ** HOMOGENEOUS SOLUTION FOR ILLUMINATION
C                             ** FROM TOP (IHOM=1), THEN BOTTOM (IHOM=2)
C
         CALL  SOLVE1( B, CBAND, FISOT, IHOM, IPVT, LL, MI9M2, MXCMU,
     $                 NCOL, NLYR, NN, NNLYRI, NSTR, Z )
C
C                             ** COMPUTE AZIMUTHALLY-AVERAGED INTENSITY
C                             ** AT USER ANGLES; GIVES ALBEDO IF MULTI-
C                             ** LAYER (EQ. 9 OF REF S2); GIVES BOTH
C                             ** ALBEDO AND TRANSMISSIVITY IF SINGLE
C                             ** LAYER (EQS. 3-4 OF REF S2)
C
         CALL  ALTRIN( GU, KK, LL, MXCMU, MXUMU, MAXUMU, NLYR,
     $                 NN, NSTR, NUMU, TAUCPR, UMU, U0U, WK )
C
         IF ( IHOM.EQ.1 )  THEN
C                                   ** SAVE ALBEDOS;  FLIP TRANSMISSIV.
C                                   ** END OVER END TO CORRESPOND TO
C                                   ** POSITIVE -UMU- INST. OF NEGATIVE
            DO 120  IU = 1, NUMU/2
               ALBMED(IU) = U0U( IU + NUMU/2, 1 )
               IF( NLYR.EQ.1 )  TRNMED(IU) = U0U( NUMU/2+1-IU, 2 )
     $                       + DEXP( - TAUCPR(NLYR) / UMU(IU+NUMU/2) )
120         CONTINUE
C                                    ** GET SPHERICAL ALBEDO AND, FOR 1
C                                    ** LAYER, SPHERICAL TRANSMISSIVITY
            IF( ALBEDO.GT.0.0D0 )
     $          CALL SPALTR( CMU, CWT, GC, KK, LL, MXCMU, NLYR,
     $                       NN, NSTR, TAUCPR, SPHALB, SPHTRN )
C
         ELSE IF ( IHOM.EQ.2 )  THEN
C                                      ** SAVE TRANSMISSIVITIES
            DO 140  IU = 1, NUMU/2
               TRNMED(IU) = U0U( IU + NUMU/2, 1 )
     $                      + DEXP( - TAUCPR(NLYR) / UMU(IU+NUMU/2) )
140         CONTINUE
C                                     ** GET SPHERICAL TRANSMISSIVITY
            IF( ALBEDO.GE.0.0D0 )
     $          CALL SPALTR( CMU, CWT, GC, KK, LL, MXCMU, NLYR,
     $                       NN, NSTR, TAUCPR, SPHTRN, DUMMY )
         END IF
200   CONTINUE
C
      IF ( ALBEDO.GT.0.0D0 )  THEN
C                                ** REF. S2, EQS. 16-17 (THESE EQS. HAVE
C                                ** A SIMPLE PHYSICAL INTERPRETATION
C                                ** LIKE THAT OF THE DOUBLING EQS.)
         DO 220  IU = 1, NUMU
            ALBMED(IU) = ALBMED(IU) + ( ALBEDO / (1.-ALBEDO*SPHALB) )
     $                                * SPHTRN * TRNMED(IU)
            TRNMED(IU) = TRNMED(IU) + ( ALBEDO / (1.-ALBEDO*SPHALB) )
     $                                * SPHALB * TRNMED(IU)
220      CONTINUE
      END IF
C                          ** RETURN -UMU- TO ALL POSITIVE VALUES, TO
C                          ** AGREE WITH ORDERING IN -ALBMED,TRNMED-
      NUMU = NUMU / 2
      DO 230  IU = 1, NUMU
        UMU(IU) = UMU(IU+NUMU)
 230  CONTINUE
C
      IF ( PRNT(6) )  CALL  PRALTR( UMU, NUMU, ALBMED, TRNMED )
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  ALTRIN( GU, KK, LL, MXCMU, MXUMU, MAXUMU, NLYR,
     $                    NN, NSTR, NUMU, TAUCPR, UMU, U0U, WK )
C
C       COMPUTES AZIMUTHALLY-AVERAGED INTENSITY AT TOP AND BOTTOM
C       OF MEDIUM (RELATED TO ALBEDO AND TRANSMISSION OF MEDIUM BY
C       RECIPROCITY PRINCIPLES;  SEE REF S2).  USER POLAR ANGLES ARE
C       USED AS INCIDENT BEAM ANGLES. (THIS IS A VERY SPECIALIZED
C       VERSION OF 'USRINT')
C
C       ** NOTE **  USER INPUT VALUES OF -UMU- (ASSUMED POSITIVE) ARE
C                   TEMPORARILY IN UPPER LOCATIONS OF  -UMU-  AND
C                   CORRESPONDING NEGATIVES ARE IN LOWER LOCATIONS
C                   (THIS MAKES -GU- COME OUT RIGHT).  I.E. THE CONTENTS
C                   OF THE TEMPORARY -UMU- ARRAY ARE:
C
C                     -UMU(NUMU),..., -UMU(1), UMU(1),..., UMU(NUMU)
C
C   I N P U T    V A R I A B L E S:
C
C       GU     :  EIGENVECTORS INTERPOLATED TO USER POLAR ANGLES
C                 (i.e., g IN EQ. SC(1) )
C       KK     :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       LL     :  CONSTANTS OF INTEGRATION IN EQ. SC(1), OBTAINED
C                 BY SOLVING SCALED VERSION OF EQ. SC(5);
C                 EXPONENTIAL TERM OF EQ. SC(12) NOT INCLUDED
C       NN     :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       TAUCPR :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T    V A R I A B L E:
C
C       U0U  :    DIFFUSE AZIMUTHALLY-AVERAGED INTENSITY AT TOP AND
C                 BOTTOM OF MEDIUM (DIRECTLY TRANSMITTED COMPONENT,
C                 CORRESPONDING TO -BNDINT- IN 'USRINT', IS OMITTED).
C
C   I N T E R N A L    V A R I A B L E S:
C
C       DTAU   :  OPTICAL DEPTH OF A COMPUTATIONAL LAYER
C       PALINT :  NON-BOUNDARY-FORCED INTENSITY COMPONENT
C       UTAUPR :  OPTICAL DEPTHS OF USER OUTPUT LEVELS (DELTA-M SCALED)
C       WK     :  SCRATCH VECTOR FOR SAVING 'EXP' EVALUATIONS
C       ALL THE EXPONENTIAL FACTORS (i.e., EXP1, EXPN,... etc.)
C       COME FROM THE SUBSTITUTION OF CONSTANTS OF INTEGRATION IN
C       EQ. SC(12) INTO EQS. S1(8-9).  ALL HAVE NEGATIVE ARGUMENTS.
C+---------------------------------------------------------------------+
C
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8  UTAUPR( 2 )
      REAL*8 GU( MXUMU,MXCMU,* ), KK( MXCMU,* ), LL( MXCMU,* ), MU,
     $       TAUCPR( 0:* ), UMU(*), U0U( MAXUMU,* ), WK(*)
C
C
      UTAUPR(1) = 0.0D0
      UTAUPR(2) = TAUCPR( NLYR )
      DO 100  LU = 1, 2
         IF ( LU.EQ.1 )  THEN
            IUMIN = NUMU / 2 + 1
            IUMAX = NUMU
            SGN = 1.0D0
         ELSE
            IUMIN = 1
            IUMAX = NUMU / 2
            SGN = - 1.0D0
         END IF
C                                   ** LOOP OVER POLAR ANGLES AT WHICH
C                                   ** ALBEDOS/TRANSMISSIVITIES DESIRED
C                                   ** ( UPWARD ANGLES AT TOP BOUNDARY,
C                                   ** DOWNWARD ANGLES AT BOTTOM )
         DO 50  IU = IUMIN, IUMAX
            MU = UMU(IU)
C                                     ** INTEGRATE FROM TOP TO BOTTOM
C                                     ** COMPUTATIONAL LAYER
            PALINT = 0.0D0
            DO 30  LC = 1, NLYR
C
               DTAU = TAUCPR(LC) - TAUCPR(LC-1)
               EXP1 =  DEXP( (UTAUPR(LU) - TAUCPR(LC-1)) / MU )
               EXP2 =  DEXP( (UTAUPR(LU) - TAUCPR( LC )) / MU )
C
C                                      ** -KK- IS NEGATIVE
               DO 20  IQ = 1, NN
                  WK(IQ) = DEXP( KK(IQ,LC) * DTAU )
                  DENOM = 1.0D0 + MU * KK(IQ,LC)
                  IF ( DABS(DENOM).LT.0.0001D0 ) THEN
C                                                   ** L'HOSPITAL LIMIT
                     EXPN = DTAU / MU * EXP2
                  ELSE
                     EXPN = ( EXP1 * WK(IQ) - EXP2 ) * SGN / DENOM
                  END IF
                  PALINT = PALINT + GU(IU,IQ,LC) * LL(IQ,LC) * EXPN
20             CONTINUE
C                                      ** -KK- IS POSITIVE
               DO 21  IQ = NN+1, NSTR
                  DENOM = 1.0D0 + MU * KK(IQ,LC)
                  IF ( DABS(DENOM).LT.0.0001D0 ) THEN
                     EXPN = - DTAU / MU * EXP1
                  ELSE
                     EXPN = ( EXP1 - EXP2 * WK(NSTR+1-IQ) ) *SGN / DENOM
                  END IF
                  PALINT = PALINT + GU(IU,IQ,LC) * LL(IQ,LC) * EXPN
21             CONTINUE
C
30          CONTINUE
C
            U0U( IU, LU ) = PALINT
C
 50      CONTINUE
100   CONTINUE
C
      RETURN
      END
C**********************************************************************      
      SUBROUTINE  ASYMTX( A, EVEC, EVAL, M, IA, IEVEC, IER, WK,
     $                    AD, EVECD, EVALD, WKD )
C
C    =======  D O U B L E    P R E C I S I O N    V E R S I O N  ======
C
C       SOLVES EIGENFUNCTION PROBLEM FOR REAL ASYMMETRIC MATRIX
C       FOR WHICH IT IS KNOWN A PRIORI THAT THE EIGENVALUES ARE REAL.
C
C       THIS IS AN ADAPTATION OF A SUBROUTINE 'EIGRF' IN THE IMSL
C       LIBRARY.  THE CHANGES CONSISTED IN USING REAL INSTEAD OF
C       COMPLEX ARITHMETIC TO ACCOUNT FOR THE KNOWN FACT
C       THAT THE EIGENVALUES AND EIGENVECTORS ARE REAL, IN
C       PUTTING ALL THE CALLED SUBROUTINES IN-LINE, IN DELETING
C       THE PERFORMANCE INDEX CALCULATION, AND IN UPDATING THE DO-LOOPS
C       TO FORTRAN77.
C
C       'EIGRF' IS BASED PRIMARILY ON 'EISPACK' ROUTINES.  THE MATRIX
C       IS FIRST BALANCED USING THE PARLETT-REINSCH ALGORITHM.  THEN
C       THE MARTIN-WILKINSON ALGORITHM IS APPLIED.
C
C       REFERENCES:
C          DONGARRA, J. AND C. MOLER, EISPACK -- A PACKAGE FOR SOLVING
C             MATRIX EIGENVALUE PROBLEMS, IN COWELL, ED., 1984:
C             SOURCES AND DEVELOPMENT OF MATHEMATICAL SOFTWARE,
C             PRENTICE-HALL, ENGLEWOOD CLIFFS, NJ
C         PARLETT AND REINSCH, 1969: BALANCING A MATRIX FOR CALCULATION
C             OF EIGENVALUES AND EIGENVECTORS, NUM. MATH. 13, 293-304
C         WILKINSON, J., 1965: THE ALGEBRAIC EIGENVALUE PROBLEM,
C             CLARENDON PRESS, OXFORD
C
C   I N P U T    V A R I A B L E S:
C
C        A    :  INPUT ASYMMETRIC MATRIX, DESTROYED AFTER SOLVED
C        M    :  ORDER OF -A-
C       IA    :  FIRST DIMENSION OF -A-
C    IEVEC    :  FIRST DIMENSION OF -EVEC-
C
C   O U T P U T    V A R I A B L E S:
C
C       EVEC  :  (UNNORMALIZED) EIGENVECTORS OF -A-
C                   ( COLUMN J CORRESPONDS TO EVAL(J) )
C
C       EVAL  :  (UNORDERED) EIGENVALUES OF -A- ( DIMENSION AT LEAST M )
C
C       IER   :  IF .NE. 0, SIGNALS THAT EVAL(J) FAILED TO CONVERGE,
C                   WHERE  J = IER-128;  IN THAT CASE EIGENVALUES
C                   J+1, J+2, ..., M  ARE CORRECT BUT EIGENVALUES
C                   1, ..., J ARE SET TO ZERO.
C
C   S C R A T C H   V A R I A B L E S:
C
C       WK    :  WORK AREA ( DIMENSION AT LEAST 2*M )
C       AD    :  REAL*8 STAND-IN FOR -A-
C       EVECD :  REAL*8 STAND-IN FOR -EVEC-
C       EVALD :  REAL*8 STAND-IN FOR -EVAL-
C       WKD   :  REAL*8 STAND-IN FOR -WK-
C+---------------------------------------------------------------------+
C
      IMPLICIT REAL*8 ( A-H, O-Z )
      REAL*8  A( IA,* ),  WK(*),  EVAL(*), EVEC( IEVEC,* )
      REAL*8  AD( IA,* ), WKD(*), EVALD(*), EVECD( IA,* )
      LOGICAL           NOCONV, NOTLAS
      DATA     C1 / 0.4375D0 /, C2/ 0.5D0 /, C3/ 0.75D0 /, C4/ 0.95D0 /,
     $         C5/ 16.D0 /, C6/ 256.D0 /, RDELP/ 2.775557562D-17 /
C
C
      IF ( M.LT.1 .OR. IA.LT.M .OR. IEVEC.LT.M )
     $     CALL ERRMSG( 'ASYMTX--BAD INPUT VARIABLE(S)', .TRUE. )
C
      IF ( M.EQ.1 )  THEN
         EVAL(1) = A(1,1)
         EVEC(1,1) = 1.0D0
         RETURN
      ELSE IF ( M.EQ.2 )  THEN
         DISCRI = ( A(1,1) - A(2,2) )**2 + 4.0D0 * A(1,2) * A(2,1)
         IF ( DISCRI.LT.0.0D0 )
     $        CALL ERRMSG( 'ASYMTX--COMPLEX EVALS IN 2X2 CASE', .TRUE. )
         SGN = 1.0D0
         IF ( A(1,1).LT.A(2,2) )  SGN = - 1.0D0
         EVAL(1) = 0.5D0 * ( A(1,1) + A(2,2) + SGN*DSQRT(DISCRI) )
         EVAL(2) = 0.5D0 * ( A(1,1) + A(2,2) - SGN*DSQRT(DISCRI) )
         EVEC(1,1) = 1.0D0
         EVEC(2,2) = 1.0D0
         IF ( A(1,1).EQ.A(2,2) .AND. (A(2,1).EQ.0.D0.OR.
     $	    A(1,2).EQ.0.D0) ) THEN
            RNORM = DABS(A(1,1))+ DABS(A(1,2)) + DABS(A(2,1)) + 
     $      DABS(A(2,2))
            W = RDELP * RNORM
            EVEC(2,1) = A(2,1) / W
            EVEC(1,2) = - A(1,2) / W
         ELSE
            EVEC(2,1) = A(2,1) / ( EVAL(1) - A(2,2) )
            EVEC(1,2) = A(1,2) / ( EVAL(2) - A(1,1) )
         ENDIF
         RETURN
      END IF
C                               ** PUT MATRIX A INTO MATRIX AD
      DO 1  J = 1, M
         DO 1  K = 1, M
            AD( J,K ) =  A(J,K) 
    1 CONTINUE
C                                        ** INITIALIZE OUTPUT VARIABLES
      IER   = 0
      DO 20 I = 1, M
         EVALD(I) = 0.D0
         DO 10 J = 1, M
            EVECD(I,J) = 0.D0
10       CONTINUE
         EVECD(I,I) = 1.D0
20    CONTINUE
C                  ** BALANCE THE INPUT MATRIX AND REDUCE ITS NORM BY
C                  ** DIAGONAL SIMILARITY TRANSFORMATION STORED IN WK;
C                  ** THEN SEARCH FOR ROWS ISOLATING AN EIGENVALUE
C                  ** AND PUSH THEM DOWN
      RNORM = 0.D0
      L  = 1
      K  = M
C
30    KKK = K
         DO 70  J = KKK, 1, -1
            ROW = 0.D0
            DO 40 I = 1, K
               IF ( I.NE.J ) ROW = ROW + DABS( AD(J,I) )
40          CONTINUE
            IF ( ROW.EQ.0.D0 ) THEN
               WKD(K) = J
               IF ( J.NE.K ) THEN
                  DO 50 I = 1, K
                     REPL   = AD(I,J)
                     AD(I,J) = AD(I,K)
                     AD(I,K) = REPL
50                CONTINUE
                  DO 60 I = L, M
                     REPL   = AD(J,I)
                     AD(J,I) = AD(K,I)
                     AD(K,I) = REPL
60                CONTINUE
               END IF
               K = K - 1
               GO TO 30
            END IF
70       CONTINUE
C                                     ** SEARCH FOR COLUMNS ISOLATING AN
C                                       ** EIGENVALUE AND PUSH THEM LEFT
80    LLL = L
         DO 120 J = LLL, K
            COL = 0.D0
            DO 90 I = L, K
               IF ( I.NE.J ) COL = COL + DABS( AD(I,J) )
90          CONTINUE
            IF ( COL.EQ.0.D0 ) THEN
               WKD(L) = J
               IF ( J.NE.L ) THEN
                  DO 100 I = 1, K
                     REPL   = AD(I,J)
                     AD(I,J) = AD(I,L)
                     AD(I,L) = REPL
100               CONTINUE
                  DO 110 I = L, M
                     REPL   = AD(J,I)
                     AD(J,I) = AD(L,I)
                     AD(L,I) = REPL
110               CONTINUE
               END IF
               L = L + 1
               GO TO 80
            END IF
120      CONTINUE
C                           ** BALANCE THE SUBMATRIX IN ROWS L THROUGH K
      DO 130 I = L, K
         WKD(I) = 1.D0
130   CONTINUE
C
140   NOCONV = .FALSE.
         DO 200 I = L, K
            COL = 0.D0
            ROW = 0.D0
            DO 150 J = L, K
               IF ( J.NE.I ) THEN
                  COL = COL + DABS( AD(J,I) )
                  ROW = ROW + DABS( AD(I,J) )
               END IF
150         CONTINUE
            F = 1.D0
            G = ROW / C5
            H = COL + ROW
160         IF ( COL.LT.G ) THEN
               F   = F * C5
               COL = COL * C6
               GO TO 160
            END IF
            G = ROW * C5
170         IF ( COL.GE.G ) THEN
               F   = F / C5
               COL = COL / C6
               GO TO 170
            END IF
C                                                         ** NOW BALANCE
            IF ( (COL+ROW) / F.LT.C4 * H ) THEN
               WKD(I)  = WKD(I) * F
               NOCONV = .TRUE.
               DO 180 J = L, M
                  AD(I,J) = AD(I,J) / F
180            CONTINUE
               DO 190 J = 1, K
                  AD(J,I) = AD(J,I) * F
190            CONTINUE
            END IF
200      CONTINUE
C
      IF ( NOCONV ) GO TO 140
C                                  ** IS -A- ALREADY IN HESSENBERG FORM?
      IF ( K-1.LT.L+1 ) GO TO 350
C                                   ** TRANSFER -A- TO A HESSENBERG FORM
      DO 290 N = L+1, K-1
         H       = 0.D0
         WKD(N+M) = 0.D0
         SCALE   = 0.D0
C                                                        ** SCALE COLUMN
         DO 210 I = N, K
            SCALE = SCALE + DABS(AD(I,N-1))
210      CONTINUE
         IF ( SCALE.NE.0.D0 ) THEN
            DO 220 I = K, N, -1
               WKD(I+M) = AD(I,N-1) / SCALE
               H = H + WKD(I+M) * WKD(I+M)
220         CONTINUE
            G = -DSIGN( DSQRT(H),WKD(N+M) )
            H = H - WKD(N+M) * G
            WKD(N+M) = WKD(N+M) - G
C                                                 ** FORM (I-(U*UT)/H)*A
            DO 250 J = N, M
               F = 0.D0
               DO 230  I = K, N, -1
                  F = F + WKD(I+M) * AD(I,J)
230            CONTINUE
               DO 240 I = N, K
                  AD(I,J) = AD(I,J) - WKD(I+M) * F / H
240            CONTINUE
250         CONTINUE
C                                    ** FORM (I-(U*UT)/H)*A*(I-(U*UT)/H)
            DO 280 I = 1, K
               F = 0.D0
               DO 260  J = K, N, -1
                  F = F + WKD(J+M) * AD(I,J)
260            CONTINUE
               DO 270 J = N, K
                  AD(I,J) = AD(I,J) - WKD(J+M) * F / H
270            CONTINUE
280         CONTINUE
            WKD(N+M)  = SCALE * WKD(N+M)
            AD(N,N-1) = SCALE * G
         END IF
290   CONTINUE
C
      DO 340  N = K-2, L, -1
         N1 = N + 1
         N2 = N + 2
         F  = AD(N+1,N)
         IF ( F.NE.0.D0 ) THEN
            F  = F * WKD(N+1+M)
            DO 300 I = N+2, K
               WKD(I+M) = AD(I,N)
300         CONTINUE
            IF ( N+1.LE.K ) THEN
               DO 330 J = 1, M
                  G = 0.D0
                  DO 310 I = N+1, K
                     G = G + WKD(I+M) * EVECD(I,J)
310               CONTINUE
                  G = G / F
                  DO 320 I = N+1, K
                     EVECD(I,J) = EVECD(I,J) + G * WKD(I+M)
320               CONTINUE
330            CONTINUE
            END IF
         END IF
340   CONTINUE
C
350   CONTINUE
      N = 1
      DO 370 I = 1, M
         DO 360 J = N, M
            RNORM = RNORM + DABS(AD(I,J))
360      CONTINUE
         N = I
         IF ( I.LT.L .OR. I.GT.K ) EVALD(I) = AD(I,I)
370   CONTINUE
      N = K
      T = 0.D0
C                                         ** SEARCH FOR NEXT EIGENVALUES
380   IF ( N.LT.L ) GO TO 530
      IN = 0
      N1 = N - 1
      N2 = N - 2
C                          ** LOOK FOR SINGLE SMALL SUB-DIAGONAL ELEMENT
390   CONTINUE
      DO 400  LB = N, L+1, -1
         S = DABS( AD(LB-1,LB-1)) + DABS(AD(LB,LB) )
         IF ( S.EQ.0.D0 ) S = RNORM
         IF ( DABS(AD(LB,LB-1)) .LE. RDELP * S ) GO TO 410
400   CONTINUE
      LB = L
C                                                      ** ONE EVAL FOUND
410   X = AD(N,N)
      IF ( LB.EQ.N  ) THEN
         AD(N,N)  = X + T
         EVALD(N) = AD(N,N)
         N = N1
         GO TO 380
      END IF
C                                                     ** TWO EVALS FOUND
      Y = AD(N1,N1)
      W = AD(N,N1) * AD(N1,N)
      IF ( LB.EQ.N1 ) THEN
         P = (Y-X) * C2
         Q = P * P + W
         Z = DSQRT(ABS(Q))
         AD(N,N) = X + T
         X = AD(N,N)
         AD(N1,N1) = Y + T
C                                                           ** REAL PAIR
         Z = P + DSIGN(Z,P)
         EVALD(N1) = X + Z
         EVALD(N)  = EVALD(N1)
         IF ( Z.NE.0.D0 ) EVALD(N) = X - W / Z
         X = AD(N,N1)
C                                  ** EMPLOY SCALE FACTOR IN CASE
C                                  ** X AND Z ARE VERY SMALL
         R = DSQRT(X * X + Z * Z)
         P = X / R
         Q = Z / R
C                                                    ** ROW MODIFICATION
         DO 420 J = N1, M
            Z = AD(N1,J)
            AD(N1,J) = Q * Z + P * AD(N,J)
            AD(N,J)  = Q * AD(N,J) - P * Z
420      CONTINUE
C                                                 ** COLUMN MODIFICATION
         DO 430 I = 1, N
            Z = AD(I,N1)
            AD(I,N1) = Q * Z + P * AD(I,N)
            AD(I,N)  = Q * AD(I,N) - P * Z
430      CONTINUE
C                                          ** ACCUMULATE TRANSFORMATIONS
         DO 440 I = L, K
            Z = EVECD(I,N1)
            EVECD(I,N1) = Q * Z + P * EVECD(I,N)
            EVECD(I,N)  = Q * EVECD(I,N) - P * Z
440      CONTINUE
         N = N2
         GO TO 380
      END IF
C                    ** NO CONVERGENCE AFTER 30 ITERATIONS; SET ERROR
C                    ** INDICATOR TO THE INDEX OF THE CURRENT EIGENVALUE
C
      IF ( IN.EQ.30 ) THEN
         IER = 128 + N
         GO TO 670
      END IF
C                                                          ** FORM SHIFT
      IF ( IN.EQ.10 .OR. IN.EQ.20 ) THEN
         T = T + X
         DO 450 I = L, N
            AD(I,I) = AD(I,I) - X
450      CONTINUE
         S = DABS(AD(N,N1)) + DABS(AD(N1,N2))
         X = C3 * S
         Y = X
         W = -C1 * S * S
      END IF
C
      IN = IN + 1
C                ** LOOK FOR TWO CONSECUTIVE SMALL SUB-DIAGONAL ELEMENTS
C
      DO 460  I = N2, LB, -1
         Z = AD(I,I)
         R = X - Z
         S = Y - Z
         P = (R * S-W) / AD(I+1,I) + AD(I,I+1)
         Q = AD(I+1,I+1) - Z - R - S
         R = AD(I+2,I+1)
         S = DABS(P) + DABS(Q) + DABS(R)
         P = P / S
         Q = Q / S
         R = R / S
         X = DABS( AD(I,I-1) ) * ( DABS(Q) + DABS(R) )
         Y = RDELP * DABS(P) * ( DABS(AD(I-1,I-1)) + DABS(Z)
     $                         + DABS(AD(I+1,I+1)) )
         IF ( X.LE.Y ) GO TO 470
460   CONTINUE
      I = LB
C
470   CONTINUE
      AD(I+2,I) = 0.D0
      DO 480 J = I+3, N
         AD(J,J-2) = 0.D0
         AD(J,J-3) = 0.D0
480   CONTINUE
C
C             ** DOUBLE QR STEP INVOLVING ROWS K TO N AND COLUMNS M TO N
C
      DO 520 KA = I, N1
         NOTLAS = KA.NE.N1
         IF ( KA.NE.I ) THEN
            P = AD(KA,KA-1)
            Q = AD(KA+1,KA-1)
            R = 0.D0
            IF ( NOTLAS ) R = AD(KA+2,KA-1)
            X = DABS(P) + DABS(Q) + DABS(R)
            IF ( X.EQ.0.D0 ) GO TO 520
            P = P / X
            Q = Q / X
            R = R / X
         END IF
         S = DSIGN( DSQRT(P * P+Q * Q+R * R),P )
         IF ( KA.EQ.I ) THEN
            IF ( LB.NE.I ) AD(KA,KA-1) = - AD(KA,KA-1)
         ELSE
            AD(KA,KA-1) = - S * X
         END IF
         P = P + S
         X = P / S
         Y = Q / S
         Z = R / S
         Q = Q / P
         R = R / P
C                                                    ** ROW MODIFICATION
         DO 490 J = KA, M
            P = AD(KA,J) + Q * AD(KA+1,J)
            IF ( NOTLAS ) THEN
               P = P + R * AD(KA+2,J)
               AD(KA+2,J) = AD(KA+2,J) - P * Z
            END IF
            AD(KA+1,J) = AD(KA+1,J) - P * Y
            AD(KA,J)   = AD(KA,J)   - P * X
490      CONTINUE
C                                                 ** COLUMN MODIFICATION
         DO 500 II = 1, MIN0(N,KA+3)
            P = X * AD(II,KA) + Y * AD(II,KA+1)
            IF ( NOTLAS ) THEN
               P = P + Z * AD(II,KA+2)
               AD(II,KA+2) = AD(II,KA+2) - P * R
            END IF
            AD(II,KA+1) = AD(II,KA+1) - P * Q
            AD(II,KA)   = AD(II,KA) - P
500      CONTINUE
C                                          ** ACCUMULATE TRANSFORMATIONS
         DO 510 II = L, K
            P = X * EVECD(II,KA) + Y * EVECD(II,KA+1)
            IF ( NOTLAS ) THEN
               P = P + Z * EVECD(II,KA+2)
               EVECD(II,KA+2) = EVECD(II,KA+2) - P * R
            END IF
            EVECD(II,KA+1) = EVECD(II,KA+1) - P * Q
            EVECD(II,KA)   = EVECD(II,KA) - P
510      CONTINUE
520   CONTINUE
      GO TO 390
C                     ** ALL EVALS FOUND, NOW BACKSUBSTITUTE REAL VECTOR
530   CONTINUE
      IF ( RNORM.NE.0.D0 ) THEN
         DO 560  N = M, 1, -1
            N2 = N
            AD(N,N) = 1.D0
            DO 550  I = N-1, 1, -1
               W = AD(I,I) - EVALD(N)
               IF ( W.EQ.0.D0 ) W = RDELP * RNORM
               R = AD(I,N)
               DO 540 J = N2, N-1
                  R = R + AD(I,J) * AD(J,N)
540            CONTINUE
               AD(I,N) = -R / W
               N2 = I
550         CONTINUE
560      CONTINUE
C                      ** END BACKSUBSTITUTION VECTORS OF ISOLATED EVALS
C
         DO 580 I = 1, M
            IF ( (I.LT.L) .OR. (I.GT.K) ) THEN
               DO 570 J = I, M
                  EVECD(I,J) = AD(I,J)
570            CONTINUE
            END IF
580      CONTINUE
C                                   ** MULTIPLY BY TRANSFORMATION MATRIX
         IF ( K.NE.0 ) THEN
            DO 610  J = M, L, -1
               DO 600 I = L, K
                  Z = 0.D0
                  DO 590 N = L, MIN0(J,K)
                     Z = Z + EVECD(I,N) * AD(N,J)
590               CONTINUE
                  EVECD(I,J) = Z
600            CONTINUE
610         CONTINUE
         END IF
C
      END IF
C
      DO 620 I = L, K
         DO 620 J = 1, M
            EVECD(I,J) = EVECD(I,J) * WKD(I)
620   CONTINUE
C                           ** INTERCHANGE ROWS IF PERMUTATIONS OCCURRED
      DO 640  I = L-1, 1, -1
         J = WKD(I)
         IF ( I.NE.J ) THEN
            DO 630 N = 1, M
               REPL      = EVECD(I,N)
               EVECD(I,N) = EVECD(J,N)
               EVECD(J,N) = REPL
630         CONTINUE
         END IF
640   CONTINUE
C
      DO 660 I = K+1, M
         J = WKD(I)
         IF ( I.NE.J ) THEN
            DO 650 N = 1, M
               REPL       = EVECD(I,N)
               EVECD(I,N) = EVECD(J,N)
               EVECD(J,N) = REPL
650         CONTINUE
         END IF
660   CONTINUE
C                                  ** SET OUTPUT ARRAYS
C                                  ** EQUAL TO REAL*8 VERSIONS
  670 CONTINUE
      DO 680 J = 1, M
         EVAL( J ) =  EVALD(J)
         DO 680 K = 1, M
            EVEC( J,K ) =  EVECD(J,K)
680   CONTINUE
C
      RETURN
      END
C**********************************************************************      
      SUBROUTINE  CHEKIN( NLYR, DTAUC, SSALB, PMOM, TEMPER, WVNMLO,
     $                    WVNMHI, USRTAU, NTAU, UTAU, NSTR, USRANG,
     $                    NUMU, UMU, NPHI, PHI, IBCND, FBEAM, UMU0,
     $                    PHI0, FISOT, LAMBER, ALBEDO, HL, BTEMP,
     $                    TTEMP, TEMIS, NOPLNK, ONLYFL, ACCUR, MAXCLY,
     $                    MAXULV, MAXUMU, MAXCMU, MAXPHI, MXCLY,
     $                    MXULV,  MXUMU,  MXCMU,  MXPHI, TAUC )
C
C           CHECKS THE INPUT DIMENSIONS AND VARIABLES
C
	IMPLICIT REAL*8 (A-H, O-Z)

      LOGICAL  LAMBER, NOPLNK, ONLYFL, USRANG, USRTAU, INPERR
      INTEGER  IBCND, MAXCLY, MAXUMU, MAXULV, MAXCMU, MAXPHI, NLYR,
     $         NUMU, NSTR, NPHI, NTAU, MXCMU, MXUMU, MXPHI, MXCLY,
     $         MXULV
      REAL*8 ACCUR, ALBEDO, BTEMP, DTAUC( MAXCLY ), FBEAM, FISOT,
     $       HL( 0:MAXCMU ), PHI( MAXPHI ), PMOM( 0:MAXCMU, MAXCLY ),
     $       PHI0, SSALB( MAXCLY ), TEMPER( 0:MAXCLY ), TEMIS, TTEMP,
     $       WVNMLO, WVNMHI, UMU( MAXUMU ), UMU0, UTAU( MAXULV ),
     $       TAUC( 0:* )
C
      INPERR = .FALSE.
      IF ( NLYR.LT.1 ) CALL WRTBAD( 'NLYR', INPERR )
      IF ( NLYR.GT.MAXCLY ) CALL WRTBAD( 'MAXCLY', INPERR )
C
      DO 10  LC = 1, NLYR
         IF ( DTAUC(LC).LT.0.0D0 ) CALL WRTBAD( 'DTAUC', INPERR )
         IF ( SSALB(LC).LT.0.0D0 .OR. SSALB(LC).GT.1.0D0 )
     $        CALL WRTBAD( 'SSALB', INPERR )
         IF ( .NOT.NOPLNK .AND. IBCND.NE.1 )  THEN
            IF( LC.EQ.1 .AND. TEMPER(0).LT.0.0D0 )
     $          CALL WRTBAD( 'TEMPER', INPERR )
            IF( TEMPER(LC).LT.0.0D0 ) CALL WRTBAD( 'TEMPER', INPERR )
         ENDIF
         DO 5  K = 0, NSTR
            IF( PMOM(K,LC).LT.-1.0D0 .OR. PMOM(K,LC).GT.1.0D0 )
     $          CALL WRTBAD( 'PMOM', INPERR )
 5       CONTINUE
10    CONTINUE
C
      IF ( IBCND.EQ.1 )  THEN
         IF ( MAXULV.LT.2 ) CALL WRTBAD( 'MAXULV', INPERR )
      ELSE IF ( USRTAU )  THEN
         IF ( NTAU.LT.1 ) CALL WRTBAD( 'NTAU', INPERR )
         IF ( MAXULV.LT.NTAU ) CALL WRTBAD( 'MAXULV', INPERR )
         DO 20  LU = 1, NTAU
            IF(DABS(UTAU(LU)-TAUC(NLYR)).LE.1.D-4) UTAU(LU) =TAUC(NLYR)
            IF( UTAU(LU).LT.0.0D0 .OR. UTAU(LU).GT.TAUC(NLYR) )
     $          CALL WRTBAD( 'UTAU', INPERR )
20       CONTINUE
      ELSE
         IF ( MAXULV.LT.NLYR+1 ) CALL WRTBAD( 'MAXULV', INPERR )
      END IF
C
      IF ( NSTR.LT.2 .OR. MOD(NSTR,2).NE.0 ) CALL WRTBAD( 'NSTR',INPERR)
      IF ( NSTR.GT.MAXCMU ) CALL WRTBAD( 'MAXCMU', INPERR )
C
      IF ( USRANG )  THEN
         IF ( NUMU.LT.0 ) CALL WRTBAD( 'NUMU', INPERR )
         IF ( .NOT.ONLYFL .AND. NUMU.EQ.0 ) CALL WRTBAD( 'NUMU',INPERR )
         IF ( NUMU.GT.MAXUMU ) CALL WRTBAD( 'MAXUMU', INPERR )
         IF ( IBCND.EQ.1 .AND. 2*NUMU.GT.MAXUMU )
     $        CALL WRTBAD( 'MAXUMU', INPERR )
         DO 30  IU = 1, NUMU
            IF( UMU(IU).LT.-1.0D0 .OR. UMU(IU).GT.1.0D0 .OR.
     $        UMU(IU).EQ.0.0D0)
     $           CALL WRTBAD( 'UMU', INPERR )
            IF( IBCND.EQ.1 .AND. UMU(IU).LT.0.0D0 )
     $           CALL WRTBAD( 'UMU', INPERR )
            IF( IU.GT.1 .AND. UMU(IU).LT.UMU(IU-1) )
     $           CALL WRTBAD( 'UMU', INPERR )
30       CONTINUE
      ELSE
         IF( MAXUMU.LT.NSTR ) CALL WRTBAD( 'MAXUMU', INPERR )
      END IF
C
      IF ( .NOT.ONLYFL .AND. IBCND.NE.1 )  THEN
         IF ( NPHI.LE.0 ) CALL WRTBAD( 'NPHI', INPERR )
         IF ( NPHI.GT.MAXPHI ) CALL WRTBAD( 'MAXPHI', INPERR )
         DO 40  J = 1, NPHI
            IF ( PHI(J).LT.0.0D0 .OR. PHI(J).GT.360.0D0 )
     $           CALL WRTBAD( 'PHI', INPERR )
40       CONTINUE
      END IF
C
      IF ( IBCND.LT.0 .OR. IBCND.GT.1 ) CALL WRTBAD( 'IBCND', INPERR )
      IF ( IBCND.EQ.0 )  THEN
         IF ( FBEAM.LT.0.0D0 ) CALL WRTBAD( 'FBEAM', INPERR )
         IF ( FBEAM.GT.0.0D0 .AND. ( UMU0.LE.0.0D0 .OR.
     $     UMU0.GT.1.0D0 ) )
     $        CALL WRTBAD( 'UMU0', INPERR )
         IF ( FBEAM.GT.0.0D0 .AND. ( PHI0.LT.0.0D0 .OR.
     $     PHI0.GT.360.0D0 ) )
     $        CALL WRTBAD( 'PHI0',INPERR)
         IF ( FISOT.LT.0.0D0 ) CALL WRTBAD( 'FISOT', INPERR )
         IF ( LAMBER )  THEN
            IF ( ALBEDO.LT.0.0D0 .OR. ALBEDO.GT.1.0D0 )
     $           CALL WRTBAD( 'ALBEDO', INPERR )
         ELSE
C                    ** MAKE SURE FLUX ALBEDO AT DENSE MESH OF INCIDENT 
C                    ** ANGLES DOES NOT ASSUME UNPHYSICAL VALUES
C
            DO 50  RMU = 0.0D0, 1.0D0, 0.01D0
               FLXALB = DREF( RMU, HL, NSTR )
c               write(3,*) flxalb
               IF ( FLXALB.LT.0.0D0 .OR. FLXALB.GT.1.0D0 )
     $              CALL WRTBAD( 'HL', INPERR )
50          CONTINUE
         ENDIF
C
      ELSE IF ( IBCND.EQ.1 )  THEN
         IF ( ALBEDO.LT.0.0D0 .OR. ALBEDO.GT.1.0D0 )
     $        CALL WRTBAD( 'ALBEDO', INPERR )
      END IF
C
      IF ( .NOT.NOPLNK .AND. IBCND.NE.1 )  THEN
         IF ( WVNMLO.LT.0.0D0 .OR. WVNMHI.LE.WVNMLO )
     $        CALL WRTBAD( 'WVNMLO,HI', INPERR )
         IF ( TEMIS.LT.0.0D0 .OR. TEMIS.GT.1.0D0 )
     $        CALL WRTBAD( 'TEMIS', INPERR )
         IF ( BTEMP.LT.0.0D0 ) CALL WRTBAD( 'BTEMP', INPERR )
         IF ( TTEMP.LT.0.0D0 ) CALL WRTBAD( 'TTEMP', INPERR )
      END IF
C
      IF ( ACCUR.LT.0.0D0 .OR. ACCUR.GT.1.0D-2 )
     $     CALL WRTBAD( 'ACCUR', INPERR )
C
      IF ( MXCLY.LT.NLYR ) CALL WRTDIM( 'MXCLY', NLYR, INPERR )
      IF ( IBCND.NE.1 )  THEN
         IF ( USRTAU .AND. MXULV.LT.NTAU )
     $        CALL WRTDIM( 'MXULV', NTAU, INPERR )
         IF ( .NOT.USRTAU .AND. MXULV.LT.NLYR+1 )
     $        CALL WRTDIM( 'MXULV', NLYR+1, INPERR )
      ELSE
         IF ( MXULV.LT.2 ) CALL WRTDIM( 'MXULV', 2, INPERR )
      END IF
      IF ( MXCMU.LT.NSTR ) CALL WRTDIM( 'MXCMU', NSTR, INPERR )
      IF ( USRANG .AND. MXUMU.LT.NUMU )
     $     CALL WRTDIM( 'MXUMU', NUMU, INPERR )
      IF ( USRANG .AND. IBCND.EQ.1 .AND. MXUMU.LT.2*NUMU )
     $     CALL WRTDIM( 'MXUMU', NUMU, INPERR )
      IF ( .NOT.USRANG .AND. MXUMU.LT.NSTR )
     $      CALL WRTDIM( 'MXUMU', NSTR, INPERR )
      IF ( .NOT.ONLYFL .AND. IBCND.NE.1 .AND. MXPHI.LT.NPHI )
     $      CALL WRTDIM( 'MXPHI', NPHI, INPERR )
C
      IF ( INPERR )
     $   CALL ERRMSG( 'DISORT--INPUT AND/OR DIMENSION ERRORS', .TRUE. )
C
      DO 100  LC = 1, NLYR
         IF (.NOT.NOPLNK .AND. DABS(TEMPER(LC)-TEMPER(LC-1)) .GT. 10.0)
     $          CALL ERRMSG( 'CHEKIN--VERTICAL TEMPERATURE STEP MAY'
     $          // ' BE TOO LARGE FOR GOOD ACCURACY', .FALSE. )
100   CONTINUE
C
      RETURN
      END
C********************************************************************** 
      SUBROUTINE  CMPINT( FBEAM, GC, KK, LAYRU, LL, LYRCUT, MAZ,
     $                    MXCMU, MXULV, MXUMU, NCUT, NN, NSTR,
     $                    NOPLNK, NTAU, TAUCPR, UMU0, UTAUPR,
     $                    ZZ, ZPLK0, ZPLK1, UUM )
C
C       CALCULATES THE FOURIER INTENSITY COMPONENTS AT THE QUADRATURE
C       ANGLES FOR AZIMUTHAL EXPANSION TERMS (MAZ) IN EQ. SD(2)
C
C    I N P U T    V A R I A B L E S:
C
C       KK      :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       GC      :  EIGENVECTORS AT POLAR QUADRATURE ANGLES, SC(1)
C       LL      :  CONSTANTS OF INTEGRATION IN EQ. SC(1), OBTAINED
C                  BY SOLVING SCALED VERSION OF EQ. SC(5);
C                  EXPONENTIAL TERM OF EQ. SC(12) NOT INCLUDED
C       LYRCUT  :  LOGICAL FLAG FOR TRUNCATION OF COMPUT. LAYER
C       MAZ     :  ORDER OF AZIMUTHAL COMPONENT
C       NCUT    :  NUMBER OF COMPUTATIONAL LAYER WHERE ABSORPTION
C                  OPTICAL DEPTH EXCEEDS 10
C       NN      :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       TAUCPR  :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       UTAUPR  :  OPTICAL DEPTHS OF USER OUTPUT LEVELS IN DELTA-M
C                  COORDINATES;  EQUAL TO -UTAU- IF NO DELTA-M
C       ZZ      :  BEAM SOURCE VECTORS IN EQ. SS(19)
C       ZPLK0   :  THERMAL SOURCE VECTORS -Z0-, BY SOLVING EQ. SS(16)
C       ZPLK1   :  THERMAL SOURCE VECTORS -Z1-, BY SOLVING EQ. SS(16)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T   V A R I A B L E S:
C
C       UUM     :  FOURIER COMPONENTS OF THE INTENSITY IN EQ.  SD(12)
C                   ( AT POLAR QUADRATURE ANGLES )
C
C    I N T E R N A L   V A R I A B L E S:
C
C       FACT    :  DEXP( - UTAUPR / UMU0 )
C       ZINT    :  INTENSITY OF M=0 CASE, IN EQ. SC(1)
C+----------------------------------------------------------------------
C
	 IMPLICIT REAL*8(A-H,O-Z)
       LOGICAL  LYRCUT, NOPLNK
       INTEGER  LAYRU(*)
       REAL*8  UUM( MXUMU, MXULV, 0:* )
       REAL*8  GC( MXCMU,MXCMU,* ), KK( MXCMU,* ),LL(MXCMU,*),
     $         TAUCPR( 0:* ), UTAUPR(*), ZZ( MXCMU, *),
     $         ZPLK0( MXCMU,* ), ZPLK1( MXCMU,* )
C
C
C                                                  ** ZERO OUTPUT ARRAY
       CALL ZEROIT( UUM, MXUMU*MXULV*(MXCMU + 1) )
C
C                                       ** LOOP OVER USER LEVELS
       DO 100  LU = 1, NTAU
C
          LYU = LAYRU(LU)
          IF ( LYRCUT .AND. LYU.GT.NCUT )  GO TO 100
C
          DO 20  IQ = 1, NSTR
             ZINT = 0.0D0
             DO 10  JQ = 1, NN
               ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $                  DEXP( - KK(JQ,LYU)*(UTAUPR(LU) - TAUCPR(LYU)) )
10           CONTINUE
             DO 11  JQ = NN+1, NSTR
                ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $                DEXP( - KK(JQ,LYU)*(UTAUPR(LU) - TAUCPR(LYU-1)) )
11           CONTINUE
C
             UUM(IQ,LU,MAZ) = ZINT
             IF ( FBEAM.GT.0.0D0 )
     $            UUM(IQ,LU,MAZ) = ZINT + ZZ(IQ,LYU)
     $                                    * DEXP( - UTAUPR(LU) / UMU0 )
             IF ( .NOT.NOPLNK .AND. MAZ.EQ.0 )
     $            UUM(IQ,LU,MAZ) = UUM(IQ,LU,MAZ) + ZPLK0(IQ,LYU) +
     $                             ZPLK1(IQ,LYU) * UTAUPR(LU)
20        CONTINUE
C
100   CONTINUE
C
      RETURN
      END
C**********************************************************************
      REAL*8 FUNCTION  DREF( MU, HL, NSTR )
C
C        EXACT FLUX ALBEDO FOR GIVEN ANGLE OF INCIDENCE, GIVEN
C        A BIDIRECTIONAL REFLECTIVITY CHARACTERIZED BY ITS
C        LEGENDRE COEFFICIENTS ( NOTE** THESE WILL ONLY AGREE
C        WITH BOTTOM-BOUNDARY ALBEDOS CALCULATED BY 'DISORT' IN
C        THE LIMIT AS NUMBER OF STREAMS GO TO INFINITY, BECAUSE
C        'DISORT' EVALUATES THE INTEGRAL 'CL' ONLY APPROXIMATELY,
C        BY QUADRATURE, WHILE THIS ROUTINE CALCULATES IT EXACTLY. )
C
C      INPUT :   MU     COSINE OF INCIDENCE ANGLE
C                HL     LEGENDRE COEFFICIENTS OF BIDIRECTIONAL REF'Y
C              NSTR     NUMBER OF ELEMENTS OF 'HL' TO CONSIDER
C
C      INTERNAL VARIABLES (P-SUB-L IS THE L-TH LEGENDRE POLYNOMIAL) :
C
C              CL    INTEGRAL FROM 0 TO 1 OF  MU * P-SUB-L(MU)
C                       (VANISHES FOR  L = 3, 5, 7, ... )
C              PL    P-SUB-L
C            PLM1    P-SUB-(L-1)
C            PLM2    P-SUB-(L-2)
C
	IMPLICIT REAL*8 (A-H, O-Z)
      PARAMETER  ( MAXTRM = 100 )
      LOGICAL      PASS1
      
      REAL*8  MU, HL( 0:* ), C( MAXTRM )
      DATA  PASS1 / .TRUE. /
C
C
      IF ( PASS1 )  THEN
         PASS1 = .FALSE.
         CL = 0.125D0
         C(2) = 10.0D0 * CL
         DO 1  L = 4, MAXTRM, 2
            CL = - CL * (L-3) / (L+2)
            C(L) = 2.D0 * (2*L+1) * CL
    1    CONTINUE
      END IF
C
      IF ( NSTR.GT.MAXTRM )  CALL
     $     ERRMSG( 'DREF--PARAMETER MAXTRM TOO SMALL', .TRUE. )
C
c      iii=1
      DREF = HL(0) - 2.0D0*HL(1) * MU
c      if (iii.eq.1) write(*,*) hl(0),hl(1),dref
c      iii=2
      PLM2 = 1.0D0
      PLM1 = - MU
      DO 10  L = 2, NSTR-1
C                                ** LEGENDRE POLYNOMIAL RECURRENCE
C
         PL = ( (2*L-1) * (-MU) * PLM1 - (L-1) * PLM2 ) / L
         IF( MOD(L,2).EQ.0 )  DREF = DREF + C(L) * HL(L) * PL
         PLM2 = PLM1
         PLM1 = PL
   10 CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  FLUXES( CMU, CWT, FBEAM, GC, KK, LAYRU, LL, LYRCUT,
     $                    MXCMU, MXULV, NCUT, NN, NSTR, NTAU, PI,
     $                    PRNT, SSALB, TAUCPR, UMU0, UTAU, UTAUPR,
     $                    XR0, XR1, ZZ, ZPLK0, ZPLK1, DFDT, FLUP,
     $                    FLDN, FLDIR, RFLDIR, RFLDN, UAVG, U0C,
     $                    MAXULV )
C
C       CALCULATES THE RADIATIVE FLUXES, MEAN INTENSITY, AND FLUX
C       DERIVATIVE WITH RESPECT TO OPTICAL DEPTH FROM THE M=0 INTENSITY
C       COMPONENTS (THE AZIMUTHALLY-AVERAGED INTENSITY)
C
C    I N P U T     V A R I A B L E S:
C
C       CMU      :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT      :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       GC       :  EIGENVECTORS AT POLAR QUADRATURE ANGLES, SC(1)
C       KK       :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       LAYRU    :  LAYER NUMBER OF USER LEVEL -UTAU-
C       LL       :  CONSTANTS OF INTEGRATION IN EQ. SC(1), OBTAINED
C                   BY SOLVING SCALED VERSION OF EQ. SC(5);
C                   EXPONENTIAL TERM OF EQ. SC(12) NOT INCLUDED
C       LYRCUT   :  LOGICAL FLAG FOR TRUNCATION OF COMPUT. LAYER
C       NN       :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       NCUT     :  NUMBER OF COMPUTATIONAL LAYER WHERE ABSORPTION
C                   OPTICAL DEPTH EXCEEDS 10
C       TAUCPR   :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       UTAUPR   :  OPTICAL DEPTHS OF USER OUTPUT LEVELS IN DELTA-M
C                     COORDINATES;  EQUAL TO  -UTAU- IF NO DELTA-M
C       XR0      :  EXPANSION OF THERMAL SOURCE FUNCTION IN EQ. SS(14)
C       XR1      :  EXPANSION OF THERMAL SOURCE FUNCTION EQS. SS(16)
C       ZZ       :  BEAM SOURCE VECTORS IN EQ. SS(19)
C       ZPLK0    :  THERMAL SOURCE VECTORS -Z0-, BY SOLVING EQ. SS(16)
C       ZPLK1    :  THERMAL SOURCE VECTORS -Z1-, BY SOLVING EQ. SS(16)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T     V A R I A B L E S:
C
C       U0C      :  AZIMUTHALLY AVERAGED INTENSITIES
C                   ( AT POLAR QUADRATURE ANGLES )
C       (RFLDIR, RFLDN, FLUP, DFDT, UAVG ARE 'DISORT' OUTPUT VARIABLES)
C
C   I N T E R N A L       V A R I A B L E S:
C
C       DIRINT   :  DIRECT INTENSITY ATTENUATED
C       FDNTOT   :  TOTAL DOWNWARD FLUX (DIRECT + DIFFUSE)
C       FLDIR    :  DIRECT-BEAM FLUX (DELTA-M SCALED)
C       FLDN     :  DIFFUSE DOWN-FLUX (DELTA-M SCALED)
C       FNET     :  NET FLUX (TOTAL-DOWN - DIFFUSE-UP)
C       FACT     :  EXP( - UTAUPR / UMU0 )
C       PLSORC   :  PLANCK SOURCE FUNCTION (THERMAL)
C       ZINT     :  INTENSITY OF m = 0 CASE, IN EQ. SC(1)
C+---------------------------------------------------------------------+
C
	IMPLICIT REAL*8 (A-H, O-Z)

      LOGICAL LYRCUT, PRNT(*)
      REAL*8  DFDT(*), FLUP(*), FLDIR(*), FLDN(*), RFLDIR(*), RFLDN(* ),
     $        U0C( MXCMU,MXULV ), UAVG(*)
      INTEGER LAYRU(*)
      REAL*8  CMU(*), CWT(*), GC( MXCMU,MXCMU,* ), KK( MXCMU,* ),
     $        LL( MXCMU,* ), SSALB(*), TAUCPR( 0:* ),
     $        UTAU(*), UTAUPR(*), XR0(*), XR1(*), ZZ( MXCMU,* ),
     $        ZPLK0( MXCMU,* ), ZPLK1( MXCMU,* )
C
C
      IF ( PRNT(2) )  WRITE( 3,1010 )
C                                          ** ZERO DISORT OUTPUT ARRAYS
      CALL  ZEROIT( U0C, MXULV*MXCMU )
      CALL  ZEROIT( RFLDIR, MAXULV )
      CALL  ZEROIT( FLDIR,  MXULV )
      CALL  ZEROIT( RFLDN,  MAXULV )
      CALL  ZEROIT( FLDN,   MXULV )
      CALL  ZEROIT( FLUP,   MAXULV )
      CALL  ZEROIT( UAVG,   MAXULV )
      CALL  ZEROIT( DFDT,   MAXULV )
C                                        ** LOOP OVER USER LEVELS
      DO 100  LU = 1, NTAU
C
         LYU = LAYRU(LU)
C
         IF ( LYRCUT .AND. LYU.GT.NCUT ) THEN
C                                                ** NO RADIATION REACHES
C                                                ** THIS LEVEL
            FDNTOT = 0.0D0
            FNET   = 0.0D0
            PLSORC = 0.0D0
            GO TO 90
         END IF
C
         IF ( FBEAM.GT.0.0D0 )  THEN
            FACT  = DEXP( - UTAUPR(LU) / UMU0 )
            DIRINT = FBEAM * FACT
            FLDIR(  LU ) = UMU0 * ( FBEAM * FACT )
            RFLDIR( LU ) = UMU0 * FBEAM * DEXP( - UTAU( LU ) / UMU0 )
         ELSE
            DIRINT = 0.0D0
            FLDIR(  LU ) = 0.0D0
            RFLDIR( LU ) = 0.0D0
         END IF
C
         DO 20  IQ = 1, NN
C
            ZINT = 0.0D0
            DO 10  JQ = 1, NN
               ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $               DEXP( - KK(JQ,LYU) * (UTAUPR(LU) - TAUCPR(LYU)) )
10          CONTINUE
            DO 11  JQ = NN+1, NSTR
               ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $              DEXP( - KK(JQ,LYU) * (UTAUPR(LU) - TAUCPR(LYU-1)) )
11          CONTINUE
C
            U0C( IQ,LU ) = ZINT
            IF ( FBEAM.GT.0.D0 ) U0C( IQ,LU )= ZINT + ZZ(IQ,LYU) * FACT
            U0C( IQ,LU ) = U0C( IQ,LU ) + ZPLK0(IQ,LYU)
     $                     + ZPLK1(IQ,LYU) * UTAUPR(LU)
            UAVG(LU) = UAVG(LU) + CWT(NN+1-IQ) * U0C( IQ,LU )
            FLDN(LU) = FLDN(LU) + CWT(NN+1-IQ)*CMU(NN+1-IQ)*U0C(IQ,LU)
20       CONTINUE
C
         DO 40  IQ = NN+1, NSTR
C
            ZINT = 0.0D0
            DO 30  JQ = 1, NN
               ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $                DEXP( - KK(JQ,LYU) * (UTAUPR(LU) - TAUCPR(LYU)) )
30          CONTINUE
            DO 31  JQ = NN+1, NSTR
               ZINT = ZINT + GC(IQ,JQ,LYU) * LL(JQ,LYU) *
     $              DEXP( - KK(JQ,LYU) * (UTAUPR(LU) - TAUCPR(LYU-1)) )
31          CONTINUE
C
            U0C( IQ,LU ) = ZINT
            IF ( FBEAM.GT.0.0 )  U0C( IQ,LU ) = ZINT + ZZ(IQ,LYU) * FACT
            U0C( IQ,LU ) = U0C( IQ,LU ) + ZPLK0(IQ,LYU)
     $                     + ZPLK1(IQ,LYU) * UTAUPR(LU)
            UAVG(LU) = UAVG(LU) + CWT(IQ-NN) * U0C( IQ,LU )
            FLUP(LU) = FLUP(LU) + CWT(IQ-NN) * CMU(IQ-NN)*U0C( IQ,LU )
40       CONTINUE
C
         FLUP( LU )  = 2.0D0 * PI * FLUP( LU )
         FLDN( LU )  = 2.0D0 * PI * FLDN( LU )
         FDNTOT = FLDN( LU ) + FLDIR( LU )
         FNET   = FDNTOT - FLUP( LU )
         RFLDN( LU ) = FDNTOT - RFLDIR( LU )
         UAVG( LU ) = ( 2.0D0 * PI * UAVG(LU) + DIRINT ) / ( 4.0D0*PI )
         PLSORC =  XR0(LYU) + XR1(LYU) * UTAUPR(LU)
         DFDT( LU ) = ( 1.0D0-SSALB(LYU) ) * 4.D0*PI*(UAVG(LU)-PLSORC)
 90      IF( PRNT(2) )  WRITE( 3,1020 ) UTAU(LU), LYU, RFLDIR(LU),
     $                                 RFLDN(LU), FDNTOT, FLUP(LU),
     $                                 FNET, UAVG(LU), PLSORC, DFDT(LU)
100   CONTINUE
C
      IF ( PRNT(3) )  THEN
         WRITE ( 3,1100 )
         DO 200  LU = 1, NTAU
            WRITE( 3,1110 )  UTAU( LU )
            DO  200  IQ = 1, NN
               ANG1 = 180.0D0/PI * DACOS( CMU(2*NN-IQ+1) )
               ANG2 = 180.0D0/PI * DACOS( CMU(IQ) )
               WRITE( 3,1120 ) ANG1, CMU(2*NN-IQ+1), U0C(IQ,LU),
     $                         ANG2, CMU(IQ),        U0C(IQ+NN,LU)
200      CONTINUE
      END IF
C
1010  FORMAT( //, 21X,
     $ '<----------------------- FLUXES ----------------------->', /,
     $ '   OPTICAL  COMPU    DOWNWARD    DOWNWARD    DOWNWARD     ',
     $ ' UPWARD                    MEAN      PLANCK   D(NET FLUX)', /,
     $ '     DEPTH  LAYER      DIRECT     DIFFUSE       TOTAL     ',
     $ 'DIFFUSE         NET   INTENSITY      SOURCE   / D(OP DEP)', / )
1020  FORMAT( F10.4, I7, 1P,7E12.3, E14.3 )
1100  FORMAT( //, ' ******** AZIMUTHALLY AVERAGED INTENSITIES',
     $      ' ( AT POLAR QUADRATURE ANGLES ) *******' )
1110  FORMAT( /, ' OPTICAL DEPTH =', F10.4, //,
     $  '     ANGLE (DEG)   COS(ANGLE)     INTENSITY',
     $  '     ANGLE (DEG)   COS(ANGLE)     INTENSITY' )
1120  FORMAT( 2( 0P,F16.4, F13.5, 1P,E14.3 ) )
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  LEPOLY( NMU, M, MAXMU, TWONM1, MU, YLM )
C
C       COMPUTES THE NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL,
C       DEFINED IN TERMS OF THE ASSOCIATED LEGENDRE POLYNOMIAL
C       PLM = P-SUB-L-SUPER-M AS
C
C             YLM(MU) = DSQRT( (L-M)!/(L+M)! ) * PLM(MU)
C
C       FOR FIXED ORDER -M- AND ALL DEGREES FROM L = M TO TWONM1.
C       WHEN M.GT.0, ASSUMES THAT Y-SUB(M-1)-SUPER(M-1) IS AVAILABLE
C       FROM A PRIOR CALL TO THE ROUTINE.
C
C       REFERENCE: Dave, J.V. and B.H. Armstrong, Computations of
C                  High-Order Associated Legendre Polynomials,
C                  J. Quant. Spectrosc. Radiat. Transfer 10,
C                  557-562, 1970.  (hereafter D/A)
C
C       METHOD: Varying degree recurrence relationship.
C
C       NOTE 1: The D/A formulas are transformed by
C               setting  M = n-1; L = k-1.
C       NOTE 2: Assumes that routine is called first with  M = 0,
C               then with  M = 1, etc. up to  M = TWONM1.
C       NOTE 3: Loops are written in such a way as to vectorize.
C
C  I N P U T     V A R I A B L E S:
C
C       NMU    :  NUMBER OF ARGUMENTS OF -YLM-
C       M      :  ORDER OF -YLM-
C       MAXMU  :  FIRST DIMENSION OF -YLM-
C       TWONM1 :  MAX DEGREE OF -YLM-
C       MU(I)  :  I = 1 TO NMU, ARGUMENTS OF -YLM-
C       IF M.GT.0, YLM(M-1,I) FOR I = 1 TO NMU IS REQUIRED
C
C  O U T P U T     V A R I A B L E:
C
C       YLM(L,I) :  L = M TO TWONM1, NORMALIZED ASSOCIATED LEGENDRE
C                   POLYNOMIALS EVALUATED AT ARGUMENT -MU(I)-
C+---------------------------------------------------------------------+
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8  MU(*), YLM( 0:MAXMU,* )
      INTEGER  M, NMU, TWONM1
      PARAMETER  ( MAXSQT = 1000 )
      REAL*8  SQT( MAXSQT )
      LOGICAL  PASS1
      SAVE  SQT, PASS1
      DATA  PASS1 / .TRUE. /
C
C
      IF ( PASS1 )  THEN
         PASS1 = .FALSE.
         DO 1  NS = 1, MAXSQT
            SQT( NS ) = DSQRT( DBLE(NS) )
    1    CONTINUE
      ENDIF
C
      IF ( 2*TWONM1 .GT. MAXSQT )
     $   CALL ERRMSG( 'LEPOLY--NEED TO INCREASE PARAM MAXSQT', .TRUE. )
C
      IF ( M .EQ. 0 )  THEN
C                             ** UPWARD RECURRENCE FOR ORDINARY
C                             ** LEGENDRE POLYNOMIALS
         DO  10  I = 1, NMU
            YLM( 0,I ) = 1.0D0
            YLM( 1,I ) = MU( I )
10       CONTINUE
         DO  20  L = 2, TWONM1
            DO  20  I = 1, NMU
               YLM( L,I ) = ( ( 2*L-1 ) * MU(I) * YLM( L-1,I )
     $                      - ( L-1 ) * YLM( L-2,I ) ) / L
20       CONTINUE
C
      ELSE
C
         DO  30  I = 1, NMU
C                               ** Y-SUB-M-SUPER-M; DERIVED FROM
C                               ** D/A EQS. (11,12)
C
            YLM( M,I) = - SQT( 2*M-1 ) / SQT( 2*M )
     $                  * DSQRT( 1. - MU(I)**2 ) * YLM( M-1,I )
C
C                              ** Y-SUB-(M+1)-SUPER-M; DERIVED FROM
C                              ** D/A EQS. (13,14) USING EQS. (11,12)
C
            YLM( M+1,I ) = SQT( 2*M+1 ) * MU(I) * YLM( M,I )
30       CONTINUE
C                                   ** UPWARD RECURRENCE; D/A EQ. (10)
         DO  40  L = M+2, TWONM1
            TMP1 = SQT( L-M ) * SQT( L+M )
            TMP2 = SQT( L-M-1 ) * SQT( L+M-1 )
            DO  40  I = 1, NMU
               YLM( L,I ) = ( ( 2*L-1 ) * MU(I) * YLM( L-1,I )
     $                        - TMP2 * YLM( L-2,I ) ) / TMP1
40       CONTINUE
C
      END IF
C
      RETURN
      END
C**********************************************************************      
      SUBROUTINE  PRALTR( UMU, NUMU, ALBMED, TRNMED )
C
C        PRINT PLANAR ALBEDO AND TRANSMISSIVITY OF MEDIUM
C        AS A FUNCTION OF INCIDENT BEAM ANGLE
C

      REAL*8  UMU(*), ALBMED(*), TRNMED(*)
C
C
      WRITE( 3,110 )
      DO 20  IU = 1, NUMU
         ANGL = 180.0D0/3.14159265D0 * DACOS( UMU(IU) )
         WRITE(3,111)  ANGL, UMU(IU), ALBMED(IU), TRNMED(IU)
 20   CONTINUE
C
      RETURN
C
110   FORMAT( ///, ' *******  FLUX ALBEDO AND/OR TRANSMISSIVITY OF ',
     $ 'ENTIRE MEDIUM  ********', //,
     $ ' BEAM ZEN ANG   COS(BEAM ZEN ANG)      ALBEDO   TRANSMISSIVITY')
111   FORMAT( 0P,F13.4, F20.6, F12.5, 1P,E17.4 )
      END
C**********************************************************************
      SUBROUTINE  PRAVIN( UMU, NUMU, MAXUMU, UTAU, NTAU, U0U )
C
C        PRINT AZIMUTHALLY AVERAGED INTENSITIES AT USER ANGLES
C
      REAL*8 UMU(*), UTAU(*), U0U( MAXUMU,* )
C
C
      WRITE ( 3, '(//,A)' )
     $         ' *********  (1) AZIMUTHALLY AVERAGED INTENSITIES'
     $       // '(USER POLAR ANGLES)  *********'
      LENFMT = 8
      NPASS = 1 + NUMU / LENFMT
      IF ( MOD(NUMU,LENFMT) .EQ. 0 )  NPASS = NPASS - 1
      DO 10  NP = 1, NPASS
         IUMIN = 1 + LENFMT * (NP-1)
         IUMAX = MIN0( LENFMT*NP, NUMU )
         WRITE ( 3,101 )  ( UMU(IU), IU = IUMIN, IUMAX )
101      FORMAT( /, 3X,'OPTICAL   POLAR ANGLE COSINES',
     $        /, 3X,'  DEPTH', 8F14.5 )
         DO 10  LU = 1, NTAU
            WRITE( 3,102 ) UTAU(LU), ( U0U(IU,LU), IU=IUMIN,IUMAX)
102         FORMAT( 0P,F10.4, 1P,8E14.4 )
 10   CONTINUE


 	RETURN
      END

C**********************************************************************
      SUBROUTINE  PRTINP( NLYR, DTAUC, SSALB, PMOM, TEMPER, WVNMLO,
     $                    WVNMHI, NTAU, UTAU, NSTR, NUMU, UMU,
     $                    NPHI, PHI, IBCND, FBEAM, UMU0, PHI0,
     $                    FISOT, LAMBER, ALBEDO, HL, BTEMP, TTEMP,
     $                    TEMIS, DELTAM, NOPLNK, ONLYFL, ACCUR,
     $                    FLYR, LYRCUT, OPRIM, TAUC, TAUCPR,
     $                    MAXCMU, PRTMOM )
C
C        PRINT VALUES OF INPUT VARIABLES
C
      LOGICAL  DELTAM, LAMBER, LYRCUT, NOPLNK, ONLYFL, PRTMOM
	REAL*8   ACCUR,ALBEDO,BTEMP,FBEAM,FISOT,PHI0,TEMIS,TTEMP,
     $         UMU0,WVNMLO,WVNMHI
      REAL*8   UMU(*), FLYR(*), DTAUC(*), OPRIM(*), PHI(*),
     $         PMOM( 0:MAXCMU,* ), SSALB(*), UTAU(*), TAUC( 0:* ),
     $         TAUCPR( 0:* ), TEMPER( 0:* ), HL( 0:MAXCMU )
C
C
      WRITE( 3,1010 )  NSTR, NLYR
      IF ( IBCND.NE.1 ) WRITE( 3,1030 )  NTAU, (UTAU(LU), LU = 1, NTAU)
      IF ( .NOT.ONLYFL )
     $      WRITE( 3,1040 )  NUMU, ( UMU(IU), IU = 1, NUMU )
      IF ( .NOT.ONLYFL .AND. IBCND.NE.1 )
     $      WRITE( 3,1050 )  NPHI, ( PHI(J), J = 1, NPHI )
      IF ( NOPLNK .OR. IBCND.EQ.1 )  WRITE( 3,1100 )
      WRITE( 3,1055 )  IBCND
      IF ( IBCND.EQ.0 )  THEN
         WRITE( 3,1060 ) FBEAM, UMU0, PHI0, FISOT
         IF ( LAMBER )   WRITE( 3,1080 ) ALBEDO
         IF ( .NOT.LAMBER )  WRITE( 3,1090 ) ( HL(K), K = 0, NSTR )
         IF ( .NOT.NOPLNK )  WRITE( 3,1110 ) WVNMLO, WVNMHI, BTEMP,
     $                                       TTEMP, TEMIS
      ELSE IF ( IBCND.EQ.1 )  THEN
         WRITE( 3,1080 ) ALBEDO
      ENDIF
      IF ( DELTAM )      WRITE( 3,1120 )
      IF ( .NOT.DELTAM ) WRITE( 3,1130 )
      IF ( IBCND.EQ.1 )  THEN
         WRITE( 3,1135 )
      ELSE IF ( ONLYFL )  THEN
         WRITE( 3,1140 )
      ELSE
         WRITE( 3,1150 )
      ENDIF
      WRITE( 3,1160 )  ACCUR
      IF ( LYRCUT )  WRITE( 3,1170 )
      IF( .NOT.NOPLNK )  WRITE ( 3,1190 )
      IF(      NOPLNK )  WRITE ( 3,1191 )
      YESSCT = 0.0D0
      DO 10 LC = 1, NLYR
         YESSCT = YESSCT + SSALB(LC)
         IF( .NOT.NOPLNK )
     $       WRITE( 3,1200 )  LC, DTAUC(LC), TAUC(LC), SSALB(LC),
     $                    FLYR(LC), TAUCPR(LC)-TAUCPR(LC-1), TAUCPR(LC),
     $                    OPRIM(LC), PMOM(1,LC), TEMPER(LC-1)
         IF( NOPLNK )
     $       WRITE( 3,1200 )  LC, DTAUC(LC), TAUC(LC), SSALB(LC),
     $                    FLYR(LC), TAUCPR(LC)-TAUCPR(LC-1), TAUCPR(LC),
     $                    OPRIM(LC), PMOM(1,LC)
 10   CONTINUE
      IF( .NOT.NOPLNK )  WRITE( 3,1210 ) TEMPER(NLYR)
C
      IF( PRTMOM .AND. YESSCT.GT.0.0D0 )  THEN
         WRITE( 3, '(/,A)' )  ' LAYER   PHASE FUNCTION MOMENTS'
         DO 20 LC = 1, NLYR
            IF( SSALB(LC).GT.0.0D0 )
     $          WRITE( 3,1300 )  LC, ( PMOM(K,LC), K = 0, NSTR )
 20      CONTINUE
      ENDIF
C
      RETURN
C
1010  FORMAT ( /, ' NO. STREAMS =', I4,
     $  '     NO. COMPUTATIONAL LAYERS =', I4 )
1030  FORMAT( I4,' USER OPTICAL DEPTHS :',10F10.4, /, (26X,10F10.4) )
1040  FORMAT( I4,' USER POLAR ANGLE COSINES :',10F9.5,/,(31X,10F9.5) )
1050  FORMAT( I4,' USER AZIMUTHAL ANGLES :', 10F9.2, /, (28X,10F9.2) )
1055  FORMAT( ' BOUNDARY CONDITION FLAG: IBCND =', I2 )
1060  FORMAT( '    INCIDENT BEAM WITH INTENSITY =', 1P,E11.3, ' AND',
     $ ' POLAR ANGLE COSINE = ', 0P,F8.5,'  AND AZIMUTH ANGLE =', F7.2,
     $ /,'    PLUS ISOTROPIC INCIDENT INTENSITY =', 1P,E11.3 )
1070  FORMAT( '    ISOTROPIC ILLUMINATION FROM TOP AND BOTTOM OF',
     $   ' INTENSITY =', 1P,E11.3 )
1080  FORMAT( '    BOTTOM ALBEDO (LAMBERTIAN) =', 0P,F8.4 )
1090  FORMAT( '    LEGENDRE COEFFS OF BOTTOM BIDIRECTIONAL',
     $ ' REFLECTIVITY :', /, (10X,10F9.5) )
1100  FORMAT( ' NO THERMAL EMISSION' )
1110  FORMAT( '    THERMAL EMISSION IN WAVENUMBER INTERVAL :', 2F14.4,/,
     $   '    BOTTOM TEMPERATURE =', F10.2, '     TOP TEMPERATURE =',
     $   F10.2,'    TOP EMISSIVITY =', F8.4 )
1120  FORMAT( ' USES DELTA-M METHOD' )
1130  FORMAT( ' DOES NOT USE DELTA-M METHOD' )
1135  FORMAT( ' CALCULATE ALBEDO AND TRANSMISSIVITY OF MEDIUM',
     $   ' VS. INCIDENT BEAM ANGLE' )
1140  FORMAT( ' CALCULATE FLUXES AND AZIM-AVERAGED INTENSITIES ONLY' )
1150  FORMAT( ' CALCULATE FLUXES AND INTENSITIES' )
1160  FORMAT( ' RELATIVE CONVERGENCE CRITERION FOR AZIMUTH SERIES =',
     $   1P,E11.2 )
1170  FORMAT( ' SETS RADIATION = 0 BELOW ABSORPTION OPTICAL DEPTH 10' )
1190  FORMAT( /, 37X, '<------------- DELTA-M --------------->', /,
     $'                   TOTAL    SINGLE                           ',
     $               'TOTAL    SINGLE', /,
     $'       OPTICAL   OPTICAL   SCATTER   TRUNCATED   ',
     $   'OPTICAL   OPTICAL   SCATTER    ASYMM', /,
     $'         DEPTH     DEPTH    ALBEDO    FRACTION     ',
     $     'DEPTH     DEPTH    ALBEDO   FACTOR   TEMPERATURE' )
1191  FORMAT( /, 37X, '<------------- DELTA-M --------------->', /,
     $'                   TOTAL    SINGLE                           ',
     $               'TOTAL    SINGLE', /,
     $'       OPTICAL   OPTICAL   SCATTER   TRUNCATED   ',
     $   'OPTICAL   OPTICAL   SCATTER    ASYMM', /,
     $'         DEPTH     DEPTH    ALBEDO    FRACTION     ',
     $     'DEPTH     DEPTH    ALBEDO   FACTOR' )
1200  FORMAT( I4, 2F10.4, F10.5, F12.5, 2F10.4, F10.5, F9.4,F14.3 )
1210  FORMAT( 85X, F14.3 )
1300  FORMAT( I6, 10F11.6, /, (6X,10F11.6) )
C
      END
C**********************************************************************      
      SUBROUTINE  PRTINT( UU, UTAU, NTAU, UMU, NUMU, PHI, NPHI,
     $                    MAXULV, MAXUMU )
C
C         PRINTS THE INTENSITY AT USER POLAR AND AZIMUTHAL ANGLES
C
C     ALL ARGUMENTS ARE DISORT INPUT OR OUTPUT VARIABLES
C
C+---------------------------------------------------------------------+

      REAL*8 PHI(*), UMU(*), UTAU(*), UU( MAXUMU, MAXULV, * )
C
C
      WRITE ( 3, '(a)') char(12)
      WRITE ( 3, '(A)' )
     $         ' *********  I N T E N S I T I E S  *********'
      LENFMT = 10
      NPASS = 1 + NPHI / LENFMT
      IF ( MOD(NPHI,LENFMT) .EQ. 0 )  NPASS = NPASS - 1
      DO 10  LU = 1, NTAU
         DO 10  NP = 1, NPASS
            JMIN = 1 + LENFMT * (NP-1)
            JMAX = MIN0( LENFMT*NP, NPHI )
            WRITE( 3,101 )  ( PHI(J), J = JMIN, JMAX )
            DO 10  IU = 1, NUMU
               IF( IU.EQ.1 )  WRITE( 3,102 )  UTAU(LU), UMU(IU),
     $           ( UU( IU,LU,J ), J = JMIN, JMAX )
               IF( IU.GT.1 )  WRITE( 3,103 )  UMU(IU),
     $           ( UU( IU,LU,J ), J = JMIN, JMAX )
10    CONTINUE
C
      RETURN
C
101   FORMAT( /, 3X,'          POLAR   AZIMUTH ANGLES (DEGREES)',
     $        /, 3X,'OPTICAL   ANGLE',
     $        /, 3X,' DEPTH   COSINE', 10(F10.1,4X) )
102   FORMAT( /,0p, f10.3, f8.4, 1p, 10e14.5)
103   FORMAT( 10x, 0p,     f8.4, 1p, 10e14.5)

      END
C**********************************************************************
      SUBROUTINE  QGAUSN( M, GMU, GWT )
C
C       COMPUTE WEIGHTS AND ABSCISSAE FOR ORDINARY GAUSSIAN QUADRATURE
C       (NO WEIGHT FUNCTION INSIDE INTEGRAL) ON THE INTERVAL (0,1)
C
C       REFERENCE:  Davis, P.J. and P. Rabinowitz, Methods of Numerical
C                   Integration, Academic Press, New York, pp. 87, 1975.
C
C          METHOD:  Compute the abscissae as roots of the Legendre
C                   Polynomial P-SUB-N using a cubically convergent
C                   refinement of Newton's method.  Compute the
C                   weights from EQ. 2.7.3.8 of Davis/Rabinowitz.
C
C        ACCURACY:  at least 13 significant digits
C
C
C  I N P U T :    M       ORDER OF QUADRATURE RULE
C
C  O U T P U T :  GMU(I)  I = 1 TO M,    ARRAY OF ABSCISSAE
C                 GWT(I)  I = 1 TO M,    ARRAY OF WEIGHTS
C
C  I N T E R N A L    V A R I A B L E S:
C
C    PM2,PM1,P : 3 SUCCESSIVE LEGENDRE POLYNOMIALS
C    PPR       : DERIVATIVE OF LEGENDRE POLYNOMIAL
C    P2PRI     : 2ND DERIVATIVE OF LEGENDRE POLYNOMIAL
C    TOL       : CONVERGENCE CRITERION FOR LEGENDRE POLY ROOT ITERATION
C    X,XI      : SUCCESSIVE ITERATES IN CUBICALLY-
C                CONVERGENT VERSION OF NEWTON'S METHOD
C                ( SEEKING ROOTS OF LEGENDRE POLYNOMIAL )
C+---------------------------------------------------------------------+
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8 CONA, GMU(*), GWT(*), PI, T
      INTEGER  LIM, M, NP1
      DOUBLE   PRECISION  EN, NNP1, P, PM1, PM2, PPR, P2PRI, PROD,
     $                    TMP, TOL, X, XI
      DATA     PI / 0.0D0 /
C
C
      IF ( PI.EQ.0.0D0 )  THEN
         PI = 2.0D0 * DASIN(1.d0)
C         TOL = 10.0D0 * 5.96D-08
         TOL = 10.0D0 * 2.22D-16		!10 X EPS - CODY(1988)
      END IF
C
      IF ( M.LE.1 )  THEN
         M = 1
         GMU( 1 ) = 0.5D0
         GWT( 1 ) = 1.0D0
         RETURN
      END IF
C
      EN   = M
      NP1  = M + 1
      NNP1 = M * NP1
      CONA = DBLE( M-1 ) / ( 8 * M**3 )
C                                        ** INITIAL GUESS FOR K-TH ROOT
C                                        ** OF LEGENDRE POLYNOMIAL, FROM
C                                        ** DAVIS/RABINOWITZ (2.7.3.3A)
      LIM  = M / 2
      DO 30  K = 1, LIM
         T = ( 4*K - 1 ) * PI / ( 4*M + 2 )
         X = DCOS ( T + CONA / DTAN( T ) )
C                                        ** RECURSION RELATION FOR
C                                        ** LEGENDRE POLYNOMIALS
10       PM2 = 1.D0
         PM1 = X
         DO 20 NN = 2, M
            P   = ( ( 2*NN - 1 ) * X * PM1 - ( NN-1 ) * PM2 ) / NN
            PM2 = PM1
            PM1 = P
20       CONTINUE
C
         TMP   = 1.D0 / ( 1.D0 - X**2 )
         PPR   = EN * ( PM2 - X * P ) * TMP
         P2PRI = ( 2.D0 * X * PPR - NNP1 * P ) * TMP
         XI    = X - ( P / PPR ) * ( 1.D0 +
     $               ( P / PPR ) * P2PRI / ( 2.D0 * PPR ) )
C
C                                              ** CHECK FOR CONVERGENCE
         IF ( DABS(XI-X) .GT. TOL ) THEN
            X = XI
            GO TO 10
         END IF
C                          ** ITERATION FINISHED--CALC. WEIGHTS,
C                          ** ABSCISSAE FOR (-1,1)
         GMU( K ) = - X
         GWT( K ) = 2.D0 / ( TMP * ( EN * PM2 )**2 )
         GMU( NP1 - K ) = - GMU( K )
         GWT( NP1 - K ) =   GWT( K )
30    CONTINUE
C                                    ** SET MIDDLE ABSCISSA AND WEIGHT
C                                    ** FOR RULES OF ODD ORDER
      IF ( MOD( M,2 ) .NE. 0 )  THEN
         GMU( LIM + 1 ) = 0.0D0
         PROD = 1.D0
         DO 40 K = 3, M, 2
            PROD = PROD * K / ( K-1 )
40       CONTINUE
         GWT( LIM + 1 ) = 2.D0 / PROD**2
      END IF
C                                        ** CONVERT FROM (-1,1) TO (0,1)
      DO 50  K = 1, M
         GMU( K ) = 0.5D0 * GMU( K ) + 0.5D0
         GWT( K ) = 0.5D0 * GWT( K )
50    CONTINUE
C
      RETURN
      END
C**********************************************************************
      REAL*8 FUNCTION  RATIO( A, B )
C
C        CALCULATE RATIO  A/B  WITH OVER- AND UNDER-FLOW PROTECTION
C
	REAL*8 A, B, EPSIL
	EPSIL = 2.22D-16
	
         IF ( DABS(A).LT.1.0D-8 .AND. DABS(B).LT.1.0D-8 )  THEN
            RATIO = 1.0D0
         ELSE IF ( B. LT. EPSIL )  THEN
            RATIO = 1.D+20
         ELSE
            RATIO = A / B
         END IF
C
      RETURN
      END
C**********************************************************************      
      SUBROUTINE  SETDIS( CMU, CWT, DELTAM, DTAUC, EXPBEA, FBEAM, FLYR,
     $                    GL, HL, HLPR, IBCND, LAMBER, LAYRU, LYRCUT, 
     $                    MAXUMU, MAXCMU, MXCMU, NCUT, NLYR, NTAU, NN, 
     $                    NSTR, NOPLNK, NUMU, ONLYFL, OPRIM, PMOM,SSALB,
     $                    TAUC, TAUCPR, UTAU, UTAUPR, UMU, UMU0, USRTAU,
     $                    USRANG )
C
C          PERFORM MISCELLANEOUS SETTING-UP OPERATIONS
C
C       ROUTINES CALLED:  ERRMSG, QGAUSN, ZEROIT
C
C       INPUT :  ALL ARE 'DISORT' INPUT VARIABLES (SEE DOC FILE)
C
C       OUTPUT:  NTAU,UTAU   IF USRTAU = FALSE
C                NUMU,UMU    IF USRANG = FALSE
C                CMU,CWT     COMPUTATIONAL POLAR ANGLES AND
C                               CORRESPONDING QUADRATURE WEIGHTS
C                EXPBEA      TRANSMISSION OF DIRECT BEAM
C                FLYR        TRUNCATED FRACTION IN DELTA-M METHOD
C                GL          PHASE FUNCTION LEGENDRE COEFFICIENTS MULTI-
C                              PLIED BY (2L+1) AND SINGLE-SCATTER ALBEDO
C                HLPR        LEGENDRE MOMENTS OF SURFACE BIDIRECTIONAL
C                              REFLECTIVITY, TIMES 2K+1
C                LAYRU       COMPUTATIONAL LAYER IN WHICH -UTAU- FALLS
C                LYRCUT      FLAG AS TO WHETHER RADIATION WILL BE ZEROED
C                              BELOW LAYER -NCUT-
C                NCUT        COMPUTATIONAL LAYER WHERE ABSORPTION
C                              OPTICAL DEPTH FIRST EXCEEDS 10
C                NN          NSTR / 2
C                OPRIM       DELTA-M-SCALED SINGLE-SCATTER ALBEDO
C                TAUCPR      DELTA-M-SCALED OPTICAL DEPTH
C                UTAUPR      DELTA-M-SCALED VERSION OF -UTAU-
C
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL  DELTAM, LAMBER, LYRCUT, NOPLNK, ONLYFL, USRTAU, USRANG
      INTEGER  LAYRU(*)

      REAL*8   CMU(*), CWT(*), DTAUC(*), EXPBEA(0:*), FLYR(*),
     $         GL(0:MXCMU,*), HL(0:*), HLPR(0:*), OPRIM(*),
     $         PMOM(0:MAXCMU,*), SSALB(*), TAUC(0:*), TAUCPR(0:*),
     $         UTAU(*), UTAUPR(*), UMU(*)
C
C
      IF ( .NOT.USRTAU ) THEN
C                              ** SET OUTPUT LEVELS AT COMPUTATIONAL
C                              ** LAYER BOUNDARIES
         NTAU = NLYR + 1
         DO 30  LC = 0, NTAU-1
            UTAU(LC+1) = TAUC(LC)
30       CONTINUE
      END IF
C                        ** APPLY DELTA-M SCALING AND MOVE DESCRIPTION
C                        ** OF COMPUTATIONAL LAYERS TO LOCAL VARIABLES
      EXPBEA( 0 ) = 1.0D0
      CALL  ZEROIT( TAUCPR(0), MXCLY+1 )
      CALL  ZEROIT( EXPBEA(1), MXCLY )
      CALL  ZEROIT( FLYR, MXCLY )
      CALL  ZEROIT( GL, (MXCMU+1)*MXCLY )
      CALL  ZEROIT( OPRIM, MXCLY )
      ABSTAU = 0.0D0
      DO  60  LC = 1, NLYR
         PMOM(0,LC) = 1.0D0
         IF ( ABSTAU.LT.10.0D0 )  NCUT = LC
         ABSTAU = ABSTAU + ( 1. - SSALB(LC) ) * DTAUC(LC)
C
         IF ( .NOT.DELTAM )  THEN
            OPRIM(LC) = SSALB(LC)
            TAUCPR(LC) = TAUC(LC)
            DO 40  K = 0, NSTR-1
               GL(K,LC) = (2*K+1) * OPRIM(LC) * PMOM(K,LC)
 40         CONTINUE
            F = 0.0D0
         ELSE
C                                    ** DO DELTA-M TRANSFORMATION
            F = PMOM( NSTR,LC )
            OPRIM(LC) = SSALB(LC) * (1.D0-F)/(1.D0-F* SSALB(LC))
            TAUCPR(LC) = TAUCPR(LC-1) + (1.D0-F*SSALB(LC) )* DTAUC(LC)
            DO 50  K = 0, NSTR-1
               GL(K,LC) = (2*K+1)*OPRIM(LC)*(PMOM(K,LC)-F)/(1.D0-F)
 50         CONTINUE
         ENDIF
         FLYR(LC) = F
         EXPBEA(LC) = 0.0D0
         IF ( FBEAM.GT.0.D0 )  EXPBEA(LC) = DEXP( - TAUCPR(LC) / UMU0 )
C
60    CONTINUE
C                      ** IF NO THERMAL EMISSION, CUT OFF MEDIUM BELOW
C                      ** ABSORPTION OPTICAL DEPTH = 10 ( NOTE THAT
C                      ** DELTA-M TRANSFORMATION LEAVES ABSORPTION
C                      ** OPTICAL DEPTH INVARIANT ).  NOT WORTH THE
C                      ** TROUBLE FOR ONE-LAYER PROBLEMS, THOUGH.
      LYRCUT = .false.
      IF ( ABSTAU.GE.10.0D0 .AND. NOPLNK .AND. IBCND.NE.1
     $     .AND. NLYR.GT.1 )  LYRCUT =.TRUE.
      IF( .NOT.LYRCUT )  NCUT = NLYR
C
C                             ** SET ARRAYS DEFINING LOCATION OF USER
C                             ** OUTPUT LEVELS WITHIN DELTA-M-SCALED
C                             ** COMPUTATIONAL MESH
      DO 90  LU = 1, NTAU
         DO 70 LC = 1, NLYR
            IF ( UTAU(LU).GE.TAUC(LC-1) .AND. UTAU(LU).LE.TAUC(LC) )
     $           GO TO 80
70       CONTINUE
         LC = NLYR
C
80       UTAUPR(LU) = UTAU(LU)
         IF(DELTAM) UTAUPR(LU) = TAUCPR(LC-1)+(1.D0-SSALB(LC)*FLYR(LC))
     $                                        * (UTAU(LU) - TAUC(LC-1))
         LAYRU(LU) = LC
90    CONTINUE
C                      ** CALCULATE COMPUTATIONAL POLAR ANGLE COSINES
C                      ** AND ASSOCIATED QUADRATURE WEIGHTS FOR GAUSSIAN
C                      ** QUADRATURE ON THE INTERVAL (0,1) (UPWARD)
      NN = NSTR / 2
      CALL  QGAUSN( NN, CMU, CWT )
C                                  ** DOWNWARD (NEG) ANGLES AND WEIGHTS
      DO 100  IQ = 1, NN
         CMU(IQ+NN) = - CMU(IQ)
         CWT(IQ+NN) =   CWT(IQ)
100   CONTINUE
C
      IF ( FBEAM.GT.0.0D0 )  THEN
C                               ** COMPARE BEAM ANGLE TO COMPU'L ANGLES
         DO 110  IQ = 1, NN
            IF ( DABS(UMU0-CMU(IQ))/UMU0 .LT. 1.D-4 )  CALL ERRMSG
     $         ( 'SETDIS--BEAM ANGLE=COMPUTATIONAL ANGLE; CHANGE NSTR',
     $            .TRUE. )
  110    CONTINUE
      END IF
C
      IF ( .NOT.USRANG .OR. (ONLYFL .AND. MAXUMU.GE.NSTR) )  THEN
C
C                                   ** SET OUTPUT POLAR ANGLES TO
C                                   ** COMPUTATIONAL POLAR ANGLES
            NUMU = NSTR
            DO 120  IU = 1, NN
               UMU(IU) = - CMU(NN+1-IU)
120         CONTINUE
            DO 121  IU = NN+1, NSTR
               UMU(IU) = CMU(IU-NN)
121         CONTINUE
      END IF
C
      IF ( USRANG .AND. IBCND.EQ.1 )  THEN
C
C                               ** SHIFT POSITIVE USER ANGLE COSINES TO
C                               ** UPPER LOCATIONS AND PUT NEGATIVES
C                               ** IN LOWER LOCATIONS
         DO 140  IU = 1, NUMU
            UMU(IU+NUMU) = UMU(IU)
140      CONTINUE
         DO 141  IU = 1, NUMU
            UMU(IU) = - UMU( 2*NUMU+1-IU)
141      CONTINUE
         NUMU = 2*NUMU
      END IF
C
      IF ( .NOT.LYRCUT .AND. .NOT.LAMBER )  THEN
         DO 160  K = 0, NSTR
            HLPR(K) = (2*K+1) * HL(K)
160      CONTINUE
      END IF
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SETMTX( BDR, CBAND, CMU, CWT, DELM0, GC, KK, LAMBER,
     $                    LYRCUT, MI, MI9M2, MXCMU, NCOL, NCUT, NNLYRI,
     $                    NN, NSTR, TAUCPR, WK )
C
C        CALCULATE COEFFICIENT MATRIX FOR THE SET OF EQUATIONS
C        OBTAINED FROM THE BOUNDARY CONDITIONS AND THE CONTINUITY-
C        OF-INTENSITY-AT-LAYER-INTERFACE EQUATIONS;  STORE IN THE
C        SPECIAL BANDED-MATRIX FORMAT REQUIRED BY LINPACK ROUTINES
C
C     ROUTINES CALLED:  ZEROIT
C
C     I N P U T      V A R I A B L E S:
C
C       BDR      :  SURFACE BIDIRECTIONAL REFLECTIVITY
C       CMU      :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT      :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       DELM0    :  KRONECKER DELTA, DELTA-SUB-M0
C       GC       :  EIGENVECTORS AT POLAR QUADRATURE ANGLES, SC(1)
C       KK       :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       LYRCUT   :  LOGICAL FLAG FOR TRUNCATION OF COMPUT. LAYER
C       NN       :  NUMBER OF STREAMS IN A HEMISPHERE (NSTR/2)
C       NCUT     :  TOTAL NUMBER OF COMPUTATIONAL LAYERS CONSIDERED
C       TAUCPR   :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T     V A R I A B L E S:
C
C       CBAND    :  LEFT-HAND SIDE MATRIX OF LINEAR SYSTEM EQ. SC(5),
C                   SCALED BY EQ. SC(12); IN BANDED FORM REQUIRED
C                   BY LINPACK SOLUTION ROUTINES
C       NCOL     :  COUNTS OF COLUMNS IN -CBAND-
C
C   I N T E R N A L    V A R I A B L E S:
C
C       IROW     :  POINTS TO ROW IN  -CBAND-
C       JCOL     :  POINTS TO POSITION IN LAYER BLOCK
C       LDA      :  ROW DIMENSION OF -CBAND-
C       NCD      :  NUMBER OF DIAGONALS BELOW OR ABOVE MAIN DIAGONAL
C       NCOL     :  COUNTS OF COLUMNS IN -CBAND-
C       NSHIFT   :  FOR POSITIONING NUMBER OF ROWS IN BAND STORAGE
C       WK       :  TEMPORARY STORAGE FOR 'EXP' EVALUATIONS
C ---------------------------------------------------------------------+
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL LAMBER, LYRCUT

      REAL*8  BDR( MI,0:* ), CBAND( MI9M2,NNLYRI ), CMU(*), CWT(*),
     $        GC( MXCMU,MXCMU,* ), KK( MXCMU,* ), TAUCPR( 0:* ), WK(*)
C
C
      CALL  ZEROIT( CBAND, MI9M2*NNLYRI )
      NCD    = 3*NN - 1
      LDA    = 3*NCD + 1
      NSHIFT = LDA - 2*NSTR + 1
      NCOL   = 0
C                         ** USE CONTINUITY CONDITIONS OF EQ. STWJ(17)
C                         ** TO FORM COEFFICIENT MATRIX IN STWJ(20);
C                         ** EMPLOY SCALING TRANSFORMATION STWJ(22)
      DO 30  LC = 1, NCUT
C
         DO 4  IQ = 1, NN
            WK(IQ) = DEXP( KK(IQ,LC) * (TAUCPR(LC) - TAUCPR(LC-1)) )
 4       CONTINUE
C
         JCOL = 0
         DO 10  IQ = 1, NN
            NCOL = NCOL + 1
            IROW = NSHIFT - JCOL
            DO 5  JQ = 1, NSTR
               CBAND(IROW+NSTR,NCOL) =   GC(JQ,IQ,LC)
               CBAND(IROW,     NCOL) = - GC(JQ,IQ,LC) * WK(IQ)
               IROW = IROW + 1
 5          CONTINUE
            JCOL = JCOL + 1
10       CONTINUE
C
         DO 20  IQ = NN+1, NSTR
            NCOL = NCOL + 1
            IROW = NSHIFT - JCOL
            DO 15  JQ = 1, NSTR
               CBAND(IROW+NSTR,NCOL) =   GC(JQ,IQ,LC) * WK(NSTR+1-IQ)
               CBAND(IROW,     NCOL) = - GC(JQ,IQ,LC)
               IROW = IROW + 1
15          CONTINUE
            JCOL = JCOL + 1
20       CONTINUE
C
30    CONTINUE
C                  ** USE TOP BOUNDARY CONDITION OF STWJ(20A) FOR
C                  ** FIRST LAYER
      JCOL = 0
      DO 40  IQ = 1, NN
         EXPA = DEXP( KK(IQ,1) * TAUCPR(1) )
         IROW = NSHIFT - JCOL + NN
         DO 35  JQ = NN, 1, -1
            CBAND(IROW,JCOL+1) = GC(JQ,IQ,1) * EXPA
            IROW = IROW+1
35       CONTINUE
         JCOL = JCOL+1
40    CONTINUE
C
      DO 50  IQ = NN+1, NSTR
         IROW = NSHIFT - JCOL + NN
         DO 45  JQ = NN, 1, -1
            CBAND(IROW,JCOL+1) = GC(JQ,IQ,1)
            IROW = IROW+1
45       CONTINUE
         JCOL = JCOL+1
50    CONTINUE
C                           ** USE BOTTOM BOUNDARY CONDITION OF
C                           ** STWJ(20C) FOR LAST LAYER
      NNCOL = NCOL - NSTR
      JCOL  = 0
      DO 70  IQ = 1, NN
         NNCOL = NNCOL + 1
         IROW  = NSHIFT - JCOL + NSTR
C
         DO 60  JQ = NN+1, NSTR
            IF ( LYRCUT .OR. (LAMBER .AND. DELM0.EQ.0) ) THEN
C
C                          ** NO AZIMUTHAL-DEPENDENT INTENSITY IF LAM-
C                          ** BERT SURFACE; NO INTENSITY COMPONENT IF
C                          ** TRUNCATED BOTTOM LAYER
C
               CBAND(IROW,NNCOL) = GC(JQ,IQ,NCUT)
            ELSE
               SUM = 0.0D0
               DO 55  K = 1, NN
                  SUM = SUM + CWT(K) * CMU(K) * BDR(JQ-NN,K)
     $                        * GC(NN+1-K,IQ,NCUT)
55             CONTINUE
               CBAND(IROW,NNCOL) = GC(JQ,IQ,NCUT) - (1.D0+DELM0) * SUM
            END IF
C
            IROW = IROW + 1
60       CONTINUE
         JCOL = JCOL + 1
70    CONTINUE
C
      DO 90  IQ = NN+1, NSTR
         NNCOL = NNCOL + 1
         IROW  = NSHIFT - JCOL + NSTR
         EXPA = WK(NSTR+1-IQ)
C
         DO 80  JQ = NN+1, NSTR
C
            IF ( LYRCUT .OR. (LAMBER .AND. DELM0.EQ.0) ) THEN
               CBAND(IROW,NNCOL) = GC(JQ,IQ,NCUT) * EXPA
            ELSE
               SUM = 0.0D0
               DO 75  K = 1, NN
                  SUM = SUM + CWT(K) * CMU(K) * BDR(JQ-NN,K)
     $                        * GC(NN+1-K,IQ,NCUT)
75             CONTINUE
               CBAND(IROW,NNCOL) = ( GC(JQ,IQ,NCUT)
     $                               - (1.D0+DELM0) * SUM ) * EXPA
            END IF
C
            IROW = IROW + 1
80       CONTINUE
         JCOL = JCOL + 1
90    CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SLFTST( ACCUR, ALBEDO, BTEMP, DELTAM, DTAUC, FBEAM,
     $                    FISOT, IBCND, LAMBER, NLYR, NOPLNK, NPHI,
     $                    NUMU, NSTR, NTAU, ONLYFL, PHI, PHI0, PMOM,
     $                    PRNT, SSALB, TEMIS, TEMPER, TTEMP, UMU,
     $                    USRANG, USRTAU, UTAU, UMU0, WVNMHI, WVNMLO,
     $                    COMPAR, FLUP, RFLDIR, RFLDN, UU)
C
C       IF  COMPAR = FALSE, SAVE USER INPUT VALUES THAT WOULD OTHERWISE
C       BE DESTROYED AND REPLACE THEM WITH INPUT VALUES FOR SELF-TEST.
C       IF  COMPAR = TRUE, COMPARE SELF-TEST CASE RESULTS WITH CORRECT
C       ANSWERS AND RESTORE USER INPUT VALUES IF TEST IS PASSED.
C
C       (SEE FILE 'DISORT.DOC' FOR VARIABLE DEFINITIONS.)
C
C       I N T E R N A L    V A R I A B L E S:
C
C         ACC     RELATIVE ACCURACY REQUIRED FOR PASSING SELF-TEST
C         ERRORn  RELATIVE ERRORS IN 'DISORT' OUTPUT VARIABLES
C         OK      LOGICAL VARIABLE FOR DETERMINING FAILURE OF SELF-TEST
C+---------------------------------------------------------------------+
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8   PMOM( 0:* ), TEMPER( 0:* )
      LOGICAL  COMPAR, DELTAM, LAMBER, NOPLNK, OK, ONLYFL,
     $         PRNT(*), USRANG, USRTAU
      DATA     ACC / 1.D-4 /
C
C
      IF  ( .NOT.COMPAR )  THEN
C                                              ** SAVE USER INPUT VALUES
C
         WRITE ( 99, *, ERR=990 )  ACCUR, ALBEDO, BTEMP, DELTAM, DTAUC,
     $           FBEAM, FISOT, IBCND, LAMBER, NLYR, NOPLNK, NPHI,
     $           NUMU, NSTR, NTAU, ONLYFL, PHI, PHI0,
     $           ( PMOM(K), K = 0, 4 ), ( PRNT(I), I = 1, 7 ),
     $           SSALB, TEMIS, ( TEMPER(I), I = 0, 1 ), TTEMP,
     $           USRANG, USRTAU, UTAU, UMU, UMU0, WVNMHI, WVNMLO

C
C                                     ** SET INPUT VALUES FOR SELF-TEST
         NLYR = 1
         DTAUC = 1.0D0
         SSALB = 0.9D0
C                          ** HAZE L MOMENTS
         PMOM(0) = 1.0D0
         PMOM(1) = 0.8042D0
         PMOM(2) = 0.646094D0
         PMOM(3) = 0.481851D0
         PMOM(4) = 0.359056D0
         NSTR = 4
         USRANG = .TRUE.
         NUMU  = 1
         UMU  = 0.5D0
         USRTAU = .TRUE.
         NTAU = 1
         UTAU  = 0.5D0
         NPHI = 1
         PHI  = 90.0D0
         IBCND = 0
         FBEAM = 3.14159265D0
         UMU0 = 0.866D0
         PHI0 = 0.0D0
         FISOT  = 1.0D0
         LAMBER = .TRUE.
         ALBEDO = 0.7D0
         DELTAM = .TRUE.
         ONLYFL = .FALSE.
         ACCUR = 0.005D0
         NOPLNK = .false.
         WVNMLO = 0.0D0
         WVNMHI = 50000.0D0
         BTEMP = 300.0D0
         TTEMP = 100.0D0
         TEMIS = 0.8D0
         TEMPER( 0 ) = 210.0D0
         TEMPER( 1 ) = 200.0D0
         DO 1 I = 1, 7
            PRNT( I ) = .FALSE.
    1    CONTINUE
C
      ELSE
C                                    ** COMPARE TEST CASE RESULTS WITH
C                                    ** CORRECT ANSWERS AND ABORT IF BAD
         OK = .TRUE.
         ERROR1 = ( UU  - 47.86005D0 ) / 47.86005D0
         ERROR2 = ( RFLDIR - 1.527286D0 ) / 1.527286D0
         ERROR3 = ( RFLDN - 28.37223D0 ) / 28.37223D0
         ERROR4 = ( FLUP   - 152.5853D0 ) / 152.5853D0
         IF( DABS(ERROR1).GT.ACC ) CALL TSTBAD( 'UU',     ERROR1, OK )
         IF( DABS(ERROR2).GT.ACC ) CALL TSTBAD( 'RFLDIR', ERROR2, OK )
         IF( DABS(ERROR3).GT.ACC ) CALL TSTBAD( 'RFLDN',  ERROR3, OK )
         IF( DABS(ERROR4).GT.ACC ) CALL TSTBAD( 'FLUP',   ERROR4, OK )
C
         IF( .NOT. OK )
     $       CALL ERRMSG( 'DISORT--SELF-TEST FAILED', .TRUE. )
C
C                                           ** RESTORE USER INPUT VALUES
         REWIND 99
         READ ( 99, *, ERR=995, END=996 )
     $           ACCUR, ALBEDO, BTEMP, DELTAM, DTAUC,
     $           FBEAM, FISOT, IBCND, LAMBER, NLYR, NOPLNK, NPHI,
     $           NUMU, NSTR, NTAU, ONLYFL, PHI, PHI0,
     $           ( PMOM(K), K = 0, 4 ), ( PRNT(I), I = 1, 7 ),
     $           SSALB, TEMIS, ( TEMPER(I), I = 0, 1 ), TTEMP,
     $           USRANG, USRTAU, UTAU, UMU, UMU0, WVNMHI, WVNMLO
      END IF
C
      RETURN
C
  990 CALL ERRMSG( 'SLFTST--ERROR SAVING USER INPUT BEFORE SELF-TEST',
     $             .TRUE. )
  995 CALL ERRMSG( 'SLFTST--ERROR READING USER INPUT AFTER SELF-TEST',
     $             .TRUE. )
  996 CALL ERRMSG( 'SLFTST--EOF READING USER INPUT AFTER SELF-TEST',
     $             .TRUE. )
      END
C**********************************************************************      
      SUBROUTINE  SOLEIG( AMB, APB, ARRAY, CMU, CWT, GL, MI, MAZ,
     $                    MXCMU, NN, NSTR, WK, YLMC, CC, EVECC, EVAL,
     $                    KK, GC, AD, WKD, EVECCD, EVALD )
C
C         SOLVES EIGENVALUE/VECTOR PROBLEM NECESSARY TO CONSTRUCT
C         HOMOGENEOUS PART OF DISCRETE ORDINATE SOLUTION; STWJ(8B)
C         ** NOTE ** EIGENVALUE PROBLEM IS DEGENERATE WHEN SINGLE
C                    SCATTERING ALBEDO = 1;  PRESENT WAY OF DOING IT
C                    SEEMS NUMERICALLY MORE STABLE THAN ALTERNATIVE
C                    METHODS THAT WE TRIED
C
C     ROUTINES CALLED:  ASYMTX
C
C   I N P U T     V A R I A B L E S:
C
C       GL     :  DELTA-M SCALED LEGENDRE COEFFICIENTS OF PHASE FUNCTION
C                    (INCLUDING FACTORS 2L+1 AND SINGLE-SCATTER ALBEDO)
C       CMU    :  COMPUTATIONAL POLAR ANGLE COSINES
C       CWT    :  WEIGHTS FOR QUADRATURE OVER POLAR ANGLE COSINE
C       MAZ    :  ORDER OF AZIMUTHAL COMPONENT
C       NN     :  HALF THE TOTAL NUMBER OF STREAMS
C       YLMC   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE QUADRATURE ANGLES -CMU-
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T    V A R I A B L E S:
C
C       CC     :  CAPITAL-C-SUB-IJ IN EQ. SS(5); NEEDED IN SS(15&18)
C       EVAL   :  -NN- EIGENVALUES OF EQ. SS(12) ON RETURN FROM 'ASYMTX'
C                    BUT THEN SQUARE ROOTS TAKEN
C       EVECC  :  -NN- EIGENVECTORS  (G+) - (G-)  ON RETURN
C                    FROM 'ASYMTX' ( COLUMN J CORRESPONDS TO -EVAL(J)- )
C                    BUT THEN  (G+) + (G-)  IS CALCULATED FROM SS(10),
C                    G+  AND  G-  ARE SEPARATED, AND  G+  IS STACKED ON
C                    TOP OF  G-  TO FORM -NSTR- EIGENVECTORS OF SS(7)
C       GC     :  PERMANENT STORAGE FOR ALL -NSTR- EIGENVECTORS, BUT
C                    IN AN ORDER CORRESPONDING TO -KK-
C       KK     :  PERMANENT STORAGE FOR ALL -NSTR- EIGENVALUES OF SS(7),
C                    BUT RE-ORDERED WITH NEGATIVE VALUES FIRST ( SQUARE
C                    ROOTS OF -EVAL- TAKEN AND NEGATIVES ADDED )
C
C   I N T E R N A L   V A R I A B L E S:
C
C       AMB,APB :  MATRICES (ALPHA-BETA), (ALPHA+BETA) IN REDUCED
C                    EIGENVALUE PROBLEM
C       ARRAY   :  COMPLETE COEFFICIENT MATRIX OF REDUCED EIGENVALUE
C                    PROBLEM: (ALFA+BETA)*(ALFA-BETA)
C       GPPLGM  :  (G+) + (G-) (CF. EQS. SS(10-11))
C       GPMIGM  :  (G+) - (G-) (CF. EQS. SS(10-11))
C       WK      :  SCRATCH ARRAY REQUIRED BY 'ASYMTX'
C+---------------------------------------------------------------------+
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8  AMB( MI,* ), APB( MI,* ), ARRAY( MI,* ), CC( MXCMU,* ),
     $        CMU(*), CWT(*), EVAL(*), EVECC( MXCMU,* ), GC( MXCMU,* ),
     $        GL(0:*), KK(*), WK(*), YLMC( 0:MXCMU,* )
      REAL*8  EVECCD( MI,* ), EVALD(*), WKD(*), AD( MI,* )
C
C
C                             ** CALCULATE QUANTITIES IN EQS. SS(5-6)
      DO 40 IQ  = 1, NN
C
         DO 20  JQ = 1, NSTR
            SUM = 0.0D0
            DO 10  L = MAZ, NSTR-1
               SUM = SUM + GL(L) * YLMC(L,IQ) * YLMC(L,JQ)
10          CONTINUE
            CC(IQ,JQ) = 0.5D0 * SUM * CWT(JQ)
20       CONTINUE
C
         DO 30  JQ = 1, NN
C                             ** FILL REMAINDER OF ARRAY USING SYMMETRY
C                             ** RELATIONS  C(-MUI,MUJ) = C(MUI,-MUJ)
C                             ** AND        C(-MUI,-MUJ) = C(MUI,MUJ)
C
            CC(IQ+NN,JQ) = CC(IQ,JQ+NN)
            CC(IQ+NN,JQ+NN) = CC(IQ,JQ)
C                                      ** GET FACTORS OF COEFF. MATRIX
C                                      ** OF REDUCED EIGENVALUE PROBLEM
            ALPHA =   CC(IQ,JQ) / CMU(IQ)
            BETA = CC(IQ,JQ+NN) / CMU(IQ)
            AMB(IQ,JQ) = ALPHA - BETA
            APB(IQ,JQ) = ALPHA + BETA
30       CONTINUE
         AMB(IQ,IQ) = AMB(IQ,IQ) - 1.0D0 / CMU(IQ)
         APB(IQ,IQ) = APB(IQ,IQ) - 1.0D0 / CMU(IQ)
C
40    CONTINUE
C                      ** FINISH CALCULATION OF COEFFICIENT MATRIX OF
C                      ** REDUCED EIGENVALUE PROBLEM:  GET MATRIX
C                      ** PRODUCT (ALFA+BETA)*(ALFA-BETA); SS(12)
      DO 70  IQ = 1, NN
         DO 70  JQ = 1, NN
            SUM = 0.0D0
            DO 60  KQ = 1, NN
               SUM = SUM + APB(IQ,KQ) * AMB(KQ,JQ)
60          CONTINUE
            ARRAY(IQ,JQ) = SUM
70    CONTINUE
C                      ** FIND (REAL) EIGENVALUES AND EIGENVECTORS
C
      CALL  ASYMTX( ARRAY, EVECC, EVAL, NN, MI, MXCMU, IER, WK,
     $              AD, EVECCD, EVALD, WKD )
C
      IF ( IER.GT.0 )  THEN
         WRITE( *, '(//,A,I4,A)' )  ' ASYMTX--EIGENVALUE NO. ', IER-128,
     $     '  DIDNT CONVERGE.  LOWER-NUMBERED EIGENVALUES WRONG.'
         CALL  ERRMSG( 'ASYMTX--CONVERGENCE PROBLEMS', .TRUE. )
      END IF
C
      DO 75  IQ = 1, NN
         EVAL(IQ) = DSQRT( DABS( EVAL(IQ) ) )
         KK( IQ+NN ) = EVAL(IQ)
C                                             ** ADD NEGATIVE EIGENVALUE
         KK( NN+1-IQ ) = - EVAL(IQ)
75    CONTINUE
C                          ** FIND EIGENVECTORS (G+) + (G-) FROM SS(10)
C                          ** AND STORE TEMPORARILY IN -APB- ARRAY
      DO 90  JQ = 1, NN
         DO 90  IQ = 1, NN
            SUM = 0.0D0
            DO 80  KQ = 1,NN
               SUM = SUM + AMB(IQ,KQ) * EVECC(KQ,JQ)
80          CONTINUE
            APB(IQ,JQ) = SUM / EVAL(JQ)
90    CONTINUE
C
      DO 100  JQ = 1, NN
         DO 100  IQ = 1, NN
            GPPLGM = APB(IQ,JQ)
            GPMIGM = EVECC(IQ,JQ)
C                                ** RECOVER EIGENVECTORS G+,G- FROM
C                                ** THEIR SUM AND DIFFERENCE; STACK THEM
C                                ** TO GET EIGENVECTORS OF FULL SYSTEM
C                                ** SS(7) (JQ = EIGENVECTOR NUMBER)
C
            EVECC(IQ,      JQ) = 0.5D0 * ( GPPLGM + GPMIGM )
            EVECC(IQ+NN,   JQ) = 0.5D0 * ( GPPLGM - GPMIGM )
C
C                                ** EIGENVECTORS CORRESPONDING TO
C                                ** NEGATIVE EIGENVALUES (CORRESP. TO
C                                ** REVERSING SIGN OF 'K' IN SS(10) )
            GPPLGM = - GPPLGM
            EVECC(IQ,   JQ+NN) = 0.5D0 * ( GPPLGM + GPMIGM )
            EVECC(IQ+NN,JQ+NN) = 0.5D0 * ( GPPLGM - GPMIGM )
            GC( IQ+NN,   JQ+NN )   = EVECC( IQ,    JQ )
            GC( NN+1-IQ, JQ+NN )   = EVECC( IQ+NN, JQ )
            GC( IQ+NN,   NN+1-JQ ) = EVECC( IQ,    JQ+NN )
            GC( NN+1-IQ, NN+1-JQ ) = EVECC( IQ+NN, JQ+NN )
100   CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SOLVE0( B, BDR, BEM, BPLANK, CBAND, CMU, CWT, EXPBEA,
     $                    FBEAM, FISOT, IPVT, LAMBER, LL, LYRCUT,
     $                    MAZ, MI, MI9M2, MXCMU, NCOL, NCUT, NN, NSTR,
     $                    NNLYRI, PI, TPLANK, TAUCPR, UMU0, Z, ZZ,
     $                    ZPLK0, ZPLK1 )
C
C        CONSTRUCT RIGHT-HAND SIDE VECTOR -B- FOR GENERAL BOUNDARY
C        CONDITIONS STWJ(17) AND SOLVE SYSTEM OF EQUATIONS OBTAINED
C        FROM THE BOUNDARY CONDITIONS AND THE
C        CONTINUITY-OF-INTENSITY-AT-LAYER-INTERFACE EQUATIONS.
C        THERMAL EMISSION CONTRIBUTES ONLY IN AZIMUTHAL INDEPENDENCE.
C
C     ROUTINES CALLED:  SGBCO, SGBSL, ZEROIT
C
C     I N P U T      V A R I A B L E S:
C
C       BDR      :  SURFACE BIDIRECTIONAL REFLECTIVITY
C       BEM      :  SURFACE BIDIRECTIONAL EMISSIVITY
C       BPLANK   :  BOTTOM BOUNDARY THERMAL EMISSION
C       CBAND    :  LEFT-HAND SIDE MATRIX OF LINEAR SYSTEM EQ. SC(5),
C                   SCALED BY EQ. SC(12); IN BANDED FORM REQUIRED
C                   BY LINPACK SOLUTION ROUTINES
C       CMU      :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT      :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       EXPBEA   :  TRANSMISSION OF INCIDENT BEAM, EXP(-TAUCPR/UMU0)
C       LYRCUT   :  LOGICAL FLAG FOR TRUNCATION OF COMPUT. LAYER
C       MAZ      :  ORDER OF AZIMUTHAL COMPONENT
C       NCOL     :  COUNTS OF COLUMNS IN -CBAND-
C       NN       :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       NCUT     :  TOTAL NUMBER OF COMPUTATIONAL LAYERS CONSIDERED
C       TPLANK   :  TOP BOUNDARY THERMAL EMISSION
C       TAUCPR   :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       ZZ       :  BEAM SOURCE VECTORS IN EQ. SS(19)
C       ZPLK0    :  THERMAL SOURCE VECTORS -Z0-, BY SOLVING EQ. SS(16)
C       ZPLK1    :  THERMAL SOURCE VECTORS -Z1-, BY SOLVING EQ. SS(16)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T     V A R I A B L E S:
C
C       B        :  RIGHT-HAND SIDE VECTOR OF EQ. SC(5) GOING INTO
C                   *SGBSL*; RETURNS AS SOLUTION VECTOR OF EQ.
C                   SC(12), CONSTANTS OF INTEGRATION WITHOUT
C                   EXPONENTIAL TERM
C      LL        :  PERMANENT STORAGE FOR -B-, BUT RE-ORDERED
C
C   I N T E R N A L    V A R I A B L E S:
C
C       IPVT     :  INTEGER VECTOR OF PIVOT INDICES
C       IT       :  POINTER FOR POSITION IN  -B-
C       NCD      :  NUMBER OF DIAGONALS BELOW OR ABOVE MAIN DIAGONAL
C       RCOND    :  INDICATOR OF SINGULARITY FOR -CBAND-
C       Z        :  SCRATCH ARRAY REQUIRED BY *SGBCO*
C+---------------------------------------------------------------------+
C
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL  LAMBER, LYRCUT
      INTEGER  IPVT(*)

      REAL*8   B(*), BDR( MI,0:* ), BEM(*), CBAND( MI9M2,NNLYRI ),
     $         CMU(*), CWT(*), EXPBEA(0:*), LL( MXCMU,* ),
     $         TAUCPR( 0:* ), Z(*), ZZ( MXCMU,* ), ZPLK0( MXCMU,* ),
     $         ZPLK1( MXCMU,* )
C
C
      CALL  ZEROIT( B, NNLYRI )
C                             ** CONSTRUCT -B-,  STWJ(20A,C) FOR
C                             ** PARALLEL BEAM + BOTTOM REFLECTION +
C                             ** THERMAL EMISSION AT TOP AND/OR BOTTOM
C
      IF ( MAZ.GT.0 .AND. FBEAM.GT.0.0D0 )  THEN
C
C                                         ** AZIMUTH-DEPENDENT CASE
C                                         ** (NEVER CALLED IF FBEAM = 0)
         IF ( LYRCUT .OR. LAMBER ) THEN
C
C               ** NO AZIMUTHAL-DEPENDENT INTENSITY FOR LAMBERT SURFACE;
C               ** NO INTENSITY COMPONENT FOR TRUNCATED BOTTOM LAYER
C
            DO 10  IQ = 1, NN
C                                                     ** TOP BOUNDARY
               B(IQ) = - ZZ(NN+1-IQ,1)
C                                                  ** BOTTOM BOUNDARY
               B(NCOL-NN+IQ) = - ZZ(IQ+NN,NCUT) * EXPBEA(NCUT)
10          CONTINUE
C
         ELSE
C
            DO 20  IQ = 1, NN
               B(IQ) = - ZZ(NN+1-IQ,1)
C
               SUM = 0.D0
               DO 15  JQ = 1, NN
                  SUM = SUM + CWT(JQ) * CMU(JQ) * BDR(IQ,JQ)
     $                        * ZZ(NN+1-JQ,NCUT) * EXPBEA(NCUT)
15             CONTINUE
               B(NCOL-NN+IQ) = SUM
               IF ( FBEAM.GT.0.0D0 )
     $              B(NCOL-NN+IQ) = SUM + ( BDR(IQ,0) * UMU0*FBEAM/PI
     $                                 - ZZ(IQ+NN,NCUT) ) * EXPBEA(NCUT)
20          CONTINUE
         END IF
C                             ** CONTINUITY CONDITION FOR LAYER
C                             ** INTERFACES OF EQ. STWJ(20B)
         IT = NN
         DO 40  LC = 1, NCUT-1
            DO 30  IQ = 1, NSTR
               IT    = IT + 1
               B(IT) = ( ZZ(IQ,LC+1) - ZZ(IQ,LC) ) * EXPBEA(LC)
30          CONTINUE
40       CONTINUE
C
      ELSE
C                                   ** AZIMUTH-INDEPENDENT CASE
         IF ( FBEAM.EQ.0.0D0 )  THEN
C
            DO 50 IQ = 1, NN
C                                      ** TOP BOUNDARY
C
               B(IQ) = - ZPLK0(NN+1-IQ,1) + FISOT + TPLANK
50          CONTINUE
C
            IF ( LYRCUT ) THEN
C                               ** NO INTENSITY COMPONENT FOR TRUNCATED
C                               ** BOTTOM LAYER
               DO 60 IQ = 1, NN
C                                      ** BOTTOM BOUNDARY
C
                  B(NCOL-NN+IQ) = - ZPLK0(IQ+NN,NCUT)
     $                            - ZPLK1(IQ+NN,NCUT) * TAUCPR(NCUT)
60             CONTINUE
C
            ELSE
C
               DO 80 IQ = 1, NN
C
                  SUM = 0.D0
                  DO 70 JQ = 1, NN
                     SUM = SUM + CWT(JQ) * CMU(JQ) * BDR(IQ,JQ)
     $                          * ( ZPLK0(NN+1-JQ,NCUT)
     $                            + ZPLK1(NN+1-JQ,NCUT) * TAUCPR(NCUT) )
70                CONTINUE
                  B(NCOL-NN+IQ) = 2.D0*SUM + BEM(IQ) * BPLANK
     $                            - ZPLK0(IQ+NN,NCUT)
     $                            - ZPLK1(IQ+NN,NCUT) * TAUCPR(NCUT)
80             CONTINUE
            END IF
C                             ** CONTINUITY CONDITION FOR LAYER
C                             ** INTERFACES, STWJ(20B)
            IT = NN
            DO 100  LC = 1, NCUT-1
               DO 90  IQ = 1, NSTR
                  IT    = IT + 1
                  B(IT) = ZPLK0(IQ,LC+1) - ZPLK0(IQ,LC) +
     $                  ( ZPLK1(IQ,LC+1) - ZPLK1(IQ,LC) ) * TAUCPR(LC)
90             CONTINUE
100         CONTINUE
C
         ELSE
C
            DO 150 IQ = 1, NN
               B(IQ) = - ZZ(NN+1-IQ,1) - ZPLK0(NN+1-IQ,1) +FISOT +TPLANK
150         CONTINUE
C
            IF ( LYRCUT ) THEN
C
               DO 160 IQ = 1, NN
                  B(NCOL-NN+IQ) = - ZZ(IQ+NN,NCUT) * EXPBEA(NCUT)
     $                            - ZPLK0(IQ+NN,NCUT)
     $                            - ZPLK1(IQ+NN,NCUT) * TAUCPR(NCUT)
160            CONTINUE
C
            ELSE
C
               DO 180 IQ = 1, NN
C
                  SUM = 0.0D0
                  DO 170 JQ = 1, NN
                     SUM = SUM + CWT(JQ) * CMU(JQ) * BDR(IQ,JQ)
     $                          * ( ZZ(NN+1-JQ,NCUT) * EXPBEA(NCUT)
     $                            + ZPLK0(NN+1-JQ,NCUT)
     $                            + ZPLK1(NN+1-JQ,NCUT) * TAUCPR(NCUT))
170               CONTINUE
                  B(NCOL-NN+IQ) = 2.D0*SUM+( BDR(IQ,0) * UMU0*FBEAM/PI
     $                                 - ZZ(IQ+NN,NCUT) ) * EXPBEA(NCUT)
     $                            + BEM(IQ) * BPLANK
     $                            - ZPLK0(IQ+NN,NCUT)
     $                            - ZPLK1(IQ+NN,NCUT) * TAUCPR(NCUT)
180            CONTINUE
            END IF
C
            IT = NN
            DO 200  LC = 1, NCUT-1
               DO 190  IQ = 1, NSTR
                  IT    = IT + 1
                  B(IT) = ( ZZ(IQ,LC+1) - ZZ(IQ,LC) ) * EXPBEA(LC)
     $                    + ZPLK0(IQ,LC+1) - ZPLK0(IQ,LC) +
     $                    ( ZPLK1(IQ,LC+1) - ZPLK1(IQ,LC) ) * TAUCPR(LC)
190            CONTINUE
200         CONTINUE
C
         END IF
C
      END IF
C                     ** FIND L-U (LOWER/UPPER TRIANGULAR) DECOMPOSITION
C                     ** OF BAND MATRIX -CBAND- AND TEST IF IT IS NEARLY
C                     ** SINGULAR (NOTE: -CBAND- IS DESTROYED)
C                     ** (-CBAND- IS IN LINPACK PACKED FORMAT)
      RCOND = 0.0D0
      NCD = 3*NN - 1
      CALL  SGBCO( CBAND, MI9M2, NCOL, NCD, NCD, IPVT, RCOND, Z )
      IF ( 1.0D0+RCOND .EQ. 1.0D0 )  CALL  ERRMSG
     $   ( 'SOLVE0--SGBCO SAYS MATRIX NEAR SINGULAR',.FALSE.)
C
C                   ** SOLVE LINEAR SYSTEM WITH COEFF MATRIX -CBAND-
C                   ** AND R.H. SIDE(S) -B- AFTER -CBAND- HAS BEEN L-U
C                   ** DECOMPOSED.  SOLUTION IS RETURNED IN -B-.
C
      CALL  SGBSL( CBAND, MI9M2, NCOL, NCD, NCD, IPVT, B, 0 )
C
C                   ** ZERO -CBAND- (IT MAY CONTAIN 'FOREIGN'
C                   ** ELEMENTS UPON RETURNING FROM LINPACK);
C                   ** NECESSARY TO PREVENT ERRORS
C
      CALL  ZEROIT( CBAND, MI9M2*NNLYRI )
C
      DO 220  LC = 1, NCUT
         IPNT = LC*NSTR - NN
         DO 220  IQ = 1, NN
            LL(NN+1-IQ,LC) = B(IPNT+1-IQ)
            LL(IQ+NN,  LC) = B(IQ+IPNT)
220   CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SOLVE1( B, CBAND, FISOT, IHOM, IPVT, LL, MI9M2, MXCMU,
     $                    NCOL, NCUT, NN, NNLYRI, NSTR, Z )
C
C        CONSTRUCT RIGHT-HAND SIDE VECTOR -B- FOR ISOTROPIC INCIDENCE
C        (ONLY) ON EITHER TOP OR BOTTOM BOUNDARY AND SOLVE SYSTEM
C        OF EQUATIONS OBTAINED FROM THE BOUNDARY CONDITIONS AND THE
C        CONTINUITY-OF-INTENSITY-AT-LAYER-INTERFACE EQUATIONS
C
C     ROUTINES CALLED:  SGBCO, SGBSL, ZEROIT
C
C     I N P U T      V A R I A B L E S:
C
C       CBAND    :  LEFT-HAND SIDE MATRIX OF LINEAR SYSTEM EQ. SC(5),
C                   SCALED BY EQ. SC(12); IN BANDED FORM REQUIRED
C                   BY LINPACK SOLUTION ROUTINES
C       IHOM     :  DIRECTION OF ILLUMINATION FLAG
C       NCOL     :  COUNTS OF COLUMNS IN -CBAND-
C       NN       :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T     V A R I A B L E S:
C
C       B        :  RIGHT-HAND SIDE VECTOR OF EQ. SC(5) GOING INTO
C                   *SGBSL*; RETURNS AS SOLUTION VECTOR OF EQ.
C                   SC(12), CONSTANTS OF INTEGRATION WITHOUT
C                   EXPONENTIAL TERM
C       LL      :   PERMANENT STORAGE FOR -B-, BUT RE-ORDERED
C
C   I N T E R N A L    V A R I A B L E S:
C
C       IPVT     :  INTEGER VECTOR OF PIVOT INDICES
C       NCD      :  NUMBER OF DIAGONALS BELOW OR ABOVE MAIN DIAGONAL
C       RCOND    :  INDICATOR OF SINGULARITY FOR -CBAND-
C       Z        :  SCRATCH ARRAY REQUIRED BY *SGBCO*
C----------------------------------------------------------------------+
      IMPLICIT REAL*8 (A-H, O-Z)
      INTEGER  IPVT(*)

      REAL*8 B( NNLYRI ), CBAND( MI9M2,NNLYRI ), LL( MXCMU,* ), Z(*)
C
C
      CALL  ZEROIT( B, NNLYRI )
      NCD = 3*NN - 1
C
      IF ( IHOM.EQ.1 )  THEN
C                             ** BECAUSE THERE ARE NO BEAM OR EMISSION
C                             ** SOURCES, REMAINDER OF -B- ARRAY IS ZERO
         DO 10  I = 1, NN
            B(I) = FISOT
            B( NCOL-NN+I ) = 0.0D0
10       CONTINUE
C
         RCOND = 0.0D0
         CALL  SGBCO( CBAND, MI9M2, NCOL, NCD, NCD, IPVT, RCOND, Z )
         IF ( 1.0D0+RCOND .EQ. 1.0D0)  CALL  ERRMSG
     $         ( 'SOLVE1--SGBCO SAYS MATRIX NEAR SINGULAR', .FALSE. )
C
      ELSE IF ( IHOM.EQ.2 )  THEN
C
         DO 20 I = 1, NN
            B(I) = 0.0D0
            B( NCOL-NN+I ) = FISOT
20       CONTINUE
C
      END IF
C
      CALL  SGBSL( CBAND, MI9M2, NCOL, NCD, NCD, IPVT, B, 0 )
C
C                          ** ZERO -CBAND- TO GET RID OF 'FOREIGN'
C                          ** ELEMENTS PUT IN BY LINPACK
      DO 30  LC = 1, NCUT
         IPNT = LC*NSTR - NN
         DO 30  IQ = 1, NN
            LL( NN+1-IQ, LC) = B( IPNT+1-IQ )
            LL( IQ+NN,   LC) = B( IQ+IPNT )
30    CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SPALTR( CMU, CWT, GC, KK, LL, MXCMU, NLYR,
     $                    NN, NSTR, TAUCPR, SFLUP, SFLDN )
C
C       CALCULATES SPHERICAL ALBEDO AND TRANSMISSIVITY FOR THE ENTIRE
C       MEDIUM FROM THE M=0 INTENSITY COMPONENTS
C       (THIS IS A VERY SPECIALIZED VERSION OF 'FLUXES')
C
C    I N P U T    V A R I A B L E S:
C
C       CMU     :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT     :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       KK      :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       GC      :  EIGENVECTORS AT POLAR QUADRATURE ANGLES, SC(1)
C       LL      :  CONSTANTS OF INTEGRATION IN EQ. SC(1), OBTAINED
C                  BY SOLVING SCALED VERSION OF EQ. SC(5);
C                  EXPONENTIAL TERM OF EQ. SC(12) NOT INCLUDED
C       NN      :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T   V A R I A B L E S:
C
C       SFLUP   :  UP-FLUX AT TOP (EQUIVALENT TO SPHERICAL ALBEDO DUE TO
C                  RECIPROCITY).  FOR ILLUMINATION FROM BELOW IT GIVES
C                  SPHERICAL TRANSMISSIVITY
C       SFLDN   :  DOWN-FLUX AT BOTTOM (FOR SINGLE LAYER
C                  EQUIVALENT TO SPHERICAL TRANSMISSIVITY
C                  DUE TO RECIPROCITY)
C
C    I N T E R N A L   V A R I A B L E S:
C
C       ZINT    :  INTENSITY OF M=0 CASE, IN EQ. SC(1)
C+----------------------------------------------------------------------
C
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8  CMU(*), CWT(*), GC( MXCMU,MXCMU,* ), KK( MXCMU,* ),
     $        LL( MXCMU,* ), TAUCPR( 0:* )
C
      SFLUP = 0.0D0
      DO 20  IQ = NN+1, NSTR
         ZINT  = 0.0D0
         DO 10   JQ = 1, NN
            ZINT = ZINT + GC(IQ,JQ,1) * LL(JQ,1) *
     $                    DEXP( KK(JQ,1) * TAUCPR(1) )
10       CONTINUE
         DO 11  JQ = NN+1, NSTR
            ZINT = ZINT + GC(IQ,JQ,1) * LL(JQ,1)
11       CONTINUE
C
         SFLUP = SFLUP + CWT(IQ-NN) * CMU(IQ-NN) * ZINT
20    CONTINUE
C
      SFLDN  = 0.0D0
      DO 40  IQ = 1, NN
         ZINT   = 0.0D0
         DO 30  JQ = 1, NN
             ZINT = ZINT + GC(IQ,JQ,NLYR) * LL(JQ,NLYR)
30       CONTINUE
         DO 31  JQ = NN+1, NSTR
             ZINT = ZINT + GC(IQ,JQ,NLYR) * LL(JQ,NLYR) *
     $            DEXP( - KK(JQ,NLYR)*(TAUCPR(NLYR) - TAUCPR(NLYR-1)) )
31       CONTINUE
C
         SFLDN = SFLDN + CWT(NN+1-IQ) * CMU(NN+1-IQ) * ZINT
40    CONTINUE
C
      SFLUP = 2.0D0 * SFLUP
      SFLDN = 2.0D0 * SFLDN
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  SURFAC( ALBEDO, CMU, CWT, DELM0, FBEAM, HLPR, LAMBER,
     $                    MI, MAZ, MXCMU, MXUMU, NN, NUMU, NSTR, ONLYFL,
     $                    UMU, USRANG, YLM0, YLMC, YLMU, BDR, EMU, BEM,
     $                    RMU )
C
C       SPECIFIES USER'S SURFACE BIDIRECTIONAL PROPERTIES, STWJ(21)
C
C   I N P U T     V A R I A B L E S:
C
C       DELM0  :  KRONECKER DELTA, DELTA-SUB-M0
C       CMU    :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT    :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       HLPR   :  LEGENDRE MOMENTS OF SURFACE BIDIRECTIONAL REFLECTIVITY
C                    (WITH 2K+1 FACTOR INCLUDED)
C       MAZ    :  ORDER OF AZIMUTHAL COMPONENT
C       NN     :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       YLM0   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE BEAM ANGLE
C       YLMC   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIALS
C                 AT THE QUADRATURE ANGLES
C       YLMU   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIALS
C                 AT THE USER ANGLES
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T     V A R I A B L E S:
C
C       BDR :  SURFACE BIDIRECTIONAL REFLECTIVITY (COMPUTATIONAL ANGLES)
C       RMU :  SURFACE BIDIRECTIONAL REFLECTIVITY (USER ANGLES)
C       BEM :  SURFACE DIRECTIONAL EMISSIVITY (COMPUTATIONAL ANGLES)
C       EMU :  SURFACE DIRECTIONAL EMISSIVITY (USER ANGLES)
C
C    I N T E R N A L     V A R I A B L E S:
C
C       DREF      DIRECTIONAL REFLECTIVITY
C       NMUG   :  NUMBER OF ANGLE COSINE QUADRATURE POINTS
C                 ON (0,1) FOR INTEGRATING BIDIRECTIONAL REFLECTIVITY
C                 TO GET DIRECTIONAL EMISSIVITY (IT IS NECESSARY TO USE
C                 A QUADRATURE SET DISTINCT FROM THE COMPUTATIONAL
C                 ANGLES, BECAUSE THE COMPUTATIONAL ANGLES MAY NOT BE
C                 DENSE ENOUGH -- I.E. 'NSTR' MAY BE TOO SMALL-- TO GIVE
C                 AN ACCURATE APPROXIMATION FOR THE INTEGRATION).
C       GMU    :  THE 'NMUG' ANGLE COSINE QUADRATURE POINTS ON (0,1)
C       GWT    :  THE 'NMUG' ANGLE COSINE QUADRATURE WEIGHTS ON (0,1)
C       YLMG   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIALS
C                 AT THE 'NMUG' QUADRATURE ANGLES
C+---------------------------------------------------------------------+
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL  LAMBER, ONLYFL, USRANG

      REAL*8   BDR( MI,0:* ), BEM(*), CMU(*), CWT(*), EMU(*),
     $         HLPR(0:*), RMU( MXUMU,0:* ), UMU(*),
     $         YLM0(0:*), YLMC( 0:MXCMU,* ), YLMU( 0:MXCMU,* )
      PARAMETER  ( NMUG = 10, MAXSTR = 100 )
      LOGICAL  PASS1
      REAL*8   GMU( NMUG ), GWT( NMUG ), YLMG( 0:MAXSTR, NMUG )
      DATA  PASS1 / .TRUE. /
C
C
      IF ( PASS1 )  THEN
         PASS1 = .FALSE.
         CALL QGAUSN( NMUG, GMU, GWT )
C
         CALL LEPOLY( NMUG, 0, MAXSTR, MAXSTR, GMU, YLMG )
C                       ** CONVERT LEGENDRE POLYS. TO NEGATIVE -GMU-
         SGN  = - 1.0D0
         DO 1  K = 0, MAXSTR
            SGN = - SGN
            DO 1  JG = 1, NMUG
               YLMG( K,JG ) = SGN * YLMG( K,JG )
 1       CONTINUE
C
      END IF
C
      CALL  ZEROIT( BDR, MI*(MI+1) )
      CALL  ZEROIT( BEM, MI )
C
      IF ( LAMBER .AND. MAZ.EQ.0 ) THEN
C
         DO 20 IQ = 1, NN
            BEM(IQ) = 1.0D0 - ALBEDO
            DO 20 JQ = 0, NN
               BDR(IQ,JQ) = ALBEDO
20       CONTINUE
C
      ELSE IF ( .NOT.LAMBER ) THEN
C                                  ** COMPUTE SURFACE BIDIRECTIONAL
C                                  ** PROPERTIES AT COMPUTATIONAL ANGLES
         DO 60 IQ = 1, NN
C
            DO 40 JQ = 1, NN
              SUM = 0.0D0
              DO 30 K = MAZ, NSTR-1
                 SUM = SUM + HLPR(K) * YLMC(K,IQ) * YLMC(K,JQ+NN)
30            CONTINUE
              BDR(IQ,JQ) = (2.D0-DELM0) * SUM
40          CONTINUE
C
            IF ( FBEAM.GT.0.0D0 )  THEN
               SUM = 0.0D0
               DO 50 K = MAZ, NSTR-1
                  SUM = SUM + HLPR(K) * YLMC(K,IQ) * YLM0(K)
50             CONTINUE
               BDR(IQ,0) = (2.D0-DELM0) * SUM
            ENDIF
C
60       CONTINUE
C
         IF ( MAZ.EQ.0 ) THEN
C
            IF ( NSTR.GT.MAXSTR )  CALL 
     $           ERRMSG( 'SURFAC--PARAMETER MAXSTR TOO SMALL', .TRUE. )
C
C                              ** INTEGRATE BIDIRECTIONAL REFLECTIVITY
C                              ** AT REFLECTION POLAR ANGLES -CMU- AND
C                              ** INCIDENT ANGLES -GMU- TO GET 
C                              ** DIRECTIONAL EMISSIVITY AT
C                              ** COMPUTATIONAL ANGLES -CMU-.
            DO 100  IQ = 1, NN
               DREF = 0.0D0
               DO 90  JG = 1, NMUG
                  SUM = 0.0D0
                  DO 80  K = 0, NSTR-1
                     SUM = SUM + HLPR(K) * YLMC(K,IQ) * YLMG(K,JG)
80                CONTINUE
                  DREF = DREF + 2.D0* GWT(JG) * GMU(JG) * SUM
90             CONTINUE
               BEM(IQ) = 1.0D0 - DREF
100         CONTINUE
C
         END IF
C
      END IF
C                                       ** COMPUTE SURFACE BIDIRECTIONAL
C                                       ** PROPERTIES AT USER ANGLES
C
      IF ( .NOT.ONLYFL .AND. USRANG )  THEN
C
         CALL  ZEROIT( EMU, MXUMU )
         CALL  ZEROIT( RMU, MXUMU*(MI+1) )
C
         DO 170 IU = 1, NUMU
            IF ( UMU(IU).GT.0.0D0 )  THEN
C
               IF ( LAMBER .AND. MAZ.EQ.0 )  THEN
                  DO 110 IQ = 0, NN
                     RMU(IU,IQ) = ALBEDO
110               CONTINUE
                  EMU(IU) = 1.0D0 - ALBEDO
C
               ELSE IF ( .NOT.LAMBER ) THEN
                  DO 130 IQ = 1, NN
                     SUM = 0.0D0
                     DO 120 K = MAZ, NSTR-1
                        SUM = SUM + HLPR(K) * YLMU(K,IU) * YLMC(K,IQ+NN)
120                  CONTINUE
                     RMU(IU,IQ) = (2.D0-DELM0) * SUM
130               CONTINUE
C
                  IF ( FBEAM.GT.0.0D0 )  THEN
                     SUM = 0.0D0
                     DO 140 K = MAZ, NSTR-1
                        SUM = SUM + HLPR(K) * YLMU(K,IU) * YLM0(K)
140                  CONTINUE
                     RMU(IU,0) = (2.D0-DELM0) * SUM
                  END IF
C
                  IF ( MAZ.EQ.0 ) THEN
C
C                               ** INTEGRATE BIDIRECTIONAL REFLECTIVITY
C                               ** AT REFLECTION ANGLES -UMU- AND
C                               ** INCIDENT ANGLES -GMU- TO GET
C                               ** DIRECTIONAL EMISSIVITY AT
C                               ** USER ANGLES -UMU-.
                     DREF = 0.0D0
                     DO 160 JG = 1, NMUG
                        SUM = 0.0D0
                        DO 150 K = 0, NSTR-1
                           SUM = SUM + HLPR(K) * YLMU(K,IU) * YLMG(K,JG)
150                     CONTINUE
                        DREF = DREF + 2.D0* GWT(JG) * GMU(JG) * SUM
160                  CONTINUE
C
                     EMU(IU) = 1.0D0 - DREF
                  END IF
C
               END IF
            END IF
170      CONTINUE
C
      END IF
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  TERPEV( CWT, EVECC, GL, GU, MAZ, MXCMU, MXUMU,
     $                    NN, NSTR, NUMU, WK, YLMC, YLMU )
C
C         INTERPOLATE EIGENVECTORS TO USER ANGLES; EQ SD(8)
C
	IMPLICIT REAL*8 (A-H, O-Z)

      REAL*8  CWT(*), EVECC( MXCMU,* ), GL(0:*), GU(  MXUMU,* ), WK(*),
     $        YLMC(  0:MXCMU,* ), YLMU(  0:MXCMU,* )
C
      DO 50  IQ = 1, NSTR
C
         DO 20  L = MAZ, NSTR-1
C                                       ** INNER SUM IN SD(8) TIMES ALL
C                                   ** FACTORS IN OUTER SUM BUT PLM(MU)
            SUM = 0.0D0
            DO 10  JQ = 1, NSTR
               SUM = SUM + CWT(JQ) * YLMC(L,JQ) * EVECC(JQ,IQ)
10          CONTINUE
            WK(L+1) = 0.5D0 * GL(L) * SUM
20       CONTINUE
C                                    ** FINISH OUTER SUM IN SD(8)
C                                    ** AND STORE EIGENVECTORS
         DO 40  IU = 1, NUMU
            SUM = 0.D0
            DO 30  L = MAZ, NSTR-1
               SUM = SUM + WK(L+1) * YLMU(L,IU)
30          CONTINUE
            IF ( IQ.LE.NN )  GU( IU, IQ+NN     ) = SUM
            IF ( IQ.GT.NN )  GU( IU, NSTR+1-IQ ) = SUM
40       CONTINUE
C
50    CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  TERPSO( CWT, DELM0, FBEAM, GL, MAZ, MXCMU, MXUMU,
     $                    NOPLNK, NUMU, NSTR, OPRIM, PI, YLM0, YLMC,
     $                    YLMU, PSI, XR0, XR1, Z0, ZJ, ZBEAM, Z0U,
     $                    Z1U )
C
C         INTERPOLATES SOURCE FUNCTIONS TO USER ANGLES
C
C    I N P U T      V A R I A B L E S:
C
C       CWT    :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       DELM0  :  KRONECKER DELTA, DELTA-SUB-M0
C       GL     :  DELTA-M SCALED LEGENDRE COEFFICIENTS OF PHASE FUNCTION
C                    (INCLUDING FACTORS 2L+1 AND SINGLE-SCATTER ALBEDO)
C       MAZ    :  ORDER OF AZIMUTHAL COMPONENT
C       OPRIM  :  SINGLE SCATTERING ALBEDO
C       XR0    :  EXPANSION OF THERMAL SOURCE FUNCTION
C       XR1    :  EXPANSION OF THERMAL SOURCE FUNCTION EQS.SS(14-16)
C       YLM0   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE BEAM ANGLE
C       YLMC   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE QUADRATURE ANGLES
C       YLMU   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE USER ANGLES
C       Z0     :  SOLUTION VECTORS Z-SUB-ZERO OF EQ. SS(16)
C       ZJ     :  SOLUTION VECTOR CAPITAL -Z-SUB-ZERO AFTER SOLVING
C                 EQ. SS(19)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T     V A R I A B L E S:
C
C       ZBEAM  :  INCIDENT-BEAM SOURCE FUNCTION AT USER ANGLES
C       Z0U,Z1U:  COMPONENTS OF A LINEAR-IN-OPTICAL-DEPTH-DEPENDENT
C                    SOURCE (APPROXIMATING THE PLANCK EMISSION SOURCE)
C
C   I N T E R N A L       V A R I A B L E S:
C
C       PSI    :  SUM JUST AFTER SQUARE BRACKET IN  EQ. SD(9)
C+---------------------------------------------------------------------+
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL  NOPLNK

      REAL*8  CWT(*), GL(0:*), PSI(*),  YLM0(0:*), YLMC( 0:MXCMU,* ),
     $         YLMU( 0:MXCMU,*), Z0(*), ZJ(*), ZBEAM(*), Z0U(*),
     $         Z1U(*)
C
C
      IF ( FBEAM.GT.0.0D0 )  THEN
C                                  ** BEAM SOURCE TERMS; EQ. SD(9)
         DO 20  IQ = MAZ, NSTR-1
            PSUM = 0.0D0
            DO 10  JQ = 1, NSTR
               PSUM = PSUM + CWT(JQ) * YLMC(IQ,JQ) * ZJ(JQ)
10          CONTINUE
            PSI(IQ+1) = 0.5D0 * GL(IQ) * PSUM
20       CONTINUE
C
         FACT = ( 2.0D0 - DELM0 ) * FBEAM / (4.0D0*PI)
         DO 40  IU = 1, NUMU
            SUM = 0.D0
            DO 30 IQ = MAZ, NSTR-1
               SUM = SUM + YLMU(IQ,IU) *
     $                    ( PSI(IQ+1) + FACT * GL(IQ) * YLM0(IQ) )
30          CONTINUE
            ZBEAM(IU) = SUM
40       CONTINUE
      END IF
C
      IF ( .NOT.NOPLNK .AND. MAZ.EQ.0 )  THEN
C
C                                ** THERMAL SOURCE TERMS, STWJ(27C)
         DO 80  IQ = MAZ, NSTR-1
            PSUM = 0.0D0
            DO 70  JQ = 1, NSTR
               PSUM = PSUM + CWT(JQ) * YLMC(IQ,JQ) * Z0(JQ)
 70         CONTINUE
            PSI(IQ+1) = 0.5D0 * GL(IQ) * PSUM
 80       CONTINUE
C
          DO 100  IU = 1, NUMU
            SUM = 0.0D0
            DO 90   IQ = MAZ, NSTR-1
               SUM = SUM + YLMU(IQ,IU) * PSI(IQ+1)
90          CONTINUE
            Z0U(IU) = SUM + (1.-OPRIM) * XR0
            Z1U(IU) = XR1
100      CONTINUE
C
      END IF
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  UPBEAM( ARRAY, CC, CMU, DELM0, FBEAM, GL, IPVT, MAZ,
     $                    MXCMU, NN, NSTR, PI, UMU0, WK, YLM0, YLMC, ZJ,
     $                    ZZ )
C
C         FINDS THE INCIDENT-BEAM PARTICULAR SOLUTION  OF SS(18)
C
C     ROUTINES CALLED:  SGECO, SGESL
C
C   I N P U T    V A R I A B L E S:
C
C       CC     :  CAPITAL-C-SUB-IJ IN EQ. SS(5)
C       CMU    :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       DELM0  :  KRONECKER DELTA, DELTA-SUB-M0
C       GL     :  DELTA-M SCALED LEGENDRE COEFFICIENTS OF PHASE FUNCTION
C                    (INCLUDING FACTORS 2L+1 AND SINGLE-SCATTER ALBEDO)
C       MAZ    :  ORDER OF AZIMUTHAL COMPONENT
C       YLM0   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE BEAM ANGLE
C       YLMC   :  NORMALIZED ASSOCIATED LEGENDRE POLYNOMIAL
C                 AT THE QUADRATURE ANGLES
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T    V A R I A B L E S:
C
C       ZJ     :  RIGHT-HAND SIDE VECTOR CAPITAL-X-SUB-ZERO IN SS(19);
C                 ALSO THE SOLUTION VECTOR CAPITAL-Z-SUB-ZERO
C                 AFTER SOLVING THAT SYSTEM
C       ZZ     :  PERMANENT STORAGE FOR -ZJ-, BUT RE-ORDERED
C
C   I N T E R N A L    V A R I A B L E S:
C
C       ARRAY  :  COEFFICIENT MATRIX IN LEFT-HAND SIDE OF EQ. SS(19)
C       IPVT   :  INTEGER VECTOR OF PIVOT INDICES REQUIRED BY *LINPACK*
C       WK     :  SCRATCH ARRAY REQUIRED BY *LINPACK*
C+---------------------------------------------------------------------+
C
      IMPLICIT REAL*8 (A-H, O-Z)
      INTEGER  IPVT(*)

      REAL*8   ARRAY( MXCMU,* ), CC( MXCMU,* ), CMU(*), GL(0:*),
     $         WK(*), YLM0(0:*), YLMC( 0:MXCMU,* ), ZJ(*), ZZ(*)
C
C
      DO 40  IQ = 1, NSTR
C
         DO 10  JQ = 1, NSTR
            ARRAY(IQ,JQ) = - CC(IQ,JQ)
10       CONTINUE
         ARRAY(IQ,IQ) = 1.D0 + CMU(IQ) / UMU0 + ARRAY(IQ,IQ)
C
         SUM = 0.D0
         DO 20  K = MAZ, NSTR-1
            SUM = SUM + GL(K) * YLMC(K,IQ) * YLM0(K)
20       CONTINUE
         ZJ(IQ) = ( 2.0D0 - DELM0 ) * FBEAM * SUM / (4.0D0*PI)
40    CONTINUE
C                  ** FIND L-U (LOWER/UPPER TRIANGULAR) DECOMPOSITION
C                  ** OF -ARRAY- AND SEE IF IT IS NEARLY SINGULAR
C                  ** (NOTE:  -ARRAY- IS DESTROYED)
      RCOND = 0.0D0
      CALL  SGECO( ARRAY, MXCMU, NSTR, IPVT, RCOND, WK )
      IF ( 1.0D0+RCOND .EQ. 1.0D0 )  CALL  ERRMSG
     $   ( 'UPBEAM--SGECO SAYS MATRIX NEAR SINGULAR',.FALSE.)
C
C                ** SOLVE LINEAR SYSTEM WITH COEFF MATRIX -ARRAY-
C                ** (ASSUMED ALREADY L-U DECOMPOSED) AND R.H. SIDE(S)
C                ** -ZJ-;  RETURN SOLUTION(S) IN -ZJ-
      JOB = 0
      CALL  SGESL( ARRAY, MXCMU, NSTR, IPVT, ZJ, JOB )
C
      DO 50  IQ = 1, NN
         ZZ( IQ+NN )   = ZJ( IQ )
         ZZ( NN+1-IQ ) = ZJ( IQ+NN )
50    CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  UPISOT( ARRAY, CC, CMU, IPVT, MXCMU, NN, NSTR, OPRIM,
     $                    WK, XR0, XR1, Z0, Z1, ZPLK0, ZPLK1 )
C
C       FINDS THE PARTICULAR SOLUTION OF THERMAL RADIATION OF SS(15)
C
C     ROUTINES CALLED:  SGECO, SGESL
C
C   I N P U T     V A R I A B L E S:
C
C       CC     :  CAPITAL-C-SUB-IJ IN EQ. SS(5)
C       CMU    :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       OPRIM  :  DELTA-M SCALED SINGLE SCATTERING ALBEDO
C       XR0    :  EXPANSION OF THERMAL SOURCE FUNCTION
C       XR1    :  EXPANSION OF THERMAL SOURCE FUNCTION EQS. SS(14-16)
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C    O U T P U T    V A R I A B L E S:
C
C       Z0     :  SOLUTION VECTORS Z-SUB-ZERO OF EQ. SS(16)
C       Z1     :  SOLUTION VECTORS Z-SUB-ONE  OF EQ. SS(16)
C       ZPLK0, :  PERMANENT STORAGE FOR -Z0,Z1-, BUT RE-ORDERED
C        ZPLK1
C
C   I N T E R N A L    V A R I A B L E S:
C
C       ARRAY  :  COEFFICIENT MATRIX IN LEFT-HAND SIDE OF EQ. SS(16)
C       IPVT   :  INTEGER VECTOR OF PIVOT INDICES REQUIRED BY *LINPACK*
C       WK     :  SCRATCH ARRAY REQUIRED BY *LINPACK*
C+---------------------------------------------------------------------+
C
      IMPLICIT REAL*8 (A-H, O-Z)
      INTEGER IPVT(*)

      REAL*8  ARRAY( MXCMU,* ), CC( MXCMU,* ), CMU(*), WK(*),
     $        Z0(*), Z1(*), ZPLK0(*), ZPLK1(*)
C
C
      DO 20 IQ = 1, NSTR
C
         DO 10 JQ = 1, NSTR
            ARRAY(IQ,JQ) = - CC(IQ,JQ)
10       CONTINUE
         ARRAY(IQ,IQ) = 1.0D0 + ARRAY(IQ,IQ)
C
         Z1(IQ) = XR1
         Z0(IQ) = (1.0D0-OPRIM) * XR0 + CMU(IQ) * Z1(IQ)
20    CONTINUE
C                       ** SOLVE LINEAR EQUATIONS: SAME AS IN *UPBEAM*,
C                       ** EXCEPT -ZJ- REPLACED BY -Z0-
      RCOND = 0.0D0
      CALL  SGECO( ARRAY, MXCMU, NSTR, IPVT, RCOND, WK )
      IF ( 1.0D0+RCOND .EQ. 1.0D0 )  CALL  ERRMSG
     $   ( 'UPISOT--SGECO SAYS MATRIX NEAR SINGULAR',.FALSE.)
C
      CALL  SGESL( ARRAY, MXCMU, NSTR, IPVT, Z0, 0 )
C
      DO 30  IQ = 1, NN
         ZPLK0( IQ+NN )   = Z0( IQ )
         ZPLK1( IQ+NN )   = Z1( IQ )
         ZPLK0( NN+1-IQ ) = Z0( IQ+NN )
         ZPLK1( NN+1-IQ ) = Z1( IQ+NN )
30    CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  USRINT( BPLANK, CMU, CWT, DELM0, EMU, EXPBEA,
     $                    FBEAM, FISOT, GC, GU, KK, LAMBER, LAYRU, LL,
     $                    LYRCUT, MAZ, MXCMU, MXULV, MXUMU, NCUT,
     $                    NLYR, NN, NSTR, NOPLNK, NUMU, NTAU, PI, RMU,
     $                    TAUCPR, TPLANK, UMU, UMU0, UTAUPR, WK,
     $                    ZBEAM, Z0U, Z1U, ZZ, ZPLK0, ZPLK1, UUM )
C
C       COMPUTES INTENSITY COMPONENTS AT USER OUTPUT ANGLES
C       FOR AZIMUTHAL EXPANSION TERMS IN EQ. SD(2)
C
C   I N P U T    V A R I A B L E S:
C
C       BPLANK :  INTEGRATED PLANCK FUNCTION FOR EMISSION FROM
C                 BOTTOM BOUNDARY
C       CMU    :  ABSCISSAE FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       CWT    :  WEIGHTS FOR GAUSS QUADRATURE OVER ANGLE COSINE
C       DELM0  :  KRONECKER DELTA, DELTA-SUB-M0
C       EMU    :  SURFACE DIRECTIONAL EMISSIVITY (USER ANGLES)
C       EXPBEA :  TRANSMISSION OF INCIDENT BEAM, EXP(-TAUCPR/UMU0)
C       GC     :  EIGENVECTORS AT POLAR QUADRATURE ANGLES, SC(1)
C       GU     :  EIGENVECTORS INTERPOLATED TO USER POLAR ANGLES
C                 (i.e., g IN EQ. SC(1) )
C       KK     :  EIGENVALUES OF COEFF. MATRIX IN EQ. SS(7)
C       LAYRU  :  LAYER NUMBER OF USER LEVEL -UTAU-
C       LL     :  CONSTANTS OF INTEGRATION IN EQ. SC(1), OBTAINED
C                 BY SOLVING SCALED VERSION OF EQ. SC(5);
C                 EXPONENTIAL TERM OF EQ. SC(12) NOT INCLUDED
C       LYRCUT :  LOGICAL FLAG FOR TRUNCATION OF COMPUT. LAYER
C       MAZ    :  ORDER OF AZIMUTHAL COMPONENT
C       NCUT   :  TOTAL NUMBER OF TRUNCATED COMPUTATIONAL LAYERS
C       NN     :  ORDER OF DOUBLE-GAUSS QUADRATURE (NSTR/2)
C       RMU    :  SURFACE BIDIRECTIONAL REFLECTIVITY (USER ANGLES)
C       TAUCPR :  CUMULATIVE OPTICAL DEPTH (DELTA-M-SCALED)
C       TPLANK :  INTEGRATED PLANCK FUNCTION FOR EMISSION FROM
C                 TOP BOUNDARY
C       UTAUPR :  OPTICAL DEPTHS OF USER OUTPUT LEVELS IN DELTA-M
C                    COORDINATES;  EQUAL TO  -UTAU- IF NO DELTA-M
C       Z0U    :  Z-SUB-ZERO IN EQ. SS(16) INTERPOLATED TO USER
C                 ANGLES FROM AN EQUATION DERIVED FROM SS(16)
C       Z1U    :  Z-SUB-ONE IN EQ. SS(16) INTERPOLATED TO USER
C                 ANGLES FROM AN EQUATION DERIVED FROM SS(16)
C       ZZ     :  BEAM SOURCE VECTORS IN EQ. SS(19)
C       ZPLK0  :  THERMAL SOURCE VECTORS -Z0-, BY SOLVING EQ. SS(16)
C       ZPLK1  :  THERMAL SOURCE VECTORS -Z1-, BY SOLVING EQ. SS(16)
C       ZBEAM  :  INCIDENT-BEAM SOURCE VECTORS
C       (REMAINDER ARE 'DISORT' INPUT VARIABLES)
C
C   O U T P U T    V A R I A B L E S:
C
C       UUM  :  AZIMUTHAL COMPONENTS OF THE INTENSITY IN EQ. STWJ(5)
C
C   I N T E R N A L    V A R I A B L E S:
C
C       BNDDIR :  DIRECT INTENSITY DOWN AT THE BOTTOM BOUNDARY
C       BNDDFU :  DIFFUSE INTENSITY DOWN AT THE BOTTOM BOUNDARY
C       BNDINT :  INTENSITY ATTENUATED AT BOTH BOUNDARIES, STWJ(25-6)
C       DTAU   :  OPTICAL DEPTH OF A COMPUTATIONAL LAYER
C       LYREND :  END LAYER OF INTEGRATION
C       LYRSTR :  START LAYER OF INTEGRATION
C       PALINT :  INTENSITY COMPONENT FROM PARALLEL BEAM
C       PLKINT :  INTENSITY COMPONENT FROM PLANCK SOURCE
C       WK     :  SCRATCH VECTOR FOR SAVING 'EXP' EVALUATIONS
C       ALL THE EXPONENTIAL FACTORS ( EXP1, EXPN,... etc.)
C       COME FROM THE SUBSTITUTION OF CONSTANTS OF INTEGRATION IN
C       EQ. SC(12) INTO EQS. S1(8-9).  THEY ALL HAVE NEGATIVE
C       ARGUMENTS SO THERE SHOULD NEVER BE OVERFLOW PROBLEMS.
C+---------------------------------------------------------------------+
C
      IMPLICIT REAL*8 (A-H, O-Z)
      LOGICAL  LAMBER, LYRCUT, NOPLNK, NEGUMU
      INTEGER  LAYRU(*)

      REAL*8   CMU(*), CWT(*), EMU(*), EXPBEA(0:*),GC( MXCMU,MXCMU,* ),
     $         GU( MXUMU,MXCMU,* ), KK( MXCMU,* ), LL( MXCMU,* ),
     $         RMU( MXUMU,0:* ), TAUCPR( 0:* ), UUM( MXUMU,MXULV,0:* ),
     $         UMU(*), UTAUPR(*), WK(*), Z0U( MXUMU,* ), Z1U( MXUMU,* ),
     $         ZBEAM( MXUMU,* ), ZZ( MXCMU,* ), ZPLK0( MXCMU,* ),
     $         ZPLK1( MXCMU,* )
C
C
      CALL  ZEROIT( UUM, MXUMU*MXULV*(MXCMU+1) )
C
C                          ** INCORPORATE CONSTANTS OF INTEGRATION INTO
C                          ** INTERPOLATED EIGENVECTORS
      DO 10  LC = 1, NCUT
         DO  10  IQ = 1, NSTR
            DO 10  IU = 1, NUMU
               GU(IU,IQ,LC) = GU(IU,IQ,LC) * LL(IQ,LC)
10    CONTINUE
C                           ** LOOP OVER LEVELS AT WHICH INTENSITIES
C                           ** ARE DESIRED ('USER OUTPUT LEVELS')
      DO 200  LU = 1, NTAU
C
         EXP0 = DEXP( - UTAUPR(LU) / UMU0 )
         LYU = LAYRU(LU)
C                              ** LOOP OVER POLAR ANGLES AT WHICH
C                              ** INTENSITIES ARE DESIRED
         DO 100  IU = 1, NUMU
            IF ( LYRCUT .AND. LYU.GT.NCUT )  GO TO 100
            NEGUMU = UMU(IU).LT.0.0
            IF( NEGUMU )  THEN
               LYRSTR = 1
               LYREND = LYU - 1
               SGN = - 1.0D0
            ELSE
               LYRSTR = LYU + 1
               LYREND = NCUT
               SGN = 1.0D0
            END IF
C                          ** FOR DOWNWARD INTENSITY, INTEGRATE FROM TOP
C                          ** TO 'LYU-1' IN EQ. S1(8); FOR UPWARD,
C                          ** INTEGRATE FROM BOTTOM TO 'LYU+1' IN S1(9)
            PALINT = 0.0D0
            PLKINT = 0.0D0
            DO 30  LC = LYRSTR, LYREND
C
               DTAU = TAUCPR(LC) - TAUCPR(LC-1)
               EXP1 =  DEXP( (UTAUPR(LU) - TAUCPR(LC-1)) / UMU(IU) )
               EXP2 =  DEXP( (UTAUPR(LU) - TAUCPR( LC )) / UMU(IU) )
C
               IF ( .NOT.NOPLNK .AND. MAZ.EQ.0 )
     $           PLKINT = PLKINT + SGN * ( Z0U(IU,LC) * (EXP1 - EXP2) +
     $                    Z1U(IU,LC) * ( (TAUCPR(LC-1) + UMU(IU))*EXP1 -
     $                                   (TAUCPR(LC) + UMU(IU))*EXP2 ) )
C
               IF ( FBEAM.GT.0.0D0 )  THEN
                  DENOM = 1.0D0 + UMU(IU) / UMU0
                  IF ( DABS(DENOM).LT.0.0001D0 ) THEN
C                                                   ** L'HOSPITAL LIMIT
                     EXPN = ( DTAU / UMU0 ) * EXP0
                  ELSE
                     EXPN = ( EXP1 * EXPBEA(LC-1) - EXP2 * EXPBEA(LC) )
     $                      * SGN / DENOM
                  END IF
                  PALINT = PALINT + ZBEAM(IU,LC) * EXPN
               ENDIF
C                                                   ** -KK- IS NEGATIVE
               DO 20  IQ = 1, NN
                  WK(IQ) = DEXP( KK(IQ,LC) * DTAU )
                  DENOM = 1.0D0 + UMU(IU) * KK(IQ,LC)
                  IF ( DABS(DENOM).LT.0.0001D0 ) THEN
C                                                   ** L'HOSPITAL LIMIT
                     EXPN = DTAU / UMU(IU) * EXP2
                  ELSE
                     EXPN = SGN * ( EXP1 * WK(IQ) - EXP2 ) / DENOM
                  END IF
                  PALINT = PALINT + GU(IU,IQ,LC) * EXPN
20             CONTINUE
C                                                   ** -KK- IS POSITIVE
               DO 21  IQ = NN+1, NSTR
                  DENOM = 1.0D0 + UMU(IU) * KK(IQ,LC)
                  IF ( DABS(DENOM).LT.0.0001D0 ) THEN
C                                                   ** L'HOSPITAL LIMIT
                     EXPN = - DTAU / UMU(IU) * EXP1
                  ELSE
                     EXPN = SGN *( EXP1 - EXP2 * WK(NSTR+1-IQ) ) / DENOM
                  END IF
                  PALINT = PALINT + GU(IU,IQ,LC) * EXPN
21             CONTINUE
C
30          CONTINUE
C                           ** CALCULATE CONTRIBUTION FROM USER
C                           ** OUTPUT LEVEL TO NEXT COMPUTATIONAL LEVEL
C
            DTAU1 = UTAUPR(LU) - TAUCPR(LYU-1)
            DTAU2 = UTAUPR(LU) - TAUCPR(LYU)
            IF( DABS(DTAU1).LT.1.D-6 .AND. NEGUMU )  GO TO 50
            IF( DABS(DTAU2).LT.1.D-6 .AND. (.NOT.NEGUMU) )  GO TO 50
            IF( NEGUMU ) EXP1 = DEXP( DTAU1 / UMU(IU) )
            IF( .NOT.NEGUMU ) EXP2 = DEXP( DTAU2 / UMU(IU) )
C
            IF ( FBEAM.GT.0.0D0 )  THEN
               DENOM = 1.0D0 + UMU(IU) / UMU0
               IF ( DABS(DENOM).LT.0.0001D0 ) THEN
                  EXPN =  ( DTAU1 / UMU0 ) * EXP0
               ELSE IF ( NEGUMU ) THEN
                  EXPN = ( EXP0 - EXPBEA(LYU-1) * EXP1 ) / DENOM
               ELSE
                  EXPN = ( EXP0 - EXPBEA(LYU) * EXP2 ) / DENOM
               END IF
               PALINT = PALINT + ZBEAM(IU,LYU) * EXPN
            ENDIF
C                                                   ** -KK- IS NEGATIVE
            DTAU = TAUCPR(LYU) - TAUCPR(LYU-1)
            DO 40  IQ = 1, NN
               DENOM = 1.0D0 + UMU(IU) * KK(IQ,LYU)
               IF ( DABS(DENOM).LT.0.0001D0 ) THEN
                  EXPN = - DTAU2 / UMU(IU) * EXP2
               ELSE IF ( NEGUMU ) THEN
                  EXPN = ( DEXP( - KK(IQ,LYU) * DTAU2 ) -
     $                     DEXP( KK(IQ,LYU) * DTAU ) * EXP1 ) / DENOM
               ELSE
                  EXPN = ( DEXP( - KK(IQ,LYU) * DTAU2 ) - EXP2 ) / DENOM
               END IF
               PALINT = PALINT + GU(IU,IQ,LYU) * EXPN
40          CONTINUE
C                                                   ** -KK- IS POSITIVE
            DO 41  IQ = NN+1, NSTR
               DENOM = 1.0D0 + UMU(IU) * KK(IQ,LYU)
               IF ( DABS(DENOM).LT.0.0001D0 ) THEN
                  EXPN = - DTAU1 / UMU(IU) * EXP1
               ELSE IF ( NEGUMU ) THEN
                  EXPN = ( DEXP(- KK(IQ,LYU) * DTAU1 ) - EXP1 ) / DENOM
               ELSE
                  EXPN = ( DEXP( - KK(IQ,LYU) * DTAU1 ) -
     $                     DEXP( - KK(IQ,LYU) * DTAU ) * EXP2 ) / DENOM
               END IF
               PALINT = PALINT + GU(IU,IQ,LYU) * EXPN
41          CONTINUE
C
            IF ( .NOT.NOPLNK .AND. MAZ.EQ.0 )  THEN
              IF ( NEGUMU ) THEN
                 EXPN = EXP1
                 FACT = TAUCPR(LYU-1) + UMU(IU)
              ELSE
                 EXPN = EXP2
                 FACT = TAUCPR( LYU ) + UMU(IU)
              END IF
              PLKINT = PLKINT + Z0U(IU,LYU) * ( 1.D0- EXPN ) +
     $                 Z1U(IU,LYU) *( UTAUPR(LU) + UMU(IU) - FACT*EXPN )
            END IF
C                            ** CALCULATE INTENSITY COMPONENTS
C                            ** ATTENUATED AT BOTH BOUNDARIES. 
C                            ** NOTE:: NO AZIMUTHAL INTENSITY
C                            ** COMPONENT FOR ISOTROPIC SURFACE
50          BNDINT = 0.0D0
            IF ( NEGUMU .AND. MAZ.EQ.0 ) THEN
              BNDINT = ( FISOT + TPLANK ) * DEXP( UTAUPR(LU) / UMU(IU) )
            ELSE IF ( .NOT.NEGUMU ) THEN
              IF ( LYRCUT .OR. (LAMBER .AND. MAZ.GT.0) )  GO TO 90
              DO 60  JQ = NN+1, NSTR
                WK(JQ) = DEXP(-KK(JQ,NLYR)*(TAUCPR(NLYR)-
     $          TAUCPR(NLYR-1)))
60            CONTINUE
              BNDDFU = 0.0D0
              DO 80  IQ = NN, 1, -1
                 DFUINT = 0.0D0
                 DO 70  JQ = 1, NN
                    DFUINT = DFUINT + GC(IQ,JQ,NLYR) * LL(JQ,NLYR)
70               CONTINUE
                 DO 71  JQ = NN+1, NSTR
                    DFUINT = DFUINT + GC(IQ,JQ,NLYR) * LL(JQ,NLYR)
     $                                * WK(JQ)
71               CONTINUE
                 IF ( FBEAM.GT.0.0D0 )
     $                DFUINT = DFUINT + ZZ(IQ,NLYR) * EXPBEA(NLYR)
                 DFUINT = DFUINT + DELM0 * ( ZPLK0(IQ,NLYR)
     $                                + ZPLK1(IQ,NLYR) * TAUCPR(NLYR) )
                 BNDDFU = BNDDFU + ( 1.D0 + DELM0 ) * RMU(IU,NN+1-IQ)
     $                           * CMU(NN+1-IQ) * CWT(NN+1-IQ) * DFUINT
80            CONTINUE
C
              BNDDIR = 0.0D0
              IF (FBEAM.GT.0.0) BNDDIR = UMU0*FBEAM/PI * RMU(IU,0)
     $                                   * EXPBEA(NLYR)
              BNDINT = ( BNDDFU + BNDDIR + DELM0 * EMU(IU) * BPLANK )
     $                 * DEXP( (UTAUPR(LU)-TAUCPR(NLYR)) / UMU(IU) )
            END IF
C
90          UUM( IU, LU, MAZ ) = PALINT + PLKINT + BNDINT
C
100      CONTINUE
200   CONTINUE
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  ZEROAL( AMB, APB, ARRAY, CC, CMU, CWT, EVAL, EVECC,
     $                    GC, GU, HLPR, KK, LL, PSI, WK, XR0, XR1,
     $                    YLM0, YLMC, YLMU, Z, Z0, Z1, ZJ, ZZ, ZPLK0,
     $                    ZPLK1, Z0U, Z1U, ZBEAM, MI, MXCMU, MXCLY,
     $                    NNLYRI, MXUMU, MXULV )
C
C            ZERO ARRAYS
C
      REAL*8  AMB(MI,*), APB(MI,*), ARRAY(MXCMU,*), CC(MXCMU,*),
     $      CMU(*), CWT(*), EVAL(*), EVECC(MXCMU,*), GC(MXCMU,MXCMU,*),
     $      GU(MXUMU,MXCMU,*), HLPR(0:*), KK(MXCMU,*), LL(MXCMU,*),
     $      PSI(*), WK(*), XR0(*), XR1(*),  YLM0(0:*),
     $      YLMC(0:MXCMU,*), YLMU(0:MXCMU,*), Z(*), Z0(*), Z1(*),
     $      Z0U(MXUMU,*), Z1U(MXUMU,*), ZJ(*), ZZ(MXCMU,*),
     $      ZPLK0(MXCMU,*), ZPLK1(MXCMU,*), ZBEAM(MXUMU,*)
C
C
      CALL  ZEROIT( XR0, MXCLY )
      CALL  ZEROIT( XR1, MXCLY )
      CALL  ZEROIT( CMU, MXCMU )
      CALL  ZEROIT( CWT, MXCMU )
      CALL  ZEROIT( PSI, MXCMU )
      CALL  ZEROIT( EVAL,MXCMU )
      CALL  ZEROIT( WK,  MXCMU )
      CALL  ZEROIT( Z0,  MXCMU )
      CALL  ZEROIT( Z1,  MXCMU )
      CALL  ZEROIT( ZJ,  MXCMU )
      CALL  ZEROIT( HLPR, MXCMU+1 )
      CALL  ZEROIT( YLM0, MXCMU+1 )
      CALL  ZEROIT( ARRAY, MXCMU**2 )
      CALL  ZEROIT( CC,    MXCMU**2 )
      CALL  ZEROIT( EVECC, MXCMU**2 )
      CALL  ZEROIT( YLMC, (MXCMU+1)*MXCMU )
      CALL  ZEROIT( YLMU, (MXCMU+1)*MXUMU )
      CALL  ZEROIT( AMB, MI**2 )
      CALL  ZEROIT( APB, MI**2 )
      CALL  ZEROIT( KK,     MXCMU*MXCLY )
      CALL  ZEROIT( LL,     MXCMU*MXCLY )
      CALL  ZEROIT( ZZ,     MXCMU*MXCLY )
      CALL  ZEROIT( ZPLK0,  MXCMU*MXCLY )
      CALL  ZEROIT( ZPLK1,  MXCMU*MXCLY )
      CALL  ZEROIT( Z0U,   MXUMU*MXCLY )
      CALL  ZEROIT( Z1U,   MXUMU*MXCLY )
      CALL  ZEROIT( ZBEAM, MXUMU*MXCLY )
      CALL  ZEROIT( GC, MXCMU**2*MXCLY )
      CALL  ZEROIT( GU, MXUMU*MXCMU*MXCLY )
      CALL  ZEROIT( Z, NNLYRI )
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  ZEROIT( A, LENGTH )
C
C         ZEROS A REAL ARRAY -A- HAVING -LENGTH- ELEMENTS
C
      REAL*8  A(*)
C
      DO 10  L = 1, LENGTH
         A( L ) = 0.0D0
10    CONTINUE
C
      RETURN
      END
C**********************************************************************      
      DOUBLE PRECISION FUNCTION  PLKAVG ( WNUMLO, WNUMHI, T )
C
C        COMPUTES PLANCK FUNCTION INTEGRATED BETWEEN TWO WAVENUMBERS
C
C  NOTE ** CHANGE 'R1MACH' TO 'D1MACH' TO RUN IN REAL*8
C
C  I N P U T :  WNUMLO : LOWER WAVENUMBER ( INV CM ) OF SPECTRAL
C                           INTERVAL
C               WNUMHI : UPPER WAVENUMBER
C               T      : TEMPERATURE (K)
C
C  O U T P U T :  PLKAVG : INTEGRATED PLANCK FUNCTION ( WATTS/SQ M )
C                           = INTEGRAL (WNUMLO TO WNUMHI) OF
C                              2H C**2  NU**3 / ( DEXP(HC NU/KT) - 1)
C                              (WHERE H=PLANCKS CONSTANT, C=SPEED OF
C                              LIGHT, NU=WAVENUMBER, T=TEMPERATURE,
C                              AND K = BOLTZMANN CONSTANT)
C
C  REFERENCE : SPECIFICATIONS OF THE PHYSICAL WORLD: NEW VALUE
C                 OF THE FUNDAMENTAL CONSTANTS, DIMENSIONS/N.B.S.,
C                 JAN. 1974
C
C  METHOD :  FOR  -WNUMLO-  CLOSE TO  -WNUMHI-, A SIMPSON-RULE
C            QUADRATURE IS DONE TO AVOID ILL-CONDITIONING; OTHERWISE
C
C            (1)  FOR WAVENUMBER (WNUMLO OR WNUMHI) SMALL,
C                 INTEGRAL(0 TO WNUM) IS CALCULATED BY EXPANDING
C                 THE INTEGRAND IN A POWER SERIES AND INTEGRATING
C                 TERM BY TERM;
C
C            (2)  OTHERWISE, INTEGRAL(WNUMLO/HI TO INFINITY) IS
C                 CALCULATED BY EXPANDING THE DENOMINATOR OF THE
C                 INTEGRAND IN POWERS OF THE EXPONENTIAL AND
C                 INTEGRATING TERM BY TERM.
C
C  ACCURACY :  AT LEAST 6 SIGNIFICANT DIGITS, ASSUMING THE
C              PHYSICAL CONSTANTS ARE INFINITELY ACCURATE
C
C  ERRORS WHICH ARE NOT TRAPPED:
C
C      * POWER OR EXPONENTIAL SERIES MAY UNDERFLOW, GIVING NO
C        SIGNIFICANT DIGITS.  THIS MAY OR MAY NOT BE OF CONCERN,
C        DEPENDING ON THE APPLICATION.
C
C      * SIMPSON-RULE SPECIAL CASE IS SKIPPED WHEN DENOMINATOR OF
C        INTEGRAND WILL CAUSE OVERFLOW.  IN THAT CASE THE NORMAL
C        PROCEDURE IS USED, WHICH MAY BE INACCURATE IF THE
C        WAVENUMBER LIMITS (WNUMLO, WNUMHI) ARE CLOSE TOGETHER.
C ----------------------------------------------------------------------
C                                   *** ARGUMENTS
	IMPLICIT REAL*8 (A-H, O-Z)

C                                   *** LOCAL VARIABLES
C
C        A1,2,... :  POWER SERIES COEFFICIENTS
C        C2       :  H * C / K, IN UNITS CM*K (H = PLANCKS CONSTANT,
C                      C = SPEED OF LIGHT, K = BOLTZMANN CONSTANT)
C        D(I)     :  EXPONENTIAL SERIES EXPANSION OF INTEGRAL OF
C                       PLANCK FUNCTION FROM WNUMLO (I=1) OR WNUMHI
C                       (I=2) TO INFINITY
C        EPSIL    :  SMALLEST NUMBER SUCH THAT 1+EPSIL .GT. 1 ON
C                       COMPUTER
C        EX       :  DEXP( - V(I) )
C        EXM      :  EX**M
C        MMAX     :  NO. OF TERMS TO TAKE IN EXPONENTIAL SERIES
C        MV       :  MULTIPLES OF 'V(I)'
C        P(I)     :  POWER SERIES EXPANSION OF INTEGRAL OF
C                       PLANCK FUNCTION FROM ZERO TO WNUMLO (I=1) OR
C                       WNUMHI (I=2)
C        PI       :  3.14159...
C        SIGMA    :  STEFAN-BOLTZMANN CONSTANT (W/M**2/K**4)
C        SIGDPI   :  SIGMA / PI
C        SMALLV   :  NUMBER OF TIMES THE POWER SERIES IS USED (0,1,2)
C        V(I)     :  C2 * (WNUMLO(I=1) OR WNUMHI(I=2)) / TEMPERATURE
C        VCUT     :  POWER-SERIES CUTOFF POINT
C        VCP      :  EXPONENTIAL SERIES CUTOFF POINTS
C        VMAX     :  LARGEST ALLOWABLE ARGUMENT OF 'EXP' FUNCTION
C
      PARAMETER ( A1 = 1.D0/3.D0, A2 = -1.D0/8.D0, A3 = 1.D0/60.D0,
     $  A4 = -1.D0/5040.D0, A5 = 1.D0/272160.D0, A6 =-1.D0/13305600.D0)
      INTEGER  SMALLV
      REAL*8   C2, CONC, D(2), EPSIL, EX, MV, P(2), SIGMA, SIGDPI,
     $         V(2), VCUT, VCP(7), VSQ
      SAVE     CONC, VMAX, EPSIL, SIGDPI
      DATA     C2 / 1.438786D0 /,  SIGMA / 5.67032D-8 /,
     $         VCUT / 1.5D0 /, VCP / 10.25D0, 5.7D0, 3.9D0, 2.9D0,
     $         2.3D0, 1.9D0, 0.0D0 /
      DATA     PI / 0.0D0 /
      F(X) = X**3 / ( DEXP(X) - 1 )
C
C
      IF ( PI.EQ.0.0D0 )  THEN
         PI = 2.D0 * DASIN( 1.0D0 )
         VMAX = 709.0D0
         EPSIL = 2.22D-16
         SIGDPI = SIGMA / PI
         CONC = 15.D0 / PI**4
      END IF
C
      IF( T.LT.0.0D0 .OR. WNUMHI.LE.WNUMLO .OR. WNUMLO.LT.0.D0 )
     $    CALL ERRMSG( 'PLKAVG--TEMPERATURE OR WAVENUMS. WRONG', .TRUE.)
C
      IF ( T.LT.1.D-4 )  THEN
         PLKAVG = 0.0D0
         RETURN
      ENDIF
C
      V(1) = C2 * WNUMLO / T
      V(2) = C2 * WNUMHI / T
      IF ( V(1).GT.EPSIL .AND. V(2).LT.VMAX .AND.
     $     (WNUMHI-WNUMLO)/WNUMHI .LT. 1.D-2 )  THEN
C
C                          ** WAVENUMBERS ARE VERY CLOSE.  GET INTEGRAL
C                          ** BY ITERATING SIMPSON RULE TO CONVERGENCE.
         HH = V(2) - V(1)
         OLDVAL = 0.0D0
         VAL0 = F( V(1) ) + F( V(2) )
C
         DO  2  N = 1, 10
            DEL = HH / (2*N)
            VAL = VAL0
            DO  1  K = 1, 2*N-1
               VAL = VAL + 2*(1+MOD(K,2)) * F( V(1) + K*DEL )
    1       CONTINUE
            VAL = DEL/3.D0 * VAL
            IF ( DABS( (VAL-OLDVAL)/VAL ) .LE. 1.D-6 )  GO TO 3
            OLDVAL = VAL
    2    CONTINUE
         CALL ERRMSG( 'PLKAVG--SIMPSON RULE DIDNT CONVERGE', .FALSE. )
C
    3    PLKAVG = SIGDPI * T**4 * CONC * VAL
         RETURN
      END IF
C
      SMALLV = 0
      DO  50  I = 1, 2
C
         IF( V(I).LT.VCUT )  THEN
C                                   ** USE POWER SERIES
            SMALLV = SMALLV + 1
            VSQ = V(I)**2
            P(I) =  CONC * VSQ * V(I) * ( A1 + V(I) * ( A2 + V(I) *
     $                ( A3 + VSQ * ( A4 + VSQ * ( A5 + VSQ*A6 ) ) ) ) )
         ELSE
C                    ** USE EXPONENTIAL SERIES
            MMAX = 0
C                                ** FIND UPPER LIMIT OF SERIES
   20       MMAX = MMAX + 1
               IF ( V(I).LT.VCP( MMAX ) )  GO TO 20
C
            EX = DEXP( - V(I) )
            EXM = 1.0D0
            D(I) = 0.0D0
C
            DO  30  M = 1, MMAX
               MV = M * V(I)
               EXM = EX * EXM
               D(I) = D(I) +
     $                EXM * ( 6.D0+MV*(6.D0+MV*(3.D0+ MV ) ) ) / M**4
   30       CONTINUE
C
            D(I) = CONC * D(I)
         END IF
C
   50 CONTINUE
C
      IF ( SMALLV .EQ. 2 ) THEN
C                                    ** WNUMLO AND WNUMHI BOTH SMALL
         PLKAVG = P(2) - P(1)
C
      ELSE IF ( SMALLV .EQ. 1 ) THEN
C                                    ** WNUMLO SMALL, WNUMHI LARGE
         PLKAVG = 1.D0 - P(1) - D(2)
C
      ELSE
C                                    ** WNUMLO AND WNUMHI BOTH LARGE
         PLKAVG = D(1) - D(2)
C
      END IF
C
      PLKAVG = SIGDPI * T**4 * PLKAVG
      IF( PLKAVG.EQ.0.0D0 )
     $    CALL ERRMSG( 'PLKAVG--RETURNS ZERO; POSSIBLE UNDERFLOW',
     $                 .FALSE. )
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE  ERRMSG( MESSAG, FATAL )
C
C        PRINT OUT A WARNING OR ERROR MESSAGE;  ABORT IF ERROR
C
      LOGICAL       FATAL, ONCE
      CHARACTER*(*) MESSAG
      INTEGER       MAXMSG, NUMMSG
      SAVE          MAXMSG, NUMMSG, ONCE
      DATA NUMMSG / 0 /,  MAXMSG / 100 /,  ONCE / .FALSE. /
C
C
      IF ( FATAL )  THEN
         WRITE ( 3, '(/,2A)' )  ' ******* ERROR >>>>>>  ', MESSAG
         STOP
      END IF
C
      NUMMSG = NUMMSG + 1
      IF ( NUMMSG.GT.MAXMSG )  THEN
         IF ( .NOT.ONCE )  WRITE ( 3,99 )
         ONCE = .TRUE.
      ELSE
         WRITE ( 3, '(/,2A)' )  ' ******* WARNING >>>>>>  ', MESSAG
      ENDIF
C
      RETURN
C
   99 FORMAT( ///,' >>>>>>  TOO MANY WARNING MESSAGES --  ',
     $   'THEY WILL NO LONGER BE PRINTED  <<<<<<<', /// )
      END
C**********************************************************************
      SUBROUTINE  WRTBAD ( VARNAM, ERFLAG )
C
C          WRITE NAMES OF ERRONEOUS VARIABLES
C
C      INPUT :   VARNAM = NAME OF ERRONEOUS VARIABLE TO BE WRITTEN
C                         ( CHARACTER, ANY LENGTH )
C
C      OUTPUT :  ERFLAG = LOGICAL FLAG, SET TRUE BY THIS ROUTINE
C ----------------------------------------------------------------------
      CHARACTER*(*)  VARNAM
      LOGICAL        ERFLAG
      INTEGER        MAXMSG, NUMMSG
      SAVE  NUMMSG, MAXMSG
      DATA  NUMMSG / 0 /,  MAXMSG / 50 /
C
C
      NUMMSG = NUMMSG + 1
      WRITE ( 3, '(3A)' )  ' ****  INPUT VARIABLE  ', VARNAM,
     $                     '  IN ERROR  ****'
      ERFLAG = .TRUE.
      IF ( NUMMSG.EQ.MAXMSG )
     $   CALL  ERRMSG ( 'TOO MANY INPUT ERRORS.  ABORTING...$', .TRUE. )
      RETURN
      END
C**********************************************************************
      SUBROUTINE  WRTDIM ( DIMNAM, MINVAL, ERFLAG )
C
C          WRITE NAME OF TOO-SMALL SYMBOLIC DIMENSION AND
C          THE VALUE IT SHOULD BE INCREASED TO
C
C      INPUT :  DIMNAM = NAME OF SYMBOLIC DIMENSION WHICH IS TOO SMALL
C                        ( CHARACTER, ANY LENGTH )
C               MINVAL = VALUE TO WHICH THAT DIMENSION SHOULD BE
C                        INCREASED (AT LEAST)
C
C      OUTPUT : ERFLAG = LOGICAL FLAG, SET TRUE BY THIS ROUTINE
C ----------------------------------------------------------------------
      CHARACTER*(*)  DIMNAM
      LOGICAL        ERFLAG
      INTEGER        MINVAL
C
C
      WRITE ( 3, '(3A,I7)' )  ' ****  SYMBOLIC DIMENSION  ', DIMNAM,
     $                     '  SHOULD BE INCREASED TO AT LEAST ', MINVAL
      ERFLAG = .TRUE.
      RETURN
      END
C**********************************************************************
      SUBROUTINE  TSTBAD( VARNAM, RELERR, OK )
C
C       WRITE NAME (-VARNAM-) OF VARIABLE FAILING SELF-TEST AND ITS
C       PERCENT ERROR FROM THE CORRECT VALUE.  RETURN  OK = FALSE.
C
      CHARACTER*(*)  VARNAM
      LOGICAL        OK
      REAL*8   RELERR
C
C
      OK = .FALSE.
      WRITE( 3, '(/,3A,1P,E11.2,A)' )
     $       ' OUTPUT VARIABLE  ', VARNAM,'  DIFFERED BY', 100.*RELERR,
     $       '  PER CENT FROM CORRECT VALUE.  SELF-TEST FAILED.'
      RETURN
C
      END
c----------------------------------------------------------------------
      SUBROUTINE  SGBCO( ABD, LDA, N, ML, MU, IPVT, RCOND, Z )
C
C         FACTORS A REAL BAND MATRIX BY GAUSSIAN ELIMINATION 
C         AND ESTIMATES THE CONDITION OF THE MATRIX.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C     IF  RCOND  IS NOT NEEDED, SGBFA IS SLIGHTLY FASTER.
C     TO SOLVE  A*X = B , FOLLOW SBGCO BY SGBSL.
C     TO COMPUTE  INVERSE(A)*C , FOLLOW SBGCO BY SGBSL.
C     TO COMPUTE  DETERMINANT(A) , FOLLOW SBGCO BY SGBDI.
C
C     ON ENTRY
C
C        ABD     REAL(LDA, N)
C                CONTAINS THE MATRIX IN BAND STORAGE.  THE COLUMNS
C                OF THE MATRIX ARE STORED IN THE COLUMNS OF  ABD  AND
C                THE DIAGONALS OF THE MATRIX ARE STORED IN ROWS
C                ML+1 THROUGH 2*ML+MU+1 OF  ABD .
C                SEE THE COMMENTS BELOW FOR DETAILS.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  ABD .
C                LDA MUST BE .GE. 2*ML + MU + 1 .
C
C        N       INTEGER
C                THE ORDER OF THE ORIGINAL MATRIX.
C
C        ML      INTEGER
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.
C                0 .LE. ML .LT. N .
C
C        MU      INTEGER
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.
C                0 .LE. MU .LT. N .
C                MORE EFFICIENT IF  ML .LE. MU .
C
C     ON RETURN
C
C        ABD     AN UPPER TRIANGULAR MATRIX IN BAND STORAGE AND
C                THE MULTIPLIERS WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        RCOND   REAL
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND .
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION
C                           1.0 + RCOND .EQ. 1.0
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE
C                UNDERFLOWS.
C
C        Z       REAL(N)
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .
C
C     BAND STORAGE
C
C           IF  A  IS A BAND MATRIX, THE FOLLOWING PROGRAM SEGMENT
C           WILL SET UP THE INPUT.
C
C                   ML = (BAND WIDTH BELOW THE DIAGONAL)
C                   MU = (BAND WIDTH ABOVE THE DIAGONAL)
C                   M = ML + MU + 1
C                   DO 20 J = 1, N
C                      I1 = MAX0(1, J-MU)
C                      I2 = MIN0(N, J+ML)
C                      DO 10 I = I1, I2
C                         K = I - J + M
C                         ABD(K,J) = A(I,J)
C                10    CONTINUE
C                20 CONTINUE
C
C           THIS USES ROWS  ML+1  THROUGH  2*ML+MU+1  OF  ABD .
C           IN ADDITION, THE FIRST  ML  ROWS IN  ABD  ARE USED FOR
C           ELEMENTS GENERATED DURING THE TRIANGULARIZATION.
C           THE TOTAL NUMBER OF ROWS NEEDED IN  ABD  IS  2*ML+MU+1 .
C           THE  ML+MU BY ML+MU  UPPER LEFT TRIANGLE AND THE
C           ML BY ML  LOWER RIGHT TRIANGLE ARE NOT REFERENCED.
C
C     EXAMPLE:  IF THE ORIGINAL MATRIX IS
C
C           11 12 13  0  0  0
C           21 22 23 24  0  0
C            0 32 33 34 35  0
C            0  0 43 44 45 46
C            0  0  0 54 55 56
C            0  0  0  0 65 66
C
C      THEN  N = 6, ML = 1, MU = 2, LDA .GE. 5  AND ABD SHOULD CONTAIN
C
C            *  *  *  +  +  +  , * = NOT USED
C            *  * 13 24 35 46  , + = USED FOR PIVOTING
C            * 12 23 34 45 56
C           11 22 33 44 55 66
C           21 32 43 54 65  *
C
C
C     ROUTINES CALLED:  FROM LINPACK: SGBFA
C                       FROM BLAS:    SAXPY, SDOT, SSCAL, SASUM
C                       FROM FORTRAN: DABS, DMAX1, MAX0, MIN0, DSIGN
C
      INTEGER  LDA, N, ML, MU, IPVT(*)
      DOUBLE PRECISION     ABD(LDA,*), Z(*)
      DOUBLE PRECISION     RCOND
C
      DOUBLE PRECISION     SDOT, EK, T, WK, WKM
      DOUBLE PRECISION     ANORM, S, SASUM, SM, YNORM
      INTEGER  IS, INFO, J, JU, K, KB, KP1, L, LA, LM, LZ, M, MM
C
C
C                       ** COMPUTE 1-NORM OF A
      ANORM = 0.0D0
      L = ML + 1
      IS = L + MU
      DO 10 J = 1, N
         ANORM = DMAX1(ANORM, SASUM(L,ABD(IS,J), 1))
         IF (IS .GT. ML + 1) IS = IS - 1
         IF (J .LE. MU) L = L + 1
         IF (J .GE. N - ML) L = L - 1
   10 CONTINUE
C                                               ** FACTOR
      CALL SGBFA(ABD, LDA, N, ML, MU, IPVT, INFO)
C
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  TRANS(A)*Y = E .
C     TRANS(A)  IS THE TRANSPOSE OF A .  THE COMPONENTS OF  E  ARE
C     CHOSEN TO CAUSE MAXIMUM LOCAL GROWTH IN THE ELEMENTS OF W  WHERE
C     TRANS(U)*W = E .  THE VECTORS ARE FREQUENTLY RESCALED TO AVOID
C     OVERFLOW.
C
C                     ** SOLVE TRANS(U)*W = E
      EK = 1.0D0
      DO 20 J = 1, N
         Z(J) = 0.0D0
   20 CONTINUE
C
      M = ML + MU + 1
      JU = 0
      DO 100 K = 1, N
         IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK, -Z(K))
         IF (DABS(EK-Z(K)) .GT. DABS(ABD(M,K))) THEN
            S = DABS(ABD(M,K))/DABS(EK-Z(K))
            CALL SSCAL(N, S, Z, 1)
            EK = S*EK
         ENDIF
         WK = EK - Z(K)
         WKM = -EK - Z(K)
         S = DABS(WK)
         SM = DABS(WKM)
         IF (ABD(M,K) .NE. 0.0D0) THEN
            WK  = WK /ABD(M,K)
            WKM = WKM/ABD(M,K)
         ELSE
            WK  = 1.0D0
            WKM = 1.0D0
         ENDIF
         KP1 = K + 1
         JU = MIN0(MAX0(JU, MU+IPVT(K)), N)
         MM = M
         IF (KP1 .LE. JU) THEN
            DO 60 J = KP1, JU
               MM = MM - 1
               SM = SM + DABS(Z(J)+WKM*ABD(MM,J))
               Z(J) = Z(J) + WK*ABD(MM,J)
               S = S + DABS(Z(J))
   60       CONTINUE
            IF (S .LT. SM) THEN
               T = WKM - WK
               WK = WKM
               MM = M
               DO 70 J = KP1, JU
                  MM = MM - 1
                  Z(J) = Z(J) + T*ABD(MM,J)
   70          CONTINUE
            ENDIF
         ENDIF
         Z(K) = WK
  100 CONTINUE
C
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
C
C                         ** SOLVE TRANS(L)*Y = W
      DO 120 KB = 1, N
         K = N + 1 - KB
         LM = MIN0(ML, N-K)
         IF (K .LT. N) Z(K) = Z(K) + SDOT(LM, ABD(M+1,K), 1, Z(K+1), 1)
         IF (DABS(Z(K)) .GT. 1.0D0) THEN
            S = 1.0D0 / DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
         ENDIF
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
  120 CONTINUE
C
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
C
      YNORM = 1.0D0
C                         ** SOLVE L*V = Y
      DO 140 K = 1, N
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
         LM = MIN0(ML, N-K)
         IF (K .LT. N) CALL SAXPY(LM, T, ABD(M+1,K), 1, Z(K+1), 1)
         IF (DABS(Z(K)) .GT. 1.0D0) THEN
            S = 1.0D0 / DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
            YNORM = S*YNORM
         ENDIF
  140 CONTINUE
C
      S = 1.0D0/SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
      YNORM = S*YNORM
C                           ** SOLVE  U*Z = W
      DO 160 KB = 1, N
         K = N + 1 - KB
         IF (DABS(Z(K)) .GT. DABS(ABD(M,K))) THEN
            S = DABS(ABD(M,K)) / DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
            YNORM = S*YNORM
         ENDIF
         IF (ABD(M,K) .NE. 0.0D0) Z(K) = Z(K)/ABD(M,K)
         IF (ABD(M,K) .EQ. 0.0D0) Z(K) = 1.0D0
         LM = MIN0(K, M) - 1
         LA = M - LM
         LZ = K - LM
         T = -Z(K)
         CALL SAXPY(LM, T, ABD(LA,K), 1, Z(LZ), 1)
  160 CONTINUE
C                              ** MAKE ZNORM = 1.0
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
      YNORM = S*YNORM
C
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0
      RETURN
      END
      SUBROUTINE  SGBFA( ABD, LDA, N, ML, MU, IPVT, INFO )
C
C         FACTORS A REAL BAND MATRIX BY ELIMINATION.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C     SGBFA IS USUALLY CALLED BY SBGCO, BUT IT CAN BE CALLED
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.
C
C     ON ENTRY
C
C        ABD     REAL(LDA, N)
C                CONTAINS THE MATRIX IN BAND STORAGE.  THE COLUMNS
C                OF THE MATRIX ARE STORED IN THE COLUMNS OF  ABD  AND
C                THE DIAGONALS OF THE MATRIX ARE STORED IN ROWS
C                ML+1 THROUGH 2*ML+MU+1 OF  ABD .
C                SEE THE COMMENTS BELOW FOR DETAILS.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  ABD .
C                LDA MUST BE .GE. 2*ML + MU + 1 .
C
C        N       INTEGER
C                THE ORDER OF THE ORIGINAL MATRIX.
C
C        ML      INTEGER
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.
C                0 .LE. ML .LT. N .
C
C        MU      INTEGER
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.
C                0 .LE. MU .LT. N .
C                MORE EFFICIENT IF  ML .LE. MU .
C     ON RETURN
C
C        ABD     AN UPPER TRIANGULAR MATRIX IN BAND STORAGE AND
C                THE MULTIPLIERS WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U , WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        INFO    INTEGER
C                = 0  NORMAL VALUE.
C                = K  IF  U(K,K) .EQ. 0.0 .  THIS IS NOT AN ERROR
C                     CONDITION FOR THIS SUBROUTINE, BUT IT DOES
C                     INDICATE THAT SGBSL WILL DIVIDE BY ZERO IF
C                     CALLED.  USE  RCOND  IN SBGCO FOR A RELIABLE
C                     INDICATION OF SINGULARITY.
C
C     (SEE SUBROUTINE SGBCO FOR DESCRIPTION OF BAND STORAGE MODE)
C
C     ROUTINES CALLED:  FROM BLAS:    SAXPY, SSCAL, ISAMAX
C                       FROM FORTRAN: MAX0, MIN0
C
      INTEGER  LDA, N, ML, MU, IPVT(*), INFO
      DOUBLE PRECISION     ABD(LDA,*)
C
      DOUBLE PRECISION     T
      INTEGER  I,ISAMAX,I0,J,JU,JZ,J0,J1,K,KP1,L,LM,M,MM,NM1
C
C
      M = ML + MU + 1
      INFO = 0
C                        ** ZERO INITIAL FILL-IN COLUMNS
      J0 = MU + 2
      J1 = MIN0(N, M) - 1
      DO 20 JZ = J0, J1
         I0 = M + 1 - JZ
         DO 10 I = I0, ML
            ABD(I,JZ) = 0.0D0
   10    CONTINUE
   20 CONTINUE
      JZ = J1
      JU = 0
C
C                       ** GAUSSIAN ELIMINATION WITH PARTIAL PIVOTING
      NM1 = N - 1
      DO 120 K = 1, NM1
         KP1 = K + 1
C                                  ** ZERO NEXT FILL-IN COLUMN
         JZ = JZ + 1
         IF (JZ .LE. N) THEN
            DO 40 I = 1, ML
               ABD(I,JZ) = 0.0D0
   40       CONTINUE
         ENDIF
C                                  ** FIND L = PIVOT INDEX
         LM = MIN0(ML, N-K)
         L = ISAMAX(LM+1, ABD(M,K), 1) + M - 1
         IPVT(K) = L + K - M
C
         IF (ABD(L,K) .EQ. 0.0D0) THEN
C                                      ** ZERO PIVOT IMPLIES THIS COLUMN 
C                                      ** ALREADY TRIANGULARIZED
            INFO = K
         ELSE
C                                ** INTERCHANGE IF NECESSARY
            IF (L .NE. M) THEN
               T = ABD(L,K)
               ABD(L,K) = ABD(M,K)
               ABD(M,K) = T
            ENDIF
C                                   ** COMPUTE MULTIPLIERS
            T = -1.0D0 / ABD(M,K)
            CALL SSCAL(LM, T, ABD(M+1,K), 1)
C
C                               ** ROW ELIMINATION WITH COLUMN INDEXING
C
            JU = MIN0(MAX0(JU, MU+IPVT(K)), N)
            MM = M
            DO 80 J = KP1, JU
               L = L - 1
               MM = MM - 1
               T = ABD(L,J)
               IF (L .NE. MM) THEN
                  ABD(L,J) = ABD(MM,J)
                  ABD(MM,J) = T
               ENDIF
               CALL SAXPY(LM, T, ABD(M+1,K), 1, ABD(MM+1,J), 1)
   80       CONTINUE
C
         ENDIF
C
  120 CONTINUE
C
      IPVT(N) = N
      IF (ABD(M,N) .EQ. 0.0D0) INFO = N
      RETURN
      END
      SUBROUTINE  SGBSL( ABD, LDA, N, ML, MU, IPVT, B, JOB )
C
C         SOLVES THE REAL BAND SYSTEM
C            A * X = B  OR  TRANS(A) * X = B
C         USING THE FACTORS COMPUTED BY SBGCO OR SGBFA.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C     ON ENTRY
C
C        ABD     REAL(LDA, N)
C                THE OUTPUT FROM SBGCO OR SGBFA.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  ABD .
C
C        N       INTEGER
C                THE ORDER OF THE ORIGINAL MATRIX.
C
C        ML      INTEGER
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.
C
C        MU      INTEGER
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.
C
C        IPVT    INTEGER(N)
C                THE PIVOT VECTOR FROM SBGCO OR SGBFA.
C
C        B       REAL(N)
C                THE RIGHT HAND SIDE VECTOR.
C
C        JOB     INTEGER
C                = 0         TO SOLVE  A*X = B ,
C                = NONZERO   TO SOLVE  TRANS(A)*X = B , WHERE
C                            TRANS(A)  IS THE TRANSPOSE.
C
C     ON RETURN
C
C        B       THE SOLUTION VECTOR  X .
C
C     ERROR CONDITION
C
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS A
C        ZERO ON THE DIAGONAL.  TECHNICALLY, THIS INDICATES SINGULARITY,
C        BUT IT IS OFTEN CAUSED BY IMPROPER ARGUMENTS OR IMPROPER
C        SETTING OF LDA .  IT WILL NOT OCCUR IF THE SUBROUTINES ARE
C        CALLED CORRECTLY AND IF SBGCO HAS SET RCOND .GT. 0.0
C        OR SGBFA HAS SET INFO .EQ. 0 .
C
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX
C     WITH  P  COLUMNS
C           CALL SGBCO(ABD,LDA,N,ML,MU,IPVT,RCOND,Z)
C           IF (RCOND IS TOO SMALL) GO TO ...
C           DO 10 J = 1, P
C              CALL SGBSL(ABD,LDA,N,ML,MU,IPVT,C(1,J),0)
C        10 CONTINUE
C
C     ROUTINES CALLED:  FROM BLAS:    SAXPY, SDOT
C                       FROM FORTRAN: MIN0
C
      INTEGER  LDA, N, ML, MU, IPVT(*), JOB
      DOUBLE PRECISION     ABD(LDA,*), B(*)
C
      DOUBLE PRECISION     SDOT,T
      INTEGER  K,KB,L,LA,LB,LM,M,NM1
C
C
      M = MU + ML + 1
      NM1 = N - 1
      IF (JOB .EQ. 0) THEN
C                               ** JOB = 0 , SOLVE  A * X = B
C                               ** FIRST SOLVE L*Y = B
         IF (ML .NE. 0) THEN
            DO 20 K = 1, NM1
               LM = MIN0(ML, N-K)
               L = IPVT(K)
               T = B(L)
               IF (L .NE. K) THEN
                  B(L) = B(K)
                  B(K) = T
               ENDIF
               CALL SAXPY( LM, T, ABD(M+1,K), 1, B(K+1), 1 )
   20       CONTINUE
         ENDIF
C                           ** NOW SOLVE  U*X = Y
         DO 40 KB = 1, N
            K = N + 1 - KB
            B(K) = B(K) / ABD(M,K)
            LM = MIN0(K, M) - 1
            LA = M - LM
            LB = K - LM
            T = -B(K)
            CALL SAXPY(LM, T, ABD(LA,K), 1, B(LB), 1)
   40    CONTINUE
C
      ELSE
C                          ** JOB = NONZERO, SOLVE  TRANS(A) * X = B
C                                  ** FIRST SOLVE  TRANS(U)*Y = B
         DO 60 K = 1, N
            LM = MIN0(K, M) - 1
            LA = M - LM
            LB = K - LM
            T = SDOT(LM, ABD(LA,K), 1, B(LB), 1)
            B(K) = (B(K) - T)/ABD(M,K)
   60    CONTINUE
C                                  ** NOW SOLVE TRANS(L)*X = Y
         IF (ML .NE. 0) THEN
            DO 80 KB = 1, NM1
               K = N - KB
               LM = MIN0(ML, N-K)
               B(K) = B(K) + SDOT(LM, ABD(M+1,K), 1, B(K+1), 1)
               L = IPVT(K)
               IF (L .NE. K) THEN
                  T = B(L)
                  B(L) = B(K)
                  B(K) = T
               ENDIF
   80       CONTINUE
         ENDIF
C
      ENDIF
C
      RETURN
      END
      SUBROUTINE  SGEFA( A, LDA, N, IPVT, INFO )
C
C         FACTORS A REAL MATRIX BY GAUSSIAN ELIMINATION.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C     SGEFA IS USUALLY CALLED BY SGECO, BUT IT CAN BE CALLED
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.
C     (TIME FOR SGECO) = (1 + 9/N)*(TIME FOR SGEFA) .
C
C     ON ENTRY
C
C        A       REAL(LDA, N)
C                THE MATRIX TO BE FACTORED.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS
C                WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U , WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        INFO    INTEGER
C                = 0  NORMAL VALUE.
C                = K  IF  U(K,K) .EQ. 0.0 .  THIS IS NOT AN ERROR
C                     CONDITION FOR THIS SUBROUTINE, BUT IT DOES
C                     INDICATE THAT SGESL OR SGEDI WILL DIVIDE BY ZERO
C                     IF CALLED.  USE  RCOND  IN SGECO FOR A RELIABLE
C                     INDICATION OF SINGULARITY.
C
C     ROUTINES CALLED:  FROM BLAS:    SAXPY, SSCAL, ISAMAX
C
      INTEGER  LDA, N, IPVT(*), INFO
      DOUBLE PRECISION     A(LDA,*)
C
      DOUBLE PRECISION     T
      INTEGER  ISAMAX,J,K,KP1,L,NM1
C
C
C                      ** GAUSSIAN ELIMINATION WITH PARTIAL PIVOTING
      INFO = 0
      NM1 = N - 1
      DO 60 K = 1, NM1
         KP1 = K + 1
C                                            ** FIND L = PIVOT INDEX
         L = ISAMAX( N-K+1, A(K,K), 1) + K-1
         IPVT(K) = L
C
         IF (A(L,K) .EQ. 0.0D0) THEN
C                                     ** ZERO PIVOT IMPLIES THIS COLUMN 
C                                     ** ALREADY TRIANGULARIZED
            INFO = K
         ELSE
C                                     ** INTERCHANGE IF NECESSARY
            IF (L .NE. K) THEN
               T = A(L,K)
               A(L,K) = A(K,K)
               A(K,K) = T
            ENDIF
C                                     ** COMPUTE MULTIPLIERS
            T = -1.0D0 / A(K,K)
            CALL SSCAL( N-K, T, A(K+1,K), 1 )
C
C                              ** ROW ELIMINATION WITH COLUMN INDEXING
            DO 30 J = KP1, N
               T = A(L,J)
               IF (L .NE. K) THEN
                  A(L,J) = A(K,J)
                  A(K,J) = T
               ENDIF
               CALL SAXPY( N-K, T, A(K+1,K), 1, A(K+1,J), 1 )
   30       CONTINUE
C
         ENDIF
C
   60 CONTINUE
C
      IPVT(N) = N
      IF (A(N,N) .EQ. 0.0D0) INFO = N
      RETURN
      END
      SUBROUTINE  SGECO( A, LDA, N,IPVT, RCOND, Z )
C
C         FACTORS A REAL MATRIX BY GAUSSIAN ELIMINATION
C         AND ESTIMATES THE CONDITION OF THE MATRIX.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C         IF  RCOND  IS NOT NEEDED, SGEFA IS SLIGHTLY FASTER.
C         TO SOLVE  A*X = B , FOLLOW SGECO BY SGESL.
C         TO COMPUTE  INVERSE(A)*C , FOLLOW SGECO BY SGESL.
C         TO COMPUTE  DETERMINANT(A) , FOLLOW SGECO BY SGEDI.
C         TO COMPUTE  INVERSE(A) , FOLLOW SGECO BY SGEDI.
C
C     ON ENTRY
C
C        A       REAL(LDA, N)
C                THE MATRIX TO BE FACTORED.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS
C                WHICH WERE USED TO OBTAIN IT.
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U , WHERE
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.
C
C        IPVT    INTEGER(N)
C                AN INTEGER VECTOR OF PIVOT INDICES.
C
C        RCOND   REAL
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND .
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION
C                           1.0 + RCOND .EQ. 1.0
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE
C                UNDERFLOWS.
C
C        Z       REAL(N)
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .
C
C     ROUTINES CALLED:  FROM LINPACK: SGEFA
C                       FROM BLAS:    SAXPY, SDOT, SSCAL, SASUM
C                       FROM FORTRAN: DABS, DMAX1, DSIGN
C
      INTEGER  LDA, N, IPVT(*)
      DOUBLE PRECISION     A(LDA,*), Z(*)
      DOUBLE PRECISION     RCOND
C
      DOUBLE PRECISION     SDOT,EK,T,WK,WKM
      DOUBLE PRECISION     ANORM,S,SASUM,SM,YNORM
      INTEGER  INFO,J,K,KB,KP1,L
C
C
C                        ** COMPUTE 1-NORM OF A
      ANORM = 0.0D0
      DO 10 J = 1, N
         ANORM = DMAX1( ANORM, SASUM(N,A(1,J),1) )
   10 CONTINUE
C                                      ** FACTOR
      CALL SGEFA(A,LDA,N,IPVT,INFO)
C
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  TRANS(A)*Y = E .
C     TRANS(A)  IS THE TRANSPOSE OF A .  THE COMPONENTS OF  E  ARE
C     CHOSEN TO CAUSE MAXIMUM LOCAL GROWTH IN THE ELEMENTS OF W  WHERE
C     TRANS(U)*W = E .  THE VECTORS ARE FREQUENTLY RESCALED TO AVOID
C     OVERFLOW.
C
C                        ** SOLVE TRANS(U)*W = E
      EK = 1.0D0
      DO 20 J = 1, N
         Z(J) = 0.0D0
   20 CONTINUE
C
      DO 100 K = 1, N
         IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK, -Z(K))
         IF (DABS(EK-Z(K)) .GT. DABS(A(K,K))) THEN
            S = DABS(A(K,K)) / DABS(EK-Z(K))
            CALL SSCAL(N, S, Z, 1)
            EK = S*EK
         ENDIF
         WK = EK - Z(K)
         WKM = -EK - Z(K)
         S = DABS(WK)
         SM = DABS(WKM)
         IF (A(K,K) .NE. 0.0D0) THEN
            WK  = WK  / A(K,K)
            WKM = WKM / A(K,K)
         ELSE
            WK  = 1.0D0
            WKM = 1.0D0
         ENDIF
         KP1 = K + 1
         IF (KP1 .LE. N) THEN
            DO 60 J = KP1, N
               SM = SM + DABS(Z(J)+WKM*A(K,J))
               Z(J) = Z(J) + WK*A(K,J)
               S = S + DABS(Z(J))
   60       CONTINUE
            IF (S .LT. SM) THEN
               T = WKM - WK
               WK = WKM
               DO 70 J = KP1, N
                  Z(J) = Z(J) + T*A(K,J)
   70          CONTINUE
            ENDIF
         ENDIF
         Z(K) = WK
  100 CONTINUE
C
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
C                                ** SOLVE TRANS(L)*Y = W
      DO 120 KB = 1, N
         K = N + 1 - KB
         IF (K .LT. N) Z(K) = Z(K) + SDOT(N-K, A(K+1,K), 1, Z(K+1), 1)
         IF (DABS(Z(K)) .GT. 1.0D0) THEN
            S = 1.0D0/DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
         ENDIF
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
  120 CONTINUE
C
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
C                                 ** SOLVE L*V = Y
      YNORM = 1.0D0
      DO 140 K = 1, N
         L = IPVT(K)
         T = Z(L)
         Z(L) = Z(K)
         Z(K) = T
         IF (K .LT. N) CALL SAXPY(N-K, T, A(K+1,K), 1, Z(K+1), 1)
         IF (DABS(Z(K)) .GT. 1.0D0) THEN
            S = 1.0D0/DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
            YNORM = S*YNORM
         ENDIF
  140 CONTINUE
C
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
C                                  ** SOLVE  U*Z = V
      YNORM = S*YNORM
      DO 160 KB = 1, N
         K = N + 1 - KB
         IF (DABS(Z(K)) .GT. DABS(A(K,K))) THEN
            S = DABS(A(K,K))/DABS(Z(K))
            CALL SSCAL(N, S, Z, 1)
            YNORM = S*YNORM
         ENDIF
         IF (A(K,K) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)
         IF (A(K,K) .EQ. 0.0D0) Z(K) = 1.0D0
         T = -Z(K)
         CALL SAXPY(K-1, T, A(1,K), 1, Z(1), 1)
  160 CONTINUE
C                                   ** MAKE ZNORM = 1.0
      S = 1.0D0 / SASUM(N, Z, 1)
      CALL SSCAL(N, S, Z, 1)
      YNORM = S*YNORM
C
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0
      RETURN
      END
      SUBROUTINE  SGESL( A, LDA, N,IPVT, B, JOB )
C
C         SOLVES THE REAL SYSTEM
C            A * X = B  OR  TRANS(A) * X = B
C         USING THE FACTORS COMPUTED BY SGECO OR SGEFA.
C
C         PART OF LINPACK.
C
C         REVISION DATE:  8/1/82
C         AUTHOR:  MOLER, C. B., (U. OF NEW MEXICO)
C
C     ON ENTRY
C
C        A       REAL(LDA, N)
C                THE OUTPUT FROM SGECO OR SGEFA.
C
C        LDA     INTEGER
C                THE LEADING DIMENSION OF THE ARRAY  A .
C
C        N       INTEGER
C                THE ORDER OF THE MATRIX  A .
C
C        IPVT    INTEGER(N)
C                THE PIVOT VECTOR FROM SGECO OR SGEFA.
C
C        B       REAL(N)
C                THE RIGHT HAND SIDE VECTOR.
C
C        JOB     INTEGER
C                = 0         TO SOLVE  A*X = B ,
C                = NONZERO   TO SOLVE  TRANS(A)*X = B  WHERE
C                            TRANS(A)  IS THE TRANSPOSE.
C
C     ON RETURN
C
C        B       THE SOLUTION VECTOR  X .
C
C     ERROR CONDITION
C
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS A
C        ZERO ON THE DIAGONAL.  TECHNICALLY, THIS INDICATES SINGULARITY,
C        BUT IT IS OFTEN CAUSED BY IMPROPER ARGUMENTS OR IMPROPER
C        SETTING OF LDA .  IT WILL NOT OCCUR IF THE SUBROUTINES ARE
C        CALLED CORRECTLY AND IF SGECO HAS SET RCOND .GT. 0.0
C        OR SGEFA HAS SET INFO .EQ. 0 .
C
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX
C     WITH  P  COLUMNS
C           CALL SGECO(A,LDA,N,IPVT,RCOND,Z)
C           IF (RCOND IS TOO SMALL) GO TO ...
C           DO 10 J = 1, P
C              CALL SGESL(A,LDA,N,IPVT,C(1,J),0)
C        10 CONTINUE
C
C
C     ROUTINES CALLED:  FROM BLAS:    SAXPY, SDOT
C
      INTEGER  LDA, N, IPVT(*), JOB
      DOUBLE PRECISION     A(LDA,*), B(*)
C
      DOUBLE PRECISION     SDOT,T
      INTEGER  K,KB,L,NM1
C
C
      NM1 = N - 1
      IF (JOB .EQ. 0) THEN
C                                 ** JOB = 0 , SOLVE  A * X = B
C                                     ** FIRST SOLVE  L*Y = B
         DO 20 K = 1, NM1
            L = IPVT(K)
            T = B(L)
            IF (L .NE. K) THEN
               B(L) = B(K)
               B(K) = T
            ENDIF
            CALL SAXPY( N-K, T, A(K+1,K), 1, B(K+1), 1 )
   20    CONTINUE
C                                    ** NOW SOLVE  U*X = Y
         DO 40 KB = 1, N
            K = N + 1 - KB
            B(K) = B(K) / A(K,K)
            T = -B(K)
            CALL SAXPY( K-1, T, A(1,K), 1, B(1), 1 )
   40    CONTINUE
C
      ELSE
C                         ** JOB = NONZERO, SOLVE  TRANS(A) * X = B
C                                    ** FIRST SOLVE  TRANS(U)*Y = B
         DO 60 K = 1, N
            T = SDOT( K-1, A(1,K), 1, B(1), 1 )
            B(K) = (B(K) - T) / A(K,K)
   60    CONTINUE
C                                    ** NOW SOLVE  TRANS(L)*X = Y
         DO 80 KB = 1, NM1
            K = N - KB
            B(K) = B(K) + SDOT( N-K, A(K+1,K), 1, B(K+1), 1 )
            L = IPVT(K)
            IF (L .NE. K) THEN
               T = B(L)
               B(L) = B(K)
               B(K) = T
            ENDIF
   80    CONTINUE
C
      ENDIF
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION  SASUM( N, SX, INCX )
C
C  --INPUT--  N  NUMBER OF ELEMENTS IN VECTOR TO BE SUMMED
C            SX  SING-PREC ARRAY, LENGTH 1+(N-1)*INCX, CONTAINING VECTOR
C          INCX  SPACING OF VECTOR ELEMENTS IN 'SX'
C
C --OUTPUT-- SASUM   SUM FROM 0 TO N-1 OF  DABS(SX(1+I*INCX))
C
      DOUBLE PRECISION SX(*)
C
C
      SASUM = 0.0d0
      IF( N.LE.0 )  RETURN
      IF( INCX.NE.1 ) THEN
C                                          ** NON-UNIT INCREMENTS
          DO 10 I = 1, 1+(N-1)*INCX, INCX
             SASUM = SASUM + DABS(SX(I))
   10     CONTINUE
      ELSE
C                                          ** UNIT INCREMENTS
         M = MOD(N,6)
         IF( M.NE.0 ) THEN
C                             ** CLEAN-UP LOOP SO REMAINING VECTOR 
C                             ** LENGTH IS A MULTIPLE OF 6.
            DO 30  I = 1, M
              SASUM = SASUM + DABS(SX(I))
   30       CONTINUE
         ENDIF
C                              ** UNROLL LOOP FOR SPEED
         DO 50  I = M+1, N, 6
           SASUM = SASUM + DABS(SX(I))   + DABS(SX(I+1)) + DABS(SX(I+2))
     $                   + DABS(SX(I+3)) + DABS(SX(I+4)) + DABS(SX(I+5))
   50    CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE  SAXPY( N, SA, SX, INCX, SY, INCY )
C
C          Y = A*X + Y  (X, Y = VECTORS, A = SCALAR)
C
C  --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTORS 'X' AND 'Y'
C       SA  SINGLE PRECISION SCALAR MULTIPLIER 'A'
C       SX  SING-PREC ARRAY CONTAINING VECTOR 'X'
C     INCX  SPACING OF ELEMENTS OF VECTOR 'X' IN 'SX'
C       SY  SING-PREC ARRAY CONTAINING VECTOR 'Y'
C     INCY  SPACING OF ELEMENTS OF VECTOR 'Y' IN 'SY'
C
C --OUTPUT--
C       SY   FOR I = 0 TO N-1, OVERWRITE  SY(LY+I*INCY) WITH 
C                 SA*SX(LX+I*INCX) + SY(LY+I*INCY), 
C            WHERE LX = 1          IF INCX .GE. 0,
C                     = (-INCX)*N  IF INCX .LT. 0
C            AND LY IS DEFINED IN A SIMILAR WAY USING INCY.
C
      DOUBLE PRECISION SX(*), SY(*), SA
C
C
      IF( N.LE.0 .OR. SA.EQ.0.0D0 ) RETURN
C
      IF ( INCX.EQ.INCY .AND. INCX.GT.1 )  THEN
C
          DO 10  I = 1, 1+(N-1)*INCX, INCX
             SY(I) = SY(I) + SA * SX(I)
   10     CONTINUE
C
      ELSE IF ( INCX.EQ.INCY .AND. INCX.EQ.1 )  THEN
C
C                                        ** EQUAL, UNIT INCREMENTS
         M = MOD(N,4)
         IF( M .NE. 0 ) THEN
C                            ** CLEAN-UP LOOP SO REMAINING VECTOR LENGTH
C                            ** IS A MULTIPLE OF 4.
            DO 20  I = 1, M
              SY(I) = SY(I) + SA * SX(I)
   20       CONTINUE
         ENDIF
C                              ** UNROLL LOOP FOR SPEED
         DO 30  I = M+1, N, 4
            SY(I)   = SY(I)   + SA * SX(I)
            SY(I+1) = SY(I+1) + SA * SX(I+1)
            SY(I+2) = SY(I+2) + SA * SX(I+2)
            SY(I+3) = SY(I+3) + SA * SX(I+3)
   30    CONTINUE
C
      ELSE
C               ** NONEQUAL OR NONPOSITIVE INCREMENTS.
         IX = 1
         IY = 1
         IF( INCX.LT.0 )  IX = 1 + (N-1)*(-INCX)
         IF( INCY.LT.0 )  IY = 1 + (N-1)*(-INCY)
         DO 40  I = 1, N
            SY(IY) = SY(IY) + SA*SX(IX)
            IX = IX + INCX
            IY = IY + INCY
   40    CONTINUE
C
      ENDIF
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION  SDOT( N, SX, INCX, SY, INCY )
C
C          S.P. DOT PRODUCT OF VECTORS  'X'  AND  'Y'
C
C  --INPUT--
C        N  NUMBER OF ELEMENTS IN INPUT VECTORS 'X' AND 'Y'
C       SX  SING-PREC ARRAY CONTAINING VECTOR 'X'
C     INCX  SPACING OF ELEMENTS OF VECTOR 'X' IN 'SX'
C       SY  SING-PREC ARRAY CONTAINING VECTOR 'Y'
C     INCY  SPACING OF ELEMENTS OF VECTOR 'Y' IN 'SY'
C
C --OUTPUT--
C     SDOT   SUM FOR I = 0 TO N-1 OF  SX(LX+I*INCX) * SY(LY+I*INCY),
C            WHERE  LX = 1          IF INCX .GE. 0, 
C                      = (-INCX)*N  IF INCX .LT. 0,
C            AND LY IS DEFINED IN A SIMILAR WAY USING INCY.
C
      DOUBLE PRECISION SX(*), SY(*)
C
C
      SDOT = 0.0d0
      IF( N.LE.0 )  RETURN
C
      IF ( INCX.EQ.INCY .AND. INCX.GT.1 )  THEN
C
          DO 10  I = 1, 1+(N-1)*INCX, INCX
             SDOT = SDOT + SX(I) * SY(I)
   10     CONTINUE
C
      ELSE IF ( INCX.EQ.INCY .AND. INCX.EQ.1 )  THEN
C
C                                        ** EQUAL, UNIT INCREMENTS
         M = MOD(N,5)
         IF( M .NE. 0 ) THEN
C                            ** CLEAN-UP LOOP SO REMAINING VECTOR LENGTH
C                            ** IS A MULTIPLE OF 4.
            DO 20  I = 1, M
               SDOT = SDOT + SX(I) * SY(I)
   20       CONTINUE
         ENDIF
C                              ** UNROLL LOOP FOR SPEED
         DO 30  I = M+1, N, 5
            SDOT = SDOT + SX(I)*SY(I)     + SX(I+1)*SY(I+1)
     $                  + SX(I+2)*SY(I+2) + SX(I+3)*SY(I+3)
     $                  + SX(I+4)*SY(I+4)
   30    CONTINUE
C
      ELSE
C               ** NONEQUAL OR NONPOSITIVE INCREMENTS.
         IX = 1
         IY = 1
         IF( INCX.LT.0 )  IX = 1 + (N-1)*(-INCX)
         IF( INCY.LT.0 )  IY = 1 + (N-1)*(-INCY)
         DO 40  I = 1, N
            SDOT = SDOT + SX(IX) * SY(IY)
            IX = IX + INCX
            IY = IY + INCY
   40    CONTINUE
C
      ENDIF
C
      RETURN
      END
      SUBROUTINE     SSCAL( N, SA, SX, INCX )
C
C         CALCULATE  X = A*X  (X = VECTOR, A = SCALAR)
C
C  --INPUT--  N  NUMBER OF ELEMENTS IN VECTOR
C            SA  SINGLE PRECISION SCALE FACTOR
C            SX  SING-PREC ARRAY, LENGTH 1+(N-1)*INCX, CONTAINING VECTOR
C          INCX  SPACING OF VECTOR ELEMENTS IN 'SX'
C
C --OUTPUT-- SX  REPLACE  SX(1+I*INCX)  WITH  SA * SX(1+I*INCX) 
C                FOR I = 0 TO N-1
C
      DOUBLE PRECISION SA, SX(*)
C
C
      IF( N.LE.0 ) RETURN
C
      IF( INCX.NE.1 ) THEN
C
          DO 10  I = 1, 1+(N-1)*INCX, INCX
             SX(I) = SA * SX(I)
   10     CONTINUE
C
      ELSE
C
         M = MOD(N,5)
         IF( M.NE.0 ) THEN
C                           ** CLEAN-UP LOOP SO REMAINING VECTOR LENGTH
C                           ** IS A MULTIPLE OF 5.
            DO 30  I = 1, M
               SX(I) = SA * SX(I)
   30       CONTINUE
         ENDIF
C                             ** UNROLL LOOP FOR SPEED
         DO 50  I = M+1, N, 5
            SX(I)   = SA * SX(I)
            SX(I+1) = SA * SX(I+1)
            SX(I+2) = SA * SX(I+2)
            SX(I+3) = SA * SX(I+3)
            SX(I+4) = SA * SX(I+4)
   50    CONTINUE
C
      ENDIF
C
      RETURN
      END
      INTEGER FUNCTION  ISAMAX( N, SX, INCX )
C
C  --INPUT--  N  NUMBER OF ELEMENTS IN VECTOR OF INTEREST
C            SX  SING-PREC ARRAY, LENGTH 1+(N-1)*INCX, CONTAINING VECTOR
C          INCX  SPACING OF VECTOR ELEMENTS IN 'SX'
C
C --OUTPUT-- ISAMAX   FIRST I, I = 1 TO N, TO MAXIMIZE
C                         DABS(SX(1+(I-1)*INCX))
C
      DOUBLE PRECISION SX(*), SMAX, XMAG
C
C
      IF( N.LE.0 ) THEN
         ISAMAX = 0
      ELSE IF( N.EQ.1 ) THEN
         ISAMAX = 1
      ELSE
         SMAX = 0.0d0
         II = 1
         DO 20  I = 1, 1+(N-1)*INCX, INCX
            XMAG = DABS(SX(I))
            IF( SMAX.LT.XMAG ) THEN
               SMAX = XMAG
               ISAMAX = II
            ENDIF
            II = II + 1
   20    CONTINUE
      ENDIF
C
      RETURN
      END
