function [G0h,ier]=G0_hours_profile(phi,eccentricity,delta)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la irradiacion solar extraterrestre incidente en una superficie
% horizontal en el caso de valores horarios, para las 24 horas integrales de un dia (W h / m2)
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [G0h,ier]=G0_hours_profile(phi,eccentricity,delta)
%
% INPUT: 
%       phi         : latitude del sitio (radianes, norte positivo)
%       eccentricity: correcion de la excentricidad por la orbita terrestre
%       delta       : angulo de declinacion solar (radianes)
% OUTPUT:
%       G0h(1..24)  : 24 valores de la irradiacion solar extraterrestre ( W h / m2)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
I0=1367.0; % Constante solar en W/m2
Dl=24.0;   % valor promedio de la duracion del dia en horas decimales

[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
if (ier ~= 0) return; end
a=I0*eccentricity*Dl/(2.0*pi); 
b1=sin(phi)*sin(delta);
b2=cos(phi)*cos(delta);

for i=1:24
    [omega1,ier]=solar_hour_angle(i-1);
    if (ier ~= 0) return; end
    [omega2,ier]=solar_hour_angle(i);
    if (ier ~= 0) return; end
    
    if ( (omega2 < omega_sr) | (omega1 > omega_ss) )
        G0h(i)=0.0;
    else
        if (omega1 < omega_sr) omega1=omega_sr; end
        if (omega2 > omega_ss) omega2=omega_ss; end
        G0h(i)=a*(b1*(omega2-omega1)+b2*(sin(omega2)-sin(omega1)));
    end

end
G0h=G0h';


