function [delta,ier]=declination_sun(year_number,julian_day,lambda)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Calcula la declinacion solar a mediodia (en tiempo solar) en radianes El FLAG 
% ier devuelve 0 si el calculo es correcto y 1 en caso contrario.
% Se considera que un valor promedio por dia al mediodia solar es adecuado en la practica.
% La declinacion solar depende de la longitud, ya que el mediodia ocurre antes si la longitud
% esta al este de Greenwich, y despues si esta al oeste. El algoritmo elegido emplea 1957 como
% ao base; es basicamente una serie de Fourier truncada con 6 armonicos
%
% [delta,ier]=declination_sun(year_number,julian_day,lambda)
%
% INPUT: 
%       year_number  : numero de ao con cuatro digitos  
%       julian day   : dia juliano (1..366)
%       lambda       : longitud (en radianes, positiva al este)
% OUTPUT:
%       delta        : declinacion solar at noon (radianes)
%       ier          : FLAG de control 
%
% Ref: 
%      - Bourges, B., 1985. Improvement in solar declination computation. Sol. En. 35 (4), 367-369.
%      - Carvalho, M.J. and Bourges, B. 1986. Program Eufrad 2.0 - User's Guide.
%        Project EUFRAT final scientific report, Contract EN3S-0111-F, Solar Energy and Development
%        in the European Community, pp. 12.1-12.74.
%      - Duffie, J.A. and Beckman, W.A. 1980. Solar Engineering and thermal Processes. Wiley-Interscience, New York
%-------------------------------------------------------------------------------
b1 =  0.0064979;
b2 =  0.4059059;
b3 =  0.0020054;
b4 = -0.0029880;
b5 = -0.0132296;
b6 =  0.0063809;
b7 =  0.0003508;

ier=1;
% n0 : spring-equinxo time expressed in days from the beginning of the year, i.e. the time in decimal days
%      elapsing from 00:00 hours Jan 1st to the spring equinox at Greenwich in a given year
% t1 : time in days from the spring equinox
% 0.5 represents the decimal day number at noon on Jan 1st at Greenwich
n0 = 78.8946 + 0.2422*(year_number-1957)-0.25*(year_number-1957);
t1 = -0.5-lambda/(2*pi)-n0;
w0=2*pi/365.2422;

if ( (julian_day > 0) & (julian_day <= 366) )
    ier=0;
    wt=w0*(julian_day+t1);
end
delta=b1+b2*sin(wt)+b3*sin(2*wt)+b4*sin(3*wt)+b5*cos(wt)+b6*cos(2*wt)+b7*cos(3*wt);