function [solarData]=solarTimeCorrection(me,lat,lon,dj,year,fEnt,int,fInt)

%*******************************************************************
%
%Funcin que calcula el nmero de horas que hay que mover los datos
%para colocarlos en las horas correctas.
%
% INPUT:
%          me:      Vector de datos medidos
%          lat:     Latitud del lugar (Grados)
%          lon:     Longitud          (Grados)
%          dj:      Da Juliano
%          year:    Ao
%          fEnt:    Frecuencia Datos de entrada en minutos
%          int:     Flag para indicar si se interpola
%          fInt:    Frecuencia de interpolacin en minutos
%
% OUTPUT:
%          solarData:   Vector de radiacin con la hora corregida. La
%                       frecuencias es la de entrada.
%
%*******************************************************************

%Obtenemos el ao y da del vector
%year = year; %Ao
%dj = day;   %Da Juliano
%Obtenemos valores de radiacion horaria medidos
yd=me;

%Clculo del da y mes correspondiente al da juliano.
%[day,month]=mesday(dj,year);
[day,month,ier]=julian_to_date(year,dj)

%Pasamos longitud y latitud de grados a radianes
latr = lat * (pi/180);
lonr = lon * (pi/180); 

%Clculo la radiacin solar extraterrestre horaria
[day_angle,delta,omega_ss,S0,eccentricity,G0d,ye,ier]= solar_parameters_day(day,month,year,latr,lonr,0.0);
%ye=[0,0,0,1,2,3,4,5,6,7,8,7,6,5,4,3,2,1,0,0,0,0,0,0];

%filtramos extraterrestre
ye(find(ye<1))=0; %vector para interpolar de extr.

%filtramos global superficie
yd(find(yd<1))=0; %vector para interpolar de rad.

nMedidos = 24*60-length(find(yd<1))*fEnt;   %numero de valores buenos superficie

%calculamos el porcentaje de datos buenos
porDatosBuenos=(nMedidos*100)/(24*60);
        
%si el porcentaje de valores validos es mayor al 50%
if(porDatosBuenos>50)
   
    if(int)
        
        xi=1:fInt:length(ye)*60; %vector para la interpolacin
        
        %interpolacin de extraterrestre
        xe=1:60:length(ye)*60;
        yei=interp1(xe,ye,xi); %eje X, eje Y, puntosInt ejeX
        %limpiamos NaN
        auxYe=find(isnan(yei)==1);
        yei(auxYe)=0;
            
        %interpolacin de global
        xd=1:(length(me)+2);
        yd2(1:(length(me)+2))=0; %ponemos 0 en las colas para evitar los valores NaN
        
        yd2(2:(length(me)+1))=yd; %corregimos global en caso de 
        
        %que aparezcan NaN en las colas de global
        ydi=interp1(1:fEnt:length(yd2)*fEnt,yd2,1:fInt:length(yd2)*fEnt);
        
       %obtenemos pos indice raise/dawn
       hay_ext=find(yei);
       ppio_ei=hay_ext(1);
       fin_ei=hay_ext(end);

       %1 hora before raise/after dawn -> Usamos FInt
       ppio_di=ppio_ei-(60/fInt);
       fin_di=fin_ei+(60/fInt);
       if(ppio_di<0)
           ppio_di=ppio_ei;
       end
       if(fin_di>length(yei))
           fin_di=fin_ei;
       end

       %ndice Kt
       %1 hora after raise/after dawn -> Usamos FInt        
       ppio_kt=ppio_ei+(60/fInt);
       fin_kt=fin_ei-(60/fInt);
       long_kt=fin_kt-ppio_kt+1;
       trozo_ext=yei(ppio_kt:fin_kt);
    else
       %si no interpola -> interpolamos el vector de radiacin a frecuencia
       %de entrada
       
       %interpolacin de extraterrestre
       xi=1:fEnt:24*60; %vector para la interpolacin
       xe=1:60:1440;           
       yei=interp1(xe,ye,xi); %eje X, eje Y, puntosInt ejeX
       ydi=yd;
       
       %obtenemos pos indice raise/dawn
       hay_ext=find(yei);
       ppio_ei=hay_ext(1);
       fin_ei=hay_ext(end);

       %1 hora before raise/after dawn
       ppio_di=ppio_ei-(60/fEnt);
       fin_di=fin_ei+(60/fEnt);     
       if(ppio_di<0)
           ppio_di=ppio_ei;
       end
       if(fin_di>length(yei))
           fin_di=fin_ei;
       end

       %ndice Kt
       %1 hora after raise/after dawn        
       ppio_kt=ppio_ei+(60/fEnt);
       fin_kt=fin_ei-(60/fEnt);
       long_kt=fin_kt-ppio_kt+1;
       trozo_ext=yei(ppio_kt:fin_kt);
    end
    
    %Cogemos solo los datos de luz
    auxId=find(ydi>0);
    datosi=ydi(auxId(1):auxId(end));
    GdEnd=ppio_di+length(datosi)-1;

    num=1; %numero iteraciones
    yndi(1,:)=xi; % int->1 xi=1:fInt:24*60; || int->0 xi=1:fEnt:24*60;
 
    while GdEnd<fin_di
        %inicializamos fila iteracin a cero
        yndi(num,:)=0;
        
        %Desplazamos vector de global superficie
        yndi(num,ppio_di:GdEnd)=datosi;
        %Cogemos intervalor Kt
        trozo_rad(num,1:long_kt)=yndi(num,ppio_kt:fin_kt);
        %Calculamos indice claridad
        kt(num,1:long_kt)=trozo_rad(num,:)./trozo_ext;
        num=num+1;
        GdEnd=GdEnd+1; 
        ppio_di=ppio_di+1;
    end %fin while
    
    %maximo de kt por filas
    max_kt=max(kt,[],2);
    %cogemos mximo de los minimos de kt
    num_iter=find(max_kt==min(max_kt));
    
    %si tenemos ms de dos minimos cogemos el punto central
    if length(num_iter)>1
         num_iter_SEL=num_iter(1)+floor((num_iter(end)-num_iter(1))/2);
    else
         num_iter_SEL=num_iter;
    end
            
    ndatosi=yndi(num_iter_SEL,:); %obtenemos datos de global interpolados de la iteracion
    
    if(int)
        solarData=ndatosi(1:(60/fEnt*60/fInt):length(ndatosi));
    else
        solarData=ndatosi;
    end
    
else
    solarData(1:fEnt:24*60)=NaN;
end
%fin if(tpc>50)
