 /* ProgFuzzy.c */
 /* Program for daily global solar irradiation using fuzzy procedures */

#include <stdio.h>                                    
#include <stdlib.h>                                    
#include <time.h>
#include <math.h>

#define pi 3.1416
#define alfa 1.0

int  i, j, k, nf, nrf, day;
double aba, sdelta, smed, smed2, sf;
double a1, a2, a3, a4, a5, a6, b1, b2, b3, b4, b5, b6, b7; 
double c8;
double x, y, yf, yff, pas, pas1, maxdt;
int az2, bz1, bz3, cz1, cz2, cz3;
double teta[366], decli[366], Gext[366], uo[366];
double vf1, vf2;
double mk1, mk2, mk3, mk4, mk5, mk6, mk7, mk8;
double mk11, mk33, mk44, mk55, mk555, mk5555, mk66, mk77; 
double kcrisp;

double aa2, aa3, aa4, aa5, aa6, aa7, aa8, bb1, bb2, bb3, bb4, bb5, bb6; 
double cc1, cc2, cc3, cc4, cc5, cc6, cc7;

double d[9]={0.0, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7};
double e[9]={0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8};
double g[9]={0.0, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
double baza[9];

double Hext[368], Hextkcr[368];
double Tmine[368], Tmaxe[368], tmin, tmax,dt, delta[368], tmed[368];
double Lat, Lat2, xi, dtmy, tmy;


FILE *fp;
double  *Tminep, *Tmaxep;

char kout[12]; 
  
double Calcc(double a, double b);                           /* list of used functions */
double Fuzifica(double m1, double m2);
double Functionxi(double var1, double var2);

double mdt1(double dt);
double mdt2(double dt);
double mdt3(double dt);
double mdt4(double dt);
double mdt5(double dt);
double mdt6(double dt);
double mdt7(double dt);
double mdt8(double dt);

double mzj1(int zj);            
double mzj2(int zj);

double mcind1(double kt);
double mcind2(double kt);
double mcind3(double kt);
double mcind4(double kt);
double mcind5(double kt);
double mcind6(double kt);
double mcind7(double kt);
double mcind8(double kt);

void IradExtr();
void IradExtr2();

double hh(double ome, int je);


double Functionxi(double var1, double var2)        /* calculete the xi factor */
{
  return 0.00413*var1*var1*var1-0.0964*var1*var1+1.078*var1-0.005605*var1*var1*var2-0.023*var1*var2+0.009476*var1*var2*var2+0.495*var2-0.0468*var2*var2-0.002223*var2*var2*var2-3.581;
}


void IradExtr()                                    /* calculate the extraterrestrial solar iradiation */ 
{
  for(j=1; j<366; j++)
    {
      teta[j] = 2*pi*(j-1)/365.0;
      decli[j] = 0.006918-0.399912*cos(teta[j])+0.070257*sin(teta[j])-0.006759*cos(2*teta[j])+0.000907*sin(2*teta[j])+0.00148*sin(3*teta[j])-0.002697*cos(3*teta[j]);
      Gext[j] = 1367.0*(1.00011+0.034221*cos(teta[j])+0.00128*sin(teta[j])-0.000719*cos(2*teta[j])+0.000077*sin(2*teta[j])); 
    }
}


void IradExtr2()                                    
{
  for(j=1; j<366; j++)
    {
      uo[j] = acos(-tan(Lat2)*tan(decli[j]));
    }
}


double hh(double ome, int je)
{
  return sin(Lat2)*sin(decli[je])+cos(Lat2)*cos(decli[je])*cos(ome);
}


double CalcInt(double a1, double a2)                       
{
  double sum, x;
  sum = 0.0;
  x = a1;
  while(x<a2)
    {
      sum = sum+hh(x,j)*pas1;
      x=x+pas1;
    }
  return sum;
}


double Calcc(double a, double b)
{
  sf = 0.0;
  nrf=0;
  for(nf=1; nf<366; nf++)
    {
      if((delta[nf]<b)&&(delta[nf]>a))
        {
	  sf = sf+delta[nf];
	  nrf++;
	}
    }

      return sf/nrf;
}


double mdt1(double dt)                    /* calculate the membership functions for air temperature attributes  */
{
  if(dt < cc1)
    {  
      y = 1.0;
      return y;
    }
  
  else
    {
      y = (bb1-dt)/(bb1-cc1);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }  
}


double mdt2(double dt)
{
  if(dt<cc2)
    { 
      y = (dt-aa2)/(cc2-aa2);
      
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }
    
  else
    {
      y = (bb2-dt)/(bb2-cc2);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    } 
}


double mdt3(double dt)
{
  if(dt<cc3)
    { 
      y = (dt-aa3)/(cc3-aa3);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }
  else
    {
      y = (bb3-dt)/(bb3-cc3);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }
}


double mdt4(double dt)
{
  if(dt<cc4)
    { 
      y = (dt-aa4)/(cc4-aa4);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }
  else
    {
      y = (bb4-dt)/(bb4-cc4);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf;
    }
}


double mdt5(double dt)
{
  if(dt<cc5)
    { 
      y = (dt-aa5)/(cc5-aa5);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
  else
    {
      y = (bb5-dt)/(bb5-cc5);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
}


double mdt6(double dt)
{
  if(dt<cc6)
    { 
      y = (dt-aa6)/(cc6-aa6);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
  else
    {
      y = (bb6-dt)/(bb6-cc6);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
}


double mdt7(double dt)
{
  if(dt<cc7)
    { 
      y = (dt-aa7)/(cc7-aa7);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
  else
    {
      y = (b7-dt)/(b7-cc7);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
}


double mdt8(double dt)
{
  if(dt<c8)
    { 
      y = (dt-aa8)/(c8-aa8);
      if(y<0) yf = 0.0;
      if(y>=0) yf = pow(y,alfa);
      return yf ;
    }
  else
    {
      y = 1.1;
      return y ;
    } 
}


double mzj1(int zj)                           /* calculate the membership functions for the Julian day attributes*/
{
  if((cz1<zj)&&(zj<bz3))
    {
      yff = 0.0;
      
      y = (double)(zj-cz3)/(double)(bz3-cz3);
      
      if(y>0) yff=y;
      
      yf=(double)(bz1-zj)/(double)(bz1-cz1);

      if(yf>yff) 
	{
	  y = yf;
	  yff = y;
	}      
      return yff;
    }

  else
    {
      y = 1.0;
      return y; 
    }
}


double mzj2(int zj)
{
  if(zj<cz2)
    {
      y = (double)(zj-az2)/(double)(cz2-az2);
      if(y<0) yf = 0.0;
      if(y>=0) yf = y;
      return yf;
    }
  else if(zj>cz3)
    {
      y = (double)(bz3-zj)/(double)(bz3-cz3);
      if(y<0) yf =0.0;
      if(y>=0) yf = y;
      return yf;
    }
  else
    
    {
      y = 1.0;
      return y;
    }
}


double mcind1(double kt)                             /* calculate the membership fuctions for clearness index attributes  */
{
  if(kt<e[1])
    {
      y = (kt -d[1])/(e[1]-d[1]);
      if (y<0) yf = 0.0;
      if (y>=0) yf = y;
    
      return yf;
    }
  else
    {
      y = (g[1]-kt)/(g[1]-e[1]);
      if (y<0) yf = 0.0;
      if (y>=0) yf = y;
      return yf;
    } 
}


double mcind2(double kt)
{
  if(kt<e[2])
    {
      y = (kt -d[2])/(e[2]-d[2]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[2]-kt)/(g[2]-e[2]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }  
}


double mcind3(double kt)
{
  if(kt<e[3])
    {
      y = (kt -d[3])/(e[3]-d[3]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[3]-kt)/(g[3]-e[3]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
}


double mcind4(double kt)
{
  if(kt<e[4])
    {
      y = (kt -d[4])/(e[4]-d[4]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[4]-kt)/(g[4]-e[4]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
}


double mcind5(double kt)
{
  if(kt<e[5])
    {
      y = (kt -d[5])/(e[5]-d[5]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[5]-kt)/(g[5]-e[5]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    } 
}


double mcind6(double kt)
{
  if(kt<e[6])
    {
      y = (kt -d[6])/(e[6]-d[6]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[6]-kt)/(g[6]-e[6]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
}


double mcind7(double kt)
{
  if(kt<e[7])
    {
      y = (kt -d[7])/(e[7]-d[7]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[7]-kt)/(g[7]-e[7]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
}


double mcind8(double kt)
{
  if(kt<e[8])
    {
      y = (kt -d[8])/(e[8]-d[8]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }
  else
    {
      y = (g[8]-kt)/(g[8]-e[8]);
      if (y > 0) yf = y;
      else yf = 0.0;
      return yf;
    }  
}


double Fuzifica(double m1, double m2)      /*  fuzzification function */
{
  double mk;
  mk = 0.0;
  if((m1>0)&&(m2>0)) 
    {
      mk = m1;
      if(m2<m1) mk = m2;
    }
 return mk;
}



void main()
{
  pas = 0.1;
  pas1 = 0.01;
  
  Tminep = Tmine;              
  Tmaxep = Tmaxe;
  
  az2 = 45;
  bz1 = 120; 
  bz3 = 320;
  cz1 = 45;
  cz2 = 120;
  cz3 = 240;
   
  
  for(j=1; j<9; j++)           /* calculate the triangle bases for membership function of clearness index attributes */
    baza[j] = g[j]-d[j];
   
 
  printf("Please, insert latitude (in degreese, for exemple 45.76):\n");       /* insert latitude */
  scanf("%lf",&Lat);
  printf("Thank you, latitude is %f \n ", Lat);
  Lat2 = 2.0*pi*Lat/360.0;
  
   
  IradExtr();
  IradExtr2();
  
  a1 = 0.0;                /* parameters for the membership functions of  delta_t */
  a2 = 1.0;
  a3 = 2.5;
  a4 = 5.0;
  a5 = 7.5;
  a6 = 10.0;
  
  b1 = 7.5;
  b2 = 10.0;
  b3 = 12.5;
  b4 = 15.0;
  b5 = 17.5;
  b6 = 20.0;
    

  for(j=1; j<366; j++)
    {
      Hext[j] = 0.012*Gext[j]*CalcInt(-uo[j],uo[j])/pi;
    }
  
      
  printf("Please, insert the Julian day (a number betwen 1 and 365):\n");       /* insert the Julian  day */
  scanf("%d",&day);
  printf("Thank you, Julian day is %d \n ", day);

  printf("Please, insert air temperature, maximum :\n");                        /* insert air temperatures */
  scanf("%lf",&tmax);
  printf("Thank you, maximum temperature is %f \n ", tmax);

  printf("Please, insert air temperature, minimum :\n");       
  scanf("%lf",&tmin);
  printf("Thank you, minimum temperature is %f \n ", tmin);
  
  dt = tmax-tmin;
  

  if((fp=fopen("stationtemperatures.prn","r"))==NULL)        /* open the file with air temperature data */
    {
      printf("nu pot deschide fisierul\n");
      exit(1);
    }	
  
 
  sdelta = 0.0;
  smed = 0.0;
  smed2 = 0.0;
  
  maxdt = 0.0;
  tmy = 0.0;
  
  for(i=1; i<366; i++)                                       /* read the file with air temperature data */
    {		  
      fscanf(fp,"%lf%lf",&aba, &smed2); 
      fscanf(fp,"%lf%lf",Tminep+i,Tmaxep+i);
      delta[i] = Tmaxe[i]-Tmine[i];
      tmed[i] = (Tmaxe[i]+Tmine[i])/2;    
      sdelta = sdelta + delta[i];
      smed= smed + tmed[i];
      if(delta[i]>maxdt)
	maxdt = delta[i];
      tmy = tmy+smed2;
    }
  
  tmy=tmy/365.0;
  dtmy=sdelta/365.0;   
  
     
  b7 = maxdt;
  c8 = maxdt+2.0;
  
 
  xi=Functionxi(tmy,dtmy);                      /* compute the factor xi  */
  

  bb1 = b1*xi;                                  /* apply  xi to the parameters of membership functions */
  cc1 = Calcc(a1,bb1);
  
  
  aa2 = a2*xi;
  bb2 = b2*xi;
  cc2 = Calcc(aa2,bb2);
  
  
  aa3 = a3*xi;
  bb3 = b3*xi;
  cc3 = Calcc(aa3,bb3);
  
  
  aa4 = a4*xi;
  bb4 = b4*xi;
  cc4 = Calcc(aa4,bb4);
  
  
  aa5 = a5*xi;
  bb5 = b5*xi;
  cc5 = Calcc(aa5,bb5);
  
  
  aa6 = a6*xi;
  bb6 = b6*xi;  
  cc6 = Calcc(aa6,bb6);
  
  
  aa7 = cc6;
  cc7 = Calcc(aa7,b7);
  aa8 = cc7;
                                                     
  
  mk1 = 0.0;                                   /* fuzzyfication process */
  mk2 = 0.0;
  mk3 = 0.0;
  mk4 = 0.0;
  mk5 = 0.0;
  mk6 = 0.0;
  mk7 = 0.0;
  mk8 = 0.0;
  
  vf1 = 0.0;
  vf2 = 0.0;
  
  vf1 = mzj2(day); 
  vf2 = mdt1(dt); 
  mk1 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt2(dt); 
  mk2 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt3(dt); 
  mk3 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt4(dt); 
  mk4 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt5(dt); 
  mk5 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt6(dt); 
  mk6 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt7(dt); 
  mk7 = Fuzifica(vf1,vf2);
  
  vf1 = mzj2(day); 
  vf2 = mdt8(dt); 
  mk8 = Fuzifica(vf1,vf2);
  
  vf1 = mzj1(day);
  vf2 = mdt1(dt);
  mk11 = Fuzifica(vf1,vf2);
  if(mk11>mk1) mk1 = mk11;
  
  vf1 = mzj1(day);
  vf2 = mdt2(dt);
  mk33 = Fuzifica(vf1,vf2);
  if(mk33>mk3) mk3 = mk33;
  
  vf1 = mzj1(day);
  vf2 = mdt3(dt);
  mk44 = Fuzifica(vf1,vf2);
  if(mk44>mk4) mk4 = mk44;
  
  vf1 = mzj1(day);
  vf2 = mdt4(dt);
  mk55 = Fuzifica(vf1,vf2);
  if(mk55>mk5) mk5 = mk55;
  
  vf1 = mzj1(day);
  vf2 = mdt5(dt);
  mk555 = Fuzifica(vf1,vf2);
  if(mk555>mk5) mk5 = mk555;
  
  vf1 = mzj1(day);
  vf2 = mdt6(dt);
  mk5555 = Fuzifica(vf1,vf2);
  if(mk5555>mk5) mk5 = mk5555;
  
  vf1 = mzj1(day);
  vf2 = mdt7(dt);
  mk66 = Fuzifica(vf1,vf2);
  if(mk66>mk6) mk6 = mk66;
  
  vf1 = mzj1(day);
  vf2 = mdt8(dt);
  mk77 = Fuzifica(vf1,vf2);
  if(mk77>mk7) mk7 = mk77;
  
  /* defuzzification  */
  
  kcrisp = (0.1*mk1*(1.0-0.5*mk1)+0.2*mk2*(1.0-0.5*mk2)+0.3*mk3*(1.0-0.5*mk3)+0.4*mk4*(1.0-0.5*mk4)+0.5*mk5*(1.0-0.5*mk5)+0.6*mk6*(1.0-0.5*mk6)+0.7*mk7*(1.0-0.5*mk7)+0.8*mk8*(1.0-0.5*mk8))/(mk1*(1.0-0.5*mk1)+mk2*(1.0-0.5*mk2)+mk3*(1.0-0.5*mk3)+mk4*(1.0-0.5*mk4)+mk5*(1.0-0.5*mk5)+mk6*(1.0-0.5*mk6)+mk7*(1.0-0.5*mk7)+mk8*(1.0-0.5*mk8));
    
  Hextkcr[day]= kcrisp*Hext[day];
  printf("\n");
  printf("The global solar iradiation is %f kWh/m2\n" , Hextkcr[day]);
  
  /* end fuzzification and defuzzification */ 
   
 
  fclose(fp);	    
   
}
