ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Collection of routines to compute astronomical data
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine ccosz(elat,delta,omega,cosz)
c
c     Computes the cosine of solar zenith angle
c
c     INPUT
c     elat - latitude of the place (rad)
c     delta - astronomical declination (rad)
c     omega - hour angle (rad)
c
c     OUTPUT
c     cosz - cosine of zenith angle
c
      cosz=sin(elat)*sin(delta)+cos(elat)*cos(delta)*cos(omega)
	if(cosz.lt.0.)cosz=0.
      return
      end
c----------------------------------------------------------------------
      subroutine ddelta(n,delta)
c
c     Computes astronomical declination
c
c     INPUT
c     n - day number in the year (n=1 for 1st January)
c
c     OUTPUT
c     delta - astronomical declination (rad)
c
c   Reference: R Bernard, G Menguy, M Schwartz, Le Rayonnement solaire -
c   Conversion Thermique et Applications, Technique et Documentation, 
c   Paris, 1980, p.22
c
	pi=3.14159
	om=2.*pi/366.*n
      delta=0.302-22.93*cos(om)-0.229*cos(2*om)-0.243*cos(3.*om)+
     *3.851*sin(om)+0.002*sin(2.*om)-0.055*sin(3.*om)
      delta=delta*pi/180.
      return
      end
c----------------------------------------------------------------------
      subroutine eet2(n,et)
c
c     Computes the Equation of Time
c
c     Data: 18.11.2006
c
c     INPUT
c     n - day number in the year (n=1 for 1st January)
c
c     OUTPUT
c     et - equation of time (minutes)
c
	pi=3.14159
      f=2.*pi*(n-81)/364
      et=9.87*sin(2.*f)-7.53*cos(f)-1.5*sin(f)
      return
      end
c----------------------------------------------------------------------
	subroutine emkast(cosz,em)
c
c	Computes the optical air mass with Kasten relationship
c
c	INPUT
c     cosz - cosine of solar zenith angle
c
c	OUTPUT
c     em - optical air mass
c
      tz=acos(cosz)
      call radgrad(tz,tzgrad)
      a=0.15*(93.885-tzgrad)**(-1.253)
      a=cosz+a
      em=1./a
      return
      end
c----------------------------------------------------------------------
      subroutine ie(n,vie)
c
c     Computes the intensity of solar radiation outside the atmosphere
c     (perpendicular on Sun's rays)
c
c     Calculeaza intensitatea radiatiei solare in afara atmosferei,vie
c     Referenta noua : Task IEA IX Report , 1988 , p 31-32
c
c     INPUT
c     n - day number in the year (n=1 for 1st January)
c
c     OUTPUT
c     vie - Intensity of solar radiation outside the atmosphere (W/m2)
c
      vi0=1367.
      pi=3.14159
	t=2*pi*(n-1.)/365.
	f=1.00011+0.034221*cos(t)+0.00128*sin(t)-
     *0.000719*cos(2.*t)+.000077*sin(2.*t)
	vie=vi0*f
      return
      end
c----------------------------------------------------------------------
 	subroutine oraom(elong,elst,etmin,omega)
c
c	Computes the hour angle for places in Romania
c
c     INPUT
c     elong - longitude of the place (rad)
c     elst - local standard civil time (hour)
c     et - equation of time (minutes)
c
c     OUTPUT
c     omega - hour angle (rad) - positive in the morning
c
      pi=3.14159
	call radgrad(elong,along)
c
c    For places in Romania, the longitude of the standard meridian 
c    is L_sm = 30 degrees East
c
	elsm=30.	
	elat=elst+etmin/60.-(elsm-along)/15.
	h=15.*(12.-elat)
	call gradrad(h,omega)
      return
      end
c----------------------------------------------------------------------
      subroutine zidinan(nluna,nzi,n)
c
c    Computes the number of a day in the year
c
c     INPUT
c     nluna - number of the month (January=1)
c     nzi - number of the day in the month
c
c     OUTPUT
c     n - the number of the day in the year
c
      dimension n1(12)	
      data n1/1,32,60,91,121,152,182,213,244,274,305,335/
      n=n1(nluna)+nzi-1
      return
      end
c----------------------------------------------------------------------