ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	Purpose: Collection of routines to compute atmospheric data
c     Date written: 31.01.2007
c     Last revision:
c	Author: Viorel Badescu
c		Candida Oancea Institute, Polytechnic University of Bucharest
c         Email address: badescu@theta.termo.pub.ro
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine eem(p,pst,emst,em)
c
c     Computes the optical air mass, corrected by atmospheric pressure
c
c     INPUT
c     p - atmospheric pressure (hPa)
c     pst - standard atmospheric pressure (hPa)
c     emst - standard (astronomical) optical air mass (dimensionless)
c
c     OUTPUT
c     em - optical air mass, corrected by atmospheric pressure 
c          (dimensionless)
c
      em = p/pst*emst
      return
      end
c----------------------------------------------------------------------
      subroutine ppst(t,tst0,pst)
c
c     Computes the standard atmospheric pressure 
c
c     INPUT
c     t - air temperature at ground level (K)
c     tst0 - standard air temperature at ground level (K)
c
c     OUTPUT
c     pst - standard atmospheric pressure (hPa)
c
      pst0=1017.085
      pst=pst0*((t/tst0)**5.2561)
      return
      end
c----------------------------------------------------------------------
      subroutine psatv(t,ps)
c
c     Computes the pressure of water saturated vapor
c
c     INPUT
c     t - saturation temperature (K)
c
c     OUTPUT
c     ps - pressure of water saturated vapor (Pa)
c
c	Bias error : at -10 degree Celsius : 8%
c	at 0 degree Celsius : 2 % ; 
c     above 10 degree Celsius : less than 1%
c
      ps = exp (-5416./t+26.23)
      return
      end
c----------------------------------------------------------------------
      subroutine tst(t,h,tst0)
c
c     Computes the standard temperature of air at ground level
c
c     INPUT
c     t - temperature at ground level (K)
c     h - altitude of ground (m)
c
c     OUTPUT
c     tst0 - standard temperature of air at ground level (K)
c
      tst0=t+0.0065*h
      return
      end
c----------------------------------------------------------------------
	subroutine wwleck(t,u,w)
c
c	Computes the thickness of water precipitable layer
c	by using Leckner relationship
c
c	INPUT
c	t - temperature of air at ground level (K)
c     u - air relative humidity at ground level 
c         (dimensionless, between 0 and 1)
c
c	OUTPUT
c     w - thickness of water precipitable layer (mm)
c
	a=exp(26.23-5416./t)
	b=4.93*u/t
	w=a*b
	return
	end
c----------------------------------------------------------------------