function djabs=DiaJulianoAbsoluto(dia,mes,year,year_i)
% Calcula el dia juliano absoluto correspondiente al dia mes y ao
% indicados desde el ao inicial dado por year_i
% INPUT: 
%   dia = dia
%   mes= mes
%   year= ao
%   year_i= ao inicial del periodo considerado
% OUTPUT:
%   djabs = dia juliano absoluto o acumulado contando como 1 el 1/1/year_i
%**************************************************************************
% SINTAXIS;: djabs=DiaJulianoAbsoluto(dia,mes,year,year_i)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%J Polo 2006

periodo=year-year_i;

dias =0;
for i=1:periodo
    y=year_i+i-1;
    if (mod(y,4)==0)
        %bisiesto
        dias=dias+366;
    else
        dias=dias+365;
    end
end

[julian_day,ier]=make_julian_day(dia,mes,year);
djabs=julian_day+dias;