function [G0_12,ier]=G0_general(phi,eccentricity,delta,omega1,omega2)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la irradiacion solar extraterrestre incidente sobre una superficie
% horizontal en el caso general (W h / m2)
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [G0_12,ier]=G0_general(phi,eccentricity,delta,omega1,omega2)
%
% INPUT: 
%       phi         : latitud del lugar (radianes, positiva al norte)
%       eccentricity: correcion de la excentricidad por la orbita terrestre
%       delta       : angulo de declinacion solar (radianes)
%       omega1      : angulo solar horario al comienzo del periodo (radianes)
%       omega2      : angulo solar horario al final del periodo (radianes)
% OUTPUT:
%       G0_12       : irradiacion global extratterrestre (W h / m2)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
I0=1367.0; % Constante solar en W/m2
Dl=24.0;   % valor promedio de la duracion del dia en horas decimales
ier=1;
[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
if (ier ~= 0) return; end
if (omega1 < omega_sr) omega1=omega_sr; end
if (omega2 < omega_sr) omega2=omega_sr; end
if (omega1 > omega_ss) omega1=omega_ss; end
if (omega2 > omega_ss) omega2=omega_ss; end

if (omega2 <= omega1)
    G0_12=0.0;
else
    a=I0*eccentricity*Dl/(2.0*pi); 
    b1=sin(phi)*sin(delta)*(omega2-omega1);
    b2=cos(phi)*cos(delta)*(sin(omega2)-sin(omega1));
    c=a*(b1+b2);
    if (c<0.0)
        G0_12=0.0;
    else
        G0_12=c;
    end
end
