function [G0h,ier]=G0_h(phi,eccentricity,delta,t)
% Calculo de la irradiacion ET segun Iqbal
% Jesus Polo, 2006
% sintaxis: [G0h,ier]=G0_h(phi,eccentricity,delta,t)
% phi: Latitud en rad
% eccentricity: eccentricidad
% delta= declinacion solar en rad
% t = hora decimal al final de la hora

omega_deg=(12-t)*15;
omega=omega_deg*pi/180;
[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);
Isc=1367.0;

if omega < omega_sr | omega > omega_ss
    G0h=0;
else
 G0h=Isc*eccentricity*(sin(delta)*sin(phi)+cos(delta)*cos(phi)*cos(omega));
end


