function [Bc,Dc,Gc,ier]=Gc_model5_irradiance(gamma,epsilon,TLAM2,z)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
%  Estimation of global, diffuse and beam irradiance for a clear-sky model
%
%  [Bc,Dc,Gc,ier]=Gc_model5_irradiance(gamma,epsilon,TLAM2,z)
%
%  INPUT: 
%       gamma        : elevation angle (radians) (for the sun or for satellite)
%       epsilon      : eccentricity correction
%       TLAM2        : Linke turbidity factor for air mass 2
%       z            : station elevation above sea level (m)
%  OUTPUT:
%       Bc          : Beam irradiance for clear sky (W/m2)
%       Dc          : Diffuse irradiance for a clear sky (W/m2)
%       Gc          : Global irradiance for clear sky (W/m2)
%       ier         : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%           station_height_correction
%           air_mass_Kasten
%           deltaR_Page
%           Bc_model5_irradiance
%           Dc_model5_irradiance
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ier=1;
Bc=0.0;
Dc=0.0;
Gc=0.0;

if( (TLAM2 < 1.0) | (gamma < -(pi/12)) )
    ier=0;
else
    [height_corr,ier]=station_height_correction(z);
    [m,ier]=air_mass_Kasten(gamma,z);
    [ms1,ier]=air_mass_Kasten(gamma,0.0); 
    [deltaR,ier]=deltaR_Page(ms1,m,height_corr); 

    [Bc,ier]=Bc_model5_irradiance(gamma,epsilon,m,deltaR,TLAM2);
    [Dc,ier]=Dc_model5_irradiance(z,gamma,epsilon,TLAM2);
    
    Gc=Bc+Dc;
    
    
    
end
