function [LAT,ier]=UT_to_LAT(UT,day_angle,lambda)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion calcula la conversion de UT (Universal Time) a LAT (Local Apparent Time)
% en el mediodia solar (en horas decimales). 
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [LAT,ier]=UT_to_LAT(UT,day_angle,lambda)
%
% INPUT: 
%       UT          : tiempo universal (UT) en horas decimales
%       day_angle   : angulo de dia (radian)
%       lambda      : longitud del sitio (radian, este positivo)
% OUTPUT:
%       LAT         : LAT (horas decimales)
%       ier         : FLAG de control
%-------------------------------------------------------------------------------
deg_rad=pi/180.0; % convierte grados decimales en radian
ier=1;
a1 = -0.128;
a2 = -0.165;
a3 = 2.80*deg_rad;
a4 = 19.70*deg_rad;

if ( (UT >= 0.0) & (UT <= 24.0) & (day_angle > 0.0) & (day_angle < (2.0*pi*1.0021)) & (abd(lambda) <= pi) )
    ier=0;
     ET=a1*sin(day_angle-a3)+a2*sin(2.0*day_angle+a4);
     LAT=UT+ET+(lambda*12.0/pi);
     if (LAT <0) LAT=LAT+24; end
     if (LAT > 24.0) LAT=LAT-24.0; end
end