function [delta_month,ier]=declination_sun_month(month_number,type_use)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Calcula la declinacion solar a mediodia en radianes de una forma simplificada en
% dos casos:
%     type_use = 0 : Para estimar la radiacion solar global media mensual
%     type_use = 1 : Para estimar la radiacion solar media maxima mensual  
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [delta_month,ier]=declination_sun_month(month_number,type_use)
%
% INPUT: 
%       month_number : numero de mes (1..12) 
%       type_use = 0 : Para estimar la radiacion solar global media mensual
%       type_use = 1 : Para estimar la radiacion solar media maxima mensual  
%      
% OUTPUT:
%       delta_month  : declinacion solar (radianes)
%       ier          : FLAG de control 
%
% Ref: 
%      - Gruter (Ed.) 1984
%-------------------------------------------------------------------------------
deg_rad=pi/180.0; % Convierte grados decimales en radianes
tab_julian_day =     [17,46,75,105,135,162,198,228,259,289,319,345];
tab_julian_day_max = [29,57,89,119,150,173,186,217,248,278,309,339];

ier=1;
if ( (type_use >=0) & (type_use < 2) )
    if type_use==0 julian_day=tab_julian_day(month_number); end
    if type_use==1 julian_day=tab_julian_day_max(month_number); end
    ier=0;
end
[day_angle,ier]=Day_Angle(julian_day);
if (ier ~= 0) break; end
jm=day_angle;
c1=0.3978;
c2=80.2*deg_grad; % 1.4000 in SSA manual
c3=1.92*deg_grad; % 0.0355 in SSA manual
c4=2.80*deg_grad; % 0.0489 in SAA manual

delta_month=asin(c1*sin(jm-c2+c3*sin(jm-c4)));