function [press_corr,ier]=presscorr(height_corr,ms1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                       HELIOSAT-2 METHOD
%
% Page J., 2001 (modified rigollier at el. 2000 for pressure correction
%
%  [press_corr,ier]=presscorr(height_corr,ms1)
%
%  INPUT: 
%       height_corr  : p/p0 pressure correction
%       ms1          : relative optical air mass at sea level
% OUTPUT:
%       press_corr   : pressure correction to deltaR
%       ier          : control FLAG : FLAG=0 OK, otherwise error ocurred
%
%  CALLS:
%       none
%__________________________________________________________________________________________________
% 
% Luis F. Zarzalejo, Jesus Polo and Lourdes Ramirez
% CIEMAT (Renewable Energy Department) 2004
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ier=0;
if(height_corr >= 0.99) press_corr=1.0; end
corr75=1.248174-0.011997*ms1+0.00037*ms1*ms1;
corr50=1.68219-0.03059*ms1+0.00089*ms1*ms1;

if(height_corr > 0.75)
    corr50=1.0;
end
    x=(height_corr-0.75)^2;
    y=(height_corr-1.0)^2;
    press_corr=(x+y*corr75)/(x+y);
