function [omega,ier]=solar_hour_angle_h(phi,delta,t)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Geometry of Solar Beam
%
% Esta funcion ofrece un valor promedio delo angulo horario solar (en radianes)
% durante una hora solar completa, teniendo en cuenta unicamente la porcion de
% hora solar en la que el sol esta por encima del horizonte.
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [omega,ier]=solar_hour_angle_h(phi,delta,t)
%
% INPUT: 
%       phi     : latitud (radianes) positiva hacia el norte
%       delta   : angulo de declinacion solar (radianes)
%       t       : tiempo solar, es decir LAT (0..24 horas decimales) 
% OUTPUT:
%       omega   : angulo solar horario (radianes)
%       ier     : FLAG de control
%-------------------------------------------------------------------------------
ier=1;
[omega_sr,omega_ss,ier]=sunrise_hour_angle(phi,delta,0.0);

if (ier ~= 0) break; end

omega1=(t-1.0-12.0)*pi/12.0;
if (omega1 < omega_sr) omega1=omega_sr; end
omega2=(t-12.0)*pi/12.0;
if (omega2 > omega_ss) omega2=omega_ss; end

omega=(omega1+omega2)/2.0;
