function [height_corr,ier]=station_height_correction2(z)
%--------------------- HELIOSAT II ---------------------------------------------
%-------------> Clear Sky Models
%
% Esta funcion calcula la correcion por altura de la estacion, es decir computa el
% cociente entre la presion atmosferica media a la elevacion de la estacion (p) y la
% correspondiente al nivel del mar (p0):  p/p0
% 
%
% El FLAG ier devuelve 0 si OK y 1 en caso contrario
%
% [height_corr,ier]=station_height_correction(z)
%
% INPUT: 
%       z            : altura por encima del nivel del mar de la estacion (m)
% OUTPUT:
%       height_corr  : correcion por altura
%       ier          : FLAG de control
%-------------------------------------------------------------------------------
ier=0;
zh=8434.5; % escala de altura de la atmosfera Rayleigh (m) en la atmosfera estandar
height_corr=exp(-z/zh);
    
    
