%Create a neural network to calculate the daily PAR radiation
%------------------------------------------------------------
%Daily calculations
%------------------------------------------------------------
%Initializing the environment
clear;

%Import data into Matlabs workspace. 
load ('cyprusdaily.mat') ;

%Plot all the available data for the month
figure(1);
Hold;
plot(Diffuse, '-o'); 
plot(Global, ':x');
plot(PAR_dif,'--+');
plot(PAR_tot, '-.d');
title ('Input data');
xlabel('Days (May 2003)');
ylabel('Jm(-2)/day');
legend ('Diffuse','Global','PAR_dif','PAR_tot');

Continue=input ('Output 1 : Visualize input data \nSee figure "1" - Hit Enter to continue \n');

%Preprocessing of the data (normalization)
[xn,xmin,xmax,yn,ymin,ymax]=premnmx(Global,PAR_tot);

%Create the network
net=newff([-1 1],[10 1],{'tansig' 'purelin'});

%Initialize network 
net=init(net);


%Simulate the network without training to show the initial response to the input data
Simulation=sim(net,xn');

hold off
figure(2);
plot(xn,yn,'o',xn,Simulation,'+');
title ('Untrained Network Response');
legend('Measured PAR','Simulated PAR');

Continue=input ('Output 2 : Untrained Network Response \nSee figure "2" - Hit Enter to continue \n');

%Set the most important training parameters 
net.trainParam.epochs=200;
net.trainParam.goal=.0018;

%Training the network
net=train(net,xn',yn');
anorm=sim(net,xn'); 

Continue=input ('Output 3 : The network is trained \nSee figure "Training with TRAINLM" - Hit Enter to continue \n');

%Postprocessing of the data
a=postmnmx(anorm,ymin,ymax);

%Plot the output
figure (4);
plot (Global,PAR_tot,'d',Global,a,'p');
title ('Network Response');
legend('input data','network output');
Continue=input ('Output 4 : Network Response \nSee figure "4" - Hit Enter to continue \n');

