function pr=minmax(p)
%MINMAX Ranges of matrix rows.
%
%	Syntax
%
%	  pr = minmax(p)
%
%	Description
%
%	  MINMAX(P) takes one argument,
%	    P - RxQ matrix.
%	  and returns the Rx2 matrix PR of minimum and maximum values
%	  for each row of P.
%
%	Examples
%
%	  p = [0 1 2; -1 -2 -0.5]
%	  pr = minmax(p)

% Mark Beale, 11-31-97
% Copyright 1992-2000 The MathWorks, Inc.
% $Revision: 1.7 $

pr = [min(p,[],2) max(p,[],2)];
